/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('UserController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', 'timeAgo', function($scope, toastr, Upload, $http, $ngBootbox, blockUI, BASE_FOLDER, timeAgo) {

    timeAgo.settings.fullDateAfterSeconds = 60*60*24;

    $scope.sortReverse = true;
    $scope.sortType = 'userName';

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.userStatus   = $('.userStatusCollector').html();
    $scope.selectedUser = $('.userName').html();
    $scope.currentPage = $('.currentPage').html();

    $scope.userStorage = '';
    $scope.userFree = '';
    $scope.userLimit = '';
    $scope.userUsed = '';
    $scope.skipValue = 2;

    $scope.currentUser = [];
    $scope.currentOs = $('.currentOs').html();
    $scope.userDevices = [];

    $scope.unSelectedUsers = [];
    $scope.selectedUsers = [];

    $scope.getAllUnBlockedUsersForSelectionBySearch = function(userName){
        setTimeout(function(){
            if(userName.length > 0){
                $scope.getAllUnBlockedUsersForSelection(userName);
            }else{
                $scope.getAllUnBlockedUsersForSelection('all');
                toastr.info('Please enter 1 or more Characters', 'Information!!!', {allowHtml: true});
            }
        }, 2000);
    };

    $scope.getAllUnBlockedUsersForSelection = function(userName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/getAllUnBlockedUsers',
            type: 'GET',
            data: {q: userName}
        }).done(function(data){
            try {
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.unSelectedUsers = jData.users;
                    $scope.$apply();
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }
            catch(err) {
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/logout';
                }, 3000);
            }

        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addToSelectedUsers = function($index, ignore){
        if(ignore == false){
            if($scope.unSelectedUsers.length >= 1){
                $scope.selectedUsers.push($scope.unSelectedUsers[$index]);
                $scope.unSelectedUsers.splice($index, 1);
            }else{
                toastr.error('Selected User was not found', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.addToUnSelectedUsers = function($index, ignore){
        if(ignore == false){
            if($scope.selectedUsers.length >= 1){
                $scope.unSelectedUsers.push($scope.selectedUsers[$index]);
                $scope.selectedUsers.splice($index, 1);
            }else{
                toastr.error('Selected User was not found', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.removeUserGroup = function(groupName, md5GroupName){
        if(groupName.length > 0){
            var html = $('.deleteGroup'+md5GroupName).html();
            $('.deleteGroup'+md5GroupName).attr('disabled','disabled');
            $('.deleteGroup'+md5GroupName).html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/deleteUserGroup',
                data: {groupName: groupName},
                type: 'POST'
            }).done(function(data){
                $('.deleteGroup'+md5GroupName).removeAttr('disabled');
                $('.deleteGroup'+md5GroupName).html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.reload(true);
                    }, 2000);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.$watch('file', function (file) {
        if(file){
            $scope.upload(file);
        }else if(file != undefined || file != null){
            toastr.info('Uploaded File format not supported');
        }
    });

    $scope.upload = function (file) {
        Upload.upload({
            url: $scope.BASE_FOLDER+'/upload',
            fields: {'username': $scope.username},
            file: file
        }).progress(function (evt) {
            var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
        }).success(function (data, status, headers, config) {
            if(config.file){
                if(!jQuery.isEmptyObject(config.file)){
                    toastr.success(config.file.name, 'Profile Pic Changed');
                }else{
                    toastr.error('Uploaded Format is not supported', 'Error!!');
                }
            }
        }).error(function (data, status, headers, config) {
            toastr.error(data.message);
        })
    };

    $scope.saveUserDetails = function(){
        $('.loading').html('Loading ...');
        $('.error').hide();
        $('.error').html('');
        if($('.userSettingsForm').parsley().isValid()){
            var html = $('.UserSave').html();
            $('.UserSave').attr('disabled','disabled');
            $('.UserSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/save',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = $.parseJSON(data);
                console.log("hhh" +jData);
                console.log("hhh77" +data);
                if(jData.result == 'success'){
                    toastr.success(jData.message, 'Successful!!!');
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);

                    if(jData.data == 'false'){
                        $('.account_type').addClass('hide');
                        $('.sync_access').addClass('hide');
                        $('.backup').addClass('hide');
                        $('.miniCloudName').addClass('hide');
                        $('.share_enabled').addClass('hide');
                    }else{
                        //$('.account_type').removeClass('hide');
                        //$('.sync_access').removeClass('hide');
                        //$('.backup').removeClass('hide');
                        //$('.miniCloudName').removeClass('hide');
                        //$('.share_enabled').removeClass('hide');
                    }

                }else if(jData.result == 'fieldFail'){
                    $('.error').show();
                    for(var key in jData.msg){
                        if (jData.msg.hasOwnProperty(key)) {
                            if($('.error').html() != ''){
                                $('.error').append('<br/>'+jData.msg[key]);
                            }else{
                                $('.error').html(jData.msg[key]);
                            }
                            $('[name="'+key.toLowerCase()+'"]').removeClass('parsley-success');
                            $('[name="'+key.toLowerCase()+'"]').addClass('parsley-error');
                        }
                    }
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);
                }else{
                    $('.UserSave').removeAttr('disabled');
                    $('.UserSave').html(html);
                    $('.error').hide();
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.saveNewUserDetails = function(){
        if($('.userCreationFrom').parsley().isValid()) {
            var html = $('.userSave').html();
            $('.userSave').attr('disabled', 'disabled');
            $('.userSave').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/create',
                data: $('form').serialize(),
                type: 'POST'
            }).done(function(data){
                $('.userSave').removeAttr('disabled');
                $('.userSave').html(html);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/users';
                    }, 3000)
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.blockUserProfile = function(selectedUser, confirmed){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/block',
                data: {userName: userName, blockUser: 'false'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if($scope.userStatus != undefined){
                        $scope.userStatus = false;
                    }else{
                        $scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users[key].isActive = false;
                            }
                        });
                    }
                    $scope.$apply();
                    toastr.success('User "'+userName+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.unBlockUserProfile = function(selectedUser, confirmed){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/block',
                data: {userName: userName, blockUser: 'true'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if($scope.userStatus != undefined){
                        $scope.userStatus = true;
                    }else{
                        $scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users[key].isActive = true;
                            }
                        });
                    }
                    $scope.$apply();
                    toastr.success('User "'+userName+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.deleteUserProfile = function(selectedUser, confirmed){
        $('.loading').html('Loading ...');
        var userName = '';
        if(isNaN(selectedUser)){
            userName = selectedUser;
        }else{
            userName = selectedUser;
        }
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/delete',
                data: {userName: userName, blockUser: 'true'},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(isNaN(selectedUser)){
                        window.location.href = $scope.BASE_FOLDER+'/users';
                    }else{
                        $scope.users.forEach(function(value, key){
                            if(value.userName == selectedUser){
                                $scope.users.splice(key, 1);
                            }
                        });
                        toastr.success('User "'+userName+'" '+jData.message, 'Successful!!!', {allowHtml: true});
                    }
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
                $scope.$apply();
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };


    $scope.searchUser = function(userName){
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        $scope.updateUsers(userName, 0);
    };

    $scope.loadMoreUsers = function(skipValue){
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $scope.updateUsers('all', skipValue);
    };

    $scope.users = [];

    $scope.updateUsers = function(userName, skipValue){
        console.log({userName: userName, skipValue: skipValue});
        $('.loading').html('Loading ...');
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/users',
            data: {userName: userName, skipValue: skipValue},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.loading').hide();
                $('.userListTable').show();
                if(userName == 'all'){
                    if(jData.users.length > 0){
                        $scope.skipValue = $scope.skipValue+1;
                        if(userName == 'all' && $scope.skipValue == 0){
                            $scope.users = jData.users;
                        }else{
                            jData.users.forEach(function($value){
                                $scope.users.push($value);
                            });
                        }
                        if($scope.users.length < 200){
                            $scope.updateUsers(userName, $scope.skipValue);
                        }
                        $scope.$apply();
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                        $('.nouser').show();
                    }else{
                        if(skipValue <= 1){
                            $('.loading').show();
                            $('.loading').html('No More Users were found');
                            $('.userListTable').hide();
                        }
                        $('.loadMore').hide();
                        $('.nouser').hide();
                    }
                }else{
                    if(jData.users.length > 0){
                        $scope.users = jData.users;
                        $scope.$apply();
                        $('.loadMore').hide();
                        $('.nouser').hide();
                    }else{
                        $('.loading').hide();
                        $('.nouser').show();
                        $('.userListTable').hide();
                    }
                }
                $scope.$apply();
            }else{
                //do something to stop displaying the users list
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.updateUserDevices = function(username){
        $('.loading').html('Loading ...');
        if(username){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/devices',
                data: {userName: username},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                console.log(jData);
                if(jData.result == 'success'){
                    $('.userDevices').show();
                    if(jData.devices == 0){
                        $('.userDevices').hide();
                        $('.loading').show();
                        $('.loading').html('<br/>No Devices has been configured');
                    }else{
                        $('.loading').hide();
                    }
                    $scope.userDevices = jData.devices;
                    $scope.userStorage = jData.used;
                    $scope.userLimit = jData.limit;
                    $scope.$apply();
                    var storageData = [
                        {
                            value: jData.used,
                            color:"#F7464A",
                            highlight: "#FF5A5E",
                            label: "Used"
                        },
                        {
                            value: jData.free,
                            color:"#2095f2",
                            highlight: "#115d90",
                            label: "Free"
                        }
                    ];

                    var options = {
                        segmentShowStroke : true,
                        segmentStrokeColor : "#fff",
                        segmentStrokeWidth : 2,
                        percentageInnerCutout : 50,
                        animationSteps : 100,
                        animationEasing : "easeOutBounce",
                        animateRotate : true,
                        animateScale : true,
                        legendTemplate : "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<segments.length; i++){%><li><span style=\"background-color:<%=segments[i].fillColor%>\"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>"
                    };
                    if(document.getElementById("storage")){
                        var storage = document.getElementById("storage").getContext("2d");
                        var myDoughnutChart = new Chart(storage).Doughnut(storageData,options);
                    }

                }else{
                    //do something to stop displaying the users list
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.updateUserDevicePolicyInfo = function(){
        $('.loading').html('Loading ...');
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfo',
            data: {token: ''},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $scope.currentUser.maxSizeAllowed = jData.maxSizeAllowed;
                $scope.currentUser.defaultFolders = jData.defaultFolders;
                $scope.currentUser.fileTypes = jData.fileTypes;
                $scope.currentUser.userDefinedFolders = jData.userDefinedFolders;
                $scope.currentUser.userExcludedFolders = jData.userExcludedFolders;
                $scope.$apply();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.addInclusionFolder = function(folder){
        if(folder != '{user.home}'){
            folder = checkForValidPath(folder, $scope.currentUser.userDefinedFolders);
        }else{
            folder = '{user.home}';
        }
        if($scope.currentUser.defaultFolders.length > 0){
            $scope.currentUser.defaultFolders.forEach(function(value){
                if(value == folder){
                    folder = 'exist';
                }
            });
        }
        if(folder === false || folder == 'exist'){
            $('[name="inclusionFolderName"]').popover('show');
            return;
        }else{
            $('[name="inclusionFolderName"]').popover('hide');
        }
        $('.loading').html('Loading ...');
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfo/addInclusionFolder',
            data: {folder: folder, csrf_token: $('[name="csrf_token"]').val()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('[name="inclusionFolderName"]').val('');
                $scope.currentUser.userDefinedFolders.push(folder);
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeInclusionFolder = function($index, confirmed){
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/policyInfo/removeInclusionFolder',
                data: {folder: $scope.currentUser.userDefinedFolders[$index], csrf_token: $('[name="csrf_token"]').val()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.currentUser.userDefinedFolders.splice($index, 1);
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.addExclusionFolder = function(folder){
        if(folder != '{user.home}'){
            folder = checkForValidPath(folder, $scope.currentUser.userExcludedFolders);
        }else{
            folder = '{user.home}';
        }
        if(folder === false || folder == 'exist'){
            $('[name="exclusionFolderName"]').popover('show');
            return;
        }else{
            $('[name="exclusionFolderName"]').popover('hide');
        }
        $('.loading').html('Loading ...');
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/user/device/policyInfo/addExclusionFolder',
            data: {folder: folder, csrf_token: $('[name="csrf_token"]').val()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('[name="exclusionFolderName"]').val('');
                $scope.currentUser.userExcludedFolders.push(folder);
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.removeExclusionFolder = function($index, confirmed){
        if(confirmed == 'true'){
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/policyInfo/removeExclusionFolder',
                data: {folder: $scope.currentUser.userExcludedFolders[$index], csrf_token: $('[name="csrf_token"]').val()},
                type: 'POST'
            }).done(function(data){
                blockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.currentUser.userExcludedFolders.splice($index, 1);
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    function checkForValidPath(folder, $folders){
        var pattern = new RegExp(':');
        var result = '';
        if($scope.currentOs == 'windows') {
            if(folder == '' || folder == null){
                return false;
            }else{
                if(pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length == 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\\');
                        folder = folder.replace(/\//g, '\\');
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    return false;
                }
            }
        }else{
            if(folder == '' || folder == null){
                return false;
            }else{
                if(!pattern.test(folder)){
                    if(folder.split(':', 1).join(':').length != 1){
                        folder = folder.replace(/\/+$/,'');
                        folder = folder.replace(/\\+$/,'');
                        folder = folder.concat('\/');
                        folder = folder.replace(/\\/g, "/");
                        folder = folder.toLowerCase();
                        $folders.forEach(function(value){
                            if(folder.indexOf(value.toLowerCase()) > -1){
                                result = 'exist'
                            }
                        });

                        if(result != 'exist'){ return folder; }else{ return result; }

                    }else{
                        return false;
                    }
                }else{
                    return false;
                }
            }
        }
    }

    $scope.viewDeviceDetails = function($index, deviceUUID){
        if($('.userDevice'+$index).hasClass('expand')){
            $('.userDevice'+$index).removeClass('expand');
            $('.userDevice'+$index).addClass('col-lg-4');
            $('.userDevice'+$index+' .eye i').addClass('fa-eye');
            $('.userDevice'+$index+' .eye i').removeClass('fa-times');
            $('.expandDetails'+$index).hide();
            $('.fileListBtn'+$index).hide();
        }else{
            $('.userDevice'+$index).removeClass('col-lg-4');
            $('.userDevice'+$index).addClass('expand');
            $('.userDevice'+$index+' .eye i').removeClass('fa-eye');
            $('.userDevice'+$index+' .eye i').addClass('fa-times');
            var myBlockUI = blockUI.instances.get('myBlockUI'+$index);
            myBlockUI.start();
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/device/deviceDetails',
                data: {deviceUUID: deviceUUID, csrf_token: $('[name="csrf_token"]').val()},
                type: 'POST'
            }).done(function(data){
                myBlockUI.stop();
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $scope.deviceDetails = jData.deviceDetails;
                    $scope.$apply();
                    $('.expandDetails'+$index).show();
                    $('.fileListBtn'+$index).show();
                    $('.fileListBtn'+$index+' a').attr('href', $scope.BASE_FOLDER+'/backup/files/'+jData.deviceDetails.deviceId+'/'+jData.deviceDetails.deviceName+'/'+deviceUUID);
                }else{
                    toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.changePassword = function(){

        var password = $('#password').val();
        var rePassword = $('#rePassword').val();

        var html = $('#changePasswordBtn').html();
        $('#changePasswordBtn').attr('disabled','disabled');
        $('#changePasswordBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();

        if ( $('#changePasswordForm').parsley().isValid() && password == rePassword) {
            $.ajax({
                url: $scope.BASE_FOLDER+'/user/changePassword',
                data: $('#changePasswordForm').serialize(),
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('#changePassword').modal('hide');
                    $('#changePasswordBtn').html('Saved <i class="fa fa-check"></i>').animate();
                    setTimeout(function(){
                        toastr.success('Password Successfully changed', 'Success!!!');
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                    $('#password').val("");
                    $('#rePassword').val("");
                    // location.reload();
                }else{
                    $('#changePasswordBtn').html('Failed <i class="fa fa-times"></i>').animate();
                    setTimeout(function(){
                        toastr.error('old & new password cannot be same', 'Fail!!!');
                        $('#password').val("");
                        $('#rePassword').val("");
                        $('#changePasswordBtn').html(html);
                        $('#changePasswordBtn').removeAttr('disabled');
                    }, 1000);
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }
    };

    $scope.blockUnBlockMultipleUsers = function(active){
        var users;
        if(active == true){
            users = $('.deleteUserNames').val();
        }else{
            users = $('.blockUserNames').val();
        }
        if(users != null){
            var html;
            if(active == true){
                html = $('.unblock').html();
                $('.unblock').attr('disabled','disabled');
                $('.unblock').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }else{
                html = $('.block').html();
                $('.block').attr('disabled','disabled');
                $('.block').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/users/blockMultipleUsers',
                data: {users: users, active: active, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(active == true){
                        $('.deleteUserNames').val(null).trigger("change");
                        $('.unblock').html(html);
                        $('.unblock').removeAttr('disabled');
                    }else{
                        $('.blockUserNames').val(null).trigger("change");
                        $('.block').html(html);
                        $('.block').removeAttr('disabled');
                    }
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(active == true){
                toastr.error('Please select a user to Unblock', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a user to block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.deleteMultipleUsers = function(){
        var users = $('.deleteUserNames').val();
        if(users != null){
            var html = $('.delete').html();
            $('.delete').attr('disabled','disabled');
            $('.delete').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/users/deleteMultipleUsers',
                data: {users: users, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('.deleteUserNames').val(null).trigger("change");
                    $('.delete').html(html);
                    $('.delete').removeAttr('disabled');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please select a user to delete', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.redirectTo = function(url){
        window.location.href = url;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');

        //if($scope.currentPage == 'createUserGroup'){
        //    $scope.getAllUnBlockedUsersForSelection('all');
        //}

        if(!$scope.selectedUser && $scope.currentPage == 'users'){
            blockUI.start();
            $scope.updateUsers('all', 0);
        }
        if($scope.selectedUser) {
            blockUI.start();
            $scope.updateUserDevices($scope.selectedUser);
        }
        if($scope.currentPage == 'policyInfo'){
            blockUI.start();
            $scope.updateUserDevicePolicyInfo();
        }

        var error = $('.resultError').html();
        if(error){
            if(error.length > 0){
                toastr.error(error, 'Fail');
            }
        }

        var success = $('.resultSuccess').html();
        if(success){
            if(success.length > 0){
                toastr.success(success, 'Successfull');
            }
        }

    });

}]);