/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('MainController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', '$timeout', 'Excel', 'md5', 'fileMd5Service', function($scope, toastr, Upload, $http, $ngBootbox, blockUI, BASE_FOLDER, $timeout, Excel, md5, fileMd5Service) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.download = function($type){
        window.location.href = $scope.BASE_FOLDER+'/trigger/download?type='+$type;
    };
    $scope.foundUsers = [];
    $scope.foundDevices = [];
    $scope.foundFiles = [];
    $scope.currentFileUploadList = [];
    $scope.listOFBlukrypts = [];
    $scope.bestBlukrypt = '';

    $scope.allowedFileAttributes = [];
    $scope.notAllowedFileAttributes = [];

    $scope.search = {};
    var currentDate = new Date();
    $scope.search.to = getFormattedDate(currentDate);

    currentDate.setDate(currentDate.getDate() - 15);
    $scope.search.from = getFormattedDate(currentDate);

    function getFormattedDate(today){
        var dd = today.getDate();
        var mm = today.getMonth()+1;

        var yyyy = today.getFullYear();
        if(dd<10){
            dd='0'+dd
        }
        if(mm<10){
            mm='0'+mm
        }
        return mm+'/'+dd+'/'+yyyy;
    }

    $scope.exportActivityHistory = function(){
        var html = $('.exportExcelGenerate').html();
        $('.exportExcelGenerate').attr('disabled','disabled');
        $('.exportExcelGenerate').html('Generating... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/exportActivityHistoryToExcel',
            data: $('.selectUsersForActivityHistory').serialize(),
            type: 'POST'
        }).done(function(data){
            $('.exportExcelGenerate').removeAttr('disabled');
            $('.exportExcelGenerate').html(html);
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                window.location.href = $scope.BASE_FOLDER+'/exportActivityHistoryToExcel/'+jData.fileName;
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getBlukrypts = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/pms/getAllBlukrypts',
            data: {csrf_token: $('.csrf_token').html(), secret: ''},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.blukrypts != null){
                    $scope.listOFBlukrypts = jData.blukrypts;
                    $scope.$apply();
                    $scope.listOFBlukrypts.forEach(function(value, key){
                        $.ajax({
                            url: $scope.BASE_FOLDER+'/getBestBlukrypt',
                            data: {blukrypts: jData.blukrypts, csrf_token: $('.csrf_token').html()},
                            type: 'POST'
                        }).done(function(data){
                            console.log(data);
                            var jData = JSON.parse(data);
                            if(jData.result = 'fail'){
                                $scope.bestBlukrypt = jData.bestBlukrypt;
                                $scope.$apply()
                            }else{
                                toastr.error('Due to some technical issues not able to open the file location please, manually navigate to the file', 'Fail!!!', {allowHtml: true});
                            }
                        }).error(function(data){
                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                            if(data.status == 424){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                }, 3000);
                            }else if(data.status == 503){
                                setTimeout(function(){
                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                }, 3000);
                            }
                        });
                    });
                }else{
                    $scope.bestBlukrypt = $('.blukryptIP').html();
                    $scope.$apply();
                }
            }else{
                $scope.bestBlukrypt = $('.blukryptIP').html();
                $scope.$apply();
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.exportShareActivityHistory = function(){
        console.log($('.selectUsersForActivityHistory').serialize());
        var html = $('.exportExcelGenerate').html();
        $('.exportExcelGenerate').attr('disabled','disabled');
        $('.exportExcelGenerate').html('Generating... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $.ajax({
            url: $scope.BASE_FOLDER+'/exportShareActivityHistoryToExcel',
            data: $('.selectUsersForActivityHistory').serialize(),
            type: 'POST'
        }).done(function(data){
            $('.exportExcelGenerate').removeAttr('disabled');
            $('.exportExcelGenerate').html(html);
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                window.location.href = $scope.BASE_FOLDER+'/exportShareActivityHistoryToExcel/'+jData.fileName;
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchThisText = function(text, searchType){
        if(searchType == 'all' || searchType == 'files'){
            $scope.contentSearch(text);
        }
        if(searchType == 'all' || searchType == 'usersDevices'){
            if(/^[a-zA-Z0-9- ]*$/.test(text) == false) {
                $scope.searchDevices(text);
                $scope.searchUsers(text);
            }else{
                $scope.searchUsers(text);
                $scope.searchDevices(text);
            }
        }

    };

    $scope.searchDevices = function(deviceName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/devices',
            data: {deviceName: deviceName, skipValue: 0, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.devices.length <= 0){
                    $('.status-error').show();
                    $('.status-error').prepend('<br/>There were no devices found!');
                }else{
                    $scope.foundDevices = jData.devices;
                    $scope.$apply();
                }
            }else{
                $('.status-error').show();
                $('.status-error').prepend('<br/>There were no devices found!');
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchUsers = function(userName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/users',
            data: {userName: userName, skipValue: 1, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.users.length <= 0){
                    $('.status-error').show();
                    $('.status-error').prepend('<br/>There were no users found!');
                }else{
                    $scope.foundUsers = jData.users;
                    $scope.$apply();
                }
            }else{
                $('.status-error').show();
                $('.status-error').prepend('<br/>There were no users found!')
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.contentSearch = function(text){
        $.ajax({
            url: $scope.BASE_FOLDER+'/contentSearch',
            data: {text: text, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.files.length <= 0){
                    $('.status-error').show();
                    $('.status-error').prepend('<br/>There are no results!')
                }else{
                    $scope.foundFiles = jData.files;
                    $scope.$apply();
                }
            }else{
                $('.status-error').show();
                $('.status-error').prepend('<br/>There are no results!')
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchDownload = function(path, fileName, searchID){
        $.ajax({
            url: $scope.BASE_FOLDER+'/sync/getSyncRevisionId',
            data: {searchID: searchID, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.revisionId.gatewayName.length){
                    window.open($('.protocol').html()+jData.revisionId.gatewayName+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+encodeURIComponent(fileName)+'&filePath='+encodeURIComponent(path)+'&token='+$('.uploadToken').html()+'&userName='+$('.uploadUserName').html()+'&syncRevisionId='+jData.revisionId.revisionId+'&path='+encodeURIComponent(path+'/'+fileName), '_blank');
                }else{
                    window.open($('.protocol').html()+$('.blukryptIP').html()+$('.blukryptURL').html()+$('.cloudNameConstant').html()+'/sync/portal/download/file/?fileName='+encodeURIComponent(fileName)+'&filePath='+encodeURIComponent(path)+'&token='+$('.uploadToken').html()+'&userName='+$('.uploadUserName').html()+'&syncRevisionId='+jData.revisionId.revisionId+'&path='+encodeURIComponent(path+'/'+fileName), '_blank');
                }
            }else{
                toastr.error('Due to some technical issues file cannot be downloaded, please try again later, or use the locate option', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchOpenFolderOption = function(path, fileName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/goToPath',
            data: {filePath: path, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result = 'success'){
                window.location.href = $scope.BASE_FOLDER+'/sync/files';
            }else{
                toastr.error('Due to some technical issues not able to open the file location please, manually navigate to the file', 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getHtmlContent = function(text){
        return text;
    };

    angular.element(document).ready(function(){

        // $scope.getBlukrypts();

        if($('.fileIncludeExtensions').html().length > 0){
            $scope.allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
        }

        if($('.fileExcludeExtensions').html().length > 0){
            $scope.notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
        }

        $('#createMiniCloud').on('shown.bs.modal', function () {
            $('#miniCloudName').focus();
        });

        $('#createFolder').on('shown.bs.modal', function () {
            $('#folderName').focus();
        });

        //$('#paraviewContainer').on('hidden.bs.modal', function () {
        //    window.location.reload(true);
        //});

        var searchType = $('.morphSearchText').html();
        if(searchType != 'none'){
            (function(ev) {
                var morphSearch = document.getElementById( 'morphsearch' );
                if(morphSearch){
                    var input = morphSearch.querySelector( 'input.morphsearch-input' ),
                        ctrlClose = morphSearch.querySelector( 'span.morphsearch-close' ),
                        isOpen = isAnimating = false,

                        checkForKey = function(keyCode){
                            if(keyCode >= 48 && keyCode <= 57){
                                return true;
                            }else if(keyCode >= 65 && keyCode <= 90){
                                return true;
                            }else{
                                return false;
                            }
                        },

                        toggleSearch = function(evt) {

                            if( evt.type.toLowerCase() === 'focus' && isOpen ) return false;

                            var offsets = morphsearch.getBoundingClientRect();
                            if( isOpen ) {
                                classie.remove( morphSearch, 'open' );
                                if( input.value !== '' ) {
                                    setTimeout(function() {
                                        classie.add( morphSearch, 'hideInput' );
                                        setTimeout(function() {
                                            classie.remove( morphSearch, 'hideInput' );
                                            input.value = '';
                                        }, 300 );
                                    }, 500);
                                }

                                input.blur();
                            }
                            else {
                                classie.add( morphSearch, 'open' );
                            }
                            isOpen = !isOpen;
                            if(isOpen){
                                $("body").css("overflow", "hidden");
                            }else{
                                $("body").css("overflow", "auto");
                            }
                        };

                    input.addEventListener( 'focus', toggleSearch );
                    ctrlClose.addEventListener( 'click', toggleSearch );


                    document.addEventListener( 'keydown', function( ev ) {
                        var keyCode = ev.keyCode || ev.which;
                        var focusedElement = $(document.activeElement);
                        if(focusedElement.context.localName != 'input' && focusedElement.context.localName != 'textarea'){
                            if( keyCode === 27 && isOpen ) {
                                toggleSearch(ev);
                            }
                        }
                    } );


                    document.addEventListener( 'keydown', function( ev ) {
                        if(!ev.ctrlKey && !ev.shiftKey && !ev.altKey){
                            var keyCode = ev.keyCode || ev.which;
                            var focusedElement = $(document.activeElement);
                            if(focusedElement.context.localName != 'input' && focusedElement.context.localName != 'textarea'){
                                if (checkForKey(keyCode) && !isOpen) {
                                    toggleSearch(ev);
                                    document.getElementById("morphsearch-input").focus();
                                }
                            }
                        }
                    } );

                    var searchEnabled = $('.searchEnabled').html();
                    if(searchEnabled == 'enabled'){
                        classie.add( morphSearch, 'open' );
                        document.getElementById("morphsearch-input").focus();
                    }

                    morphSearch.querySelector( 'button[type="submit"]' ).addEventListener( 'click', function(ev) {
                        ev.preventDefault();
                        $('.status-error').hide();
                        $('.status-error').html('');
                        $scope.foundFiles = [];
                        $scope.foundUsers = [];
                        $scope.foundDevices = [];
                        $scope.$apply();
                        var value = $('.morphsearch-input').val();
                        if(value.length <= 2){
                            toastr.info('Search text should at-least be of 3 characters', 'Information!!!');
                            return;
                        }
                        $scope.searchThisText(value, searchType);

                        $('.status-text').html('<span class="text-muted h3">Searching for <b>"'+encodeURI(value)+'"</b> <img width="3%" style="margin-top: -10px;" src="'+$scope.BASE_FOLDER+'/app/templates/default/images/gears.gif" /></span>');
                        $('.search-results').hide();

                        setTimeout(function(){
                            $('.status-text').html('Search Results');
                            $('.search-results').show();
                        }, 1);

                    });
                }

            })();
        }
    });

    function checkIfAllowed(fileName){
        var result;
        if(fileName.length >= 1){
            var fileAttrs = fileName.split('.');
            if($scope.notAllowedFileAttributes.length > 0){
                result = true;
                $scope.notAllowedFileAttributes.forEach(function(value, key){
                    if(value == fileAttrs[(fileAttrs.length-1)]){
                        result = false;
                    }
                });
            }else if($scope.allowedFileAttributes.length > 0){
                result = false;
                $scope.allowedFileAttributes.forEach(function(value, key){
                    if(value == fileAttrs[(fileAttrs.length-1)]){
                        result = true;
                    }
                });
            }else{
                result = true;
            }
        }
        return result;
    }

    $scope.uploadFiles = function(files) {
        blockUI.stop();
        if(files != undefined){
            $('#UploadCancelBtn').show();
            angular.forEach(files, function(file, key) {
                var fileUploadLimitSize = $('.file-limit-size').html();
                if(checkIfAllowed(file.name)){
                    if(!isNaN(fileUploadLimitSize) && fileUploadLimitSize.length > 0){
                        if(file.size <= (fileUploadLimitSize*1000*1000)){
                            $scope.currentFileUploadList.push(file);
                        }else{
                            toastr.error('File Size greater than '+fileUploadLimitSize+' MB are not allowed', 'Fail!!!', {allowHtml: true});
                        }
                    }else{
                        $scope.currentFileUploadList.push(file);
                    }
                    $scope.$apply();
                }else{
                    if($scope.notAllowedFileAttributes.length > 0){
                        toastr.error('Extensions '+$scope.notAllowedFileAttributes.join(', ')+' not allowed', 'Fail!!!', {allowHtml: true});
                    }else{
                        toastr.error('Only Extensions, '+$scope.allowedFileAttributes.join(', ')+' are allowed', 'Fail!!!', {allowHtml: true});
                    }
                }
            });
        }
        if($scope.currentFileUploadList.length >= 1){
            angular.forEach(files, function(file, key) {
                $scope.currentFileUploadList[key].progress = 0;
                if (file && !file.$error) {

                    if(isSpecialChar(file.name)){

                        $scope.currentFileUploadList[key].status = ' - Reading the file....';

                        fileMd5Service.md5(file).progress(function(stats) {

                            $scope.currentFileUploadList[key].progress = parseInt((stats.loaded / stats.total) * 100);
                        }).success(function(md5){

                            if($scope.currentFileUploadList[key].status != ' - Upload Canceled'){
                                $scope.currentFileUploadList[key].status = ' - Uploading the File....';
                                var headers = {
                                    'token'                 : $('.uploadToken').html(),
                                    'userName'              : $('.uploadUserName').html(),
                                    'Content-disposition'   : 'inline;filename='+file.name,
                                    'is-exists'             : 'false',
                                    'file-path'             : 'ParaBlu',
                                    'file-name'             : file.name,
                                    'file-size'             : file.size,
                                    'is-folder'             : 'false',
                                    'is-base-folder'        : 'false',
                                    'fileMD5'               : md5,
                                    'gatewayName'           : $('.blukryptIP').html(),
                                    'modified'              : file.lastModified
                                };

                                //in Case Cors exception occurs please ask the backend guys to enable cros for this api request.

                                file.upload = Upload.upload({
                                    url: $('.blukryptIPAddress').html()+$('.cloudNameConstant').html()+'/sync/portal/upload/file/',
                                    headers: headers,
                                    method: 'POST',
                                    file: file
                                });

                                $scope.currentFileUploadList[key].upload = file.upload;
                                file.upload.then(function (response) {

                                    $timeout(function () {
                                        file.result = response;
                                        if(response.status == 200){
                                            $('.status').hide();
                                            toastr.success(response.data.bluKryptElement.fileName+' has been uploaded successfully', 'Successfully!!!', {allowHtml: true});
                                            $scope.currentFileUploadList.forEach(function(value, key){
                                                if(value.name.toString() == response.data.bluKryptElement.fileName.toString()){
                                                    $scope.currentFileUploadList[key].status = ' - Upload Completed';
                                                }
                                            });
                                            if(checkFilesStatus() == true){
                                                $scope.currentFileUploadList = [];
                                                $('#uploadFiles').modal('hide');
                                            }
                                        }else{
                                            toastr.error('Could not upload the file, '+response.data.bluKryptElement.fileName+', '+response.status, 'Fail!!!', {allowHtml: true});
                                        }
                                    });
                                }, function (response) {
                                    if(response.status == 448){
                                        toastr.error('File, '+file.name+' already Exists', 'Fail!!!', {allowHtml: true});
                                    }else if(response.status != 0){
                                        toastr.error('Could not upload the file, '+file.name+', Error Code: '+response.status, 'Fail!!!', {allowHtml: true});
                                    }else{
                                        var headers = {
                                            'token'                 : $('.uploadToken').html(),
                                            'userName'              : $('.uploadUserName').html(),
                                            'is-exists'             : 'false',
                                            'file-path'             : 'ParaBlu',
                                            'file-name'             : file.name,
                                            'file-size'             : file.size,
                                            'is-folder'             : 'false',
                                            'is-base-folder'        : 'false',
                                            'fileMD5'               : md5,
                                            'modified'              : file.lastModified
                                        };

                                        //in Case Cors exception occurs please ask the backend guys to enable cros for this api request.

                                        $.ajax({
                                            url: $('.blukryptIPAddress').html()+$('.cloudNameConstant').html()+'/sync/portal/upload/cancel/',
                                            headers: headers,
                                            method: 'POST'
                                        }).done(function(data){

                                            toastr.error('File, '+file.name+', upload has been cancelled', 'Fail!!!', {allowHtml: true});

                                        }).error(function(data){
                                            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                                            if(data.status == 424){
                                                setTimeout(function(){
                                                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                                                }, 3000);
                                            }else if(data.status == 503){
                                                setTimeout(function(){
                                                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                                                }, 3000);
                                            }
                                        });
                                    }

                                    $scope.currentFileUploadList.forEach(function(value, key){
                                        if(value.name.toString() == file.name.toString()){
                                            $scope.currentFileUploadList.splice(key, 1);
                                        }
                                    });

                                });

                                file.upload.progress(function (evt) {
                                    if($scope.currentFileUploadList[key] != undefined){
                                        file.progress = Math.min(100, parseInt(100.0 *
                                            evt.loaded / evt.total));
                                        $scope.currentFileUploadList[key].progress = file.progress;
                                    }
                                });
                            }else{
                                if(checkFilesStatusForSingleCancel() == true){
                                    $scope.currentFileUploadList = [];
                                    $('#uploadFiles').modal('hide');
                                }
                            }
                        });
                    }
                }
            });
        }
    };

    function checkFilesStatusForSingleCancel(){
        var result = true;
        $scope.currentFileUploadList.forEach(function(value, key){
            if(value.status != ' - Upload Completed' && value.status != ' - Upload Canceled'){
                result = false;
            }
        });
        return result;
    }

    function checkFilesStatus(){
        var result = true;
        $scope.currentFileUploadList.forEach(function(value, key){
            if(value.status != ' - Upload Completed'){
                result = false;
            }
        });
        return result;
    }

    $scope.cancelUploadAll = function(){
        angular.forEach($scope.currentFileUploadList, function(file, key) {
            if(file.status == ' - Reading the file....') {
                $scope.currentFileUploadList[key].status = ' - Upload Canceled';
            }else{
                file.upload.abort();
            }
        });
        $('#uploadFiles').modal('hide');
    };

    $scope.cancelSingleFileUpload = function(key){
        if($scope.currentFileUploadList[key].status == ' - Reading the file....'){
            $scope.currentFileUploadList[key].status = ' - Upload Canceled';
        }else{
            $scope.currentFileUploadList[key].upload.abort();
        }
        if(checkFilesStatusForSingleCancel() == true){
            $('#UploadCancelBtn').hide();
        }
    };

    $scope.createMiniCloud = function(miniCloudName){$('.createMiniCloudError').hide();
        if(isSpecialCharForMiniCloud(miniCloudName) == false){
            $('.createMiniCloudError').html('<br><span class="text-danger">Special characters like ( & * \\ | : \" < > ? / ) are not allowed.</span>');
            $('.createMiniCloudError').show();
            return;
        }

        if(miniCloudName != undefined && miniCloudName.length > 0){
            $('.loading').show();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/createMiniCloud',
                data: {miniCloudName: miniCloudName, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('#createMiniCloud').modal('hide');
                    if(jData.userUpdate != '200'){
                        toastr.error('Was not able to attach MiniCloud to your account, please attach the MiniCloud manually to your account', 'Fail!!!', {allowHtml: true});
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 3000);
                    }else{
                        setTimeout(function(){
                            window.location.reload(true);
                        }, 1000);
                    }
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>MiniCloud</b> Name', 'Fail!!!', {allowHtml: true});
        }
    };

    $scope.createFolder = function(folderName){
        $('.createFolderError').hide();
        if(isSpecialChar(folderName) == false){
            $('.createFolderError').html('<br><span class="text-danger">Special characters like ( * \\ | : \" < > ? / ) are not allowed.</span>');
            $('.createFolderError').show();
            return;
        }

        if(folderName != undefined && folderName.length > 0){
            $('.loading').show();
            $.ajax({
                url: $scope.BASE_FOLDER+'/sync/createFolder',
                data: {path: 'ParaBlu/', folderName: folderName, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                console.log(data);
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                    $('#createFolder').modal('hide');
                    $('#folderName').val('');
                    $scope.folderName = '';
                    $scope.updateFileList('root', 'root', true, true);
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            toastr.error('Please enter a <b>Folder</b> Name', 'Fail!!!', {allowHtml: true});
        }
    };

    function isSpecialChar(val) {
        var tr = $.trim(val).length;
        if(val && tr) {
            var regex = /[*|\\":<>/?]/;
            if(regex.test(val)){
                return false;
            }
        }
        else{
            return false;
        }
        return true;
    }

    function isSpecialCharForMiniCloud(val) {
        var tr = $.trim(val).length;
        if(val && tr) {
            var regex = /[$-/:-?{-~!"^_`\[\]]/;
            if(regex.test(val)){
                return false;
            }
        }
        else{
            return false;
        }
        return true;
    }

    $scope.exportToExcel=function(tableId, name, items){

        if(items){
            if(items.length > 0){
                var exportHref=Excel.tableToExcel(tableId, name);

                $timeout(function(){
                    var dt = new Date();
                    var day = dt.getDate();
                    var month = dt.getMonth() + 1;
                    var year = dt.getFullYear();
                    var hour = dt.getHours();
                    var mins = dt.getMinutes();
                    var postfix = day + "." + month + "." + year + "_" + hour + "." + mins;
                    var a = document.createElement('a');
                    var clickEvent = new MouseEvent("click", {
                        "view": window,
                        "bubbles": true,
                        "cancelable": false
                    });
                    a.href = exportHref;
                    a.download = name + postfix + '.xls';
                    a.dispatchEvent(clickEvent);

                },100);
            }else{
                toastr.error('No sufficient data to export to excel', 'Fail!!!', {allowHtml: true});
            }
        }else{
            toastr.error('No sufficient data to export to excel', 'Fail!!!', {allowHtml: true});
        }
    }

}]);
