/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('DeviceController', ['$scope', 'toastr', 'Upload', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, Upload, $http, $ngBootbox, blockUI, BASE_FOLDER) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();
    $scope.skipValue = 0;
    $scope.devices = [];
    $scope.selectedDevice = '';
    $scope.currentSelectedDeviceName = '';

    $scope.updateDevices = function(deviceName, skipValue){
        $('.loading').show();
        $.ajax({
            url: $scope.BASE_FOLDER+'/devices',
            data: {deviceName: deviceName, skipValue: skipValue, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                $('.deviceListTable').show();
                if(deviceName == 'all'){
                    if(jData.devices.length > 0){
                        $scope.skipValue = $scope.skipValue+1;
                        if(deviceName == 'all'){
                            $scope.devices = jData.devices;
                        }else{
                            jData.devices.forEach(function($value){
                                $scope.devices.push($value);
                            });
                        }
                        if($scope.devices.length < 1000){
                            $scope.updateDevices(deviceName, $scope.skipValue);
                        }
                        $scope.$apply();
                        $('.loadMoreBtn').removeAttr('disabled');
                        $('.loadMoreBtn').html('Load More ...');
                        $('.loadMoreBtn').show();
                        $('.loadMore').show();
                    }else{
                        $('.loadMore').hide();
			$('.nodevice').hide();
                    }
                }else{
                    if(jData.devices.length > 0){
                        $scope.devices = jData.devices;
                        $scope.$apply();
                        $('.loadMore').hide();
			$('.nodevice').hide();
                    }else{
                        $('.loading').hide();
			$('.nodevice').show();
			$('.deviceListTable').hide();
                        $('[name="searchUsername"]').popover('show');
                    }
                }
            }else{
                toastr.error('Due to some technical issues complete details was not retrieved, please try again later', 'Fail!!!', {allowHtml: true});
                $scope.$apply();
                $('.loadMoreBtn').removeAttr('disabled');
                $('.loadMoreBtn').html('Load More ...');
                $('.loadMoreBtn').show();
                $('.loadMore').hide();
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.searchDevice = function(userName){
        $('[name="searchUsername"]').popover('hide');
        $('.loading').html('Loading ...');
        if(userName.length == 0){
            userName = 'all';
        }
        $scope.updateDevices(userName, 0);
    };

    $scope.loadMoreDevices= function(skipValue){
        $('.loadMoreBtn').attr('disabled','disabled');
        $('.loadMoreBtn').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        $scope.updateDevices('all', skipValue);
    };

    $scope.blockUnBlockDevice = function(deviceId, action, key){

        $.ajax({
            url: $scope.BASE_FOLDER+'/device/blockUnBlockDevice',
            data: {device: $scope.devices[key], action: action, csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                if(action == true){
                    $scope.devices[key].blocked = 'true';
                }else{
                    $scope.devices[key].blocked = 'false';
                }
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                $scope.$apply();
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.deleteDevice = function(deviceId, key){
        $.ajax({
            url: $scope.BASE_FOLDER+'/device/deleteDevice',
            data: {device: $scope.devices[key], csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            $('.loading').hide();
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                $scope.devices.splice(key, 1);
                $scope.$apply();
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.blockMultipleDevices = function(blocked){
        var deviceUUIDs;
        var html;
        if(blocked == true){
            deviceUUIDs = $('.blockDevices').val();
        }else{
            deviceUUIDs = $('.unBlockDevices').val();
        }
        if(deviceUUIDs != null){
            if(blocked == true){
                html = $('.block').html();
                $('.block').attr('disabled','disabled');
                $('.block').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }else{
                html = $('.unBlock').html();
                $('.unBlock').attr('disabled','disabled');
                $('.unBlock').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            }
            $.ajax({
                url: $scope.BASE_FOLDER+'/device/blockMultipleDevices',
                data: {deviceUUIDs: deviceUUIDs, blocked: blocked, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    if(blocked == true){
                        $('.blockDevices').val(null).trigger('change');
                        $('.block').html(html);
                        $('.block').removeAttr('disabled');
                    }else{
                        $('.unBlockDevices').val(null).trigger('change');
                        $('.unBlock').html(html);
                        $('.unBlock').removeAttr('disabled');
                    }
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(blocked == true){
                toastr.error('Please select a device to block', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a device to Un Block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.deleteMultipleDevices = function(){
        var deviceUUIDs = $('.unBlockDevices').val();
        var html;
        if(deviceUUIDs != null){
            html = $('.deleteBTN').html();
            $('.deleteBTN').attr('disabled','disabled');
            $('.deleteBTN').html('Loading... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
            $.ajax({
                url: $scope.BASE_FOLDER+'/device/deleteMultipleDevices',
                data: {deviceUUIDs: deviceUUIDs, csrf_token: $('.csrf_token').html()},
                type: 'POST'
            }).done(function(data){
                $('.deleteBTN').html(html);
                $('.deleteBTN').removeAttr('disabled');
                var jData = JSON.parse(data);
                if(jData.result == 'success'){
                    $('.unBlockDevices').val(null).trigger('change');
                    toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                }else{
                    toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
                }
            }).error(function(data){
                toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
                if(data.status == 424){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/sleep';
                    }, 3000);
                }else if(data.status == 503){
                    setTimeout(function(){
                        window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                    }, 3000);
                }
            });
        }else{
            if(blocked == true){
                toastr.error('Please select a device to block', 'Fail!!!', {allowHtml: true});
            }else{
                toastr.error('Please select a device to Un Block', 'Fail!!!', {allowHtml: true});
            }
        }
    };

    $scope.properties = function($index){
        $scope.selectedDevice = $scope.devices[$index];
        $('.deviceDetails').modal('show')
    };

    $scope.initiateRestoreBackup = function(uuid, deviceName){
        $('.restoreBucket').modal('show');
        $scope.currentSelectedDeviceUUID = uuid;
        $scope.currentSelectedDeviceName = deviceName;
    };

    $scope.sendFilesForRestore = function(deviceName, destinationPath){
        deviceName = (deviceName != "default" && deviceName != undefined) ? deviceName : $scope.currentSelectedDeviceName;
        var deviceLevelRestore = 'true';
        var selectedBTN = $('.restoreBtnForFiles');
        var html = selectedBTN.html();
        selectedBTN.attr('disabled','disabled');
        selectedBTN.html('Initiating... <i class="fa fa-circle-o-notch fa-spin"></i>').animate();
        var paths = [];
        $.ajax({
            url: $scope.BASE_FOLDER+'/backup/files/sendFilesForRestore',
            data: {csrf_token: $('.csrf_token').html(),deviceLevelRestore: deviceLevelRestore, paths: paths, deviceName:deviceName, path: destinationPath, restoreAllVersions: $('[name="restoreAllVersions"]').val(), deviceUUID: $scope.currentSelectedDeviceUUID},
            type: 'POST'
        }).done(function(data){
            selectedBTN.removeAttr('disabled');
            selectedBTN.html('Initiate Restore');
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.msg, 'Successful!!!', {allowHtml: true});
                setTimeout(function(){
                    window.location.reload(true);
                }, 3000);
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'devices'){
            blockUI.start();
            $scope.updateDevices('all', $scope.skipValue);
        }

    });

    $scope.sendMeTo = function(location){
        window.location.href = location;
    };

}]);
