<?php
/**
 * Created by PhpStorm.
 * User: parablu-dev
 * Developer: Prashanth Kumar B
 * Date: 6/10/15
 * Time: 12:41 PM
 */


//create alias for Router
use Core\Router;
use Helpers\Hooks;

//module routes
$hooks = Hooks::get();
$hooks->run('routes');

/* Amazon */
Router::get('amazon/create', 'AmazonController@create');
Router::post('amazon/create', 'AmazonController@saveCloud');
Router::post('amazon/saveUser', 'AmazonController@amazonSaveUser');
Router::post('checkCloudName', 'AmazonController@checkCloudName');

Router::get('', 'IndexController@index');
Router::get('dashboard', 'IndexController@index');
Router::get('auth', 'LoginController@authFromAgent');
Router::post('passwordRest', 'LoginController@passwordRest');
Router::get('restPassword', 'LoginController@restPassword');
Router::post('updatePassword', 'LoginController@updatePassword');

Router::post('setSessionForRedirect', 'MechanicController@setSessionForRedirect');
Router::post('getBestBlukrypt', 'MechanicController@getBestBlukrypt');

/* User Related Routes */
Router::get('userGroup', 'UserController@createUserGroup');
Router::post('deleteUserGroup', 'UserController@deleteUserGroup');
Router::get('user/create', 'UserController@createUser');
Router::post('user/create', 'UserController@saveNewUserDetails');
Router::get('users', 'UserController@users');
Router::post('users', 'UserController@getAllUsers');
Router::get('users/usersBulkBlockDelete', 'UserController@usersBulkBlockDelete');
Router::post('user/changePassword', 'UserController@changePassword');
Router::post('user/devices', 'UserController@getAllUserDevices');
Router::get('user/device/policyInfo/(:any)/(:any)/(:any)', 'DeviceController@getDevicePolicyInformation');
Router::post('user/device/policyInfo', 'DeviceController@getCurrentDeviceIDInformation');
Router::post('user/device/policyInfo/addInclusionFolder', 'DeviceController@addInclusionFolder');
Router::post('user/device/policyInfo/removeInclusionFolder', 'DeviceController@removeInclusionFolder');
Router::post('user/device/policyInfo/addExclusionFolder', 'DeviceController@addExclusionFolder');
Router::post('user/device/policyInfo/removeExclusionFolder', 'DeviceController@removeExclusionFolder');

Router::get('user/backupHistory/(:any)/(:any)', 'HistoryController@backupHistory');
Router::post('user/backupHistory', 'HistoryController@getBackupHistory');
Router::post('user/backupHistoryDetails', 'HistoryController@getBackupHistoryDetails');
Router::get('activityHistory', 'HistoryController@activityHistory');
Router::post('activityHistory', 'HistoryController@getActivityHistory');

Router::get('backup/files/(:any)/(:any)/(:any)', 'BackupController@files');
Router::get('backup/files/restore/(:any)/(:any)/(:any)', 'BackupController@restoreFiles');
Router::post('backup/files', 'BackupController@getFiles');
Router::post('backup/restore', 'BackupController@initiateRestore');
Router::post('backup/files/fileVersions', 'BackupController@getFileVersions');
Router::post('backup/files/fileChunks', 'BackupController@getFileChunks');
Router::post('backup/file/delete', 'BackupController@backupFileDelete');
Router::post('backup/files/sendFilesForRestore', 'BackupController@initiateRestore');
Router::post('backup/files/checkRestoreProgress', 'BackupController@checkRestoreProgress');
Router::get('backup/devices', 'BackupController@devices');
Router::post('backup/devices', 'BackupController@getDevices');
Router::post('backup/files/share', 'BackupController@shareFile');
Router::post('backup/files/updateSharePolicy', 'BackupController@updateSharePolicy');
Router::post('backup/files/unShare', 'BackupController@unShare');
Router::get('myAccount', 'UserController@myAccount');
Router::get('myAccount/(:any)', 'UserController@myAccount');
Router::any('user/settings', 'UserController@settings');
Router::any('user/settings/(:any)', 'UserController@settings');
Router::post('user/device/deviceDetails', 'UserController@deviceDetails');
Router::post('user/save', 'UserController@saveUserDetails');
Router::post('user/block', 'UserController@block');
Router::post('user/delete', 'UserController@delete');
Router::post('user/allNames', 'UserController@getAllUserNames');
Router::get('user/searchUserName', 'UserController@searchUsers');
Router::get('user/searchUserWithDevice', 'UserController@searchUserWithDevice');
Router::get('user/getAllBlockedUsers', 'UserController@getAllBlockedUsers');
Router::get('user/getAllUnBlockedUsersWithLoggedInUser', 'UserController@getAllUnBlockedUsersWithLoggedInUser');
Router::get('user/getAllUnBlockedUsers', 'UserController@getAllUnBlockedUsers');
Router::post('users/deleteMultipleUsers', 'UserController@deleteMultipleUsers');
Router::post('users/blockMultipleUsers', 'UserController@blockMultipleUsers');
Router::get('userGroups/getAllUnBlockedUsersWithGroups', 'UserController@getAllUnBlockedUsersWithGroups');

Router::get('devices', 'DeviceController@devices');
Router::get('device/searchDevices', 'DeviceController@searchDevices');
Router::post('devices', 'DeviceController@getAllDevices');
Router::post('device/blockUnBlockDevice', 'DeviceController@blockUnBlockDevice');
Router::post('device/deleteDevice', 'DeviceController@deleteDevice');
Router::get('devices/devicesBulkBlock', 'DeviceController@devicesBulkBlock');
Router::post('device/blockMultipleDevices', 'DeviceController@blockMultipleDevices');
Router::post('device/deleteMultipleDevices', 'DeviceController@deleteMultipleDevices');
Router::get('device/getAllBlockedDevices', 'DeviceController@getAllBlockedDevices');
Router::get('device/getAllUnBlockedDevices', 'DeviceController@getAllUnBlockedDevices');

/* Policy management System */
Router::get('pms', 'PmsController@pms');
Router::get('pms/schedule/create', 'PmsController@createSchedule');
Router::get('pms/schedules', 'PmsController@schedules');
Router::post('pms/schedule', 'PmsController@getSchedule');
Router::post('pms/schedule/save', 'PmsController@saveSchedule');
Router::post('pms/schedules', 'PmsController@getSchedules');
Router::post('sync/getSyncRevisionId', 'SyncController@getSyncRevisionId');

Router::get('pms/filter/create', 'PmsController@createFilter');
Router::get('pms/filters', 'PmsController@filters');
Router::post('pms/filter/save', 'PmsController@saveFilter');
Router::post('pms/filter', 'PmsController@getFilter');
Router::post('pms/filters', 'PmsController@getFilters');

Router::get('pms/filter/create', 'PmsController@createFilter');
Router::get('pms/filter/edit', 'PmsController@editFilter');
Router::post('pms/filter/save', 'PmsController@saveFilter');
Router::post('pms/filter', 'PmsController@getFilter');
Router::post('pms/filters', 'PmsController@getFilters');

Router::get('pms/policy/create', 'PmsController@createPolicy');
Router::get('pms/policy/edit/(:any)', 'PmsController@editPolicy');
Router::get('pms/policies', 'PmsController@polices');
Router::post('pms/policy/save', 'PmsController@savePolicy');
Router::post('pms/policy', 'PmsController@getPolicy');
Router::post('pms/user/policy', 'PmsController@getUserPolicy');
Router::post('pms/policies', 'PmsController@getPolicies');

Router::get('pms/policyMapping/single','PmsController@singlePolicyMapping');
Router::get('pms/policyMapping/multiple','PmsController@multiplePolicyMapping');
Router::get('pms/policyMapping/server/multiple','PmsController@serverMultiplePolicyMapping');
Router::get('pms/policyMapping/server/single','PmsController@serverSinglePolicyMapping');
Router::post('pms/policyMapping/server/single','PmsController@getServerPolicyMappingList');
Router::post('pms/policyMapping/single','PmsController@getPolicyMappingDetails');
Router::post('pms/policyMapping/single/save','PmsController@saveSinglePolicyMapping');
Router::post('pms/policyMapping/server/save','PmsController@saveServerPolicyMapping');
Router::post('pms/policyMapping/multiple/save','PmsController@saveMultiplePolicyMapping');

Router::get('pms/sync/policy/create', 'SyncPmsController@createPolicy');
Router::get('pms/sync/policy/edit/(:any)', 'SyncPmsController@editPolicy');
Router::get('pms/sync/policies', 'SyncPmsController@polices');
Router::post('pms/sync/policy/save', 'SyncPmsController@savePolicy');
Router::post('pms/sync/policy', 'SyncPmsController@getPolicy');
Router::post('pms/sync/user/policy', 'SyncPmsController@getUserSyncPolicy');
Router::post('pms/sync/policies', 'SyncPmsController@getPolicies');

Router::get('pms/sync/policyMapping/single','SyncPmsController@singlePolicyMapping');
Router::get('pms/sync/policyMapping/multiple','SyncPmsController@multiplePolicyMapping');
Router::post('pms/sync/policyMapping/single','SyncPmsController@getPolicyMappingDetails');
Router::post('pms/sync/policyMapping/single/save','SyncPmsController@saveSinglePolicyMapping');
Router::post('pms/sync/policyMapping/multiple/save','SyncPmsController@saveMultiplePolicyMapping');

/*User Based file Actions*/
Router::any('upload', 'UserController@upload');

/* Authentication Related Routes */
Router::get('login', 'LoginController@index');
Router::get('sleep', 'LoginController@sleep');
Router::post('login', 'LoginController@authenticate');

Router::get('password-rest', 'LoginController@passwordReset');
Router::get('logout', 'LoginController@logout');

Router::get('report/dashboard', 'ReportController@dashboard');
Router::get('report/statistics', 'ReportController@statistics');
Router::post('report/statistics', 'ReportController@getStatistics');
Router::post('report/statistics/serverBackup', 'ReportController@getServerBackupStatistics');
Router::get('report/overview', 'ReportController@overview');
Router::post('report/overview', 'ReportController@getOverview');
Router::get('report/syncOverview', 'ReportController@syncOverview');
Router::post('report/syncOverview', 'ReportController@getSyncOverview');
Router::get('report/longBackup', 'ReportController@longBackup');
Router::post('report/longBackup', 'ReportController@getLongBackup');
Router::get('report/currentBackup', 'ReportController@currentBackup');
Router::post('report/currentBackup', 'ReportController@getCurrentBackup');
Router::get('report/noBackup', 'ReportController@noBackup');
Router::post('report/noBackup', 'ReportController@getNoBackup');
Router::get('report/restoreByDate', 'ReportController@restoreByDate');
Router::get('report/restoreByUser', 'ReportController@restoreByUsername');
Router::get('report/restoreByDevice', 'ReportController@restoreByDevice');
Router::post('report/restoreHistory', 'ReportController@getRestoreHistory');

Router::get('report/storageUtilizedByUser', 'ReportController@storageUtilizedByUser');
Router::get('report/storageUtilizedByDevice', 'ReportController@storageUtilizedByDevice');
Router::post('report/storageUtilized', 'ReportController@getStorageUtilized');
Router::get('report/storageUtilizedByPG', 'ReportController@storageUtilizedByPG');
Router::post('report/storageUtilizedByPG', 'ReportController@getStorageUtilizedByPG');
Router::get('report/failedBackup', 'ReportController@failedBackup');
Router::post('report/failedBackup', 'ReportController@getFailedBackup');
Router::get('report/failedBackupByUser', 'ReportController@failedBackupByUser');
Router::get('report/failedBackupByDevice', 'ReportController@failedBackupByDevice');
Router::post('report/failedBackupByUserOrDevice', 'ReportController@getFailedBackupByUserOrDevice');
Router::get('report/storageTrend', 'ReportController@storage');
Router::post('report/storageTrend', 'ReportController@getStorageTrend');
Router::get('report/blobTrend', 'ReportController@blobTrend');
Router::post('report/blobTrend', 'ReportController@getBlobTrend');
Router::get('report/backupTrend', 'ReportController@backupTrend');
Router::post('report/backupTrend', 'ReportController@getBackupTrend');
Router::get('report/userDeviceHistory', 'ReportController@userDeviceHistory');
Router::post('report/userDeviceHistory', 'ReportController@getUserDeviceHistory');
Router::get('report/userBackupHistory', 'ReportController@userBackupHistory');
Router::post('report/userBackupHistory', 'ReportController@getUserBackupHistory');
Router::get('report/dailyUserBackupOverview', 'ReportController@dailyUserBackupOverview');
Router::post('report/getDailyUserBackupOverview', 'ReportController@getDailyUserBackupOverview');
Router::post('report/downloadDailyUserBackupOverview', 'ReportController@downloadDailyUserBackupOverview');
Router::get('report/downloadDailyUserBackupOverviewExcel', 'ReportController@downloadDailyUserBackupOverviewExcel');
Router::get('report/deviceUserHistory', 'ReportController@deviceUserHistory');
Router::post('report/deviceUserHistory', 'ReportController@getDeviceUserHistory');
Router::get('report/deviceBackupHistory', 'ReportController@deviceBackupHistory');
Router::post('report/deviceBackupHistory', 'ReportController@getDeviceBackupHistory');
Router::get('report/lastBackupByUser', 'ReportController@lastBackupByUser');
Router::get('report/lastBackupByDevice', 'ReportController@lastBackupByDevice');
Router::post('report/lastBackupDetails', 'ReportController@getLastBackupDetails');
Router::get('report/alertByDevice', 'ReportController@alertByDevice');
Router::get('report/alertByUser', 'ReportController@alertByUser');
Router::get('report/alertByDate', 'ReportController@alertByDate');
Router::post('report/alertHistory', 'ReportController@getAlertHistory');
Router::get('report/userMigration', 'ReportController@userMigration');
Router::post('report/userMigration', 'ReportController@getUserMigration');
Router::get('report/download/overviewReport', 'ReportController@downloadOverViewReport');
Router::get('report/download/syncOverviewReport', 'ReportController@downloadSyncOverViewReport');

Router::get('report/syncDashboard', 'ReportController@syncDashboard');
Router::get('report/syncCLoudUsage', 'ReportController@syncCLoudUsage');
Router::get('report/download/downloadOverViewReportSync', 'ReportController@downloadOverViewReportSync');
Router::post('report/syncCLoudUsage', 'ReportController@getSyncCLoudUsage');
Router::post('report/updateSyncCloudUsageDetails', 'ReportController@updateSyncCloudUsageDetails');

Router::get('migration', 'MigrationController@migration');
Router::post('migration', 'MigrationController@getMigrationDetails');
Router::get('migration/importUsers', 'MigrationController@importUsers');
Router::post('migration/getUsers', 'MigrationController@getUsers');
Router::post('migration/migrateUsers', 'MigrationController@migrateUsers');

Router::get('settings', 'SettingsController@dashboard');
Router::get('settings/email', 'SettingsController@email');
Router::post('settings/email', 'SettingsController@writeToMailConfig');
Router::get('settings/proxy', 'SettingsController@proxy');
Router::post('settings/proxyremove', 'SettingsController@proxyremove');
Router::post('settings/proxy', 'SettingsController@writeProxySettings');
Router::post('settings/editproxy', 'SettingsController@editProxySettings');
Router::get('settings/domain', 'SettingsController@domain');
Router::post('settings/domain', 'SettingsController@writeDomainHost');
Router::get('settings/sslAndEncryption', 'SettingsController@sslAndEncryption');
Router::post('settings/ssl', 'SettingsController@saveSSLCertificate');
Router::get('settings/encryption', 'SettingsController@encryption');
Router::post('settings/encryption', 'SettingsController@saveEncryption');
Router::get('settings/local', 'SettingsController@local');
Router::post('settings/local', 'SettingsController@saveLocal');
Router::get('settings/connector', 'SettingsController@connector');
Router::post('settings/odb', 'SettingsController@writeODB');
Router::post('settings/odc', 'SettingsController@writeODC');
Router::post('settings/google', 'SettingsController@writeGoogle');
Router::get('settings/adCredentials', 'SettingsController@adCredentials');
Router::post('settings/getAdCredential', 'SettingsController@getAdCredential');
Router::post('settings/getAdCredentials', 'SettingsController@getAdCredentials');
Router::post('settings/saveAdCredentials', 'SettingsController@saveAdCredentials');
Router::post('settings/editAdCredentials', 'SettingsController@editAdCredentials');
Router::post('settings/removeAdCredentials', 'SettingsController@removeAdCredentials');
Router::get('settings/smtp','SettingsController@smtp');
Router::post('settings/smtp','SettingsController@saveSmtp');
Router::get('settings/cloudProperties','SettingsController@cloudProperties');
Router::post('settings/cloudProperties','SettingsController@saveCloudProperties');

Router::get('settings/cloudCredentials', 'SettingsController@cloudCredentials');
Router::get('pms/cloudCredentials', 'PmsController@cloudCredentials');
Router::post('settings/getCloudCredentials', 'SettingsController@getAllCcS');
Router::post('settings/saveCloudCredentials', 'SettingsController@saveCloudCredentials');
Router::post('settings/removeCloudCredentials', 'SettingsController@removeCloudCredentials');

Router::get('settings/paracloudblukrypt','PmsController@paracloudblukrypt');
Router::post('pms/bluvault','PmsController@getBluvault');
Router::post('pms/bluvault/save','PmsController@saveBluvault');
Router::post('pms/bluvault/delete','PmsController@deleteBluvault');

Router::get('settings/networkThrottling','PmsController@networkThrottling');
Router::get('pms/throttling/set/(:any)/(:any)','PmsController@networkThrottlingSet');
Router::post('pms/throttling/save','PmsController@saveThrottlingLimit');
Router::post('pms/throttling/remove','PmsController@removeThrottlingLimit');

Router::get('settings/blukrypt','PmsController@blukrypt');
Router::post('pms/getAllBlukrypts','PmsController@getAllBlukrypts');
Router::post('pms/blukrypt/save','PmsController@saveBlukrypt');
Router::post('pms/blukrypt/remove','PmsController@removeBlukrypt');

Router::get('support', 'SupportController@support');
Router::get('logDetails/(:any)', 'SupportController@getLogDetails');
Router::get('downloadLog/(:any)/(:any)', 'SupportController@downloadLog');
Router::post('support', 'SupportController@getSupportLogs');

Router::get('download', 'MechanicController@download');
Router::get('trigger/download', 'MechanicController@downloadAgent');

/* Sync Releated Routes */
Router::get('sync/files', 'SyncController@files');
Router::get('sync/file/download', 'SyncController@download');
Router::post('sync/files', 'SyncController@getAllFiles');
Router::post('sync/files/delete', 'SyncController@deleteFilesFolders');
Router::post('sync/files/share', 'SyncController@shareFile');
Router::post('sync/files/shareWith', 'SyncController@shareFileWith');
Router::post('sync/files/unShare', 'SyncController@unShare');
Router::post('sync/files/updateSharePolicy', 'SyncController@updateSharePolicy');
Router::post('sync/files/cut', 'SyncController@cut');
Router::post('sync/files/copy', 'SyncController@copy');
Router::post('sync/files/paste', 'SyncController@paste');
Router::post('sync/files/checkForFilesCopiedOrCut', 'SyncController@checkForFilesCopiedOrCut');
Router::post('sync/files/isShareCheck', 'SyncController@isShareCheck');

Router::post('sync/minicloud/delete', 'SyncController@deleteMiniCloud');
Router::post('sync/files/versions', 'SyncController@getFileVersions');
Router::post('sync/files/versions/saveComments', 'SyncController@saveFileRevisionComments');
Router::post('sync/file/upload', 'SyncController@upload');
Router::post('sync/createMiniCloud', 'SyncController@createMiniCloud');
Router::post('sync/createFolder', 'SyncController@createFolder');
Router::post('sync/files/saveRename', 'SyncController@saveRename');
Router::post('sync/sendShareEmail', 'SyncController@sendShareEmail');
Router::post('sync/view', 'ParaViewController@reader');
Router::post('backup/view', 'ParaViewController@backupReader');
Router::get('pdfViewer', 'ParaViewController@pdfViewer');

Router::get('miniClouds', 'SyncController@miniClouds');
Router::post('miniClouds', 'SyncController@getMiniClouds');
Router::post('miniClouds/changeOwner', 'SyncController@changeOwner');
Router::post('miniClouds/assignUsers', 'SyncController@assignUsers');

Router::post('contentSearch', 'SyncController@getSearchResults');
Router::post('goToPath', 'SyncController@goToPath');

Router::get('trash', 'SyncController@trash');
Router::post('trash', 'SyncController@getDeletedFiles');
Router::post('trash/restoreFile', 'SyncController@restoreFile');
Router::post('trash/purgeFile', 'SyncController@purgeFile');
Router::post('trash/restoreAll', 'SyncController@restoreAll');
Router::post('trash/purgeAll', 'SyncController@purgeAll');
Router::get('openFileLocation', 'SyncController@openFileLocation');
Router::get('backup/openFileLocation', 'BackupController@openFileLocation');

Router::get('googleOAuth', 'StorageController@googleOAuth');
Router::get('odb', 'StorageController@odb');
Router::get('odbrelogin', 'StorageController@odbrelogin');

Router::get('share/myShares', 'SyncController@myShares');
Router::post('share/myShares', 'SyncController@getSharedFiles');
Router::get('share/filesSharedWithMe', 'SyncController@filesSharedWithMe');
Router::post('share/filesSharedWithMe', 'SyncController@getFilesSharedWithMe');
Router::get('share/SharesWithMe', 'SyncController@SharesWithMe');
Router::post('share/SharesWithMe', 'SyncController@getSharedWithMeFiles');
Router::get('share/activityHistory', 'HistoryController@shareActivityHistory');
Router::post('share/activityHistory', 'HistoryController@getShareActivityHistory');
Router::get('cloudInfo', 'MechanicController@cloudInfo');

Router::get('share/(:any)/(:any)/(:any)/(:any)/(:any)', 'ShareController@index');
Router::post('share/checkPassword', 'ShareController@checkPassword');
Router::get('share/file/download', 'ShareController@download');
Router::post('share/view', 'ParaViewController@sharedFileReader');
Router::post('backup/share/view', 'ParaViewController@sharedBackupFileReader');
Router::post('share/checkIfFileShared', 'ShareController@checkIfFileShared');

Router::post('readExcelFromUpload', 'MechanicController@readExcelFromUpload');
Router::get('exportActivityHistoryToExcel/(:any)', 'HistoryController@downloadExportActivityHistoryToExcel');
Router::post('exportActivityHistoryToExcel', 'HistoryController@exportActivityHistoryToExcel');
Router::get('exportShareActivityHistoryToExcel/(:any)', 'HistoryController@downloadExportShareActivityHistoryToExcel');
Router::post('exportShareActivityHistoryToExcel', 'HistoryController@exportShareActivityHistoryToExcel');

Router::get('server/dashboard', 'IndexController@serverBackup');
Router::get('server/pms/policyMapping/single', 'PmsController@serverSinglePolicyMapping');
Router::get('server/pms/policyMapping/multiple', 'PmsController@serverMultiplePolicyMapping');
Router::get('servers', 'ServerController@listOfServers');
Router::post('server/files', 'ServerController@getFiles');
Router::post('servers', 'ServerController@getAllDevices');
Router::get('server/jobs', 'ServerController@listOfServerJobs');
Router::get('server/new', 'ServerController@addAServer');
Router::get('server/restore/(:any)/(:any)/(:any)', 'ServerController@restore');
Router::get('server/attachContainer/(:any)/(:any)', 'ServerController@attachContainer');
Router::get('device/getAllServers', 'ServerController@getAllServers');
Router::get('backup/getAllUnblockedDevices', 'BackupController@getAllUnblockedDevices');
Router::post('backup/files/isShareCheck', 'BackupController@isShareCheck');
Router::post('server/jobs', 'ServerController@getListOfServerJobs');
Router::post('server/createContainer', 'ServerController@saveContainer');
Router::post('server/createContainer', 'ServerController@saveContainer');
Router::post('server/editSaveContainer', 'ServerController@editSaveContainer');
Router::post('server/remove/container', 'ServerController@removeContainer');
Router::post('server/containers', 'ServerController@getAllContainers');
Router::post('server/initiateBackup', 'ServerController@initiateBackup');
Router::post('server/getSupportLogs', 'ServerController@getSupportLogs');
Router::post('server/initiateRefreshPolicy', 'ServerController@initiateRefreshPolicy');
Router::post('server/decoupleAgent', 'ServerController@decoupleAgent');
Router::post('server/terminateServerJob', 'ServerController@terminateServerJob');
Router::post('server/initiateRestore', 'ServerController@initiateRestore');

/* Default Route */
Router::error('error@index');
Router::get('serviceDown', 'error@serviceDown');


/* turn on old style routing */
Router::$fallback = false;

/* execute matched routes */
Router::dispatch();
