<?php
namespace Models;

use Core\Model;

/**
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Class User
 * @package Models
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class User extends Model{

    /**
     * Constructing the parent
     */
    public function __construct(){
        parent::__construct();
        $this->log('User Model was called', 'info');
    }

    public function getCloudCredentials($headers){
        $url = $this->api->getUrl('getCloudCredentials');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserDetails($headers, $username){
        $url = $this->api->getUrl('userDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.str_replace(' ', '%20', $username).DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log($url.DS.str_replace(' ', '%20', $username).DS, 'info');
        $this->log('headers: '.json_encode($headers), 'info');
        $this->log(json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @return array
     */
    public function getDeviceDetails($headers){
        $url = $this->api->getUrl('getDeviceDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * below method Gets all the devices
     * of a particular user
     *
     * @param $headers
     * @return array
     */
    public function getUserDevices($headers){
        $url = $this->api->getUrl('myDevices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below method Gets all the Mini Clouds
     *
     * @param $headers
     * @return array
     */
    public function getAllMiniClouds($headers){
        $url = $this->api->getUrl('allMiniClouds');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below method Gets all User Names
     *
     * @param $headers
     * @return array
     */
    public function getAllNames($headers){
        $url = $this->api->getUrl('allUserNames');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'url' => $url,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Updates the user Details
     *
     * @param $headers
     * @param $userString
     * @param $userName
     * @return array
     */
    public function updateUserDetails($headers, $userString, $userName){
        $url = $this->api->getUrl('updateUserDetails', array('userName' => $userName));
        $this->curl->setHeaders($headers);
        $this->curl->put($url, $userString);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Retrieves all the users
     *
     * @param $headers
     * @return array
     */
    public function getAllUsers($headers){
        $url = $this->api->getUrl('users');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Retrieves Users according to search pattern
     *
     * @param $headers
     * @return array
     */
    public function searchForAUser($headers){
        $url = $this->api->getUrl('searchUser');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Retrieves Users according to search pattern
     *
     * @param $headers
     * @return array
     */
    public function searchUserWithDevice($headers){
        $url = $this->api->getUrl('searchUserWithDevice');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Retrieves all the users
     *
     * @param $headers
     * @return array
     */
    public function getAllUsersWithGroup($headers){
        $url = $this->api->getUrl('usersGroup');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Retrieves Users according to search pattern
     *
     * @param $headers
     * @return array
     */
    public function searchForAUserWithGroup($headers){
        $url = $this->api->getUrl('searchGroupUser');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $username
     * @return array
     */
    public function blockUser($headers, $username){
        $url = $this->api->getUrl('userBlock', array('userName' => $username));
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $username
     * @return array
     */
    public function deleteUser($headers, $username){
        $url = $this->api->getUrl('userDelete', array('userName' => $username));
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function userDevicePolicyInfo($headers){
        $url = $this->api->getUrl('userDevicePolicyInfo');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('UserDetails'.json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addInclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addInclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeInclusionFolder($headers){
        $url = $this->api->getUrl('removeInclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @param $folder
     * @return array
     */
    public function addExclusionFolder($headers, $folder){
        $url = $this->api->getUrl('addExclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folder);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * getUrl -> userName -> should be the getting blocked userName
     * loggedIn userName should be sent in header
     * @param $headers
     * @return array
     */
    public function removeExclusionFolder($headers){
        $url = $this->api->getUrl('removeExclusionFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserData($headers, $username){
        $url = $this->api->getUrl('userDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.$username.DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @param $xml
     * @return array
     */
    public function createNewUser($headers, $username, $xml){
        $url = $this->api->getUrl('createNewUser');
        $this->curl->setHeaders($headers);
        $this->curl->post($url.DS.$username.DS, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below method block a list of users
     * In Header set active true to unblock
     * And set active false to block
     * @param $headers
     * @return array
     */
    public function blockMultipleUsers($headers){
        $url = $this->api->getUrl('blockMultipleUsers');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below method delete a list of users
     *
     * @param $headers
     * @return array
     */
    public function deleteMultipleUsers($headers){
        $url = $this->api->getUrl('deleteMultipleUsers');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @return array
     */
    public function getCloudLicense($headers){
        $url = $this->api->getUrl('cloudLicense');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllPolicies($headers){
        $url = $this->api->getUrl('getAllPolices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllSyncPolicies($headers){
        $url = $this->api->getUrl('getAllSyncPolices');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of User Groups
     *
     * @param $headers
     * @return array
     */
    public function getUserGroups($headers){
        $url = $this->api->getUrl('userGroups');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('url: '. $url, 'info');
        $this->log('headers: '. json_encode($headers), 'info');

        return $result;
    }

    /**
     * Below method delete a user group
     *
     * @param $headers
     * @param $groupName
     * @return array
     */
    public function deleteUserGroup($headers, $groupName){
        $url = $this->api->getUrl('deleteUserGroup');
        $this->curl->setHeaders($headers);
        $this->curl->post($url.$groupName.'/');
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $emailProps
     * @return array
     */
    public function sendMail($headers, $emailProps){
        $url = $this->api->getUrl('sendMail');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $emailProps);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Sending Mail for Block Headers and Body'. json_encode($emailProps), 'info');
        $this->log('Sending Mail for Block result'. json_encode($result), 'info');
        $this->log('Sending Mail for Block Url'. $url, 'info');
        return $result;
    }

    public function getOdbDetails($headers){
        $url = $this->api->getUrl('getOdbDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,

        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }


}
