<?php

namespace Controllers;

use Core\Language;
use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Pms;
use Models\SyncPms;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class SyncPmsController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('syncPms');
        $this->_model = new SyncPms();
        $this->verifyAndCleanItUp();
    }

    public function polices(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('polices'),
            'active' => 'pms',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/view', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicies(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getAllPolicies($headers);
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $policies = [];
                    if(!empty($result['body']->{'syncPolicyElementList'})) {
                        foreach ($result['body']->{'syncPolicyElementList'} as $value) {
                            $policy = array(
                                'policygroupName'       => (string)$value->{'policygroupName'},
                                'osType'                => (string)$value->{'osType'},
                                'policyRefresh'         => (string)$value->{'policyRefresh'},
                                'cloudCredential'       => (string)$value->{'cloudCredential'},
                                'maxFileSize'           => (string)$value->{'maxFileSize'},
                                'pftSize'               => (string)$value->{'pftSize'},
                                'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                                'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                                'crawlLimit'            => (string)$value->{'crawlLimit'},
                                'maxVersions'           => (string)$value->{'maxVersions'},
                                'userSizeAllowed'       => (string)$value->{'userSizeAllowed'},
                                'vssEnabled'            => (string)$value->{'vssEnabled'},
                                'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                                'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                                'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                                'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                                'filterInclusionName'   => (string)$value->{'filterInclusionName'},
                                'syncInterval'          => (string)$value->{'syncInterval'},
                                'expiredDate'           => (string)$value->{'expiredDate'},
                                'shareEnabled'          => (string)$value->{'shareEnabled'},
                                'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                                'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                                'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                                'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
                                'contentIndexEnabled'   => (string)$value->{'contentIndexEnabled'},
                                'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                                'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                                'pftEnabled'            => (string)$value->{'pftEnabled'},
                                'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                                'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
				'dedup' => (string)$value->{'dedup'},
                                'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
                            );
                            $policies = array_merge(array($policy), $policies);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'policies' => $policies
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getDaysString($numString){
        $numString = str_replace('1', Language::show('Sunday', 'keywords'), $numString);
        $numString = str_replace('2', Language::show('Monday', 'keywords'), $numString);
        $numString = str_replace('3', Language::show('Tuesday', 'keywords'), $numString);
        $numString = str_replace('4', Language::show('Wednesday', 'keywords'), $numString);
        $numString = str_replace('5', Language::show('Thursday', 'keywords'), $numString);
        $numString = str_replace('6', Language::show('Friday', 'keywords'), $numString);
        return str_replace('7', Language::show('Saturday', 'keywords'), $numString);
    }

    public function createPolicy(){
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy'),
            'crumb2' => $this->language->get('create'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/create', $data);
        View::renderTemplate('footer', $data);
    }

    public function savePolicy(){
        $list = array();
        if(empty($_POST['systemFolders']) || $_POST['systemFolders'] != 'enabled'){
            $_POST['systemFolders'] = 'false';
        }else{
            $_POST['systemFolders'] = 'true';
        }
        if(empty($_POST['legalHold']) || $_POST['legalHold'] != 'enabled'){
            $_POST['legalHold'] = 'false';
        }else{
            $_POST['legalHold'] = 'true';
        }
        if(empty($_POST['maxVersions']) || $_POST['maxVersions'] == 'unlimited'){
            $_POST['maxVersions'] = "-1";
        }
        if(empty($_POST['maxPermissibleFileSize']) || $_POST['maxPermissibleFileSize'] == 'unlimited'){
            $_POST['maxPermissibleFileSize'] = "-1";
        }
        if(empty($_POST['perUserBackupStorageLimit']) || $_POST['perUserBackupStorageLimit'] == 'unlimited'){
            $_POST['perUserBackupStorageLimit'] = "-1";
        }
        if(empty($_POST['machineMaxThreshold']) || $_POST['machineMaxThreshold'] == 'unlimited'){
            $_POST['machineMaxThreshold'] = 100;
        }
        if (strpos($_POST['policyRefresh'], ':') == false) {
            $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
        }
        if(!empty($_POST)){
            $rules = array(
                'incrementalFileTransfer'   => 'required',
                'maxPermissibleFileSize'    => 'required',
                'maxVersions'               => 'required',
                'networkThrottling'         => 'required',
                'dcmEnabled'                => 'required',
                'osTyped'                   => 'required',
                'partialFileSize'           => 'required',
                'fileChunkableSize'         => 'required',
                'userSizeAllowed'           => 'required',
                'pgList'                    => 'required',
                'policyName'                => 'required',
                'policyRefresh'             => 'required',
                'schedules'                 => 'required',
                'filters'                   => 'required'
            );
            $filters = array(
                'incrementalFileTransfer'   => 'trim|sanitize_string',
                'maxPermissibleFileSize'    => 'trim|sanitize_string',
                'maxVersions'               => 'trim|sanitize_string',
                'networkThrottling'         => 'trim|sanitize_string',
                'dcmEnabled'                => 'trim|sanitize_string',
                'osTyped'                   => 'trim|sanitize_string',
                'partialFileSize'           => 'trim|sanitize_string',
                'fileChunkableSize'         => 'trim|sanitize_string',
                'userSizeAllowed'           => 'trim|sanitize_string',
                'pgList'                    => 'trim|sanitize_string',
                'policyName'                => 'trim|sanitize_string',
                'policyRefresh'             => 'trim|sanitize_string',
                'filters'                   => 'trim|sanitize_string'
            );
            $filteredData = $this->valid->filter($_POST, $filters);
            $validate = $this->valid->validate($filteredData, $rules);

            if($validate == true){
                $headers = array(
                    'Content-Type'         => 'application/json',
                    'token'         => $this->session->get('token')
                );

                $_POST['pgList'] = explode(',',$_POST['pgList']);

                $privacyGatewayMappingElement = array(
                    'gatewayNwThrottlingName' => 'Default',
                    'privacyGatewayNames' => !empty($_POST['Blukryptipaddress']) ? $_POST['Blukryptipaddress'] : $list
                );

		if (strpos($_POST['policyRefresh'], ':') !== false) {
                    $_POST['policyRefresh'] = $_POST['policyRefresh'];
                }
                else{
                    $_POST['policyRefresh'] = $_POST['policyRefresh'].':00';
                }

                $data = array(
                    "syncEnableAutomatic"           => !empty($_POST['syncEnableAutomatic']) ? $_POST['syncEnableAutomatic'] : '',
                    "syncInterval"                  => !empty($_POST['syncInterval']) ? $_POST['syncInterval'] : '',
                    "contentIndexEnabled"           => !empty($_POST['contentIndexEnabled']) ? $_POST['contentIndexEnabled'] : '',
                    "deDuplicationEnabled"          => !empty($_POST['deDuplicationEnabled']) ? $_POST['deDuplicationEnabled'] : '',
                    "shareEnabled"                  => !empty($_POST['shareEnabled']) ? $_POST['shareEnabled'] : 'false',
                    "highSecureShareEnabled"        => !empty($_POST['highSecureShareEnabled']) ? $_POST['highSecureShareEnabled'] : '',
                    "complexPasswordRequired"       => ($_POST['highSecureShareEnabled'] == "true") ? "true" : $_POST['complexPasswordRequired'],
                    "preventDownloadEnabled"        => ($_POST['highSecureShareEnabled'] == "true") ? "false" : $_POST['preventDownloadEnabled'],
                    "expiredDate"                   => ($_POST['highSecureShareEnabled'] == "true") ? "true" : $_POST['expiredDate'],
                    "cacheUsedData"                 => !empty($_POST['cacheUsedData']) ? $_POST['cacheUsedData'] : '',
                    "policygroupName"               => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                    "cloudCredential"               => !empty($_POST['ccS']) ? $_POST['ccS'] : '',
                    "dcmEnabled"                    => !empty($_POST['dcmEnabled']) ? ($_POST['dcmEnabled'] == 'true') ? true : false : false,
                    "maxVersions"                   => !empty($_POST['maxVersions']) ? $_POST['maxVersions'] : '',
                    "maxFileSize"                   => !empty($_POST['maxFileSize']) ? $_POST['maxFileSize'] : '',
                    "osType"                        => !empty($_POST['osTyped']) ? $_POST['osTyped'] : '',
                    "pftEnabled"                    => !empty($_POST['incrementalFileTransfer']) ? $_POST['incrementalFileTransfer'] : '',
                    "pftSize"                       => !empty($_POST['partialFileSize']) ? $_POST['partialFileSize'] : 5,
                    "fileChunkableSize"             => !empty($_POST['fileChunkableSize']) ? $_POST['fileChunkableSize'] : 4,
                    "nwFromPGToCloud"               => !empty($_POST['nwFromPGToCloud']) ? $_POST['nwFromPGToCloud'] : 0,
                    "nwFromClientToPG"              => !empty($_POST['nwFromClientToPG']) ? $_POST['nwFromClientToPG'] : 0,
                    "filterInclusionName"           => !empty($_POST['filters']) ? $_POST['filters'] : '',
                    "networkThrottlingNames"        => array('DEFAULT_NETWORK_THROTTLE'),
                    "userSizeAllowed"               => !empty($_POST['userSizeAllowed']) ? $_POST['userSizeAllowed'] : '',
                    "memoryUtilization"             => !empty($_POST['memoryUtilization']) ? $_POST['memoryUtilization'] : '',
                    "cpuUtilization"                => !empty($_POST['cpuUtilization']) ? $_POST['cpuUtilization'] : '',
                    "compressionEnabled"            => !empty($_POST['compEnabled']) ? $_POST['compEnabled'] : false,
                    "privacyGatewayMappingElement"  => $privacyGatewayMappingElement,
                    "policyRefresh"                 => !empty($_POST['policyRefresh']) ? $_POST['policyRefresh'] : '',
		    "dedup"                         => !empty($_POST['dedup']) ? $_POST['dedup'] : 'Disabled',
                    "searchAlgoForPg"                 => !empty($_POST['searchAlgoForPg']) ? $_POST['searchAlgoForPg'] : NEAREST,
                );
                $this->log('Policy Details: '. json_encode($data), 'info');
                $result = $this->_model->savePolicy($headers, json_encode($data));
                switch ($result['status']) {
                    case (200):
                        $response = array(
                            'result' => 'success',
                            'msg' => $this->language->get('policySaved')
                        );
                        echo json_encode($response);
                        exit;
                    case (421):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('421')
                        );
                        echo json_encode($result);
                        exit();
                    case (500):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('500')
                        );
                        echo json_encode($result);
                        exit();
                    case (0):
                        $result = array(
                            'result' => 'fail',
                            'msg' => $this->language->get('0')
                        );
                        echo json_encode($result);
                        exit();
                    default:
                        $result = array(
                            'result' => 'fail',
                            'code' => $result,
                            'msg' => $this->language->get('default')
                        );
                        echo json_encode($result);
                        exit();
                }
            }else{
                $result = array(
                    'result' => 'fieldFail',
                    'msg' => $this->valid->get_errors_array()
                );
                echo json_encode($result);
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function serializeTheString($oneBigStrings){
        if(!empty($oneBigStrings)){
            $strings = explode('^', $oneBigStrings);
            $array = array();
            foreach($strings as $string){
                list($scriptName, $scriptArgs, $backupType) = explode('|', $string);
                $scriptArray = array(
                    'scriptName' => $scriptName,
                    'backupType' => $backupType,
                    'scriptArgs' => explode(',', $scriptArgs)
                );
                $array = array_merge(array($scriptArray), $array);
            }
            return $array;
        }else{
            return null;
        }
    }

    public function editPolicy($policyName){
        $this->session->put('selectedPolicyName', $policyName);
        $schedules = [];
        $filters = [];
        $pgs = [];
        $ccS = [];
        $headers = array(
            'Content-Type'         => 'application/json',
            'token'         => $this->session->get('token')
        );
        $schedulesResult = $this->_model->getSchedules($headers);
        $pgsResult = $this->_model->getPgs($headers);
        $filtersResult = $this->_model->getFilters($headers);
        $ccSResult = $this->_model->getCloudCredentials($headers);

        if($ccSResult['status'] == 200 && !empty($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'})){
            foreach($ccSResult['body']->{'cloudCredentialListElement'}->{'cloudCredentialElements'} as $key => $value){
                $ccS = array_merge(array($value), $ccS);
            }
        }

        if($schedulesResult['status'] == 200 && $schedulesResult['body']->{'scheduleElementList'}){
            foreach($schedulesResult['body']->{'scheduleElementList'} as $key => $value){
                $schedule = array(
                    'time' => (string)$value->{'time'},
                    'timeZone' => (string)$value->{'timeZone'},
                    'scheduleName' => (string)$value->{'scheduleName'},
                    'daysArray' => (array)$value->{'dayArray'},
                    'days' => $this->getDaysString(implode(',', (array)$value->{'dayArray'})),
                );
                $schedules = array_merge(array($schedule), $schedules);
            }
        }

        if($filtersResult['status'] == 200 && $filtersResult['body']->{'inclusionFilterElementList'}){
            foreach($filtersResult['body']->{'inclusionFilterElementList'} as $key => $value){
                $filter = array(
                    'filters' => (string)$value->{'filters'},
                    'filterName' => (string)$value->{'filterName'},
                    'filterArray' => (array)explode(',', (string)$value->{'filters'})
                );
                $filters = array_merge(array($filter), $filters);
            }
        }

        if($pgsResult['status'] == 200 && $pgsResult['body']->{'privacyGatewayElementList'}){
            foreach($pgsResult['body']->{'privacyGatewayElementList'} as $key => $value){
                $pg = array(
                    'gatewayName' => (string)$value->{'gatewayName'}
                );
                $pgs = array_merge(array($pg), $pgs);
            }
        }

        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy'),
            'crumb2' => $this->language->get('edit'),
            'active' => 'pms',
            'schedules' => $schedules,
            'filters' => $filters,
            'pgs' => $pgs,
            'ccS' => $ccS,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicy/edit', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicy(){
        $policyName = $this->session->get('selectedPolicyName');
        if(!empty($_POST) && !empty($policyName)){
            $headers = array(
                'token' => $this->session->get('token')
            );
            $result = $this->_model->getPolicy($headers, $policyName);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'syncPolicyElement'};
                    $policyRefresh = explode(':', (string)$value->{'policyRefresh'});
                    if($policyRefresh[1] == '00'){
                        $policyRefresh = $policyRefresh[0];
                    }else{
                        $policyRefresh = (string)$value->{'policyRefresh'};
                    }
                    $policy = array(
                        'policygroupName'       => (string)$value->{'policygroupName'},
                        'osType'                => (string)$value->{'osType'},
                        'policyRefresh'         => $policyRefresh,
                        //'cloudCredential'       => (string)$value->{'cloudCredential'},
                        'maxFileSize'           => (string)$value->{'maxFileSize'},
                        'pftSize'               => (string)$value->{'pftSize'},
                        'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                        'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                        'crawlLimit'            => (string)$value->{'crawlLimit'},
                        'maxVersions'           => (string)$value->{'maxVersions'},
                        'userSizeAllowed'       => (string)$value->{'userSizeAllowed'},
                        'vssEnabled'            => (string)$value->{'vssEnabled'},
                        'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                        'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                        'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                        'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                        'filterInclusionName'   => (string)$value->{'filterInclusionName'},
                        'syncInterval'          => (string)$value->{'syncInterval'},
                        'expiredDate'           => (string)$value->{'expiredDate'},
                        'shareEnabled'          => (string)$value->{'shareEnabled'},
                        'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                        'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                        'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                        'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
                        'contentIndexEnabled'   => (string)$value->{'contentIndexEnabled'},
                        'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                        'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                        'pftEnabled'            => (string)$value->{'pftEnabled'},
                        'searchAlgoForPg'            => (string)$value->{'searchAlgoForPg'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
			'dedup' => (string)$value->{'dedup'},
                        'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function singlePolicyMapping(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('policy_mapping'),
            'crumb2' => $this->language->get('change_user_policy'),
            'active' => 'pms',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('pms/syncPolicyMapping/single', $data);
        View::renderTemplate('footer', $data);
    }

    public function getPolicyMappingDetails(){
        if(!empty($_POST)){
            $_POST['skipValue'] = ($_POST['skipValue'] != 0 ) ? $_POST['skipValue']+1 : $_POST['skipValue'];
            $headers = array(
                'token' => $this->session->get('token'),
                'skipValue' => !empty($_POST['skipValue']) ? (int)$_POST['skipValue'] : 0
            );
            if(!empty($_POST['userName']) && $_POST['userName'] != 'all'){
                $headers['userNames'] = $_POST['userName'];
                $result = $this->_model->searchPolicyMapping($headers);
            }else{
                $result = $this->_model->getPolicyMappingDetails($headers);
            }
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'policies' => $result['body']->{'editUserBackupPolicyMappingElement'}->{'existingPolicies'},
                        'users' => $result['body']->{'editUserBackupPolicyMappingElement'}->{'userBackupPolicyMappingElements'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($response);
                    exit();
                case (500):
                    $response = array(
                        'result' => 'fail',
                        'response' => $result,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($response);
                    exit();
                case (0):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($response);
                    exit();
                default:
                    $response = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($response);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function saveSinglePolicyMapping(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userName'          => $_POST['userName'],
                'newPolicyName'     => $_POST['newPolicyName'],
                'existingPolicyName'=> $_POST['oldPolicyName']
            );
            $result = $this->_model->saveSinglePolicyMapping($headers, $_POST['userName']);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function multiplePolicyMapping(){
        $result = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));

        if(!empty((array)$result['body']->{'syncPolicyElementList'})){
            $policies = [];
            foreach((array)$result['body']->{'syncPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $policies = array_merge(array($policy), $policies);
            }
            $data = array(
                'title' => $this->language->get('indexPageName'),
                'crumb1' => $this->language->get('policy_mapping'),
                'crumb2' => (Auth::checkCloudPermission('serverBackup')) ? $this->language->get('assign_policy') : $this->language->get('assign_policy_for_users_in_bulk'),
                'active' => 'pms',
                'csrf_token' => $this->setCSRFToken(),
                'policies' => $policies,
                'loggedInUser' => $this->session->all()
            );

            View::renderTemplate('header', $data);
            View::renderTemplate('navigation', $data);
            View::render('pms/syncPolicyMapping/multiple', $data);
            View::renderTemplate('footer', $data);
        }else{
            header('Location: '.Url::basePath('pms/policy/create'));
        }
    }

    public function saveMultiplePolicyMapping(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'      => 'application/json',
                'loginUserName'     => $this->session->get('userName'),
                'userNames'          => $_POST['userNames'],
                'policyName'     => $_POST['policyName']
            );
            $result = $this->_model->saveMultiplePolicyMapping($headers);
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'response' => $result,
                        'msg'    => 'done'
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getUserSyncPolicy(){
        if(!empty($_POST)){
            $headers = array(
                'token' => $this->session->get('token'),
                'userName' => $this->session->get('userName')
            );
            $result = $this->_model->getUserSyncPolicy($headers);
            $this->log('result'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $value = $result['body']->{'syncPolicyElement'};
                    $policy = array(
                        'policygroupName'       => (string)$value->{'policygroupName'},
                        'osType'                => (string)$value->{'osType'},
                        'policyRefresh'         => (string)$value->{'policyRefresh'},
                        //'cloudCredential'       => (string)$value->{'cloudCredential'},
                        'maxFileSize'           => (string)$value->{'maxFileSize'},
                        'pftSize'               => (string)$value->{'pftSize'},
                        'fileChunkableSize'     => (string)$value->{'fileChunkableSize'},
                        'compressionEnabled'    => (string)$value->{'compressionEnabled'},
                        'crawlLimit'            => (string)$value->{'crawlLimit'},
                        'expiredDate'           => (string)$value->{'expiredDate'},
                        'maxVersions'           => (string)$value->{'maxVersions'},
                        'userSizeAllowed'       => (string)$value->{'userSizeAllowed'},
                        'vssEnabled'            => (string)$value->{'vssEnabled'},
                        'cpuUtilization'        => (string)$value->{'cpuUtilization'},
                        'memoryUtilization'     => (string)$value->{'memoryUtilization'},
                        'nwFromClientToPG'      => (string)$value->{'nwFromClientToPG'},
                        'nwFromPGToCloud'       => (string)$value->{'nwFromPGToCloud'},
                        'filterInclusionName'   => (string)$value->{'filterInclusionName'},
                        'syncInterval'          => (string)$value->{'syncInterval'},
                        'shareEnabled'          => (string)$value->{'shareEnabled'},
                        'syncEnableAutomatic'   => (string)$value->{'syncEnableAutomatic'},
                        'complexPasswordRequired'=> (string)$value->{'complexPasswordRequired'},
                        'preventDownloadEnabled'=> (string)$value->{'preventDownloadEnabled'},
                        'highSecureShareEnabled'=> (string)$value->{'highSecureShareEnabled'},
                        'contentIndexEnabled'   => (string)$value->{'contentIndexEnabled'},
                        'deDuplicationEnabled'  => (string)$value->{'deDuplicationEnabled'},
                        'dcmEnabled'            => (string)$value->{'dcmEnabled'},
                        'pftEnabled'            => (string)$value->{'pftEnabled'},
                        'inclusionFilterElement'=> (array)$value->{'inclusionFilterElement'},
                        'lastModifiedTimestamp' => date('d-M-Y h:i:s', (((int)$value->{'lastModifiedTimestamp'}) / 1000)),
                        'privacyGatewayMappingElement'=> (array)$value->{'privacyGatewayMappingElement'},
                        'networkThrottlingNames'=> (array)$value->{'networkThrottlingNames'},
                    );

                    $response = array(
                        'result' => 'success',
                        'policy' => $policy
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function getAllScripts($preBackup, $postBackup, $preRestore, $postRestore){
        $data = [];
        if(!empty($preBackup)){
            foreach($preBackup as $key => $value){
                if($value['backupType'] == 'f'){
                    $preOne = $value['scriptName'].'|preBackupF|'.implode(',',$value['scriptArgs']);
                }else{
                    $preOne = $value['scriptName'].'|preBackupI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($preOne), $data);
            }
        }
        if(!empty($postBackup)){
            foreach($postBackup as $key => $value){
                if($value['backupType'] == 'f'){
                    $postOne = $value['scriptName'].'|postBackupF|'.implode(',',$value['scriptArgs']);
                }else{
                    $postOne = $value['scriptName'].'|postBackupI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($postOne), $data);
            }
        }
        if(!empty($preRestore)){
            foreach($preRestore as $key => $value){
                if($value['backupType'] == 'f'){
                    $preOne = $value['scriptName'].'|preRestoreF|'.implode(',',$value['scriptArgs']);
                }else{
                    $preOne = $value['scriptName'].'|preRestoreI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($preOne), $data);
            }
        }
        if(!empty($postRestore)){
            foreach($postRestore as $key => $value){
                if($value['backupType'] == 'f'){
                    $postOne = $value['scriptName'].'|postRestoreF|'.implode(',',$value['scriptArgs']);
                }else{
                    $postOne = $value['scriptName'].'|postRestoreI|'.implode(',',$value['scriptArgs']);
                }
                $data = array_merge(array($postOne), $data);
            }
        }
        return $data;
    }
}
