<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Share;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ShareController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->language->load('share');
        $this->_model = new Share();

    }

    /**
     * Below method gets the file details
     * and displays the option to Download or View
     *
     * @param $type
     * @param $key1
     * @param $key2
     * @param $key3
     * @param $key4
     */
    public function index($type, $key1, $key2, $key3, $key4){
        if(SHARE_LOGIN_CHECK == true){
            $this->auth->loginCheck();
        }
        $stat = $this->collectStats();
        $hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);

        $headers = array(
            'Content-Type'  => 'application/xml',
            'osType'        => $this->getOS($_SERVER['HTTP_USER_AGENT']),
            'browser'       => $_SERVER['SERVER_NAME'],
            'ip'            => $hostname.' ('.$stat['remoteAdd'].')',
            'key12'         => $key1,
            'key14'         => $key2,
            'key18'         => $key3,
            'key20'         => $key4,
            'isBackup'      => false
        );
        $this->session->put('savedFileHeaders', $headers);
        $result = $this->_model->getSharedFileDetails($headers);
        $backupID           = $result['header']->{'container'}['backupID'];
        $filePath           = $result['header']->{'container'}['filePath'];
        $syncRevisionId     = $result['header']->{'container'}['syncRevisionId'];
        $fileSize           = $result['header']->{'container'}['fileSize'];
        if($result['status'] == 200){
            $data['title']          = $this->language->get('share');
            $data['csrf_token']     = $this->setCSRFToken();
            $data['cloudName']      = $this->session->get('cloudName');
            $data['file']           = $result['body'];
            $data['filePath']       = $filePath;
            $data['backupID']       = $backupID;
            $data['syncRevisionId'] = $syncRevisionId;
            $data['fileSize']       = $fileSize;
            $data['type']           = ($type == md5('protected')) ? 'password' : 'read';
            $passwordProtected      = ($result['body']->{'is-password-protected'} == 'true') ? true : false;

            $this->session->put('passwordProtected', $passwordProtected);
            $this->session->put('passwordHash', (string)$result['body']->{'password-hash'});
            $this->session->put('download', (string)$result['body']->{'is-download'});
            $this->session->put('view', (string)$result['body']->{'is-view'});
            $this->session->put('cloudName', (string)$result['body']->{'cloud-name'});

            View::renderTemplate('LoginHeader', $data);
            View::render('share/share', $data);
            View::renderTemplate('LoginFooter', $data);
        }else{
            header("{$_SERVER['SERVER_PROTOCOL']} 404 Not Found");

            $data['title'] = $result['status'];
            $data['error'] = "Oops! There was an error";

            View::renderTemplate('header', $data);
            View::render('error/404', $data);
            View::renderTemplate('footer', $data);
        }
    }

    public function checkPassword(){
        if(!empty($_POST['type'])){
            if($_POST['type'] == true){
                if($this->session->get('download') != true){
                    $result = array(
                        'result' => 'fail',
                        'message' => 'Download is Not Enabled'
                    );
                    echo json_encode($result);
                }
            }else{
                if($this->session->get('view') != true){
                    $result = array(
                        'result' => 'fail',
                        'message' => 'View is Not Enabled'
                    );
                    echo json_encode($result);
                }
            }
        }
        if($this->session->get('passwordProtected') == true){
            if(!empty($_POST['password'])){
                if($this->session->get('passwordHash') == md5($_POST['password'])){
                    $result = array(
                        'result'    => 'success',
                        'message'   => 'Password authentication passed'
                    );
                    echo json_encode($result);
                }else{
                    $result = array(
                        'result' => 'fail',
                        'message' => 'Password authentication failed'
                    );
                    echo json_encode($result);
                }
            }else{
                $result = array(
                    'result' => 'fail',
                    'message' => 'Password field was empty'
                );
                echo json_encode($result);
            }
        }elseif($this->session->get('passwordProtected') == false){
            $result = array(
                'result' => 'success',
                'message' => 'No Password is needed'
            );
            echo json_encode($result);
        }else{
            $result = array(
                'result' => 'fail',
                'message' => 'Did not get any command to proceed'
            );
            echo json_encode($result);
        }
    }

    public function download(){

        if(!empty($_GET['path']) && !empty($_GET['fileName']) && !empty($_GET['userName']) && !empty($_GET['syncRevisionId']) && !empty($_GET['password'])){

            $checkForShareWith = !empty($_GET['shareWith']) ? true : false;

            if($this->session->get('passwordProtected') == true && $checkForShareWith == false && $this->session->get('passwordHash') != md5($_GET['password'])){
                header('Location: '.Url::basePath('error/404'));
                exit;
            }
            $headers['file-name'] = $_GET['fileName'];
            $headers['file-path'] = $_GET['path'];
            $headers['userName'] = $_GET['userName'];
            $headers['syncRevisionId'] = $_GET['syncRevisionId'];

            $downloadResult = $this->_model->download($headers);
            if($downloadResult['code'] != 449){
                header("Pragma: public");
                header("Expires: 0");
                header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
                header("Cache-Control: private",false);
                header("Content-Type: application/octet-stream");
                header('Content-Disposition: attachment; filename="'.$_GET['fileName'].'"');
                header("Content-Transfer-Encoding: binary");
                header('Content-Length: '.$downloadResult['header']['file-size']);

                ob_clean();
                print $downloadResult['body'];
                exit;
            }else{
                header('Location: '.Url::basePath('sync/files'));
            }

        }else{
            header('Location: '.Url::basePath('error/404'));
        }
    }

    public function collectStats(){

        $browser = array(
            'version'   => '0.0.0',
            'majorver'  => 0,
            'minorver'  => 0,
            'build'     => 0,
            'name'      => 'unknown',
            'useragent' => ''
        );

        $browsers = array(
            'firefox', 'msie', 'opera', 'chrome', 'safari', 'mozilla', 'seamonkey', 'konqueror', 'netscape',
            'gecko', 'navigator', 'mosaic', 'lynx', 'amaya', 'omniweb', 'avant', 'camino', 'flock', 'aol'
        );

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $browser['useragent'] = $_SERVER['HTTP_USER_AGENT'];
            $user_agent = strtolower($browser['useragent']);
            foreach($browsers as $_browser) {
                if (preg_match("/($_browser)[\/ ]?([0-9.]*)/", $user_agent, $match)) {
                    $browser['name'] = $match[1];
                    $browser['version'] = $match[2];
                    @list($browser['majorver'], $browser['minorver'], $browser['build']) = explode('.', $browser['version']);
                    break;
                }
            }
        }
        $browserName = $browser['name'] .' - '. $browser['version'];
        if (getenv('HTTP_CLIENT_IP')){
            $ipAddress = getenv('HTTP_CLIENT_IP');
        }
        else if(getenv('HTTP_X_FORWARDED_FOR')) {
            $ipAddress = getenv('HTTP_X_FORWARDED_FOR');
        }
        else if(getenv('HTTP_X_FORWARDED')){
            $ipAddress = getenv('HTTP_X_FORWARDED');
        }
        else if(getenv('HTTP_FORWARDED_FOR')){
            $ipAddress = getenv('HTTP_FORWARDED_FOR');
        }
        else if(getenv('HTTP_FORWARDED')){
            $ipAddress = getenv('HTTP_FORWARDED');
        }
        else{
            $ipAddress = 'UNKNOWN';
        }
        $remote 	= $_SERVER['REMOTE_ADDR'] ;
        $language 	= $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        return array("ip" => $ipAddress,"remoteAdd" => $remote,
            "browser" => $browserName,"language" => $language);
    }

    public function getOS($user_agent) {

        $os_platform    =   "Unknown OS Platform";
        $os_array       =   array(
            '/windows nt 10/i'     =>  'Windows 10',
            '/windows nt 6.3/i'     =>  'Windows 8.1',
            '/windows nt 6.2/i'     =>  'Windows 8',
            '/windows nt 6.1/i'     =>  'Windows 7',
            '/windows nt 6.0/i'     =>  'Windows Vista',
            '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
            '/windows nt 5.1/i'     =>  'Windows XP',
            '/windows xp/i'         =>  'Windows XP',
            '/windows nt 5.0/i'     =>  'Windows 2000',
            '/windows me/i'         =>  'Windows ME',
            '/win98/i'              =>  'Windows 98',
            '/win95/i'              =>  'Windows 95',
            '/win16/i'              =>  'Windows 3.11',
            '/macintosh|mac os x/i' =>  'Mac OS X',
            '/mac_powerpc/i'        =>  'Mac OS 9',
            '/linux/i'              =>  'Linux',
            '/ubuntu/i'             =>  'Ubuntu',
            '/iphone/i'             =>  'iPhone',
            '/ipod/i'               =>  'iPod',
            '/ipad/i'               =>  'iPad',
            '/android/i'            =>  'Android',
            '/blackberry/i'         =>  'BlackBerry',
            '/webos/i'              =>  'Mobile'
        );
        foreach ($os_array as $regex => $value) {
            if (preg_match($regex, $user_agent)) {
                $os_platform    =   $value;
            }
        }
        return $os_platform;
    }

    public function getBrowserDetails(){
        $u_agent = $_SERVER['HTTP_USER_AGENT'];
        $bname = 'Unknown';
        $platform = 'Unknown';
        $version= "";

        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        }
        elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        }
        elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }

        // Next get the name of the useragent yes seperately and for good reason
        if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent))
        {
            $bname = 'Internet Explorer';
            $ub = "MSIE";
        }
        elseif(preg_match('/Firefox/i',$u_agent))
        {
            $bname = 'Mozilla Firefox';
            $ub = "Firefox";
        }
        elseif(preg_match('/Chrome/i',$u_agent))
        {
            $bname = 'Google Chrome';
            $ub = "Chrome";
        }
        elseif(preg_match('/Safari/i',$u_agent))
        {
            $bname = 'Apple Safari';
            $ub = "Safari";
        }
        elseif(preg_match('/Opera/i',$u_agent))
        {
            $bname = 'Opera';
            $ub = "Opera";
        }
        elseif(preg_match('/Netscape/i',$u_agent))
        {
            $bname = 'Netscape';
            $ub = "Netscape";
        }

        // finally get the correct version number
        $known = array('Version', $ub, 'other');
        $pattern = '#(?<browser>' . join('|', $known) .
            ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        if (!preg_match_all($pattern, $u_agent, $matches)) {
            // we have no matching number just continue
        }

        // see how many we have
        $i = count($matches['browser']);
        if ($i != 1) {
            //we will have two since we are not using 'other' argument yet
            //see if version is before or after the name
            if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
                $version= $matches['version'][0];
            }
            else {
                $version= $matches['version'][1];
            }
        }
        else {
            $version= $matches['version'][0];
        }

        // check if we have a number
        if ($version==null || $version=="") {
            $version="?";
        }

        return array(
            'userAgent' => $u_agent,
            'name'      => $bname,
            'version'   => $version,
            'platform'  => $platform,
            'pattern'    => $pattern
        );
    }

    public function checkIfFileShared(){
        $headers = $this->session->get('savedFileHeaders');
        $headers['accessType'] = $_POST['accessType'];
        $result = $this->_model->getSharedFileDetails2($headers);

        if($result['status'] == 200){
            $result = array(
                'result'    => 'success',
                'message'   => 'Password authentication passed'
            );
            echo json_encode($result);
        }else{
            $result = array(
                'result'    => 'fail',
                'message'   => 'File has been unshared or provided link is not valid'
            );
            echo json_encode($result);
        }
    }

}