<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Report;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ReportController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('report');
        $this->_model = new Report();
        Auth::allowOnly('readOnlyAdmin');
    }

    public function dashboard(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/dashboard', $data);
        View::renderTemplate('footer', $data);
    }

    public function syncDashboard(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/syncDashboard', $data);
        View::renderTemplate('footer', $data);
    }

    public function statistics(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('statistics'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/statistics/statistics', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStatistics(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getStatistics($headers);
            switch ($result['status']) {
                case (200):
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(($result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getSyncStatistics(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getStatistics($headers);
            switch ($result['status']) {
                case (200):
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(($result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function getServerBackupStatistics(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );
            $result = $this->_model->getServerBackupStatistics($headers);
            $this->log('ServerBackup Status ' . json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'} = round($result['body']->{'cloudOverviewElement'}->{'avgRestorePerUser'}, 2);
                    $result['body']->{'cloudOverviewElement'}->{'avgNumberofBackups'} = round(($result['body']->{'cloudOverviewElement'}->{'backupsDone'}/$result['body']->{'cloudOverviewElement'}->{'devicesConnected'}), 2);
                    $response = array(
                        'result' => 'success',
                        'statistics' => $result['body']->{'cloudOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function overview(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('overview'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/overview/overview', $data);
        View::renderTemplate('footer', $data);
    }

    public function getOverview(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
            exit;
        }
        if($_POST['deviceName'] == null){
            $_POST['deviceName'] = "";
        }
        $headers = array(
            'token'         => $this->session->get('token'),
            'skipValue'     => $_POST['skipValue'],
            'userName'      => $_POST['userName'] == 'all' ? '' : $_POST['userName'],
            'deviceName'    => $_POST['deviceName'] == 'all' ? '' : $_POST['deviceName'],
        );

        $this->log(json_encode($headers), "info");
        $result = $this->_model->getOverview($headers);
        $this->log(json_encode($result));
        switch ($result['status']) {
            case (200):

                if(!empty($result['header']['overViewJobTime'])){
                    $seconds = $result['header']['overViewJobTime'] / 1000;
                    $overViewJobTime = date('d-M-Y H:i:s', $seconds) .' '. date('T');
                }else{
                    $overViewJobTime = '';
                }

                $overviewList = [];

                if(empty($result['body']->{'backupOverviewElementList'})){
                    $response = array(
                        'result' => 'success',
                        'overViewJobTime' => $overViewJobTime,
                        'overview' => array_reverse($overviewList)
                    );
                    echo json_encode($response);
                    exit;
                }

                foreach($result['body']->{'backupOverviewElementList'} as $value){
                    $filesBackedUp = $value->{'totalNoOfFiles'} - $value->{'noOfFilesRemaining'};
                    $completedPercentage = ($value->{'totalNoOfFiles'} > 0 ) ? round(($filesBackedUp / $value->{'totalNoOfFiles'}) * 100).'%' : '0 %';
                    if(empty($value->{'reason'}) || empty($value->{'lastBkpStatus'})){
                        if($value->{'lastBkpStatus'} != 'COMPLETED'){
                            $reason = $value->{'lastBkpStatus'}.' - '.$value->{'reason'};

                        }else {
                            $reason = 'Successful';
                        }
                    }elseif($value->{'lastBkpStatus'} == 'COMPLETED'){
                        $reason = 'Successful';
                    }else{
                        $reason = 'Failed';
                    }

                    $overview = array(
                        'userId' => $value->{'userId'},
                        'emailId' => $value->{'emailId'},
                        'deviceName' => $value->{'deviceName'},
                        'policyName' => $value->{'policyName'},
                        'epaInstallationDate' => $value->{'epaInstallationDate'},
                        'firstBkpStartTime' => $value->{'firstBkpStartTime'},
                        'lastBkpStartTime' => $value->{'lastBkpStartTime'},
                        'lastSuccessfulBkp' => $value->{'lastSuccessfulBkp'},
			'lastBkpStatus' => $value->{'lastBkpStatus'},
                        'reason' => $reason,
                        'storageUtilized' => $value->{'storageUtilized'},
                        'completedPercentage' => $completedPercentage,
                    );

                    $overviewList = array_merge(array($overview), $overviewList);

                }

                $response = array(
                    'result' => 'success',
                    'overViewJobTime' => $overViewJobTime,
                    'overview' => array_reverse($overviewList)
                );
                echo json_encode($response);
                exit;
            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'code' => $result,
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function restoreByDate(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('restoreHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/restore/restoreByDate', $data);
        View::renderTemplate('footer', $data);
    }

    public function restoreByUsername(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('restoreByUserName'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/restore/restoreByUsername', $data);
        View::renderTemplate('footer', $data);
    }

    public function restoreByDevice(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('restoreByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/restore/restoreByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getRestoreHistory(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'userName'      => $_POST["userName"],
                'deviceName'    => $_POST["deviceName"],
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            if(empty($_POST['from']) && empty($_POST['to']) && empty($_POST['userName']) && empty($_POST['deviceName'])){
                $headers['endDate'] = '';
                $headers['startDate'] = '';
            }elseif(!empty($_POST['from']) && !empty($_POST['to'])){
                $headers['endDate'] = $_POST['to'];
                $headers['startDate'] = $_POST['from'];
            }

            $this->log('Headers'. json_encode($headers), 'info');
            $result = $this->_model->getRestoreHistory($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'restoreByDate' => $result['body']->{'restoreHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'respos' => $headers,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function updateSyncCloudUsageDetails(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'userName'      => null,
                'deviceName'    => null,
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            if(empty($_POST['from']) && empty($_POST['to']) && empty($_POST['userName']) && empty($_POST['deviceName'])){
                $headers['endDate'] = '';
                $headers['startDate'] = '';
            }elseif(!empty($_POST['from']) && !empty($_POST['to'])){
                $headers['endDate'] = $_POST['to'];
                $headers['startDate'] = $_POST['from'];
            }elseif(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }elseif(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }
            $this->log('Headers'. json_encode($headers), 'info');
            $result = $this->_model->updateSyncCloudUsageDetails($headers);
            $this->log('Logging Syn Cloud Usage Details'.json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'syncCloudUsageDetails' => $result['body']->{'syncOverviewListElement'}->{'fileElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'respos' => $headers,
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function longBackup(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('longBackup'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/longBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getLongBackup(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );

            $result = $this->_model->getLongBackupDetails($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'longBackup' => $result['body']->{'notificationElementList'}->{'delayedNotificationHistoryElements'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function currentBackup(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('currentBackup'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/currentBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getCurrentBackup(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );

            $result = $this->_model->getCurrentBackupDetails($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'currentBackup' => $result['body']->{'notificationElementList'}->{'currentBatchElements'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function noBackup(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('noBackup'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/notifications/noBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getNoBackup(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'noOfDays'      => $_POST['numberOfDays'],
                'endDate'       => date('m/d/Y'),
                'startDate'     => '01/01/1970',
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );
            $this->log(json_encode($headers), "info");
            $result = $this->_model->getNoBackupDetails($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'noBackup' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function storageUtilizedByUser(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizationByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/storageUtilized/storageUtilizedByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function storageUtilizedByDevice(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizationByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/storageUtilized/storageUtilizedByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStorageUtilized(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token'),
                'deviceName'    => null,
                'userName'      => null,
                'skipValue'     => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );

            if(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }elseif(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }

            $result = $this->_model->getStorageUtilized($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'storageUtilized' => $result['body']->{'storageInfoElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function storageUtilizedByPG(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizedByPG'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/storageUtilized/storageUtilizedByPG', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStorageUtilizedByPG(){
        if(!empty($_POST)){
            $headers = array(
                'token'         => $this->session->get('token')
            );

            $result = $this->_model->getStorageUtilizedByPG($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'storageUtilizedByPG' => $result['body']->{'PGInfoElementList'}
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function failedBackup(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('failedBackup'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/failedBackup', $data);
        View::renderTemplate('footer', $data);
    }

    public function failedBackupByUser(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('failedBackupByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/failedBackupByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function failedBackupByDevice(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('failedBackupByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/failedBackup/failedBackupByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getFailedBackup(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'token'         => $this->session->get('token'),
                'skipValue'     => $_POST['skipValue'],
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] :'',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '01/01/1970',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y')
            );
            $this->log('Date: '. json_encode($headers), 'info');
            $result = $this->_model->getFailedBackup($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'failedBackup' => $result['body']->{'notificationElementList'}->{'notificationHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function storage(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageTrend'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/trend/storage', $data);
        View::renderTemplate('footer', $data);
    }

    public function getStorageTrend(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
            exit;
        }
        if(!empty($_POST['from']) && $_POST['to'] == 'dashboard'){
            $_POST['from'] = date('m/d/Y', ($_POST['from']/1000));
            $_POST['to'] = date('m/d/Y', ($_POST['to']/1000));
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 31){
            $data = array(
                'result' => 'fail',
                'msg' => 'Trend Graph can only be plotted between 31 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $days = array();
        for($i = 0; $i < $numberDays; $i++){
            $date = strtotime("+".$i." day", strtotime($fromDate));
            $days = array_merge($days, array(array('size'=> 0,'date'=>date('d-M', $date))));
        }
        $response 	= $this->_model->getStorageTrend($fromDate, $toDate);
        $response 	= json_decode($response , true);

        if(empty($response)){
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }

        $pgS = array();
        $dataForPG = array();
        foreach($response['PGInfoElementList'] as $item){
            $curPG = array($item['gatewayName']);
            $pgS = array_merge($pgS, $curPG);
        }
        $pgS = array_unique($pgS);
        foreach($pgS as $pg){
            $allData = array();
            foreach($response['PGInfoElementList'] as $key => $item){
                if($pg == $item['gatewayName']){
                    $data = array(
                        'size' => round($item['sizeInMB']/1000, 2),
                        'date' => date('d-M', strtotime($item['date']))
                    );
                    $allData[$key] = $data;
                }
            }
            $dataForPG[$pg] = array_values($allData);
        }
        if(count($dataForPG) >= 1){
            $dataPerDayPerPG = array();
            foreach($dataForPG as $pg => $pgData){
                $dataPerDayPerPG[$pg] = $days;
            }
            $finalPGPerData = array();
            foreach($dataPerDayPerPG as $pgKey => $data){
                $keys = array_column($dataForPG[$pgKey], 'date');
                $size = array_column($dataForPG[$pgKey], 'size');
                $finalData = array();
                foreach($data as $d){
                    if(in_array($d['date'], $keys)){
                        $key = array_search($d['date'], $keys);
                        $d['size'] = $size[$key];
                    }
                    $finalData = array_merge($finalData, array($d));
                }
                $finalPGPerData[$pgKey] = $finalData;
            }
            $jsonData = json_encode($finalPGPerData);
            echo $jsonData;
            exit;
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
    }

    public function blobTrend(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('blobTrend'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/trend/blob', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBlobTrend(){
        if(empty($_POST)){
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
            exit;
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 31){
            $data = array(
                'result' => 'fail',
                'msg' => 'Trend Graph can only be plotted between 31 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $days = array();
        for($i = 0; $i < $numberDays; $i++){
            $date = strtotime("+".$i." day", strtotime($fromDate));
            $days = array_merge($days, array(array('size'=> 0,'date'=>date('d-M', $date))));
        }
        $response 	= $this->_model->getBlobTrend($fromDate, $toDate);
        $response 	= json_decode($response , true);
        if(empty($response)){
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $pgS = array();
        $dataForPG = array();

        foreach($response['PGInfoElementList'] as $item){
            $curPG = array($item['gatewayName']);
            $pgS = array_merge($pgS, $curPG);
        }

        $pgS = array_unique($pgS);

        foreach($pgS as $pg){
            $allData = array();
            foreach($response['PGInfoElementList'] as $key => $item){
                if($pg == $item['gatewayName']){
                    $data = array(
                        'size' => round($item['sizeInMB']/1000, 3),
                        'date' => date('d-M', strtotime($item['date']))
                    );
                    $allData[$key] = $data;
                }
            }
            $dataForPG[$pg] = array_values($allData);
        }
        if(count($dataForPG) >= 1){
            $dataPerDayPerPG = array();
            foreach($dataForPG as $pg => $pgData){
                $dataPerDayPerPG[$pg] = $days;
            }
            $finalPGPerData = array();
            foreach($dataPerDayPerPG as $pgKey => $data){
                $keys = array_column($dataForPG[$pgKey], 'date');
                $size = array_column($dataForPG[$pgKey], 'size');
                $finalData = array();
                foreach($data as $d){
                    if(in_array($d['date'], $keys)){
                        $key = array_search($d['date'], $keys);
                        $d['size'] = $size[$key];
                    }
                    $finalData = array_merge($finalData, array($d));
                }
                $finalPGPerData[$pgKey] = $finalData;
            }
            $jsonData = json_encode($finalPGPerData);
            echo $jsonData;
            exit;
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
    }

    public function backupTrend(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('backupTrend'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/trend/backup', $data);
        View::renderTemplate('footer', $data);
    }

    public function getBackupTrend(){
        if(empty($_POST)) {
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => $this->language->get('noData')
                )
            );
            exit;
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 31){
            $data = array(
                'result' => 'fail',
                'msg' => 'Trend Graph can only be plotted between 31 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $days = array();
        for($i = 0; $i < $numberDays; $i++){
            $date = strtotime("+".$i." day", strtotime($fromDate));
            $days = array_merge($days, array(array('size'=> 0,'date'=>date('d-M', $date))));
        }
        $response 	= $this->_model->getBackupTrend($fromDate, $toDate);
        $response 	= json_decode($response , true);
        if(empty($response)){
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
        $pgS = array();
        $dataForPG = array();

        foreach($response['PGInfoElementList'] as $item){
            $curPG = array($item['gatewayName']);
            $pgS = array_merge($pgS, $curPG);
        }

        $pgS = array_unique($pgS);

        foreach($pgS as $pg){
            $allData = array();
            foreach($response['PGInfoElementList'] as $key => $item){
                if($pg == $item['gatewayName']){
                    $data = array(
                        'size' => round($item['sizeInMB']/1000, 3),
                        'date' => date('d-M', strtotime($item['date']))
                    );
                    $allData[$key] = $data;
                }
            }
            $dataForPG[$pg] = array_values($allData);
        }
        if(count($dataForPG) >= 1){
            $dataPerDayPerPG = array();
            foreach($dataForPG as $pg => $pgData){
                $dataPerDayPerPG[$pg] = $days;
            }
            $finalPGPerData = array();
            foreach($dataPerDayPerPG as $pgKey => $data){
                $keys = array_column($dataForPG[$pgKey], 'date');
                $size = array_column($dataForPG[$pgKey], 'size');
                $finalData = array();
                foreach($data as $d){
                    if(in_array($d['date'], $keys)){
                        $key = array_search($d['date'], $keys);
                        $d['size'] = $size[$key];
                    }
                    $finalData = array_merge($finalData, array($d));
                }
                $finalPGPerData[$pgKey] = $finalData;
            }
            $jsonData = json_encode($finalPGPerData);
            echo $jsonData;
            exit;
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'We do not have sufficient data to plot a trend'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }
    }

    public function userDeviceHistory(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userDeviceHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/userDeviceHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUserDeviceHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : ''
            );

            $result = $this->_model->getUserDeviceHistory($headers);
            $this->log('result' .json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'userDeviceHistory' => $result['body']->{'userDeviceHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function userBackupHistory(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userBackupHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/userBackupHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUserBackupHistory(){
        if(!empty($_POST)){
            $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
            $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

            if(strtotime($toDate) < strtotime($fromDate)){
                $data = array(
                    'result' => 'fail',
                    'msg' => 'To Date should be greater than From Date'
                );
                $jsonData = json_encode($data);
                echo $jsonData;
                exit;
            }
            $headers = array(
                'Content-Type'  => 'application/json',
                'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
                'deviceName'    => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''
            );

            $result = $this->_model->getUserBackupHistory($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'userBackupHistory' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'msg' => 'Please select a user'
                )
            );
        }
    }

    public function dailyUserBackupOverview(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('storageUtilizationReport'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userInfo/dailyUserBackupOverview', $data);
        View::renderTemplate('footer', $data);
    }

    

    public function getDailyUserBackupOverview(){
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -15 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');

        if(strtotime($toDate) < strtotime($fromDate)){
            $data = array(
                'result' => 'fail',
                'msg' => 'To Date should be greater than From Date'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }

        if(!empty($_POST['from']) && $_POST['to'] == 'dashboard'){
            $_POST['from'] = date('m/d/Y', ($_POST['from']/1000));
            $_POST['to'] = date('m/d/Y', ($_POST['to']/1000));
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 30){
            $data = array(
                'result' => 'fail',
                'msg' => 'Details can only be retrieved for 30 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }

        if($_POST['userName'] == 'All'){
            $_POST['userName'] = '';
        }

        $headers = array(
            'Content-Type'  => 'application/json',
            'deviceName'      => !empty($_POST['deviceName']) ? ($_POST['deviceName'] == 'all') ? '' : $_POST['deviceName'] : '',
            'userName'      => !empty($_POST['userName']) ? ($_POST['userName'] == 'all') ? "" : $_POST['userName'] : '',
            'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''
        );
        $this->log(json_encode($headers), "info");
        $result = $this->_model->getDailyUserBackupOverview($headers);
        $this->log(json_encode($result), "info");
        $dailyUserBackupOverview = [];
        switch ($result['status']) {
            case (200):
                if(!empty($result['body']->{'dailyUserBackupOverViewList'})){
                    foreach($result['body']->{'dailyUserBackupOverViewList'} as $row){
                        $current['userName'] = $row->{'userName'};
                        $current['deviceName'] = $row->{'deviceName'};
                        $current['storageDate'] = $row->{'storageDate'};
                        $current['storageUsedInPg'] = $row->{'storageUsedInPg'};
                        $current['storageUsedInCloud'] = $row->{'storageUsedInCloud'};
                        $current['storageDateReadable'] = date('m/d/y', (((int)$row->{'storageDate'}) / 1000));
                        $dailyUserBackupOverview = array_merge(array($current), $dailyUserBackupOverview);
                    }
                }
                $response = array(
                    'result' => 'success',
                    'dailyUserBackupOverview' => $dailyUserBackupOverview
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function downloadDailyUserBackupOverview(){
        if(!empty($_POST['from']) && $_POST['to'] == 'dashboard'){
            $_POST['from'] = date('m/d/Y', ($_POST['from']/1000));
            $_POST['to'] = date('m/d/Y', ($_POST['to']/1000));
        }
        $fromDate = !empty($_POST['from']) ? $_POST['from'] : date('m/d/y', strtotime(date('m/d/y') . ' -30 days'));
        $toDate = !empty($_POST['to']) ? $_POST['to'] : date('m/d/Y');
        $timeDiff = abs(strtotime($toDate) - strtotime($fromDate));
        $numberDays = intval($timeDiff/86400) + 1;
        if($numberDays > 30){
            $data = array(
                'result' => 'fail',
                'msg' => 'Details can only be retrieved for 30 days'
            );
            $jsonData = json_encode($data);
            echo $jsonData;
            exit;
        }

        if($_POST['userName'] == 'All'){
            $_POST['userName'] = '';
        }
        $headers = array(
            'Content-Type'  => 'application/json',
            'userName'      => !empty($_POST['userName']) ? $_POST['userName'] : '',
            'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
            'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''
        );

        $result = $this->_model->downloadDailyUserBackupOverview($headers);

        switch ($result['status']) {
            case (200):

                $response = array(
                    'result' => 'success',
                );
                echo json_encode($response);
                exit;

            case (421):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('421')
                );
                echo json_encode($result);
                exit();
            case (500):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('500')
                );
                echo json_encode($result);
                exit();
            case (0):
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('0')
                );
                echo json_encode($result);
                exit();
            default:
                $result = array(
                    'result' => 'fail',
                    'msg' => $this->language->get('default')
                );
                echo json_encode($result);
                exit();
        }
    }

    public function deviceUserHistory(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('deviceUserHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/deviceInfo/deviceUserHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDeviceUserHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'deviceName'      => !empty($_POST['deviceName']) ? $_POST['deviceName'] : ''
            );

            $result = $this->_model->getDeviceUserHistory($headers);
            $this->log('result' .json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'deviceUserHistory' => $result['body']->{'userDeviceHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function deviceBackupHistory(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('deviceBackupHistory'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/deviceInfo/deviceBackupHistory', $data);
        View::renderTemplate('footer', $data);
    }

    public function getDeviceBackupHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'deviceName'      => !empty($_POST['deviceName']) ? $_POST['deviceName'] : '',
                'startDate'     => !empty($_POST['from']) ? $_POST['from'] : '',
                'endDate'       => !empty($_POST['to']) ? $_POST['to'] : ''
            );

            $result = $this->_model->getDeviceBackupHistory($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'deviceBackupHistory' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function lastBackupByUser(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('lastBackupByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/lastBackup/lastBackupByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function lastBackupByDevice(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('lastBackupByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/lastBackup/lastBackupByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function getLastBackupDetails(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json'
            );

            if(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }

            if(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }

            $result = $this->_model->getLastBackupDetails($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'lastBackupDetails' => $result['body']->{'backupHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function alertByDevice(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('alertHistory'),
            'crumb2' => $this->language->get('alertByDevice'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/alertHistory/alertByDevice', $data);
        View::renderTemplate('footer', $data);
    }

    public function alertByUser(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('alertHistory'),
            'crumb2' => $this->language->get('alertByUser'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/alertHistory/alertByUser', $data);
        View::renderTemplate('footer', $data);
    }

    public function alertByDate(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('alertHistory'),
            'crumb2' => $this->language->get('alertByDate'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/alertHistory/alertByDate', $data);
        View::renderTemplate('footer', $data);
    }

    public function getAlertHistory(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json'
            );

            if(!empty($_POST['deviceName'])){
                $headers['deviceName'] = $_POST['deviceName'];
            }

            if(!empty($_POST['userName'])){
                $headers['userName'] = $_POST['userName'];
            }

            if(!empty($_POST['from']) && !empty($_POST['to'])){
                $headers['startDate'] = $_POST['from'];
                $headers['endDate'] = $_POST['to'];
            }

            $result = $this->_model->getAlertHistory($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'alertHistory' => $result['body']->{'alertHistoryElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function userMigration(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('userMigrationStatus'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/userMigration', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUserMigration(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );

            $result = $this->_model->getUserMigration($headers);

            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'userMigration' => $result['body']->{'userMigratedElementList'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function syncOverview(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('syncCloudUsage'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/sync/syncOverview', $data);
        View::renderTemplate('footer', $data);
    }

    public function getSyncOverview(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );

            $result = $this->_model->getSyncCLoudUsage($headers);
            $this->log("syncCLoudUsage: ". json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'syncCLoudUsage' => $result['body']->{'syncOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function syncCLoudUsage(){
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('syncCloudOverview'),
            'active' => 'report',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('report/sync/syncCloudUsage', $data);
        View::renderTemplate('footer', $data);
    }

    public function getSyncCLoudUsage(){
        if(!empty($_POST)){
            $headers = array(
                'Content-Type'  => 'application/json',
                'skipValue' => !empty($_POST['skipValue']) ? $_POST['skipValue'] : 0
            );

            $result = $this->_model->getSyncCLoudUsage($headers);
            $this->log("syncCLoudUsage: ". json_encode($result), 'info');
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'syncCLoudUsage' => $result['body']->{'syncOverviewElement'}
                    );
                    echo json_encode($response);
                    exit;

                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function downloadDailyUserBackupOverviewExcel(){
        $filePath = OVERVIEW_REPORT_PATH.OVERVIEW_DAILY_USERBACKUP_OVERVIEW;
        if(file_exists($filePath)){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename='.OVERVIEW_DAILY_USERBACKUP_OVERVIEW);
            header('Pragma: no-cache');
            ob_clean();
            readfile($filePath);
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
        }
    }

    public function downloadOverViewReport(){
        $headers = array(
            'Content-Type' => 'application/json'
        );
        $result = $this->_model->downloadOverViewReport($headers);

        if($result['status'] == 200){
            $filePath = OVERVIEW_REPORT_PATH.OVERVIEW_REPORT_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.OVERVIEW_REPORT_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }

    }

    public function downloadSyncOverViewReport(){
        $headers = array(
            'Content-Type' => 'application/json'
        );
        $result = $this->_model->downloadSyncOverViewReport($headers);

        if($result['status'] == 200){
            $filePath = OVERVIEW_REPORT_PATH.SYNC_OVERVIEW_REPORT_NAME;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.SYNC_OVERVIEW_REPORT_NAME);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }

    }

    public function downloadOverViewReportSync(){
        $headers = array(
            'Content-Type' => 'application/json',
            'endDate'       => date('m/d/Y'),
            'startDate'     => '01/01/1970'
        );

        if(!empty($_GET['fromDate']) && !empty($_GET['toDate'])){
            $headers['endDate'] = $_GET['toDate'];
            $headers['startDate'] = $_GET['fromDate'];
        }else{
            header('Location: '.Url::basePath('report/syncCLoudUsage'.$_GET['from'].'?result=302'));
        }

        $this->log('Headers'. json_encode($headers), 'info');
        $result = $this->_model->downloadOverViewReportSync($headers);
        $this->log('Result'. json_encode($result), 'info');
        if($result['status'] == 200){
            $filePath = OVERVIEW_REPORT_PATH.OVERVIEW_REPORT_NAME_SYNC;
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.OVERVIEW_REPORT_NAME_SYNC);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/syncCLoudUsage'.$_GET['from'].'?result=404'));
            }
        }else{
            header('Location: '.Url::basePath('report/syncCLoudUsage'.$_GET['from'].'?result=500'));
        }

    }

}
