#param($myPath,$timestamp,$databaseName)
param (
    [string]$BACKUP_DESTINATION_FOLDER,
    [string]$DATABASES_TO_BE_BACKUPEDUP = $(throw "-databaseName is required"),
    [string]$USERNAME,
    [string]$PASSWORD,
    [string]$ORACLE_HOME_PATH,
    [string]$DB_IP,
    [string]$DB_PORT,
    [string]$recivedTimestamp
    )
$restorePath=$BACKUP_DESTINATION_FOLDER

if($recivedTimestamp){
    $timestamp=[datetime]::ParseExact(($recivedTimestamp),"MM/dd/yyyy:HH.mm",$null);
}
$scriptsPath= Split-Path -Parent -Path $MyInvocation.MyCommand.Definition
$file_content = Get-Content "$scriptsPath\conf.txt"
$file_content = $file_content -join [Environment]::NewLine
$configuration = ConvertFrom-StringData($file_content)
#$DATABASES_TO_BE_BACKUPEDUP = $configuration.'DATABASES_TO_BE_BACKUPEDUP'
#$ORACLE_HOME_PATH = $configuration.'ORACLE_HOME_PATH'
$databaseArray= $DATABASES_TO_BE_BACKUPEDUP -split ',';
#$databaseArray=$databaseName
"datsbase array ::: $databaseArray"
Set-Item env:ORACLE_HOME -value($ORACLE_HOME_PATH)
Write-Output "ora home ::::::::: $env:ORACLE_HOME"
$BIN_DIR=$scriptsPath\commands
foreach($database in $databaseArray){
    if($database -eq ""){
        Write-Output "The database string is empty"
    }Else{
        Write-Output "Restore path :: $restorePath"
        $lastControllfile
        $fullRestorePath
        [string[]]$incrSubFolders = Get-ChildItem ($restorePath+"\incremental\") | % {$_.Name} | Sort-Object -Descending;
        Write-Output "before sort ::: $incrSubFolders"
        $incrSubFolders = $incrSubFolders | Sort-Object {[System.DateTime]::ParseExact($_, "MM-dd-yyyy_HH.mm", $null)}
        Write-Output "after sort ::: $incrSubFolders"
        [datetime[]]$comparable = @();

        if($incrSubFolders -gt 0){
            if(($timestamp) -and ($timestamp -ne "")-and($timestamp -ne "null")){
                foreach($dateStr in $incrSubFolders)
                {
                    $comparable+=[datetime]::ParseExact($dateStr,"MM-dd-yyyy_HH.mm",$null)
                }
                Write-Output "Comparable::  $comparable"

                $TimeDiff = [TimeSpan]::MaxValue#.TotalMilliseconds  
                $comparable | foreach {
                    if($_ -lt $timestamp){
                        $differ=($timestamp - $_)
                    }Else{
                        $differ=($_ - $timestamp)
                    }
                    Write-Output "timespan :::$differ"

                    if( $differ -lt $TimeDiff){           
                        $SelectSID = $_
                        $TimeDiff = $differ
                    } 
                } 
                Write-Output "::best::: $SelectSID"
                $d="{0:MM-dd-yyyy_HH.mm}" -f [datetime]$SelectSID
                Write-Output "dte >>>>>>>>>::::>>>>   $d"
                $fullRestorePath = ($restorePath+"\incremental\"+$d)
                 Write-Output "pth ::  $fullRestorePath"
                 [string[]]$childFile=Get-ChildItem  $fullRestorePath CONTROLSPFILE* | % {$_.Name};
                 Write-Output "chiols ::: $childFile"
                 $lastControllfile=$childFile.Get($childFile.Count-1)
             }Else{
                $fullRestorePath = ($restorePath+"\incremental\"+$incrSubFolders.Get($incrSubFolders.Count-1))
                Write-Output "pth ::  $fullRestorePath"
                [string[]]$childFile=Get-ChildItem  $fullRestorePath CONTROLSPFILE* | % {$_.Name};
                Write-Output "chiols ::: $childFile"
                $lastControllfile=$childFile.Get($childFile.Count-1)
                Write-Output "No timestamp lastControllfile>> $lastControllfile"
            }
        }Else{
            Write-Output "No incremental folders"
            $fullRestorePath = ($restorePath+"\full")
            [string[]]$childFile=Get-ChildItem  $fullRestorePath CONTROLSPFILE* | % {$_.Name};
            #Sort-Object $childFile -Descending
            $lastControllfile=$childFile.Get($childFile.Count-1)
            
        }
        Set-Item  env:ORACLE_SID  -value($database)
        $PATH=($env:ORACLE_HOME+'\BIN')
        #Push-Location  $PATH
        Write-Output "-------------------------------"
        Write-Output "PATH :::: $PATH"
        Write-Output ('"'''+$fullRestorePath+'''"')
        Write-Output ('"'''+$lastControllfile+'''"')
        Write-Output (''''+$BIN_DIR+'\restore.scp'+'''')
        Write-Output "-------------------------------"
        
        #rman target / cmdfile=$BIN_DIR\restore.scp USING ('"'''+$fullRestorePath+'''"') ('"'''+$lastControllfile+'''"');
        if($?){
        	Write-Output "Restore has been completed with a warning please re-check if all the database values exist"
        }Else{
            Write-Output "Restore has been completed"
        }
    }
}   
