param (
    [string]$BACKUP_DESTINATION_FOLDER,
    [string]$DATABASES_TO_BE_BACKUPEDUP = $(throw "-databaseName is required"),
    [string]$USERNAME,
    [string]$PASSWORD,
    [string]$ORACLE_HOME_PATH,
    [string]$DB_IP,
    [string]$DB_PORT,
    [string]$timestamp
)
$scriptsPath =Split-Path -Parent -Path $MyInvocation.MyCommand.Definition
Invoke-Expression "$scriptsPath\createFolder.ps1 incr $BACKUP_DESTINATION_FOLDER"
$valueRet=$LastExitCode
Write-Output "exit code for creating folders :: $valueRet "
if($valueRet -ne 0){
	Write-Output "folder structure was not created successfuly :: $valueRet"
}Else{
	Write-Output "Folders successfuly created"
}

$file_content = Get-Content "$scriptsPath\conf.txt"
$file_content = $file_content -join [Environment]::NewLine
$configuration = ConvertFrom-StringData($file_content)
#$DATABASES_TO_BE_BACKUPEDUP = $configuration.'DATABASES_TO_BE_BACKUPEDUP'
#$ORACLE_HOME_PATH = $configuration.'ORACLE_HOME_PATH'
$FILE_PATH= $configuration.'FILE_PATH'
$CUMULATIVE_BACKUP= $configuration.'CUMULATIVE_BACKUP'
#$PASSWORD= $configuration.'PASSWORD'
#$USERNAME= $configuration.'USERNAME'
#$LOG_DIR=E:\ORACLE12c\oracleBackup\logs
$BIN_DIR=$scriptsPath\commands


$file_content1 = Get-Content "$scriptsPath\temp.txt"
$file_content1 = $file_content1 -join [Environment]::NewLine
$configuration1 = ConvertFrom-StringData($file_content1)
$BACKUP_FILE_PATH = $configuration1.'filePath'
Write-Output "bfp ::: $BACKUP_FILE_PATH"
$BACKUP_TIME=get-date -f "MM-dd-yyyy_HH.mm";

Set-Item  env:CURRENT_BACKUP_TIME  -value($BACKUP_TIME)

$databaseArray= $DATABASES_TO_BE_BACKUPEDUP -split ',';
#Setting oracle home path
#set oracle home
Set-Item env:ORACLE_HOME -value($ORACLE_HOME_PATH)
#set path to bin directory for rman.exe
set-item -path env:path -value($env:ORACLE_HOME+"\BIN\")
Write-Output "path set :::: $env:path"
#setx PATH $env:path;E:\app\Vulcan\product\11.2.0\dbhome_1\BIN -m

foreach($database in $databaseArray){
    Write-Output "database ::: $database"
	if($database -eq ""){
		Write-Output "The database string is empty"
	}Else{

		$env:ORACLE_SID=$database
        #set oracle SID
        Set-Item  env:ORACLE_SID  -value($database)
        $pathToTest = ($BACKUP_FILE_PATH+"incremental\"+$BACKUP_TIME+"\") 
        Write-Output "path to test ::: $pathToTest"
		if(Test-Path $pathToTest){
			Write-Output "Backup destination folder already exists "
		}Else{
			mkdir ($BACKUP_FILE_PATH+"incremental\"+$BACKUP_TIME+"\") -force 
			if($?){
				Write-Output "Created folder successfuly :: $BACKUP_FILE_PATH"incrementa\"$BACKUP_TIME"
			}Else{
				Write-Output "Could not Create a folder "
			}
		}
		Write-Output "----------------------------------------------"
		Write-Output "rman backup cm_level0 for orcl started date"
        Write-Output ('"'''+$BACKUP_FILE_PATH+"\full\"+'''"')
		Write-Output "-----------------------------------------------"

		if($CUMULATIVE_BACKUP -eq "true"){
            #call rman to run the backup script and output to log file
            rman target username/password cmdfile=$BIN_DIR\incCumulative.scp USING ('"'''+$BACKUP_FILE_PATH+"incremental\"+$BACKUP_TIME+'''"') ('"'''+$BACKUP_TIME+'''"'); 

			if($?){
				Write-Output "Rman command was successful"
			}Else{
				Write-Output "Rman backup was not successfull, ERROR CODE: $?"
				exit 1
			}
			Write-Output "----------------------------------------------"
			Write-Output "rman backup cm_level0 for orcl ended date"
			Write-Output "-----------------------------------------------"
			exit 0
		}Else{
            #call rman to run the backup script and output to log file
			rman target username/password cmdfile=$BIN_DIR\incDifferential.scp USING ('"'''+$BACKUP_FILE_PATH+"incremental\"+$BACKUP_TIME+'''"') ('"'''+$BACKUP_TIME+'''"'); 
			if($?){
				Write-Output "Rman backup has been taken successfuly"
			}Else{
				Write-Output "Rman backup was not taken successfuly exit value :: $?"
				exit 0
			}
		}
	}
}
