param (
	[string]$BACKUP_DESTINATION_FOLDER,
	[string]$DATABASES_TO_BE_BACKUPEDUP = $(throw "-databaseName is required"),
	[string]$USERNAME,
	[string]$PASSWORD,
	[string]$ORACLE_HOME_PATH,
	[string]$DB_IP,
	[string]$DB_PORT,
	[string]$timestamp
	)
$scriptsPath= Split-Path -Parent -Path $MyInvocation.MyCommand.Definition



$databaseArray=$DATABASES_TO_BE_BACKUPEDUP -split '\|'

$file_content = Get-Content "$scriptsPath\conf.txt"
$file_content = $file_content -join [Environment]::NewLine
$configuration = ConvertFrom-StringData($file_content)
#$DATABASES_TO_BE_BACKUPEDUP = $configuration.'DATABASES_TO_BE_BACKUPEDUP'
#$ORACLE_HOME_PATH = $configuration.'ORACLE_HOME_PATH'
$FILE_PATH= $configuration.'FILE_PATH'
$CUMULATIVE_BACKUP= $configuration.'CUMULATIVE_BACKUP'
#$PASSWORD= $configuration.'PASSWORD'
#$USERNAME= $configuration.'USERNAME'
$LOG_DIR=E:\ORACLE12c\oracleBackup\logs
$BIN_DIR=$scriptsPath\commands


#$file_content1 = Get-Content "$scriptsPath\temp.txt"
#$file_content1 = $file_content1 -join [Environment]::NewLine
#$configuration1 = ConvertFrom-StringData($file_content1)
#$BACKUP_FILE_PATH = $configuration1.'filePath'
#Write-Output "bfp ::: $BACKUP_FILE_PATH"
$BACKUP_TIME=get-date -f "MM-dd-yyyy_HH.mm";

Set-Item  env:CURRENT_BACKUP_TIME  -value($BACKUP_TIME)

####$databaseArray= $DATABASES_TO_BE_BACKUPEDUP -split ',';
#Setting oracle home path
#set oracle home
Set-Item env:ORACLE_HOME -value($ORACLE_HOME_PATH)
#set path to bin directory for rman.exe
set-item -path env:path -value($env:ORACLE_HOME+"\BIN\")
	Write-Output "path set :::: $env:path"
	#setx PATH $env:path;$ORACLE_HOME_PATH -m

	foreach($database in $databaseArray){
		Write-Output "database ::: $database"
		Invoke-Expression "$scriptsPath\createFolder.ps1 full $BACKUP_DESTINATION_FOLDER $database"
		$valueRet="true";#$LastExitCode
		Write-Output "exit code for creating folders :: $valueRet "
		if($valueRet){
			Write-Output "Folders successfuly created"
		}Else{
			Write-Output "folder structure was not created successfuly :: $valueRet"
		}
		
		$file_content1 = Get-Content "$scriptsPath\temp.txt"
		$file_content1 = $file_content1 -join [Environment]::NewLine   
		$configuration1 = ConvertFrom-StringData($file_content1)
		$BACKUP_FILE_PATH = $configuration1.'filePath'
		Write-Output "bfp ::: $BACKUP_FILE_PATH"

		if($database -eq ""){
			Write-Output "The database string is empty"
		}Else{

			$env:ORACLE_SID=$database
			#set oracle SID
			Set-Item  env:ORACLE_SID  -value($database)

			if(Test-Path '$BACKUP_FILE_PATH\full\'){
				Write-Output "Backup destination folder already exists "
			}Else{
				mkdir ($BACKUP_FILE_PATH+"\"+"full\") -force 
				if($?){
					Write-Output "-----------------------------------------------------------------"
					Write-Output "Created folder successfuly :: $BACKUP_FILE_PATH\full\"
					Write-Output "------------------------------------------------------------------"
				}Else{
					Write-Output "--------------------------"
					Write-Output "Could not Create a folder "
					Write-Output "--------------------------"
				}
			}
			Write-Output "-------------------------------------------"
			Write-Output "rman backup cm_level0 for orcl started date"
			Write-Output ('"'''+$BACKUP_FILE_PATH+"\full"+'''"')
			Write-Output "-------------------------------------------"

			if($CUMULATIVE_BACKUP -eq "true"){
            #call rman to run the backup script and output to log file
            rman target username/password cmdfile=$BIN_DIR\fullCumulative.scp USING ('"'''+$BACKUP_FILE_PATH+"\full"+'''"') ('"'''+$BACKUP_TIME+'''"'); 

            if($?){
            	Write-Output "---------------------------"
            	Write-Output "Rman command was successful"
            	Write-Output "---------------------------"
            }Else{
            	Write-Output "-----------------------------------------------"
            	Write-Output "Rman backup was not successfull, ERROR CODE: $?"
            	Write-Output "-----------------------------------------------"
            	exit 1
            }
            Write-Output "-----------------------------------------"
            Write-Output "rman backup cm_level0 for orcl ended date"
            Write-Output "-----------------------------------------"
            exit 0
        }Else{
            #call rman to run the backup script and output to log file
            rman target username/password cmdfile=$BIN_DIR\fullDifferential.scp USING ('"'''+$BACKUP_FILE_PATH+"\full"+'''"') ('"'''+$BACKUP_TIME+'''"'); 
            if($?){
            	Write-Output "--------------------------------------"
            	Write-Output "Rman backup has been taken successfuly"
            	Write-Output "--------------------------------------"
            }Else{
            	Write-Output "------------------------------------------------------"
            	Write-Output "Rman backup was not taken successfuly exit value :: $?"
            	Write-Output "------------------------------------------------------"
            	exit 0
            }
        }
    }
}
