param($backupType , $BACKUP_DESTINATION_FOLDER, $database)
$scriptsPath= Split-Path -Parent -Path $MyInvocation.MyCommand.Definition
Write-Output "script path passed ::: ::: :: $scriptsPath"
$timestamp=$(get-date -f MM-dd-yyyy_HH.mm)

$file_content = Get-Content "$scriptsPath\conf.txt"
$file_content = $file_content -join [Environment]::NewLine
#$configuration = ConvertFrom-StringData($file_content)
#$BACKUP_DESTINATION_FOLDER = $configuration.'BACKUP_DESTINATION_FOLDER'
write-output "destination folder :: $BACKUP_DESTINATION_FOLDER"
write-output "backupType ::::$backupType"

$BACKUP_FILE_PATH
if($backupType -eq "incr"){
    $file_content1 = Get-Content "$scriptsPath\temp.txt"
    $file_content1 = $file_content1 -join [Environment]::NewLine
    $configuration1 = ConvertFrom-StringData($file_content1)
    $BACKUP_FILE_PATH = $configuration1.'filePath'
}Else{
    $BACKUP_FILE_PATH = $BACKUP_DESTINATION_FOLDER+"\"+$database+"\"+$timestamp
}
Write-Output "backup file pth :::: $BACKUP_FILE_PATH"
#Checking for bkp folder
if(Test-Path $BACKUP_DESTINATION_FOLDER){
	write-output "----------------------------------------"
	write-output "Backup Destination folder already exists"
	write-output "----------------------------------------"
}Else{
	mkdir $BACKUP_DESTINATION_FOLDER -force
	if($?){
		write-output "---------------------------"
		write-output "Directory created $BACKUP_DESTINATION_FOLDER"
		write-output "---------------------------"
	}Else{
		write-output "-----------------------------------------------------------------------"
		write-output "Backup destination directory coudn't be created :: $BACKUP_DESTINATION_FOLDER"
		write-output "-----------------------------------------------------------------------"
		exit 1	
	}
}

if(Test-Path $BACKUP_FILE_PATH"\full\"){
	write-output "------------------------------------------"
	write-output "Backup destination folder alredy exists"
	write-output "------------------------------------------"
}Else{
	mkdir $BACKUP_FILE_PATH"\full\"
	if($?){
		write-output "-------------------------------------"
		write-output "backup destination folder has been created :: $BACKUP_DESTINATION_FOLDER\$database\$timestamp\full\ "
		write-output "-------------------------------------"
	}Else{
		write-output "Could not create full folder inside destination folder :: $BACKUP_DESTINATION_FOLDER\$database\$timestamp\full\"
		exit 1
	}
}
if(Test-Path $BACKUP_FILE_PATH"\incremental\"){
	write-output "----------------------------------------------"
	write-output "Backup incremefntal destination folder exists"
	write-output "-----------------------------------------------"
}Else{
	mkdir $BACKUP_FILE_PATH"\incremental\" -force
	if($?){
		write-output "Backup destination folder for incremental was created $BACKUP_DESTINATION_FOLDER\$database\$timestamp\incremental\"
	}Else{
		write-output "could not create Backup incremental folder "
		exit 1
	}

    if($backupType -ne "incr"){
	$value =("filePath="+$BACKUP_FILE_PATH+"\") -replace "\\","\\"
    Write-Output "_____________________________________________________________"
	Write-Output "backup path to temp file :::: $value"
    Write-Output "_____________________________________________________________"
	Set-content -path "$scriptsPath\temp.txt" -value $value
    write-output "::::::::::::: "$?
	}Else{
        Write-Output "Incremental Hence not writing to temp file"    
    }
exit 0

}
