/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.constant.StringLiterals;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    public static final String CLOUD_NAME = PropertyHelper.getMessageResourceString("Cloud-Name");
    private static final String WL_PROPERTIES = "WL.properties";
    public static final String REGVIEW_APPNAME = PropertyHelper.getMessageResourceString("App-Name");
    public static final String REGVIEW_CONNECT_TO_LABEL = PropertyHelper.getMessageResourceString("Connect-to-Vault");
    public static final String REGVIEW_CLOUD_DETAILS = PropertyHelper.getMessageResourceString("Cloud-details");
    public static final String REGVIEW_CLOUD_NAME = PropertyHelper.getMessageResourceString("Cloud-Name-Label");
    public static final String REGVIEWPROGRESS_CONNECTING_LABEL = PropertyHelper.getMessageResourceString("Connecting-Label");
    public static final String REGVIEWPROGRESS_SUCCESSFULL_LABEL = PropertyHelper.getMessageResourceString("Success-Label");
    public static final String REGVIEWPROGRESS_CONFIGURE_FOLDER_LABEL = PropertyHelper.getMessageResourceString("Configure-Folder-Label");
    public static final String SYSTRAY_BALLOONTIP_LABEL = PropertyHelper.getMessageResourceString("Systray-Balloon-Label");
    public static final String SYSTRAY_BALLOONTIP_BELOW_LABEL = PropertyHelper.getMessageResourceString("Systray-Balloon-Below-Label");
    public static final String SYSTRAY_TOOLTIP_LABEL = PropertyHelper.getMessageResourceString("Systray-Tooltip-Label");
    public static final String SYSTRAY_OPEN_SHORTCUT_FOLDER_LABEL = PropertyHelper.getMessageResourceString("Systray-Open-Folder-Label");
    public static final String EXIT_MSG_CONFIRMATION_LABEL = PropertyHelper.getMessageResourceString("Exit-Msg-Label");
    public static final String DECOUPLE_CONFIRMATION_LABEL = PropertyHelper.getMessageResourceString("Decouple-Msg-Label");
    public static final String NO_INTERNET_ICON = PropertyHelper.getMessageResourceString("No-Internet-Icon");
    public static final String SYS_TRAY_ICON = PropertyHelper.getMessageResourceString("Sys-Tray-Icon");
    public static final String TASK_BAR_ICON = PropertyHelper.getMessageResourceString("Task-Bar-Icon");
    public static final String REG_VIEW_SEARCH_GIF = PropertyHelper.getMessageResourceString("Reg-ViewSearch-Gif");
    public static final String REG_VIEW_VALIDATE_ICON = PropertyHelper.getMessageResourceString("Reg-View-Validate-Icon");
    public static final String SYS_TRAY_CURRENT_SYNCING_ICON = PropertyHelper.getMessageResourceString("Sys-Tray-Current-Syncing-Icon");
    public static final String SHORTCUT_FOLDER_NAME = PropertyHelper.getMessageResourceString("Shortcut-Folder-Name");
    public static final String SHORTCUT_FOLDER_IMAGE = PropertyHelper.getMessageResourceString("Shortcut-Folder-Image");
    public static final String USER_SYNC_BACK_DISABLED_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("No-Permissions-Error");
    public static final String DEVICE_REGISTRATION_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("Device-Registration-Error");
    public static final String DEVICE_REGISTRATION_ERROR_TITLE = PropertyHelper.getMessageResourceString("Device-Registration-Error-Title");
    public static final String HELP_LINK_SEND_MAIL = PropertyHelper.getMessageResourceString("Mail-Link");
    public static final String STATUS_CLOUD_UNREACHABLE = PropertyHelper.getMessageResourceString("Cloud-Unreachable");
    public static final String STATUS_FINISHED_SYNC = PropertyHelper.getMessageResourceString("Sync-Finished-Status");
    public static final String DEVICE_BLOCKED_FROM_ACCESS = PropertyHelper.getMessageResourceString("Device-Blocked-From-Access");
    public static final String DEVICE_LIMIT_EXCEEDED_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("Device-Limit-Exceeded-Error");
    public static final String NO_CLOUDS_ATTACHED_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("No-Clouds-Attached-Error");
    public static final String INSYNC_LABEL = PropertyHelper.getMessageResourceString("InSync-Label");
    public static final String USERNAME_TOOLTIP_LABEL = PropertyHelper.getMessageResourceString("UserName-Tooltip");
    public static final String CLOUD_NAME_TOOL_TIP = PropertyHelper.getMessageResourceString("CloudName-Tooltip");
    public static final String APP_WEBSITE_URL_FOR_SHELLEXT = PropertyHelper.getMessageResourceString("App-Website-Url");
    public static final String DEVICE_BLOCKED_MESSAGE_TOOLTIP = PropertyHelper.getMessageResourceString("Device-Blocked-Tooltip");
    public static final String SYNC_COMPLETE_MESSAGE_TOOLTIP = PropertyHelper.getMessageResourceString("Sync-CompleteMsg-Tooltip");
    public static final String LOGIN_CREDENTIALS_EXPIRED_MESSAGE_TOOLTIP = PropertyHelper.getMessageResourceString("Login-Credentials-Expired-Tooltip");
    public static final String BLUSYNC_VERSION_LABEL = PropertyHelper.getMessageResourceString("BluSync-Version-Label");
    public static final String MAIN_EBMS_DOMAIN = PropertyHelper.getMessageResourceString("Main-EBMS-domain");
    public static final String SUB_EBMS_DOMAIN = PropertyHelper.getMessageResourceString("Sub-EBMS-domain");
    public static final String CERT_FILE_ALIAS = PropertyHelper.getMessageResourceString("Cert-File-Alias");
    public static final String SUB_EBMS_DOMAIN_1 = PropertyHelper.getMessageResourceString("Sub-EBMS-domain-1");
    public static final String BKRYPT_DOMAIN_FOR_SYNC = PropertyHelper.getMessageResourceString("BK-domain-sync");
    public static final String BACKUP_CRAWL_LIMIT = PropertyHelper.getMessageResourceString("Backup-Crawl-Limit");
    public static final String AGENT_LISTNER_PORT = PropertyHelper.getMessageResourceString("Agent-Listner-Port");
    public static final String COMMAND_LISTNER_ENABLED = PropertyHelper.getMessageResourceString("Comand-Listner-Enabled");
    private static final Logger logger = LoggerFactory.getLogger(PropertyHelper.class);
    public static final String WL_DIRECTORY_LINUX = "/opt/ParaBlu/Blusync/";
    public static final String EXCEP_STRING = "Exception getting Script Resource String :";
    private static String userHome;

    private PropertyHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessageResourceString(String key) {
        String usrHome;
        String text = "";
        userHome = usrHome = System.getProperty("user.home");
        String osType = System.getProperty("os.name");
        String wlDirectory = userHome + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
        ResourceBundle bundle = null;
        FileInputStream fis = null;
        try {
            if (osType.toLowerCase().contains("win")) {
                fis = new FileInputStream(wlDirectory + WL_PROPERTIES);
                bundle = new PropertyResourceBundle(fis);
            } else if (osType.toLowerCase().contains("lin")) {
                fis = new FileInputStream("/opt/ParaBlu/Blusync/WL.properties");
                bundle = new PropertyResourceBundle(fis);
            } else {
                bundle = osType.toLowerCase().contains("mac") ? ResourceBundle.getBundle("WL", Locale.US) : ResourceBundle.getBundle("WL", Locale.US);
            }
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEP_STRING + e.getMessage());
        }
        try {
            if (bundle != null) {
                text = bundle.getString(key);
            }
        }
        catch (MissingResourceException e) {
            logger.trace("" + e);
            logger.error(EXCEP_STRING + e.getMessage());
            text = "";
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error(EXCEP_STRING + e.getMessage());
            }
        }
        return text;
    }

    public static void changeConfigProperty(String key, String value) throws ConfigurationException {
        String wlDirectory = userHome + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
        PropertiesConfiguration config = new PropertiesConfiguration(wlDirectory + WL_PROPERTIES);
        config.setProperty(key, (Object)value);
        config.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptResourceString(String key) {
        String text = "";
        String osType = System.getProperty("os.name");
        String keyTemp = key;
        keyTemp = osType.substring(0, 3).concat(keyTemp);
        logger.debug("Script key :" + keyTemp);
        String scDir = userHome + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Scripts" + StringLiterals.FILE_SEPARATOR;
        String scDirLin = "/opt/ParaBlu/Scripts/";
        ResourceBundle bundle = null;
        FileInputStream fis = null;
        try {
            if (osType.toLowerCase().contains("win")) {
                fis = new FileInputStream(scDir + "SC.properties");
                bundle = new PropertyResourceBundle(fis);
            } else if (osType.toLowerCase().contains("lin")) {
                fis = new FileInputStream(scDirLin + "SC.properties");
                bundle = new PropertyResourceBundle(fis);
            } else {
                bundle = ResourceBundle.getBundle("SC", Locale.US);
            }
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEP_STRING + e.getMessage());
        }
        try {
            if (bundle != null) {
                text = bundle.getString(keyTemp);
            }
        }
        catch (MissingResourceException e) {
            logger.trace("" + e);
            logger.error(EXCEP_STRING + e.getMessage());
            logger.debug("Missing Resource");
            text = "";
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error(EXCEP_STRING + e.getMessage());
            }
        }
        return text;
    }
}

