/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.BackupElement;
import com.parablu.epa.core.element.BackupStatusElement;
import com.parablu.epa.core.element.ChunkFileElement;
import com.parablu.epa.core.element.ContainerListElement;
import com.parablu.epa.core.element.DeviceElement;
import com.parablu.epa.core.element.DeviceListElement;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.FolderDeviceListElement;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.UploadChunkFileException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.RestoreHelper;
import com.parablu.epa.core.service.transformer.Xmlparser;
import com.parablu.epa.core.to.BackupCheckTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ContainerBackupStatusTo;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.GzipTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupAdapter
extends BaseAdapter {
    private static final String PARACLOUD_BACKUP_UPLOAD = "/backup/upload";
    private static final String PARACLOUD_BACKUP_VALIDATION = "/crawl/backup/validate";
    private static final String PARACLOUD_BACKUP_ADD_FOLDER = "/backup/addfolder";
    private static final String PARACLOUD_BACKUP_REGISTERED_DEVICES_BY_USER = "/backup/device/all";
    private static final String PARACLOUD_BACKUP_GET_FILE_LIST_FOR_DEVICE = "/backup/files/all";
    private static final String PARACLOUD_BACKUP_GET_FILE_LIST_FOR_FOLDER_DEVICE = "/backup/folder/files/all";
    private static final String PARACLOUD_BACKUP_GET_BASE_PATH_FOR_SELECTED_DEVICE = "/backup/files/child/agent";
    private static final String PARACLOUD_BACKUP_SEND_NOTIFICATION = "/backupBatch/save";
    private static final String PARACLOUD_BACKUP_DOWNLOAD_FILE = "/backup/download/file";
    private static final String PARACLOUD_BACKUP_BACKEDUP_FODLERS = "/backup/base/all";
    private static final String CLIENT_PROTOCOL_EXCEPTION = "ClientProtocol Exception ";
    private static final String EXCEPTION = "Exception :";
    private static final String FILE_NOT_FOUND_EXCEPTION = "FileNotFoundException :";
    private static final String NO_ROUTE_TO_HOST_EXCEPTION = "NoRouteToHostException ";
    private static final String HTTP_HOST_CONNECT_EXCEPTION = "HttpHostConnectException ";
    private static final String UNKNOWN_HOST_EXCEPTION = "UnknownHostException ";
    private static final String DOWNLOAD_RESPONSE = "Download Response is null";
    private static final String DOWNLOAD_RESPONSE_CODE = "The response code for download is :";
    private static final String URL = "URL: ";
    private static final String URI = "uri: ";
    private static final String UPLOAD_URL = "Upload Url for this file:";
    private static final String INSIDE_CATCH_BLOCK = "Inside Catch";
    private static final String INTO_VALIDATE = "Entering : ParacloudAdapter.validateDeltaForBackUp";
    private static final String INTO_UPLOAD_FILE = "Entering : ParacloudAdapter.uploadFile";
    private static final String RESPONSE_NULL = "Response is null";
    private static final String ERR_MSG = "errorMessage";
    private static final String NEW_LINE_CHAR = "[\n\r]";
    private static final String RESPONSE_CODE = "Response Code: ";
    private static final String IO_EXCEPTION = "IOException ";
    private static final String PARACLOUD_EXTERNAL_BACKUP_UPLOAD = "/externalbackup/upload";
    private static final String PARACLOUD_SEND_BACKUP_STATISTICS = "/save/statistics/";
    private static final String PARACLOUD_SEND_BACKUP_FILE_STATISTICS = "/save/files/ah/";
    private static final String PARACLOUD_CHECK_DEDUP = "/file/check/dedup/";
    private static final String PARACLOUD_CHECK_BACKUP_POLICY_VERSION = "/check/backupPolicy/version";
    private static final String PARACLOUD_CHECK_ISBACKUP_POLICY_ENABLED = "/check/groupPolicy/";
    private static final String UPLOAD_CHUNK_FILES = "/upload/file/chunks/";
    private static final String STORE_FILE_INEXTERNAL_STORAGE = "/upload/file/externalStorage/";
    private static final String CHUNK_FILE_DISK_FULL_EXCEPTION = "ChunkFile Disk Full  Exception ";
    private static final String CHUNK_FILE_USER_STORAGE_EXCEED_EXCEPTION = "ChunkFile User Limit Exceed ";
    private static final String PARACLOUD_GET_BACKUP_STATUS = "/get/backupstatus";
    private static final String PARACLOUD_GET_BACKUP_FILE_REVISIONS = "/backup/agent/files/version";
    private static final String BLUKRYPT_UPDATE_RESTART_ID = "/update/restartid";
    private static final String PARACLOUD_GET_BACKUP_POLICY = "/get/deviceBackupPolicy/";
    private static final String PARACLOUD_GET_CONTAINER_DETAILS = "/getContainer/";
    private static final Logger logger = LoggerFactory.getLogger(BackupAdapter.class);
    private HttpResponse response = null;
    private HttpPut httpPut = null;
    private HttpPost httpPost = null;
    MultipartEntity entity = null;
    private RestoreHelper restoreHelper = null;

    public BackupAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public FileListElement getListOfBackedUpFolders(String ip, Integer port, String token) throws Exception {
        HttpGet httpget = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        FileListElement listFileElement = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_BACKEDUP_FODLERS) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_BACKEDUP_FODLERS);
            httpget = new HttpGet(uri);
            httpget.setHeader("token", token);
            httpget.setHeader("backupIdEnabled", "true");
            httpget.setHeader("Content-Type", "text/xml");
            this.response = this.httpclient.execute((HttpUriRequest)httpget);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("ResponseCode: " + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                listFileElement = Xmlparser.parseFileListElementResponse(responseXmlAsString);
            }
        }
        catch (Exception ex) {
            logger.trace("" + ex);
            logger.error("Exception getting List Of BackedUp Folders" + ex.getMessage());
            throw new CrawlAdapterException(EXCEPTION, ex);
        }
        finally {
            this.closeResponseEntity();
        }
        return listFileElement;
    }

    public int downloadFile(String ip, Integer port, String token, FileElement fileElement, File downTempFile, String deviceUUID) throws Exception {
        logger.trace("Entering Download file");
        String filePath = null;
        InputStream in = null;
        boolean fileTransferSuccess = true;
        String md5ofDownloadedFile = "";
        HttpGet httpGet = null;
        String downloadFileUrl = "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_DOWNLOAD_FILE;
        logger.trace("downloadFileUrl: " + downloadFileUrl);
        try {
            filePath = fileElement.getFileCompletePath();
            URI uri = port != null ? this.formHttpsUri(ip, port, downloadFileUrl) : this.formHttpsUri(ip, downloadFileUrl);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("file-path", filePath);
            httpGet.setHeader("file-name", fileElement.getFileName());
            httpGet.setHeader("token", token);
            httpGet.setHeader("deviceUUID", deviceUUID);
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpclient.getParams(), (int)86400000);
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpclient.getParams(), (int)86400000);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(FILE_NOT_FOUND_EXCEPTION + e, e);
        }
        catch (IOException ex) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            logger.trace(DOWNLOAD_RESPONSE);
            this.closeResponseEntity();
            return 1;
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            logger.trace(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
            int responseStatusCode = this.response.getStatusLine().getStatusCode();
            this.closeResponseEntity();
            if (responseStatusCode == 507) {
                return 5;
            }
            if (responseStatusCode == 416) {
                return 1005;
            }
            if (this.response.getStatusLine().getStatusCode() == 420) {
                return 1009;
            }
            if (this.response.getStatusLine().getStatusCode() == 421) {
                return 1008;
            }
            return 2;
        }
        return this.parseResponseEntityAndDownloadFileToTempFolder(fileElement, downTempFile, in, fileTransferSuccess, md5ofDownloadedFile);
    }

    private int parseResponseEntityAndDownloadFileToTempFolder(FileElement fileElement, File downTempFile, InputStream in, boolean fileTransferSuccess, String md5ofDownloadedFile) {
        HttpEntity resEntity = this.response.getEntity();
        InputStream inTemp = in;
        try {
            inTemp = resEntity.getContent();
        }
        catch (Exception e) {
            this.closeResponseEntity();
            logger.error("FILE_DOWNLOAD_INTERNAL_ERROR:  " + e);
            return 3;
        }
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        fileTransferSuccessTemp = this.downloadFileFromServerUsingTheInputStream(inTemp, downTempFile, fileTransferSuccessTemp);
        this.closeResponseEntity();
        if (!fileTransferSuccessTemp) {
            return 3;
        }
        logger.trace("Generates md5 and check " + new Date().toString() + " " + downTempFile);
        String md5 = MD5Generator.generateMD5OfFile((File)downTempFile);
        if (!md5.equals(md5ofDownloadedFile)) {
            logger.trace("Md5 mis match " + md5);
            return 4;
        }
        fileElement.setMd5checksum(md5ofDownloadedFile);
        logger.trace("Generating md5 and checking done" + new Date().toString());
        return 4;
    }

    public FileListElement restoreFromSelectedDeviceToFolder(String ip, Integer port, String token, String deviceElementXml) throws Exception {
        int responseCode = 0;
        HttpEntity responseEntity = null;
        ByteArrayEntity httpEntity = null;
        String responseXmlAsString = null;
        FileListElement listFileElement = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_GET_FILE_LIST_FOR_DEVICE) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_GET_FILE_LIST_FOR_DEVICE);
            logger.trace(URL + uri);
            this.httpPost = new HttpPost(uri);
            this.httpPost.setHeader("token", token);
            this.httpPost.setHeader("Content-Type", "text/xml");
            httpEntity = new ByteArrayEntity(deviceElementXml.getBytes());
            this.httpPost.setEntity((HttpEntity)httpEntity);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug(" Response Code: " + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                listFileElement = Xmlparser.parseFileListElementResponse(responseXmlAsString);
            }
        }
        catch (Exception ex) {
            throw new CrawlAdapterException(EXCEPTION, ex);
        }
        finally {
            this.closeResponseEntity();
        }
        return listFileElement;
    }

    public FileListElement restoreFromSelectedFolderDeviceToFileElement(String ip, Integer port, String deviceid, String token, String deviceElementXml) throws Exception {
        HttpPost httpPost2 = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        ByteArrayEntity httpEntity = null;
        String responseXmlAsString = null;
        FileListElement listFolderFileElement = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_GET_FILE_LIST_FOR_FOLDER_DEVICE) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_GET_FILE_LIST_FOR_FOLDER_DEVICE);
            logger.trace(URL + uri);
            httpPost2 = new HttpPost(uri);
            httpPost2.setHeader("token", token);
            httpPost2.setHeader("Content-Type", "text/xml");
            httpPost2.setHeader("deviceUUID", deviceid);
            logger.trace(" Device Element   " + deviceElementXml);
            httpEntity = new ByteArrayEntity(deviceElementXml.getBytes());
            httpPost2.setEntity((HttpEntity)httpEntity);
            this.response = this.httpclient.execute((HttpUriRequest)httpPost2);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug(RESPONSE_CODE + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("Response xml for list folders. " + responseXmlAsString);
                listFolderFileElement = Xmlparser.parseFileListElementResponse(responseXmlAsString);
            }
        }
        catch (Exception ex) {
            throw new CrawlAdapterException(EXCEPTION, ex);
        }
        finally {
            this.closeResponseEntity();
        }
        return listFolderFileElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceTo> getAllRegisteredDevicesByUser(String ip, Integer port, String token) throws Exception {
        logger.debug("Inside device call url");
        List<DeviceTo> listDevices = new ArrayList<DeviceTo>();
        HttpGet httpGet = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_REGISTERED_DEVICES_BY_USER) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_REGISTERED_DEVICES_BY_USER);
            logger.trace(URL + uri);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("token", token);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug(RESPONSE_CODE + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                DeviceListElement listDeviceElement = Xmlparser.parseDeviceListResponse(responseXmlAsString);
                listDevices = ObjectUtils.convertToDeviceList(listDeviceElement);
            }
        }
        catch (Exception ex) {
            logger.trace("" + ex);
            logger.error("Exception getting device list by user :" + ex.getMessage());
            ArrayList<DeviceTo> arrayList = listDevices = null;
            return arrayList;
        }
        finally {
            this.closeResponseEntity();
        }
        return listDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceTo> getAllBasePathForRegisteredDevicesByUser(String ip, Integer port, String deviceId, String token, String folderPath) throws Exception {
        List<DeviceTo> listFolderDevices = new ArrayList<DeviceTo>();
        HttpGet httpGet = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_GET_BASE_PATH_FOR_SELECTED_DEVICE) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_GET_BASE_PATH_FOR_SELECTED_DEVICE);
            logger.trace(URL + uri + "token:" + token + "deviceID:" + deviceId);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("token", token);
            httpGet.setHeader("deviceId", deviceId);
            httpGet.setHeader("filePath", folderPath);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug(RESPONSE_CODE + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.trace("Response XML: " + responseXmlAsString);
                FolderDeviceListElement listFolderDeviceElement = Xmlparser.parseFolderDeviceListResponse(responseXmlAsString);
                listFolderDevices = ObjectUtils.convertToFolderDeviceList(listFolderDeviceElement);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.trace("Response Entity: " + ex);
            ArrayList<DeviceTo> arrayList = listFolderDevices;
            return arrayList;
        }
        finally {
            this.closeResponseEntity();
        }
        return listFolderDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceTo> getAllRevisionsForAFile(String ip, Integer port, String deviceId, String token, String folderPath, String fileName) throws Exception {
        List<DeviceTo> listFolderDevices = new ArrayList<DeviceTo>();
        HttpGet httpGet = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_GET_BACKUP_FILE_REVISIONS) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_GET_BACKUP_FILE_REVISIONS);
            logger.debug(URL + uri);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("token", token);
            httpGet.setHeader("deviceId", deviceId);
            httpGet.setHeader("filePath", folderPath);
            httpGet.setHeader("fileName", fileName);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("Response Code for versions: " + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("response :: " + responseXmlAsString);
                FolderDeviceListElement listFolderDeviceElement = Xmlparser.parseFolderDeviceListResponse(responseXmlAsString);
                listFolderDevices = ObjectUtils.convertToFolderDeviceList(listFolderDeviceElement);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.trace("Response Entity: " + ex);
            ArrayList<DeviceTo> arrayList = listFolderDevices;
            return arrayList;
        }
        finally {
            this.closeResponseEntity();
        }
        return listFolderDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendEmailNotification(String status, String ip, String token, String batchId, String jobType, String deviceName, int totalCount, int errorCode, String deviceUUID, long totalUploadSize, String totalUploadedCount, int crawlCount, String crawlTimeStamp) throws Exception {
        int responseCode = 0;
        String batchIdTemp = batchId;
        String count = Integer.toString(totalCount);
        String failCode = Integer.toString(errorCode);
        String uploadSize = Long.toString(totalUploadSize);
        logger.trace("IP:" + ip + "status:" + status + "count:" + count);
        logger.debug("total no of files:" + count);
        try {
            Header[] headerarr;
            URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_SEND_NOTIFICATION);
            logger.debug(URL + uri);
            this.httpPost = new HttpPost(uri);
            this.httpPost.setHeader("token", token);
            this.httpPost.setHeader("batchStatus", status);
            this.httpPost.setHeader("batchId", batchIdTemp);
            this.httpPost.setHeader("jobType", jobType);
            this.httpPost.setHeader("deviceName", deviceName);
            this.httpPost.setHeader("noOfFiles", count);
            this.httpPost.setHeader("errorCode", failCode);
            this.httpPost.setHeader("deviceUUID", deviceUUID);
            this.httpPost.setHeader("uploadedSize", uploadSize);
            this.httpPost.setHeader("uploadedFiles", totalUploadedCount);
            this.httpPost.setHeader("totalNoOfFiles", String.valueOf(crawlCount));
            this.httpPost.setHeader("crawlTimestamp", crawlTimeStamp);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            for (Header header : headerarr = this.response.getAllHeaders()) {
                if (!header.getName().equals("batchId")) continue;
                batchIdTemp = header.getValue();
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("Send email notification Response Code:" + responseCode + " batchID:" + batchIdTemp + " Status:" + status);
        }
        finally {
            this.closeResponseEntity();
        }
        return batchIdTemp;
    }

    public GroupPolicyElementList getGroupPolicyElement(String ip, String deviceName, String token, String deviceUUID, String userName, String serverBackupEnabled) throws CrawlAdapterException {
        HttpGet httpget = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        GroupPolicyElement groupPolicyElement = null;
        GroupPolicyElementList groupPolicyElementList = new GroupPolicyElementList();
        try {
            URI uri = "true".equalsIgnoreCase(serverBackupEnabled) ? this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_GET_BACKUP_POLICY) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/groupPolicy");
            logger.debug(URI + uri);
            httpget = new HttpGet(uri);
            httpget.setHeader("Content-Type", "text/xml");
            httpget.setHeader("deviceName", deviceName);
            httpget.setHeader("token", token);
            httpget.setHeader("deviceUUID", deviceUUID);
            httpget.setHeader("userName", userName);
            this.response = this.httpclient.execute((HttpUriRequest)httpget);
            responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("REsponse: " + responseXmlAsString);
                if ("true".equalsIgnoreCase(serverBackupEnabled)) {
                    groupPolicyElementList = Xmlparser.parseGroupPolicyElementListResponse(responseXmlAsString);
                } else {
                    groupPolicyElement = Xmlparser.parseGroupPolicyElementResponse(responseXmlAsString);
                    ArrayList<GroupPolicyElement> groupPolicyElements = new ArrayList<GroupPolicyElement>();
                    groupPolicyElements.add(groupPolicyElement);
                    groupPolicyElementList.setGroupPolicyElement(groupPolicyElements);
                }
            }
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + e, e);
        }
        catch (HttpHostConnectException e) {
            logger.error(HTTP_HOST_CONNECT_EXCEPTION + (Object)((Object)e));
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (UnknownHostException e) {
            logger.error(UNKNOWN_HOST_EXCEPTION + e);
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (Exception ex) {
            throw new CrawlAdapterException(EXCEPTION, ex);
        }
        finally {
            this.closeResponseEntity();
            if (httpget != null) {
                httpget.abort();
                httpget = null;
            }
        }
        logger.debug("Response Code " + responseCode);
        return groupPolicyElementList;
    }

    public GzipTO validateDeltaForBackUp(byte[] gzipReq, String ip, Integer port, boolean isFirstTime, String token) throws CrawlAdapterException {
        logger.trace(INTO_VALIDATE);
        GzipTO gzipResponse = null;
        this.response = null;
        HttpPost httppost = null;
        ByteArrayEntity httpEntity = null;
        int responseCode = 0;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_VALIDATION) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_VALIDATION);
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "text/xml");
            httppost.setHeader("Content-Encoding", "gzip");
            httppost.setHeader("complete-backup", String.valueOf(isFirstTime));
            httppost.setHeader("token", token);
            httpEntity = new ByteArrayEntity(gzipReq);
            httppost.setEntity((HttpEntity)httpEntity);
            logger.debug("Http Post gzip request>>>" + gzipReq);
            this.response = this.httpclient.execute((HttpUriRequest)httppost);
            if (this.response == null) {
                logger.error("Resonse for registration is null");
                throw new CrawlAdapterException(RESPONSE_NULL);
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("URL:" + uri.toString() + " Response " + responseCode);
            gzipResponse = this.downloadGzipResponseAsByteArray(responseCode);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            logger.trace("" + (Object)((Object)e));
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
        }
        catch (HttpHostConnectException e) {
            logger.error(HTTP_HOST_CONNECT_EXCEPTION + (Object)((Object)e));
        }
        catch (UnknownHostException e) {
            logger.error(UNKNOWN_HOST_EXCEPTION + e);
            logger.trace("" + e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
        }
        this.closeResponseEntity();
        return gzipResponse;
    }

    private GzipTO downloadGzipResponseAsByteArray(int responseCode) throws IOException {
        GzipTO crawlresponseObject = new GzipTO();
        if (responseCode == 200) {
            HttpEntity responseEntity = this.response.getEntity();
            if (responseEntity != null) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    IOUtils.copy((InputStream)responseEntity.getContent(), (OutputStream)outputStream);
                    logger.trace("Copying done");
                    crawlresponseObject.setResponse(outputStream.toByteArray());
                }
                catch (IOException e) {
                    throw new IOException("IOException occured", e);
                }
            }
        } else if (responseCode == 500 || responseCode == 400) {
            if (this.response.getStatusLine() != null) {
                logger.error(this.response.getStatusLine().getReasonPhrase());
            }
            if (this.response.getFirstHeader(ERR_MSG) != null) {
                logger.error(this.response.getFirstHeader(ERR_MSG).getValue());
            }
        }
        crawlresponseObject.setResponseCode(responseCode);
        return crawlresponseObject;
    }

    public void closeResponseEntity() {
        if (this.response != null && this.response.getEntity() != null && this.response.getEntity().isStreaming()) {
            try {
                if (this.response.getEntity().getContent() != null) {
                    this.response.getEntity().getContent().close();
                    EntityUtils.consume((HttpEntity)this.response.getEntity());
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    public int uploadBackUpFile(BackupTO fileTO, String ip, Integer port, String tempPath, String token) throws CrawlAdapterException {
        logger.trace(INTO_UPLOAD_FILE);
        this.response = null;
        File file = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_UPLOAD) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_UPLOAD);
            logger.debug(UPLOAD_URL + uri + "  MD5:" + fileTO.getMd5checksum() + "  TimeStamp:" + fileTO.getLastModifiedTimestamp());
            this.httpPut = new HttpPut(uri.toString());
            if (!fileTO.isFolder()) {
                file = new File(tempPath);
                this.setHeaderToHttpPutForFileUploadToBackUp(fileTO, file, token);
                this.httpPut.setEntity((HttpEntity)new FileEntity(file, "binary/octet-stream"));
            } else {
                this.setHeaderToHttpPutForFileUploadToBackUp(fileTO, null, token);
            }
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPut);
            logger.debug("uploaded; Response: " + this.response);
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(IO_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            this.closeResponseEntity();
            this.httpPut.abort();
            this.httpPut = null;
        }
        int responseValue = this.parseUploadResponse();
        this.closeResponseEntity();
        this.httpPut = null;
        return responseValue;
    }

    private void setHeaderToHttpPutForFileUploadToBackUp(BackupTO fileTO, File file, String token) {
        this.httpPut.setHeader("header-encoding", "base64");
        this.httpPut.setHeader("file-name", this.encodeUTFBase64(fileTO.getFileName()));
        this.httpPut.setHeader("file-path", this.encodeUTFBase64(fileTO.getAbstractFilePath()));
        this.httpPut.setHeader("meta-data", this.encodeUTFBase64(fileTO.getMetaData()));
        this.httpPut.setHeader("modified", String.valueOf(fileTO.getLastModifiedTimestamp()));
        this.httpPut.setHeader("is-folder", String.valueOf(fileTO.isFolder()));
        this.httpPut.setHeader("is-exists", String.valueOf(true));
        this.httpPut.setHeader("fileMD5", fileTO.getMd5checksum());
        this.httpPut.setHeader("token", token);
        this.httpPut.setHeader("is-base-folder", String.valueOf(fileTO.isBaseFolder()));
        if (file != null) {
            this.httpPut.setHeader("file-size", String.valueOf(file.length()));
        } else {
            this.httpPut.setHeader("file-size", "0");
        }
    }

    public void cancelHttpPut() {
        if (this.httpPut != null) {
            this.httpPut.abort();
            this.httpPut = null;
        }
    }

    private int parseUploadResponse() {
        int responseValue;
        if (this.response == null) {
            responseValue = 1;
        } else if (this.response.getStatusLine().getStatusCode() != 200) {
            logger.trace(this.response.getStatusLine().getReasonPhrase());
            logger.trace("response status code" + this.response.getStatusLine().getStatusCode());
            responseValue = 2;
            if (this.response.getStatusLine().getStatusCode() != 507 && this.response.getStatusLine().getStatusCode() != 419) {
                if (this.response.getStatusLine().getStatusCode() == 416) {
                    responseValue = 1005;
                } else if (this.response.getStatusLine().getStatusCode() == 420) {
                    responseValue = 1009;
                } else if (this.response.getStatusLine().getStatusCode() == 421) {
                    responseValue = 1008;
                } else if (this.response.getStatusLine().getStatusCode() == 449) {
                    responseValue = 1011;
                } else if (this.response.getStatusLine().getStatusCode() == 500) {
                    responseValue = 500;
                } else if (this.response.getStatusLine().getStatusCode() == 502) {
                    responseValue = 502;
                } else {
                    Header header = this.response.getFirstHeader(ERR_MSG);
                    if (header != null) {
                        logger.trace("ErrorMessage:" + header.getValue());
                    }
                }
            } else {
                responseValue = this.response.getStatusLine().getStatusCode() == 507 ? 1007 : 1006;
            }
        } else {
            responseValue = 3;
        }
        return responseValue;
    }

    public BackupCheckTO addFolderToBackup(String ip, Integer port, String backupElementXml, String token) {
        BackupCheckTO backupCheckTO;
        logger.trace("Entering : ParacloudAdapter.addFolderToBackup");
        URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_ADD_FOLDER) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_BACKUP_ADD_FOLDER);
        logger.trace("Current URL:" + uri + " BackupElementXml:" + backupElementXml);
        try {
            this.httpPost = new HttpPost(uri.toString());
            this.httpPost.setHeader("content-type", "application/xml");
            this.httpPost.setHeader("token", token);
            this.httpPost.setEntity((HttpEntity)new ByteArrayEntity(backupElementXml.getBytes("UTF-8")));
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            int responseCode = this.response.getStatusLine().getStatusCode();
            logger.trace("response: " + responseCode);
            String responseString = null;
            if (responseCode == 200 || responseCode == 201) {
                responseString = EntityUtils.toString((HttpEntity)this.response.getEntity());
                backupCheckTO = new BackupCheckTO(responseString, false, responseCode);
            } else if (responseCode == 409) {
                responseString = EntityUtils.toString((HttpEntity)this.response.getEntity());
                backupCheckTO = new BackupCheckTO(responseString, true, responseCode);
            } else {
                backupCheckTO = new BackupCheckTO(responseString, false, responseCode);
            }
        }
        catch (IOException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        this.closeResponseEntity();
        return backupCheckTO;
    }

    private boolean downloadFileFromServerUsingTheInputStream(InputStream in, File downloadTempFile, boolean fileTransferSuccess) {
        FileOutputStream out = null;
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        try {
            boolean result;
            out = new FileOutputStream(downloadTempFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            fileTransferSuccessTemp = result = this.downloadFileUsingInputStream(len, in, out, buffer, fileTransferSuccessTemp);
        }
        catch (FileNotFoundException e) {
            logger.error("Exception while reading inputstream while download", (Throwable)e);
            fileTransferSuccessTemp = false;
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                logger.error("Couldnt close inputStream ", (Throwable)e);
                logger.error(EXCEPTION + e);
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("Couldnt close inputStream " + e);
                logger.error(EXCEPTION + e);
            }
        }
        return fileTransferSuccessTemp;
    }

    private boolean downloadFileUsingInputStream(int len, InputStream in, OutputStream out, byte[] buffer, boolean fileTransferSuccess) {
        boolean fileTransferSuccessTemp = fileTransferSuccess;
        int lenTemp = len;
        try {
            int gcSize = 0;
            int gcThreshold = 0x100000;
            while ((lenTemp = in.read(buffer)) > 0) {
                out.write(buffer, 0, lenTemp);
                if ((gcSize += lenTemp) <= gcThreshold) continue;
                gcSize = 0;
            }
        }
        catch (IOException e) {
            logger.error("Exception while reading inputstream while download", (Throwable)e);
            fileTransferSuccessTemp = false;
        }
        return fileTransferSuccessTemp;
    }

    public boolean isBackupPolicyLatest(String ip, String deviceUUID, String lastModifiedTime, String token, String userName, String productVersion) {
        logger.debug("Entering : CheckBackupPolicy version");
        int port = 0;
        URI uri = port > 0 ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_CHECK_BACKUP_POLICY_VERSION) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_CHECK_BACKUP_POLICY_VERSION);
        logger.debug("current uri:" + uri + " Modified time:" + lastModifiedTime);
        try {
            HttpGet httpGet = new HttpGet(uri.toString());
            httpGet.setHeader("content-type", "application/xml");
            httpGet.setHeader("deviceUUID", deviceUUID);
            httpGet.setHeader("lastModifiedTime", lastModifiedTime);
            httpGet.setHeader("token", token);
            httpGet.setHeader("userName", userName);
            httpGet.setHeader("productVersion", productVersion);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            int responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                for (Header header : this.response.getAllHeaders()) {
                    if (!"isLatestVersion".equalsIgnoreCase(header.getName())) continue;
                    boolean isLatestVersion = Boolean.parseBoolean(header.getValue());
                    logger.debug("Policy latest: " + isLatestVersion);
                    this.closeResponseEntity();
                    return isLatestVersion;
                }
            }
            logger.debug("Response for policy latest: " + responseCode);
        }
        catch (ClientProtocolException e) {
            logger.debug("exception case from refresh policy >> client protocol exception...." + e.getMessage());
            logger.error(CLIENT_PROTOCOL_EXCEPTION);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.debug("exception case from refresh policy..>>>>> filenot found exception.." + e.getMessage());
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.debug("exception case from refresh policy..>>>> IoException.." + e.getMessage());
            logger.error(IO_EXCEPTION);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        this.closeResponseEntity();
        logger.debug("returning true..........");
        return true;
    }

    public String isBackupPolicyEnabled(String ip, String userName, String deviceUUID) {
        String isBackupPolicyEnabled = "false";
        int port = 0;
        URI uri = port > 0 ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_CHECK_ISBACKUP_POLICY_ENABLED + userName + "/") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_CHECK_ISBACKUP_POLICY_ENABLED + userName + "/");
        logger.debug("current uri: " + uri);
        try {
            HttpGet httpGet = new HttpGet(uri.toString());
            httpGet.setHeader("content-type", "application/xml");
            httpGet.setHeader("userName", userName);
            httpGet.setHeader("deviceUUID", deviceUUID);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            int responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                isBackupPolicyEnabled = "true";
                logger.trace("isbackuppolicy enabled:" + isBackupPolicyEnabled + "&&&&&&&&&&& response: " + responseCode);
                this.closeResponseEntity();
                return isBackupPolicyEnabled;
            }
            logger.debug("Response: " + responseCode);
        }
        catch (IOException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e);
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        this.closeResponseEntity();
        return isBackupPolicyEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextChunkValue(BackupTO fileTO, String ip, Integer port, String cloudName, String token, ChunkFileElement chunkFileElement, String osName, String deviceUUID, String userName, String backupId, boolean viaGateway, String prevGatewayName, int maxVersionsToKeep, String batchIdForBackup, String legalHoldEnabled) throws CrawlAdapterException {
        Header[] headerarr;
        UploadChunkFileException uploadChunkFileException;
        this.response = null;
        File file = null;
        int responseCode = 0;
        String fileChunks = StringUtils.join(chunkFileElement.getFileChunks(), (char)',');
        try {
            URI uri = viaGateway ? (port != null ? this.formHttpsUri(ip, port, "/BluKryptBuilder/upload/file/chunks/") : this.formHttpsUri(ip, "/BluKryptBuilder/upload/file/chunks/")) : (port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/files/chunk") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/files/chunk"));
            file = new File(chunkFileElement.getFileCompletePath());
            this.httpPost = new HttpPost(uri.toString());
            logger.debug("URI:" + uri);
            this.entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            this.entity.addPart("file", (ContentBody)new FileBody(file));
            this.entity.addPart("fileChunkNames", (ContentBody)new StringBody(fileChunks));
            this.entity.addPart("token", (ContentBody)new StringBody(token));
            this.entity.addPart("checkSum", (ContentBody)new StringBody(chunkFileElement.getChecksum()));
            this.entity.addPart("fileName", (ContentBody)new StringBody(chunkFileElement.getFileName()));
            this.entity.addPart("fileCompletePath", (ContentBody)new StringBody(chunkFileElement.getFileName()));
            this.entity.addPart("deviceUUID", (ContentBody)new StringBody(chunkFileElement.getDeviceUUID()));
            this.entity.addPart("osType", (ContentBody)new StringBody(osName));
            this.entity.addPart("userName", (ContentBody)new StringBody(userName));
            this.entity.addPart("cloudName", (ContentBody)new StringBody(cloudName));
            this.entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            this.entity.addPart("maxVersions", (ContentBody)new StringBody(String.valueOf(maxVersionsToKeep)));
            if (viaGateway) {
                this.entity.addPart("prevGatewayName", (ContentBody)new StringBody(prevGatewayName));
                this.entity.addPart("gatewayName", (ContentBody)new StringBody(ip));
                this.entity.addPart("deviceUUID", (ContentBody)new StringBody(deviceUUID));
                this.entity.addPart("originalFileName", (ContentBody)new StringBody(fileTO.getFileName()));
                this.entity.addPart("file-name", (ContentBody)new StringBody(fileTO.getFileName()));
                this.entity.addPart("file-path", (ContentBody)new StringBody(fileTO.getAbstractFilePath()));
                this.entity.addPart("is-base-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isBaseFolder())));
                this.entity.addPart("is-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isFolder())));
                this.entity.addPart("is-exists", (ContentBody)new StringBody(String.valueOf(true)));
                this.entity.addPart("modified", (ContentBody)new StringBody(String.valueOf(fileTO.getLastModifiedTimestamp())));
                this.entity.addPart("fileMD5", (ContentBody)new StringBody(String.valueOf(fileTO.getMd5checksum())));
                this.entity.addPart("batchIdForBackup", (ContentBody)new StringBody(batchIdForBackup));
                this.entity.addPart("userUnderLegalHold", (ContentBody)new StringBody(legalHoldEnabled));
            }
            this.entity.addPart("file-size", (ContentBody)new StringBody(String.valueOf(fileTO.getFileSize())));
            this.entity.addPart("fileSize", (ContentBody)new StringBody(String.valueOf(file.length())));
            this.httpPost.setEntity((HttpEntity)this.entity);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            logger.trace("Response code:" + this.response.getStatusLine().getStatusCode());
            responseCode = this.response.getStatusLine().getStatusCode();
        }
        catch (ClientProtocolException e) {
            logger.error(INSIDE_CATCH_BLOCK);
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (IOException e) {
            logger.error(INSIDE_CATCH_BLOCK);
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (RuntimeException e) {
            logger.trace("" + e);
            logger.error("Runtime exception :" + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("General exception in upload chunk:", (Object)e.getMessage());
        }
        finally {
            this.httpPost.abort();
            this.closeResponseEntity();
            this.httpPost = null;
        }
        this.closeResponseEntity();
        if (responseCode == 507) {
            uploadChunkFileException = new UploadChunkFileException(CHUNK_FILE_DISK_FULL_EXCEPTION);
            uploadChunkFileException.setErrorStatus(507);
            throw uploadChunkFileException;
        }
        if (responseCode == 449) {
            uploadChunkFileException = new UploadChunkFileException(CHUNK_FILE_USER_STORAGE_EXCEED_EXCEPTION);
            uploadChunkFileException.setErrorStatus(1011);
            throw uploadChunkFileException;
        }
        if (responseCode == 502) {
            uploadChunkFileException = new UploadChunkFileException(CHUNK_FILE_USER_STORAGE_EXCEED_EXCEPTION);
            uploadChunkFileException.setErrorStatus(502);
            throw uploadChunkFileException;
        }
        this.httpPost = null;
        String nextChunkValue = "";
        for (Header header : headerarr = this.response.getAllHeaders()) {
            if (!"nextChunk".equals(header.getName())) continue;
            nextChunkValue = header.getValue();
            return nextChunkValue;
        }
        logger.debug("Response is empty:Response code:" + this.response.getStatusLine().getStatusCode());
        return nextChunkValue;
    }

    private void setChunkElementValuesToHttpHeader(ChunkFileElement chunkFileElement) {
        String fileChunks = StringUtils.join(chunkFileElement.getFileChunks(), (String)",");
        try {
            this.entity.addPart("checkSum", (ContentBody)new StringBody(chunkFileElement.getChecksum()));
            this.entity.addPart("fileChunkNames", (ContentBody)new StringBody(fileChunks));
            this.entity.addPart("fileName", (ContentBody)new StringBody(chunkFileElement.getFileName()));
            this.entity.addPart("fileCompletePath", (ContentBody)new StringBody(chunkFileElement.getFileCompletePath()));
            this.entity.addPart("deviceUUID", (ContentBody)new StringBody(chunkFileElement.getDeviceUUID()));
            this.entity.addPart("Content-Type", (ContentBody)new StringBody("text/xml"));
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("Exception setting Element Values To HTTP Header :" + e.getMessage());
        }
    }

    public static int compressString(String data, byte[] output, int len) {
        Deflater deflater = new Deflater();
        deflater.setInput(data.getBytes(Charset.forName("utf-8")));
        deflater.finish();
        return deflater.deflate(output, 0, len);
    }

    public int uploadFileUsingGateway(BackupTO fileTO, String ip, Integer port, String tempPath, String cloudName, String token, String userName, String deviceUUID, String osName, String prevGatewayName, String fileDedup, int maxVersionsToKeep, String batchIdForBackup, String legalHoldEnabled) throws CrawlAdapterException {
        logger.trace(INTO_UPLOAD_FILE);
        this.response = null;
        File file = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/BluKryptBuilder/upload/file/") : this.formHttpsUri(ip, "/BluKryptBuilder/upload/file/");
            logger.debug(UPLOAD_URL + uri + " File:" + fileTO.getClientData());
            this.httpPost = new HttpPost(uri.toString());
            this.entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (!fileTO.isFolder()) {
                file = new File(tempPath);
                try (FileInputStream fs = new FileInputStream(file);){
                    this.entity.addPart("gatewayName", (ContentBody)new StringBody(ip));
                    this.entity.addPart("cloudName", (ContentBody)new StringBody(cloudName));
                    this.entity.addPart("userName", (ContentBody)new StringBody(userName));
                    this.entity.addPart("deviceUUID", (ContentBody)new StringBody(deviceUUID));
                    this.entity.addPart("osType", (ContentBody)new StringBody(osName));
                    this.entity.addPart("file-path", (ContentBody)new StringBody(fileTO.getAbstractFilePath()));
                    this.entity.addPart("file-name", (ContentBody)new StringBody(fileTO.getFileName()));
                    this.entity.addPart("prevGatewayName", (ContentBody)new StringBody(prevGatewayName));
                    this.entity.addPart("file", (ContentBody)new InputStreamBody((InputStream)fs, file.getName()));
                    this.entity.addPart("file-size", (ContentBody)new StringBody(String.valueOf(file.length())));
                }
            }
            this.entity.addPart("osType", (ContentBody)new StringBody(osName));
            this.entity.addPart("userName", (ContentBody)new StringBody(userName));
            this.entity.addPart("deviceUUID", (ContentBody)new StringBody(deviceUUID));
            this.entity.addPart("file-path", (ContentBody)new StringBody(fileTO.getAbstractFilePath()));
            this.entity.addPart("file-name", (ContentBody)new StringBody(fileTO.getFileName()));
            this.entity.addPart("cloudName", (ContentBody)new StringBody(cloudName));
            this.entity.addPart("token", (ContentBody)new StringBody(token));
            this.entity.addPart("prevGatewayName", (ContentBody)new StringBody(prevGatewayName));
            this.entity.addPart("gatewayName", (ContentBody)new StringBody(ip));
            this.entity.addPart("fileMD5", (ContentBody)new StringBody(fileTO.getMd5checksum()));
            this.entity.addPart("dedupifiedBackupId", (ContentBody)new StringBody(fileDedup));
            this.entity.addPart("maxVersions", (ContentBody)new StringBody(String.valueOf(maxVersionsToKeep)));
            logger.debug("MAX versions to keep: " + maxVersionsToKeep + " Batch id for backup:" + batchIdForBackup);
            this.entity.addPart("is-base-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isBaseFolder())));
            this.entity.addPart("is-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isFolder())));
            this.entity.addPart("is-exists", (ContentBody)new StringBody(String.valueOf(true)));
            this.entity.addPart("fileMD5", (ContentBody)new StringBody(fileTO.getMd5checksum()));
            this.entity.addPart("token", (ContentBody)new StringBody(token));
            this.entity.addPart("modified", (ContentBody)new StringBody(String.valueOf(fileTO.getLastModifiedTimestamp())));
            this.entity.addPart("batchIdForBackup", (ContentBody)new StringBody(batchIdForBackup));
            this.entity.addPart("userUnderLegalHold", (ContentBody)new StringBody(legalHoldEnabled));
            this.httpPost.setEntity((HttpEntity)this.entity);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            logger.debug("uploaded; response: " + this.response.getStatusLine().getStatusCode());
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(IO_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            this.httpPost.abort();
            this.closeResponseEntity();
            this.httpPost = null;
        }
        int responseValue = this.parseUploadResponse();
        this.closeResponseEntity();
        this.httpPost = null;
        return responseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pingGatewayIP(String gatewayIP) {
        int responseValue = 0;
        URI uri = this.formHttpsUri(gatewayIP, "/BluKryptBuilder/ping/");
        HttpGet httpGet = new HttpGet(uri.toString());
        try {
            logger.debug("URL:" + uri);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error("ClientProtocolException" + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            this.closeResponseEntity();
            httpGet = null;
            int n = responseValue;
            return n;
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
            this.closeResponseEntity();
            httpGet = null;
            int n = responseValue;
            return n;
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.trace("" + e);
            this.closeResponseEntity();
            httpGet = null;
            int n = responseValue;
            return n;
        }
        finally {
            logger.debug("INSIDE FINALLY IN PING GATEWAY");
            if (httpGet != null) {
                httpGet.abort();
                httpGet = null;
            }
            this.closeResponseEntity();
        }
        responseValue = this.response.getStatusLine().getStatusCode();
        logger.debug("PING RESPONSE FOR GATEWAY IS " + responseValue);
        this.closeResponseEntity();
        httpGet = null;
        return responseValue;
    }

    public int storeFileInExternalStorage(BackupTO fileTO, String ip, Integer port, String cloudName, String token, ChunkFileElement chunkFileElement, String osName, String deviceUUID, String backupId, String userName, boolean viaGateway, String prevBackupId, String prevGatewayName, int maxVersionsToKeep) throws CrawlAdapterException {
        logger.trace(INTO_UPLOAD_FILE);
        this.response = null;
        File file = null;
        String fileChunks = StringUtils.join(chunkFileElement.getFileChunks(), (String)",");
        try {
            URI uri = viaGateway ? (port != null ? this.formHttpsUri(ip, port, "/BluKryptBuilder/upload/file/externalStorage/") : this.formHttpsUri(ip, "/BluKryptBuilder/upload/file/externalStorage/")) : (port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/files/chunk/all") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/files/chunk/all"));
            logger.debug(UPLOAD_URL + uri);
            this.httpPost = new HttpPost(uri.toString());
            file = new File(fileTO.getClientData());
            this.entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            this.entity.addPart("modified", (ContentBody)new StringBody(String.valueOf(fileTO.getLastModifiedTimestamp())));
            this.entity.addPart("fileChunkNames", (ContentBody)new StringBody(fileChunks));
            this.setChunkElementValuesToHttpHeader(chunkFileElement);
            this.entity.addPart("osType", (ContentBody)new StringBody(osName));
            this.entity.addPart("userName", (ContentBody)new StringBody(userName));
            this.entity.addPart("deviceUUID", (ContentBody)new StringBody(deviceUUID));
            this.entity.addPart("file-path", (ContentBody)new StringBody(fileTO.getAbstractFilePath()));
            this.entity.addPart("file-name", (ContentBody)new StringBody(fileTO.getFileName()));
            this.entity.addPart("is-base-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isBaseFolder())));
            this.entity.addPart("is-folder", (ContentBody)new StringBody(String.valueOf(fileTO.isFolder())));
            this.entity.addPart("is-exists", (ContentBody)new StringBody(String.valueOf(true)));
            this.entity.addPart("cloudName", (ContentBody)new StringBody(cloudName));
            this.entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            this.entity.addPart("prevBackupId", (ContentBody)new StringBody(prevBackupId));
            if (viaGateway) {
                this.entity.addPart("prevGatewayName", (ContentBody)new StringBody(prevGatewayName));
                this.entity.addPart("gatewayName", (ContentBody)new StringBody(ip));
                this.entity.addPart("maxVersions", (ContentBody)new StringBody(String.valueOf(maxVersionsToKeep)));
            }
            this.entity.addPart("token", (ContentBody)new StringBody(token));
            this.entity.addPart("file-size", (ContentBody)new StringBody(String.valueOf(file.length())));
            this.entity.addPart("fileMD5", (ContentBody)new StringBody(fileTO.getMd5checksum()));
            this.httpPost.setEntity((HttpEntity)this.entity);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
        }
        catch (ClientProtocolException e) {
            logger.debug(INSIDE_CATCH_BLOCK);
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            logger.debug(INSIDE_CATCH_BLOCK);
            this.closeResponseEntity();
            throw new CrawlAdapterException(IO_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.debug(INSIDE_CATCH_BLOCK);
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        this.closeResponseEntity();
        int responseValue = this.response.getStatusLine().getStatusCode();
        logger.debug("merge file esponse: " + responseValue);
        return responseValue;
    }

    public int downloadFileViaGateway(String ip, Integer port, String token, FileElement fileElement, File downTempFile, String deviceUUID, String userName, String cloudname) throws Exception {
        logger.trace("Entering : PrivacyGateway.downloadFile");
        String filePath = null;
        InputStream in = null;
        boolean fileTransferSuccess = true;
        String md5ofDownloadedFile = "";
        HttpGet httpGet = null;
        try {
            filePath = fileElement.getFileCompletePath();
            URI uri = port != null ? this.formHttpsUri(ip, port, "/BluKryptBuilder/download/file/") : this.formHttpsUri(ip, "/BluKryptBuilder/download/file/");
            logger.debug("downloadFileUrl: " + uri);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("gatewayName", ip);
            httpGet.setHeader("file-path", filePath);
            httpGet.setHeader("file-name", fileElement.getFileName());
            httpGet.setHeader("token", token);
            httpGet.setHeader("deviceUUID", deviceUUID);
            httpGet.setHeader("userName", userName);
            httpGet.setHeader("cloudName", cloudname);
            httpGet.setHeader("backupId", fileElement.getBackupId());
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpclient.getParams(), (int)86400000);
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpclient.getParams(), (int)86400000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)this.httpclient.getParams(), (int)1000);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(FILE_NOT_FOUND_EXCEPTION + e, e);
        }
        catch (IOException ex) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            logger.debug(DOWNLOAD_RESPONSE);
            this.closeResponseEntity();
            return 1;
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            logger.debug(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
            int responseStatusCode = this.response.getStatusLine().getStatusCode();
            this.closeResponseEntity();
            if (responseStatusCode == 507) {
                return 5;
            }
            if (responseStatusCode == 416) {
                return 1005;
            }
            if (this.response.getStatusLine().getStatusCode() == 420) {
                return 1009;
            }
            if (this.response.getStatusLine().getStatusCode() == 421) {
                return 1008;
            }
            if (this.response.getStatusLine().getStatusCode() == 204) {
                return 204;
            }
            return 2;
        }
        return this.parseResponseEntityAndDownloadFileToTempFolder(fileElement, downTempFile, in, fileTransferSuccess, md5ofDownloadedFile);
    }

    public String uploadExternalBackUpFile(BackupTO fileTO, String ip, Integer port, String tempPath, String token) throws CrawlAdapterException {
        logger.trace(INTO_UPLOAD_FILE);
        this.response = null;
        File file = null;
        String backupId = null;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_EXTERNAL_BACKUP_UPLOAD) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_EXTERNAL_BACKUP_UPLOAD);
            logger.trace(UPLOAD_URL + uri + " MD5:" + fileTO.getMd5checksum() + " TimeStamp" + fileTO.getLastModifiedTimestamp());
            this.httpPut = new HttpPut(uri.toString());
            if (!fileTO.isFolder()) {
                file = new File(tempPath);
                this.setHeaderToHttpPutForFileUploadToBackUp(fileTO, file, token);
                this.httpPut.setEntity((HttpEntity)new FileEntity(file, "binary/octet-stream"));
            } else {
                this.setHeaderToHttpPutForFileUploadToBackUp(fileTO, null, token);
            }
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPut);
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(IO_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        if (this.response.getStatusLine().getStatusCode() == 200) {
            backupId = this.response.getFirstHeader("backupId").getValue();
            logger.debug("The response for put entry in portal is" + backupId);
        }
        this.closeResponseEntity();
        this.httpPut = null;
        return backupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupElement getBackupId(String ip, String deviceUUID, BackupTO fileTo, String token, String batchIdForBackup) {
        int responseValue = 0;
        String backupId = "";
        String responseXmlAsString = null;
        BackupElement backupElement = null;
        HttpEntity responseEntity = null;
        URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/files/chunk/");
        HttpGet httpGet = new HttpGet(uri.toString());
        logger.debug("URL:" + uri);
        httpGet.setHeader("fileName", fileTo.getFileName());
        httpGet.setHeader("filePath", fileTo.getAbstractFilePath());
        httpGet.setHeader("token", token);
        httpGet.setHeader("deviceUUID", deviceUUID);
        httpGet.setHeader("batchIdForBackup", batchIdForBackup);
        try {
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            responseValue = this.response.getStatusLine().getStatusCode();
            if (responseValue == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                backupId = this.response.getFirstHeader("backupId").getValue();
                backupElement = Xmlparser.parseBackupElementResponse(responseXmlAsString);
                backupElement.setBackupId(backupId);
                logger.debug("Response for get backupID and element is:" + responseValue + backupId + ":backupidElement is>>" + backupElement.getChunkFiles().size());
            }
            logger.debug("Response for get backupID and element is:" + responseValue + backupId + ":backupid");
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception getting Backup ID :" + e.getMessage());
        }
        finally {
            this.closeResponseEntity();
            httpGet.abort();
            httpGet = null;
        }
        this.closeResponseEntity();
        httpGet = null;
        return backupElement;
    }

    public int getDecoupleResponse(String ip, String deviceUUID, String token) {
        URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/device/" + deviceUUID + "/decoupled/");
        this.httpPost = new HttpPost(uri.toString());
        logger.debug("URL:" + uri);
        this.httpPost.setHeader("token", token);
        try {
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception getting decouple Response :" + e.getMessage());
        }
        int responseValue = this.response.getStatusLine().getStatusCode();
        logger.debug("Response for Decouple Machine " + responseValue);
        this.closeResponseEntity();
        return responseValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkFileDedup(String ip, String md5, String token) {
        String fileDedupFlag = "";
        URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_CHECK_DEDUP);
        HttpGet httpGet = new HttpGet(uri.toString());
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpclient.getParams(), (int)900000);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpclient.getParams(), (int)900000);
        logger.debug("URL:" + uri);
        httpGet.setHeader("token", token);
        httpGet.setHeader("md5checksum", md5);
        try {
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error("client protocol exception", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
        finally {
            httpGet.abort();
            httpGet = null;
            this.closeResponseEntity();
        }
        int responseValue = this.response.getStatusLine().getStatusCode();
        if (responseValue == 200) {
            fileDedupFlag = this.response.getFirstHeader("dedupifiedBackupId").getValue();
        }
        this.closeResponseEntity();
        httpGet = null;
        return fileDedupFlag;
    }

    public void sendBackupStatistics(byte[] gzipReq, String ip, Integer port, boolean isFirstTime, String token) throws CrawlAdapterException {
        logger.trace(INTO_VALIDATE);
        this.response = null;
        HttpPost httppost = null;
        ByteArrayEntity httpEntity = null;
        int responseCode = 0;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_SEND_BACKUP_STATISTICS) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_SEND_BACKUP_STATISTICS);
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "text/xml");
            httppost.setHeader("Content-Encoding", "gzip");
            httppost.setHeader("complete-backup", String.valueOf(isFirstTime));
            httppost.setHeader("firstCrawl", String.valueOf(isFirstTime));
            httppost.setHeader("token", token);
            httpEntity = new ByteArrayEntity(gzipReq);
            httppost.setEntity((HttpEntity)httpEntity);
            this.response = this.httpclient.execute((HttpUriRequest)httppost);
            if (this.response == null) {
                logger.error("Resonse for registration is null");
                throw new CrawlAdapterException(RESPONSE_NULL);
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("uri:" + uri.toString() + "response for send statistics:" + responseCode);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            logger.trace("" + (Object)((Object)e));
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
        }
        catch (HttpHostConnectException e) {
            logger.error(HTTP_HOST_CONNECT_EXCEPTION + (Object)((Object)e));
        }
        catch (UnknownHostException e) {
            logger.error(UNKNOWN_HOST_EXCEPTION + e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
        }
        this.closeResponseEntity();
    }

    public void sendBackupFileStatistics(String xmlForBackupStat, String ip, Integer port, String userName, String token) throws CrawlAdapterException {
        logger.trace(INTO_VALIDATE);
        this.response = null;
        HttpPost httppost = null;
        ByteArrayEntity httpEntity = null;
        int responseCode = 0;
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + PARACLOUD_SEND_BACKUP_FILE_STATISTICS) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_SEND_BACKUP_FILE_STATISTICS);
            httppost = new HttpPost(uri);
            httppost.setHeader("Content-Type", "text/xml");
            httppost.setHeader("userName", userName);
            httppost.setHeader("token", token);
            httpEntity = new ByteArrayEntity(xmlForBackupStat.getBytes());
            httppost.setEntity((HttpEntity)httpEntity);
            this.response = this.httpclient.execute((HttpUriRequest)httppost);
            if (this.response == null) {
                logger.error("Resonse for send stat for backup file is null");
                throw new CrawlAdapterException(RESPONSE_NULL);
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("URL:" + uri.toString() + "Response for send backup file statistics:" + responseCode);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + e.getMessage());
            logger.trace("" + (Object)((Object)e));
        }
        catch (NoRouteToHostException e) {
            logger.error(NO_ROUTE_TO_HOST_EXCEPTION + e);
        }
        catch (HttpHostConnectException e) {
            logger.error(HTTP_HOST_CONNECT_EXCEPTION + (Object)((Object)e));
        }
        catch (UnknownHostException e) {
            logger.error(UNKNOWN_HOST_EXCEPTION + e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            logger.trace("" + e);
        }
        this.closeResponseEntity();
    }

    public int pingParacloud(String ip) {
        int responseValue = 0;
        URI uri = this.formHttpsUri(ip, "/paracloud/ping/");
        HttpGet httpGet = new HttpGet(uri.toString());
        try {
            logger.debug("the uri is:" + uri);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error("ClientProtocolException" + e.getMessage());
            logger.trace("" + (Object)((Object)e));
            this.closeResponseEntity();
            return responseValue;
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            return responseValue;
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.trace("" + e);
            this.closeResponseEntity();
            return responseValue;
        }
        responseValue = this.response.getStatusLine().getStatusCode();
        logger.debug("The ping response for paracloud is:" + responseValue);
        this.closeResponseEntity();
        return responseValue;
    }

    public BackupStatusElement getBackupStatus(String ip, String token, String jobType, String deviceName, String deviceUUID, String userName) throws CrawlAdapterException {
        HttpGet httpGet = null;
        int responseCode = 0;
        String responseXmlAsString = null;
        BackupStatusElement backupStatusElement = null;
        HttpEntity responseEntity = null;
        String batchId = "";
        try {
            Header[] headerarr;
            URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_GET_BACKUP_STATUS);
            logger.debug("URL:" + uri);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("token", token);
            httpGet.setHeader("jobType", jobType);
            httpGet.setHeader("deviceName", deviceName);
            httpGet.setHeader("userName", userName);
            httpGet.setHeader("deviceUUID", deviceUUID);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            for (Header header : headerarr = this.response.getAllHeaders()) {
                if (!header.getName().equals("batchId")) continue;
                batchId = header.getValue();
            }
            responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("Response:" + responseXmlAsString);
                backupStatusElement = Xmlparser.parseBackupStatusElementResponse(responseXmlAsString);
                backupStatusElement.setBatchId(batchId);
                backupStatusElement.setResponseCode(responseCode);
            } else {
                backupStatusElement = new BackupStatusElement();
                backupStatusElement.setBatchId(batchId);
                backupStatusElement.setResponseCode(responseCode);
            }
            logger.debug("get backup status responseCode: " + responseCode + " batchID:" + batchId);
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(IO_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            if (httpGet != null) {
                httpGet.abort();
                httpGet = null;
            }
            this.closeResponseEntity();
        }
        return backupStatusElement;
    }

    public int downloadFileViaGateway1(String ip, Integer port, String token, String cloudname, RestoreElement restoreElement) throws Exception {
        logger.trace("Entering : PrivacyGateway.downloadFile");
        String filePath = null;
        InputStream in = null;
        HttpGet httpGet = null;
        String userName = restoreElement.getFileUserOwner();
        String destinationFolder = restoreElement.getDestinationPath();
        String devicePath = restoreElement.getDevicePath();
        String fileNameToDownload = restoreElement.getFileName();
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/BluKryptBuilder/download/files/") : this.formHttpsUri(ip, "/BluKryptBuilder/download/files/");
            logger.debug("Download File URL: " + uri + " Username:" + userName + " FilePath:" + devicePath + " FileName:" + fileNameToDownload);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("gatewayName", ip);
            httpGet.setHeader("file-path", filePath);
            httpGet.setHeader("token", token);
            httpGet.setHeader("deviceUUID", restoreElement.getDeviceUUid());
            httpGet.setHeader("userName", userName);
            httpGet.setHeader("cloudName", cloudname);
            httpGet.setHeader("restoreBatchId", restoreElement.getRestoreBatchId());
            httpGet.setHeader("devicePath", devicePath);
            httpGet.setHeader("fileName", fileNameToDownload);
            httpGet.setHeader("downloadAllVersions", String.valueOf(restoreElement.isRestoreAllVersions()));
            httpGet.setHeader("backupId", restoreElement.getFileBackupId());
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpclient.getParams(), (int)86400000);
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpclient.getParams(), (int)86400000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)this.httpclient.getParams(), (int)1000);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (ClientProtocolException e) {
            logger.error(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e));
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(FILE_NOT_FOUND_EXCEPTION + e, e);
        }
        catch (IOException ex) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(ex.getMessage(), ex);
        }
        if (this.response == null) {
            logger.debug(DOWNLOAD_RESPONSE);
            this.closeResponseEntity();
            return 1;
        }
        if (this.response.getStatusLine().getStatusCode() != 200) {
            logger.debug(DOWNLOAD_RESPONSE_CODE + this.response.getStatusLine().getStatusCode());
            int responseStatusCode = this.response.getStatusLine().getStatusCode();
            this.closeResponseEntity();
            if (responseStatusCode == 507) {
                return 5;
            }
            if (responseStatusCode == 416) {
                return 1005;
            }
            if (this.response.getStatusLine().getStatusCode() == 420) {
                return 1009;
            }
            if (this.response.getStatusLine().getStatusCode() == 421) {
                return 1008;
            }
            if (this.response.getStatusLine().getStatusCode() == 204) {
                return 204;
            }
            return 2;
        }
        return this.parseResponseEntityAndDownloadFileToTempFolder1(destinationFolder, in, restoreElement);
    }

    private int parseResponseEntityAndDownloadFileToTempFolder1(String destinationPath, InputStream in, RestoreElement restoreElement) {
        String boundary = "--PARABLUEOF";
        InputStream inTemp = in;
        byte[] bryBytes = boundary.getBytes();
        HttpEntity resEntity = this.response.getEntity();
        logger.debug("response entity:" + resEntity);
        String fs = StringLiterals.FILE_SEPARATOR;
        int responseCode = 4;
        String devicePath = restoreElement.getDevicePath();
        String fileNameToDownload = restoreElement.getFileName();
        try {
            inTemp = resEntity.getContent();
            logger.debug("content of the response entity:" + inTemp);
        }
        catch (Exception e) {
            this.closeResponseEntity();
            logger.error("FILE_DOWNLOAD_INTERNAL_ERROR:  " + e);
            return 3;
        }
        try {
            MultipartStream multipartStream = new MultipartStream(inTemp, bryBytes);
            boolean nextPart = multipartStream.skipPreamble();
            int i = 1;
            while (nextPart) {
                File restorePath;
                String header = multipartStream.readHeaders();
                logger.debug(header + " header : " + i++);
                Map<String, String> headerMap = BackupAdapter.parseHeader(header);
                String fileName = headerMap.get("fileName");
                String filePath = headerMap.get("filePath");
                String md5ofDownloadedFileTemp = headerMap.get("md5Checksum");
                String modifiedTimeStamp = headerMap.get("clientModifiedTime");
                fileName = fileName.replaceAll(NEW_LINE_CHAR, "");
                filePath = filePath.replaceAll(NEW_LINE_CHAR, "");
                md5ofDownloadedFileTemp = md5ofDownloadedFileTemp.replaceAll(NEW_LINE_CHAR, "");
                String restoreCount = headerMap.get("count");
                long modifiedTime = 0L;
                modifiedTime = this.downloadFileToTempFolder1(modifiedTimeStamp, modifiedTime);
                if (!StringUtils.isEmpty((String)restoreCount) && !StringUtils.isEmpty((String)fileName)) {
                    restoreCount = restoreCount.replaceAll(NEW_LINE_CHAR, "");
                    restoreElement.setFileBeingRestored(fileName);
                    restoreElement.setRestoreCount(restoreCount + " ");
                }
                logger.debug("filePath:" + filePath);
                logger.debug("fileName:" + fileName);
                String tempFilePath = filePath + fs + fileName;
                if (!StringUtils.isEmpty((String)devicePath) && StringUtils.isEmpty((String)fileNameToDownload)) {
                    tempFilePath = tempFilePath.substring(devicePath.length() + 1);
                } else if (!StringUtils.isEmpty((String)devicePath) && !StringUtils.isEmpty((String)fileNameToDownload)) {
                    tempFilePath = restoreElement.isRestoreAllVersions() ? fileName : (fileName = restoreElement.getFileName());
                }
                tempFilePath = tempFilePath.replaceAll(":", "_DRIVE");
                this.restoreHelper = new RestoreHelper();
                if (destinationPath != null) {
                    logger.debug("init path validation");
                    String dest = this.restoreHelper.checkForDrive(destinationPath);
                    String restoreFilePath = dest + fs + tempFilePath;
                    logger.debug("Restore File path:" + restoreFilePath);
                    restorePath = new File(restoreFilePath);
                } else {
                    logger.debug("restore  in default path");
                    String pathToRestore = this.restoreHelper.restoreToExistingPath(filePath, fileName, restoreElement);
                    restorePath = new File(pathToRestore);
                }
                restorePath.getParentFile().mkdirs();
                if (!restorePath.exists()) {
                    restorePath.createNewFile();
                }
                logger.debug("final restore path : " + restorePath);
                FileOutputStream restoreFileOutput = new FileOutputStream(restorePath);
                multipartStream.readBodyData((OutputStream)restoreFileOutput);
                restoreFileOutput.flush();
                ((OutputStream)restoreFileOutput).close();
                String md5 = MD5Generator.generateMD5OfFile((File)restorePath);
                logger.debug("Md5 from server : " + md5ofDownloadedFileTemp);
                if (!md5.equals(md5ofDownloadedFileTemp)) {
                    logger.debug("MD5 MISMATCH " + md5);
                    restorePath.delete();
                    responseCode = 2;
                }
                if (modifiedTime != 0L && restorePath.exists()) {
                    logger.debug("LAST MODIFIED TIME : " + modifiedTime);
                    restorePath.setLastModified(modifiedTime);
                }
                nextPart = multipartStream.readBoundary();
                logger.debug("NEXT PART " + nextPart);
            }
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error("Exception to Parse and Download in Temp Folder :" + e.getMessage());
            responseCode = 2;
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception to Parse and Download in Temp Folder :" + e.getMessage());
        }
        return responseCode;
    }

    private long downloadFileToTempFolder1(String modifiedTimeStamp, long modifiedTime) {
        String modifiedTimeStampTemp = modifiedTimeStamp;
        long modifiedTimeTemp = modifiedTime;
        try {
            if (modifiedTimeStampTemp != null) {
                modifiedTimeStampTemp = modifiedTimeStampTemp.replaceAll(NEW_LINE_CHAR, "");
                logger.debug("LAST MODIFIED TIME " + modifiedTimeStampTemp);
                modifiedTimeTemp = Long.parseLong(modifiedTimeStampTemp);
            } else {
                logger.error("Last Modified Time is null");
            }
        }
        catch (Exception e) {
            logger.error("Error " + e);
        }
        return modifiedTimeTemp;
    }

    private static Map<String, String> parseHeader(String header) {
        String[] headers;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String s : headers = header.split("\n")) {
            String[] keyValues = s.split(":", 2);
            if (keyValues.length <= 1) continue;
            headerMap.put(keyValues[0], keyValues[1]);
        }
        return headerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRestartID(BackupTO backupTO, String ip, String backupBatchId, String deviceUUID) throws Exception {
        int responseCode = 0;
        try {
            URI uri = this.formHttpsUri(ip, "/BluKryptBuilder/update/restartid");
            logger.debug(URI + uri);
            this.httpPost = new HttpPost(uri);
            this.httpPost.setHeader("restartId", String.valueOf(backupTO.getRestartId()));
            this.httpPost.setHeader("backupBatchId", backupBatchId);
            this.httpPost.setHeader("cloudName", this.cloudName);
            this.httpPost.setHeader("deviceUUID", deviceUUID);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            responseCode = this.response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception sening restart ID :" + e.getMessage());
        }
        finally {
            this.closeResponseEntity();
        }
        return responseCode;
    }

    public ContainerListElement getContainerDetails(String ip, String deviceUUID, String userName) throws CrawlAdapterException {
        int responseCode = 0;
        String responseXmlAsString = null;
        ContainerListElement containerListElement = null;
        HttpEntity responseEntity = null;
        try {
            URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + PARACLOUD_GET_CONTAINER_DETAILS);
            logger.debug("URL:" + uri);
            this.httpPost = new HttpPost(uri);
            this.httpPost.setHeader("userName", userName);
            this.httpPost.setHeader("deviceUUID", deviceUUID);
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            responseCode = this.response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("Response:" + responseXmlAsString);
                containerListElement = Xmlparser.parseContainerListElementResponse(responseXmlAsString);
            }
            logger.debug("get device element responseCode: " + responseCode);
        }
        catch (ClientProtocolException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(CLIENT_PROTOCOL_EXCEPTION + (Object)((Object)e), e);
        }
        catch (FileNotFoundException e) {
            this.closeResponseEntity();
            throw new CrawlAdapterException(IO_EXCEPTION + e, e);
        }
        catch (IOException e) {
            logger.error(IO_EXCEPTION + e.getMessage());
            this.closeResponseEntity();
            throw new CrawlAdapterException(EXCEPTION + e, e);
        }
        finally {
            if (this.httpPost != null) {
                this.httpPost.abort();
                this.httpPost = null;
            }
            this.closeResponseEntity();
        }
        return containerListElement;
    }

    public String sendCurrentBakupStatus(String ip, String deviceUUID, ContainerBackupStatusTo containerBackupStatusTo, boolean isUpdate, String token, String serverBackupStatusId) throws CrawlAdapterException {
        int responseCode = 0;
        String jobId = "";
        try {
            URI uri = isUpdate ? this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/updateBackupJob/") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/registerBackupJob/");
            logger.debug(URI + uri);
            JSONObject obj = new JSONObject();
            obj.put((Object)"containerName", (Object)containerBackupStatusTo.getContainerName());
            obj.put((Object)"containerType", (Object)containerBackupStatusTo.getContainerType());
            obj.put((Object)"status", (Object)containerBackupStatusTo.getStatus());
            obj.put((Object)"processId", (Object)containerBackupStatusTo.getProcessId());
            obj.put((Object)"currentStep", (Object)containerBackupStatusTo.getCurrentStep());
            obj.put((Object)"deviceUUID", (Object)deviceUUID);
            obj.put((Object)"totalSteps", (Object)containerBackupStatusTo.getTotalSteps());
            obj.put((Object)"backupJobType", (Object)containerBackupStatusTo.getBackupJobType());
            obj.put((Object)"backupSizeOnDiskInBytes", (Object)containerBackupStatusTo.getBackupSizeOnDiskInMB());
            obj.put((Object)"startTime", (Object)containerBackupStatusTo.getStartTime());
            this.httpPost = new HttpPost(uri);
            this.httpPost.setHeader("content-type", "application/json");
            this.httpPost.setHeader("deviceUUID", deviceUUID);
            this.httpPost.setHeader("containerName", containerBackupStatusTo.getContainerName());
            this.httpPost.setHeader("currentStep", String.valueOf(containerBackupStatusTo.getCurrentStep()));
            this.httpPost.setHeader("status", containerBackupStatusTo.getStatus());
            this.httpPost.setHeader("containerType", containerBackupStatusTo.getContainerType());
            this.httpPost.setHeader("jobId", serverBackupStatusId);
            this.httpPost.setHeader("endTime", containerBackupStatusTo.getEndTime());
            this.httpPost.setHeader("token", token);
            logger.debug("Request JSON : " + obj.toJSONString());
            this.httpPost.setEntity((HttpEntity)new StringEntity(obj.toJSONString()));
            this.response = this.httpclient.execute((HttpUriRequest)this.httpPost);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug("response : " + responseCode);
            if (responseCode == 200) {
                for (Header header : this.response.getAllHeaders()) {
                    if (!"JobID".equalsIgnoreCase(header.getName())) continue;
                    jobId = header.getValue();
                    logger.debug("jobId : " + jobId);
                }
            }
        }
        catch (Exception e) {
            throw new CrawlAdapterException("Exception " + e);
        }
        finally {
            this.closeResponseEntity();
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceTo getUserForDevice(String ip, String token, String deviceUUID) throws CrawlAdapterException {
        logger.debug("Inside device call url");
        DeviceTo deviceTo = null;
        HttpGet httpGet = null;
        int responseCode = 0;
        HttpEntity responseEntity = null;
        String responseXmlAsString = null;
        try {
            URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/getDeviceInfo/" + deviceUUID);
            httpGet = new HttpGet(uri);
            httpGet.setHeader("token", token);
            httpGet.setHeader("deviceUUID", deviceUUID);
            this.response = this.httpclient.execute((HttpUriRequest)httpGet);
            responseCode = this.response.getStatusLine().getStatusCode();
            logger.debug(RESPONSE_CODE + responseCode);
            if (responseCode == 200) {
                responseEntity = this.response.getEntity();
                responseXmlAsString = EntityUtils.toString((HttpEntity)responseEntity);
                logger.debug("response xml::: " + responseXmlAsString);
                DeviceElement deviceElement = Xmlparser.parseDeviceResponse(responseXmlAsString);
                deviceTo = ObjectUtils.convertToDevice(deviceElement);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.trace("" + ex);
            DeviceTo deviceTo2 = null;
            return deviceTo2;
        }
        finally {
            this.closeResponseEntity();
        }
        return deviceTo;
    }
}

