/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.api;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.element.NewSupportElement;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportAdapter
extends BaseAdapter {
    private Logger logger = LoggerFactory.getLogger(SupportAdapter.class);
    private static final String SUPPORT_MESSAGE_URL = "/support/message";
    private static final String SUPPORT_LOGS_URL = "/support/save/logs";
    private static final String HEADER_REQUEST_ID = "request-id";
    private String requestID = null;

    public SupportAdapter(String keyStore) {
        super(keyStore);
    }

    public SupportAdapter(InputStream inputStream) {
        super(inputStream);
    }

    public boolean sendSupportMessage(String cloudName, NewSupportElement supportElement, String ip) {
        HttpPost httpPost;
        HttpResponse response = null;
        boolean logSent = false;
        try {
            URI uri = this.formHttpsUri(ip, "/support/message/" + cloudName);
            this.logger.debug("uri" + uri);
            httpPost = new HttpPost(uri);
            String xmlRequest = CreateXmlObject.createXmlForSupportElement(supportElement);
            if (xmlRequest == null) {
                this.logger.debug("xmlRequest is null");
                return false;
            }
            httpPost.setHeader("Content-Type", "application/xml");
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(xmlRequest.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.error("UnsupportedEncodingException in sendSupportMessage: ", (Throwable)e1);
            return false;
        }
        try {
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            int responseStatusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("response Code= " + responseStatusCode);
            if (responseStatusCode == 200) {
                this.requestID = response.getFirstHeader(HEADER_REQUEST_ID).getValue();
                logSent = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in response: " + e);
        }
        if (response != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception sending support message :" + e.getMessage());
            }
        }
        return logSent;
    }

    public boolean sendSupportLogs(File logFile, String cloudName) {
        HttpResponse response = null;
        int responseStatusCode = 0;
        boolean logSent = false;
        try {
            URI uri = this.formHttpsUri("supportapi.parablu.com", "/support/save/logs/" + cloudName);
            HttpPost httpPost = new HttpPost(uri);
            if (this.requestID == null) {
                return false;
            }
            httpPost.setHeader(HEADER_REQUEST_ID, this.requestID);
            httpPost.setEntity((HttpEntity)new FileEntity(logFile, "binary/octet-stream"));
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            responseStatusCode = response.getStatusLine().getStatusCode();
            this.logger.debug(String.valueOf(responseStatusCode));
            if (responseStatusCode == 200) {
                logSent = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception " + e);
        }
        if (response != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception sending support logs :" + e.getMessage());
            }
        }
        return logSent;
    }

    public boolean sendSupportLogsNew(File logFile, String cloudName, String userName, String ip) {
        HttpResponse response = null;
        int responseStatusCode = 0;
        boolean logSent = false;
        try {
            URI uri = this.formHttpsUri(ip, SUPPORT_LOGS_URL);
            this.logger.debug("Calling for support logs.");
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setHeader("cloudName", cloudName);
            httpPost.setHeader("userName", userName);
            httpPost.setHeader(HEADER_REQUEST_ID, this.requestID);
            httpPost.setEntity((HttpEntity)new FileEntity(logFile, "binary/octet-stream"));
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            responseStatusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("responsestatus code" + responseStatusCode);
            if (responseStatusCode == 200) {
                String requestId = response.getFirstHeader("requestId").getValue();
                this.logger.debug("request ID:" + requestId);
                logSent = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception " + e);
        }
        if (response != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception sending new support logs :" + e.getMessage());
            }
        }
        return logSent;
    }

    public String getRequestID() {
        return this.requestID;
    }
}

