/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.sync;

import com.parablu.epa.common.dao.MediaImageDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.MediaAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.to.MediaTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncMediaUploadJob
extends Thread {
    private Logger logger = LoggerFactory.getLogger(SyncMediaUploadJob.class);
    private final List<MediaTO> uploadList;
    private final String keyStorePath;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String token;
    private MediaAdapter mediaAdapter = null;
    private MediaImageDAOImpl mediaImageDAOImpl = null;
    private int uploadCount = 0;
    private int totalSize = 0;
    public boolean isTerminated = false;

    public SyncMediaUploadJob(String iP, Integer port, String cn, String token, List<MediaTO> mediaList, String backupDBUrl, String keyStorePath) {
        this.keyStorePath = keyStorePath;
        this.mediaImageDAOImpl = new MediaImageDAOImpl(backupDBUrl);
        this.uploadIP = iP;
        this.cloudName = cn;
        this.uploadList = mediaList;
        this.mediaAdapter = new MediaAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
    }

    @Override
    public void run() {
        try {
            this.uploadCount = 0;
            this.totalSize = this.uploadList.size();
            ArrayList<MediaTO> mediaTOs = new ArrayList<MediaTO>();
            for (MediaTO tempUploadMediaFileTO : this.uploadList) {
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.error("@@@@@ Time before Media Upload file :" + timeBeforeUpload);
                if (this.isTerminated) {
                    this.logger.error("isTerminated: ", (Object)this.isTerminated);
                    break;
                }
                this.logger.debug("Media Uploading file :" + tempUploadMediaFileTO.getFileName());
                if (!this.uploadFile(tempUploadMediaFileTO)) {
                    mediaTOs.add(tempUploadMediaFileTO);
                }
                this.logger.debug("@@@@@ total BackingUp time :" + (System.currentTimeMillis() - timeBeforeUpload));
            }
            this.uploadList.removeAll(mediaTOs);
            this.updateUI("", this.uploadCount);
            this.mediaImageDAOImpl.insertListIntoTable(this.uploadList);
            NotificationHelper.setFileBeingBackedup(null);
        }
        catch (Exception e) {
            this.logger.error("Exception Occurred while backing up  file: ", (Throwable)e);
            this.logger.info("port>>" + this.port);
        }
    }

    private boolean uploadFile(MediaTO mediaFileToUpload) {
        this.logger.debug("MD5: " + mediaFileToUpload.getMd5checksum());
        this.updateUI(mediaFileToUpload.getAbstractFilePath() + mediaFileToUpload.getFileName(), this.uploadCount);
        String absPath = mediaFileToUpload.getClientData();
        if (!this.handleFileExist(absPath)) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (!this.handleFileModified(absPath, mediaFileToUpload.getLastModifiedTimestamp()) && !this.isMD5Equal(absPath, mediaFileToUpload.getMd5checksum())) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (this.handleHttpRequests(mediaFileToUpload)) {
            ++this.uploadCount;
            this.updateUI(mediaFileToUpload.getFileName(), this.uploadCount);
            return true;
        }
        return false;
    }

    private void updateUI(String fileName, int uploadCount2) {
        if (fileName != null) {
            NotificationHelper.setFileBeingUploaded(fileName);
        }
        NotificationHelper.setUploadCount(String.valueOf(uploadCount2) + "/" + this.totalSize);
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        if (!file.exists()) {
            this.logger.debug("file doesnt exist: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    private boolean handleFileModified(String absPath, long lastModifiedTimestamp) {
        File file = new File(absPath);
        if (file.isDirectory()) {
            return true;
        }
        if (file.lastModified() > lastModifiedTimestamp) {
            this.logger.debug("file modified: " + file.getAbsoluteFile());
            return false;
        }
        return true;
    }

    private boolean isMD5Equal(String filePath, String md5checksum) {
        File fileToCheckMD5 = new File(filePath);
        if (fileToCheckMD5.isDirectory()) {
            return true;
        }
        return md5checksum.equals(MD5Generator.generateMD5OfFile((File)fileToCheckMD5));
    }

    private boolean handleHttpRequests(MediaTO mediaFileToUpload) {
        int retrycount = 0;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.uploadIP;
        this.logger.debug("trying to upload meida file: " + mediaFileToUpload.getClientData());
        NotificationHelper.setMediaFileBeingUploaded(mediaFileToUpload.getClientData());
        String filePath = mediaFileToUpload.getClientData();
        while (true) {
            try {
                int response = this.mediaAdapter.uploadMediaFile(mediaFileToUpload, currentUploadIPToUse, filePath, this.token);
                if (response != 3 && response != 4) {
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                    } else if (response == 1006) {
                        this.updateSystrayToolTipNotification("Cloud disk space full", " Your cloud has reached its maximum storage limit.");
                        NotificationHelper.cloudSpaceExceeded = true;
                        this.isTerminated = true;
                    } else if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                    } else if (response == 1008) {
                        this.isTerminated = true;
                    } else if (response == 1007) {
                        this.updateSystrayToolTipNotification("Upload failed  ", " The file " + mediaFileToUpload.getFileName() + " could not be uploaded due to space restrictions.");
                    }
                    return false;
                }
                NotificationHelper.cloudSpaceExceeded = false;
                if (!currentUploadIPToUse.equals(this.uploadIP)) {
                    this.uploadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (CrawlAdapterException e) {
                this.logger.error("Exception occurred  CrawlAdapterException: ", (Throwable)e);
                ++retrycount;
                currentUploadIPToUse = this.updateIpToUse(0, 1, currentUploadIPToUse);
                if (currentUploadIPToUse != null) continue;
                this.logger.debug("currentUploadIPToUse is null");
                return false;
                if (retrycount < 2) continue;
                return false;
            }
            break;
        }
    }

    public abstract void updateSystrayToolTipNotification(String var1, String var2);

    private String updateIpToUse(int gaeLocal, int gaePublic, String currentUploadIPToUse) {
        String[] ipToUse = new String[3];
        String[] ports = new String[2];
        String currentUploadIPToBeUsed = currentUploadIPToUse;
        NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)this.keyStorePath, (String[])ipToUse, (String[])ports);
        if (ipToUse[0] == null && ports[0] == null) {
            return null;
        }
        if (ipToUse[gaeLocal] != null && !ipToUse[gaeLocal].equals(currentUploadIPToBeUsed)) {
            currentUploadIPToBeUsed = ipToUse[gaeLocal];
        } else if (ipToUse[gaeLocal] != null) {
            currentUploadIPToBeUsed = ipToUse[gaePublic];
        }
        return currentUploadIPToBeUsed;
    }

    public void abortUploadProcesses() {
        if (this.mediaAdapter != null) {
            this.mediaAdapter.cancelHttpPut();
        }
    }
}

