/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.sync;

import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.DownloadTableImpl;
import com.parablu.epa.common.dao.ImageTableImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.GetPrivacyGateway;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.ConflictFileNameGenerator;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncDownloadJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(SyncDownloadJob.class);
    private static final String TMP_DOWNLOAD_NAME = ".pbsdn.tmp";
    private List<FileTO> downloadList = null;
    private String downloadIP;
    private final String downloadTableURL;
    private final String cloudName;
    private Integer port;
    private final String devPath;
    private final String imagedbUrl;
    private final String timeStamp;
    private final String baseUrl;
    private final String curTableName;
    private SyncAdapter downloadAdapter = null;
    private int downloadCount = 0;
    private int totalsize = 0;
    private final String token;
    private String downloadIPForGateway;
    private ActivityHistoryImpl activityHistory = null;
    private String batchId = "";

    public SyncDownloadJob(String iP, Integer port, String cn, String setTableURL, String devicePath, String setImagedbUrl, String timeStamp, String baseUrl, String curImageTableName, String token, String keyStorePath, String gatewayIp) {
        this.downloadIP = iP;
        this.cloudName = cn;
        this.downloadTableURL = setTableURL;
        this.devPath = devicePath;
        this.imagedbUrl = setImagedbUrl;
        this.timeStamp = timeStamp;
        this.baseUrl = baseUrl;
        this.curTableName = curImageTableName;
        this.downloadIPForGateway = gatewayIp;
        this.downloadAdapter = new SyncAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
        this.activityHistory = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
    }

    public void run() {
        try {
            this.logger.debug("Starting Download");
            this.downloadList = new ArrayList<FileTO>();
            SettingHelper.setErrorOccuredDuringSync(false);
            ImageTableImpl imtble = new ImageTableImpl(this.imagedbUrl, this.baseUrl);
            boolean readFromTable = this.readFromDownloadTable();
            if (!readFromTable) {
                this.logger.debug("No records in Download Table");
                this.updateUI(0, null);
                Thread.sleep(100L);
                return;
            }
            this.logger.debug("Gateway IP to download is: " + this.downloadIPForGateway);
            if (this.downloadIPForGateway == null) {
                SettingHelper.setErrorOccuredDuringSync(true);
                return;
            }
            this.totalsize = this.downloadList.size();
            this.batchId = this.getBatchId();
            List<FileTO> folderList = this.fileterFolderListFromDwnldList(this.downloadList);
            this.downloadList.removeAll(folderList);
            this.logger.debug("FolderList size>>>>>>>" + folderList.size());
            String downloadListXmlString = CreateXmlObject.createXmlForDownloadListElement(this.downloadList);
            if (downloadListXmlString == null) {
                throw new BaseException("Bean utils or Simple Xml Exception occcurred; bytes = null");
            }
            InputStream in = this.downloadAdapter.downloadFileUsingMultiPart(downloadListXmlString, this.downloadIPForGateway, this.port, false, SettingHelper.getDeviceUUId(), this.batchId);
            this.parseResponseEntityAndDownloadFileToTempFolder1(in, imtble);
            for (FileTO tempDownloadFileTO : folderList) {
                if (this.isTerminated) {
                    this.logger.debug("Terminated while download: " + tempDownloadFileTO.getFileName());
                    break;
                }
                this.logger.debug("Starting file Download  " + tempDownloadFileTO.getFileName());
                if (!this.downloadFile(tempDownloadFileTO)) continue;
                imtble.storeImageInformation(tempDownloadFileTO, this.curTableName);
            }
            this.updateUI(this.downloadCount, null);
            this.downloadList = null;
        }
        catch (BaseException e) {
            this.logger.error("Base Exception: " + (Object)((Object)e));
        }
        catch (InterruptedException e) {
            this.logger.error("Interrupted probably because of disconnection of account");
        }
        catch (Exception e) {
            this.logger.error("Exception: ", (Throwable)e);
        }
    }

    private String getBatchId() {
        String currentBatchId = "";
        ActivityTO activityTO = this.activityHistory.getCurrentStatusFromActivityHistoryTable();
        if (activityTO != null) {
            currentBatchId = activityTO.getBatchId();
        }
        return currentBatchId;
    }

    private List<FileTO> fileterFolderListFromDwnldList(List<FileTO> downloadList2) {
        ArrayList<FileTO> folderList = new ArrayList<FileTO>();
        for (FileTO fileTO : downloadList2) {
            if (!fileTO.isFolder()) continue;
            folderList.add(fileTO);
        }
        return folderList;
    }

    private int parseResponseEntityAndDownloadFileToTempFolder1(InputStream inStream, ImageTableImpl imtble) {
        InputStream in;
        String boundary = "--PARABLUEOF";
        byte[] bryBytes = boundary.getBytes();
        int response = 4;
        try {
            in = inStream;
        }
        catch (Exception e) {
            this.logger.error("FILE_DOWNLOAD_INTERNAL_ERROR:  " + e);
            return 3;
        }
        try {
            MultipartStream multipartStream = new MultipartStream(in, bryBytes);
            boolean nextPart = multipartStream.skipPreamble();
            int i = 1;
            while (nextPart) {
                File newFile;
                String path;
                boolean downloadSuccess = true;
                String header = multipartStream.readHeaders();
                this.logger.debug(header + " header:" + i++);
                Map<String, String> headerMap = SyncDownloadJob.parseHeader(header);
                String fileName = headerMap.get("fileName");
                String filePath = headerMap.get("filePath");
                String md5ofDownloadedFile = headerMap.get("md5Checksum");
                String realFilePath = new StringBuffer().append(this.devPath).append(StringLiterals.FILE_SEPARATOR).append(filePath).append(StringLiterals.FILE_SEPARATOR).append(fileName).toString();
                String restoreFilePath = path = new StringBuffer().append(this.devPath).append(StringLiterals.FILE_SEPARATOR).append(filePath).append(StringLiterals.FILE_SEPARATOR).append(TMP_DOWNLOAD_NAME).toString();
                this.logger.debug("Restore File path:" + restoreFilePath);
                File oldTempFile = new File(path);
                this.createTempFile(oldTempFile);
                FileOutputStream restoreFileOutput = new FileOutputStream(oldTempFile);
                this.logger.debug("before read data >>>>");
                multipartStream.readBodyData((OutputStream)restoreFileOutput);
                this.logger.debug("after read data >>>>");
                restoreFileOutput.flush();
                ((OutputStream)restoreFileOutput).close();
                String md5 = MD5Generator.generateMD5OfFile((File)oldTempFile);
                this.logger.debug("Md5 from server>>>>" + md5ofDownloadedFile);
                if (!md5.equals(md5ofDownloadedFile)) {
                    this.logger.debug("Md5 mis match " + md5);
                    oldTempFile.delete();
                    response = 2;
                    downloadSuccess = false;
                }
                if ((newFile = new File(realFilePath)).exists()) {
                    if (newFile.lastModified() > Long.valueOf(this.timeStamp)) {
                        String oldFileName = fileName;
                        String renamedFileName = ConflictFileNameGenerator.generateConflictFileName((String)oldFileName);
                        String renamedFilePath = newFile.getParent() + StringLiterals.FILE_SEPARATOR + renamedFileName;
                        File renamedFile = new File(renamedFilePath);
                        newFile.renameTo(renamedFile);
                        this.logger.debug("Renaming due to conflict:" + renamedFile.getAbsolutePath());
                    } else {
                        newFile.delete();
                    }
                }
                File parentOfFile = newFile.getParentFile();
                this.logger.debug("The parent folder for this file/folder to be downloaded is " + parentOfFile.getAbsolutePath());
                this.logger.debug("The file/folder  downloading is " + newFile.getAbsolutePath());
                if (!parentOfFile.exists()) {
                    parentOfFile.mkdirs();
                }
                if (oldTempFile.exists()) {
                    FileUtils.moveFile((File)oldTempFile, (File)newFile);
                }
                nextPart = multipartStream.readBoundary();
                this.doPostchanges(downloadSuccess, fileName, filePath, imtble);
                this.logger.debug("next part>>>>>>>>>" + nextPart);
            }
        }
        catch (MultipartStream.MalformedStreamException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.error("malformed stream exception" + e.getMessage());
            response = 2;
        }
        catch (IOException e) {
            this.logger.trace("" + e);
            this.logger.error("IOexception" + e.getMessage());
            response = 2;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("malformed stream exception" + e.getMessage());
        }
        return response;
    }

    private void doPostchanges(boolean downloadSuccess, String fileName, String filePath, ImageTableImpl imtble) {
        String processingFilePath = filePath;
        FileTO downloadedFileTO = null;
        processingFilePath = processingFilePath.replace("/", "\\");
        for (FileTO fileTO : this.downloadList) {
            if (!fileTO.getFileName().equalsIgnoreCase(fileName) || !fileTO.getAbstractFilePath().equalsIgnoreCase(processingFilePath)) continue;
            downloadedFileTO = fileTO;
        }
        if (downloadedFileTO != null) {
            this.updateUI(this.downloadCount, downloadedFileTO.getFileName());
            if (!downloadedFileTO.isFolder()) {
                if (downloadSuccess) {
                    this.removeFromDownloadTable(downloadedFileTO);
                    ++this.downloadCount;
                    this.updateUI(this.downloadCount, downloadedFileTO.getFileName());
                } else {
                    SettingHelper.setErrorOccuredDuringSync(true);
                    this.logger.debug("Error occured during sync");
                    this.removeFromCurrentImageTable(downloadedFileTO);
                    this.logger.debug("File to Download handle returned false for:" + downloadedFileTO.getFileName());
                }
            } else {
                ++this.downloadCount;
                this.logger.debug("Download count: " + this.downloadCount);
                String folderPath = this.devPath + StringLiterals.FILE_SEPARATOR + downloadedFileTO.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + downloadedFileTO.getFileName();
                File folderToCreate = new File(folderPath);
                this.logger.debug("Folder to be Created: " + folderToCreate.getName());
                if (!folderToCreate.exists()) {
                    folderToCreate.mkdirs();
                }
                this.removeFromDownloadTable(downloadedFileTO);
                this.updateUI(this.downloadCount, downloadedFileTO.getFileName());
            }
            if (downloadSuccess) {
                imtble.storeImageInformation(downloadedFileTO, this.curTableName);
            }
        } else {
            this.logger.debug("File TO is null>>>>>>>>>$$$$$$$$$$$$$$");
        }
    }

    private static Map<String, String> parseHeader(String header) {
        String[] headers;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String s : headers = header.split("\n")) {
            String[] keyValues = s.split(":", 2);
            if (keyValues.length <= 1) continue;
            headerMap.put(keyValues[0], keyValues[1].replaceAll("[\n\r]", ""));
        }
        return headerMap;
    }

    private boolean readFromDownloadTable() {
        try {
            DownloadTableImpl download = new DownloadTableImpl(this.downloadTableURL);
            this.downloadList.addAll(download.selectSortedListFromTable());
            if (!this.downloadList.isEmpty()) {
                return true;
            }
        }
        catch (DatabaseException e) {
            this.logger.error("Exception while Read From Download Table: " + (Object)((Object)e));
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean downloadFile(FileTO fileToDownload) {
        this.updateUI(this.downloadCount, fileToDownload.getFileName());
        if (!fileToDownload.isFolder()) {
            if (this.handleHttpRequests(fileToDownload)) {
                this.removeFromDownloadTable(fileToDownload);
                ++this.downloadCount;
                this.updateUI(this.downloadCount, fileToDownload.getFileName());
                return true;
            }
            SettingHelper.setErrorOccuredDuringSync(true);
            this.logger.debug("Error occured during sync");
            this.removeFromCurrentImageTable(fileToDownload);
            this.logger.debug("File to Download handle returned false for:" + fileToDownload.getFileName());
            return false;
        }
        ++this.downloadCount;
        this.logger.debug("Download count: " + this.downloadCount);
        String folderPath = this.devPath + StringLiterals.FILE_SEPARATOR + fileToDownload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToDownload.getFileName();
        File folderToCreate = new File(folderPath);
        this.logger.debug("Folder to be Created: " + folderToCreate.getName());
        if (!folderToCreate.exists()) {
            folderToCreate.mkdirs();
        }
        this.removeFromDownloadTable(fileToDownload);
        this.updateUI(this.downloadCount, fileToDownload.getFileName());
        return true;
    }

    private void removeFromCurrentImageTable(FileTO fileToDownload) {
        ImageTableImpl imageTableHandler = new ImageTableImpl(SettingHelper.getBaseDBUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.curTableName, SettingHelper.getBaseDBUrl());
        imageTableHandler.removeFilTOFromTable(fileToDownload, this.curTableName);
    }

    private boolean updateUI(int count, String fileName) {
        NotificationHelper.setTotalDownloadCount(count);
        NotificationHelper.setDowloadCount(String.valueOf(count) + "/" + this.totalsize);
        if (fileName != null) {
            NotificationHelper.setFileBeingDownloaded(fileName);
        }
        return false;
    }

    private boolean handleHttpRequests(FileTO fileToDownload) {
        boolean retry;
        boolean dodEnabled = false;
        int retrycount = 0;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.downloadIP;
        String iPForGateway = this.downloadIPForGateway;
        String userName = SettingHelper.getUserName();
        String realFilePath = new StringBuffer().append(this.devPath).append(StringLiterals.FILE_SEPARATOR).append(fileToDownload.getAbstractFilePath()).append(StringLiterals.FILE_SEPARATOR).append(fileToDownload.getFileName()).toString();
        String path = new StringBuffer().append(this.devPath).append(StringLiterals.FILE_SEPARATOR).append(fileToDownload.getAbstractFilePath()).append(StringLiterals.FILE_SEPARATOR).append(TMP_DOWNLOAD_NAME).toString();
        File oldTempFile = new File(path);
        do {
            retry = false;
            try {
                this.createTempFile(oldTempFile);
                this.logger.debug(fileToDownload.getFileName() + "Temp Folder" + oldTempFile.getName());
                int response = fileToDownload.isFolder() ? this.downloadAdapter.downloadFile1(this.downloadIP, fileToDownload, this.port, oldTempFile, dodEnabled, this.token) : this.downloadAdapter.downloadFile(iPForGateway, fileToDownload, this.port, oldTempFile, dodEnabled, this.token, userName);
                if (response != 4) {
                    this.logger.debug("Response while download file" + response);
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                        return false;
                    }
                    if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                        return false;
                    }
                    if (response == 1010) {
                        this.removeFromDownloadTable(fileToDownload);
                    } else {
                        if (response == 1008) {
                            this.isTerminated = true;
                            return false;
                        }
                        if (response == 5) {
                            this.removeFromDownloadTable(fileToDownload);
                            return false;
                        }
                    }
                    if (oldTempFile.exists()) {
                        oldTempFile.delete();
                    }
                    return false;
                }
                File newFile = new File(realFilePath);
                if (newFile.exists()) {
                    if (newFile.lastModified() > Long.valueOf(this.timeStamp)) {
                        String oldFileName = fileToDownload.getFileName();
                        String renamedFileName = ConflictFileNameGenerator.generateConflictFileName((String)oldFileName);
                        String renamedFilePath = newFile.getParent() + StringLiterals.FILE_SEPARATOR + renamedFileName;
                        File renamedFile = new File(renamedFilePath);
                        newFile.renameTo(renamedFile);
                        this.logger.debug("Renaming due to conflict:" + renamedFile.getAbsolutePath());
                    } else {
                        newFile.delete();
                    }
                }
                File parentOfFile = newFile.getParentFile();
                this.logger.debug("The parent folder for this file/folder to be downloaded is " + parentOfFile.getAbsolutePath());
                this.logger.debug("The file/folder  downloading is " + newFile.getAbsolutePath());
                if (!parentOfFile.exists()) {
                    parentOfFile.mkdirs();
                }
                FileUtils.moveFile((File)oldTempFile, (File)newFile);
                if (!currentUploadIPToUse.equals(this.downloadIP)) {
                    this.downloadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (IOException e) {
                this.logger.error("IOException while Downloading" + e);
            }
            catch (CrawlAdapterException e) {
                this.logger.error("CrawlAdapterException while Downloading" + (Object)((Object)e));
                retry = true;
                ++retrycount;
                iPForGateway = this.sleepAndGetNearestGateway(currentUploadIPToUse, iPForGateway);
            }
            catch (InterruptedException e) {
                this.logger.trace("" + e);
                this.logger.error("InterruptedException while Downloading" + e.getMessage());
            }
            String[] ipToUse = new String[3];
            String[] ports = new String[2];
            NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)SettingHelper.getKeystorePath(), (String[])ipToUse, (String[])ports);
            if (ipToUse[0] == null && ipToUse[1] == null) {
                return false;
            }
            if (ipToUse[0] != null && !ipToUse[0].equals(currentUploadIPToUse)) {
                currentUploadIPToUse = ipToUse[0];
                continue;
            }
            if (ipToUse[0] == null) continue;
            currentUploadIPToUse = ipToUse[1];
        } while (retry && retrycount < 2);
        return false;
    }

    private String sleepAndGetNearestGateway(String currentUploadIPToUse, String ipPForGateway) {
        String ipTouse = ipPForGateway;
        try {
            Thread.sleep(60000L);
            int responseForPing = this.downloadAdapter.pingGatewayIP(currentUploadIPToUse);
            if (responseForPing != 200) {
                ipTouse = GetPrivacyGateway.getPrivacyGatewayIP();
                this.logger.debug("the pGGateway IP in catch" + ipTouse);
            }
        }
        catch (InterruptedException ex) {
            this.logger.trace("" + ex);
            this.logger.error("Exception in upload file via gateway" + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.trace("" + ex);
            this.logger.error("Error in get privacy gatewayip" + ex.getMessage());
        }
        return ipTouse;
    }

    private void createTempFile(File oldTempFile) throws IOException, InterruptedException {
        if (!oldTempFile.getParentFile().exists()) {
            oldTempFile.getParentFile().mkdirs();
        }
        if (oldTempFile.exists()) {
            oldTempFile.delete();
        }
        oldTempFile.createNewFile();
        oldTempFile.deleteOnExit();
    }

    private boolean removeFromDownloadTable(FileTO fileToRemove) {
        boolean success = false;
        DownloadTableImpl download = new DownloadTableImpl(this.downloadTableURL);
        download.removeFromTable(fileToRemove);
        return success;
    }

    public void abortDownloadProcesses() {
        if (this.downloadAdapter != null) {
            this.downloadAdapter.cancelHttpget();
        }
    }
}

