/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.CrawlLifecycle;
import com.parablu.epa.core.element.BkPolicyExcludedFolderListElement;
import com.parablu.epa.core.element.BkPolicyFolderPathElement;
import com.parablu.epa.core.element.BluVaultMappingElement;
import com.parablu.epa.core.element.BluVaultMappingListElement;
import com.parablu.epa.core.element.DayArray;
import com.parablu.epa.core.element.DeviceContainerElement;
import com.parablu.epa.core.element.ExcludedFolderPathElement;
import com.parablu.epa.core.element.FolderPathElement;
import com.parablu.epa.core.element.GatewayElement;
import com.parablu.epa.core.element.GatewayNameElement;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.InclusionFilterElement;
import com.parablu.epa.core.element.Schedule;
import com.parablu.epa.core.element.ScheduleElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BluVaultTO;
import com.parablu.epa.core.to.ContainerBackupStatusTo;
import com.parablu.epa.core.to.ContainerDetailsTo;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.InclusionTO;
import com.parablu.epa.core.to.NWThrottlingTO;
import com.parablu.epa.core.to.ScheduleTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyManagementServerHelper {
    private static String cloudName = SettingHelper.getCloudName();
    private static String keyStorePath = SettingHelper.getKeystorePath();
    public static BackupAdapter backUpAdapter = new BackupAdapter(cloudName, keyStorePath);
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
    private static BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
    private static Logger logger = LoggerFactory.getLogger(PolicyManagementServerHelper.class);
    static int policyRefreshIntervalInHrs = -1;
    static int statisticsRefreshIntervalInHrs = -1;
    private static Set<String> rootFilesList;
    private static final String USERHOME_CONTAINS = "{user.home}";
    private static final String USERHOME = "user.home";

    private PolicyManagementServerHelper() {
    }

    public static String getPrivacyGatewayIP(String backupType) {
        List<GatewayTO> gatewayList = backupPolicyDAOImpl.getGatewayList();
        ArrayList<Long> minimumTime = new ArrayList<Long>();
        ArrayList<GatewayTO> removeGatewayList = new ArrayList<GatewayTO>();
        if (gatewayList != null && !gatewayList.isEmpty()) {
            for (GatewayTO gatewayTO : gatewayList) {
                if (!gatewayTO.getGatewayName().startsWith("localhost")) continue;
                logger.debug("inside localhost skipping others : " + gatewayTO.getGatewayName());
                return gatewayTO.getGatewayName();
            }
        }
        for (GatewayTO gatewayTO : gatewayList) {
            int response;
            logger.debug("Gateway is:" + gatewayTO.getGatewayName());
            long beforeTime = System.currentTimeMillis();
            try {
                response = backUpAdapter.pingGatewayIP(gatewayTO.getGatewayName());
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("Error in ping privacy gateway" + e.getMessage());
                removeGatewayList.add(gatewayTO);
                continue;
            }
            if (response == 200) {
                long totalHitTime = System.currentTimeMillis() - beforeTime;
                gatewayTO.setHitTime(totalHitTime);
                minimumTime.add(totalHitTime);
                backUpFolderDAOImpl.updateHitTime(gatewayTO);
                continue;
            }
            logger.error("Error in ping privacy gateway");
            removeGatewayList.add(gatewayTO);
        }
        for (GatewayTO gatewayTO : removeGatewayList) {
            gatewayList.remove(gatewayTO);
        }
        List<GatewayTO> sortedPGs = PolicyManagementServerHelper.getPGTypeAndOrder(backupType, gatewayList);
        for (GatewayTO gatewayTO : sortedPGs) {
            logger.debug("SORTED PG " + gatewayTO.getGatewayName() + " - PG TYPE " + gatewayTO.getType());
        }
        PolicyManagementServerHelper.sortOutMinimumTime(minimumTime, sortedPGs);
        logger.debug("GATEWAY SIZE AFTER PING : " + sortedPGs.size());
        Collections.sort(minimumTime);
        Random random = new Random();
        int random2 = random.nextInt(1000);
        if (!sortedPGs.isEmpty()) {
            random2 %= sortedPGs.size();
        }
        for (int i = 0; i < sortedPGs.size(); ++i) {
            if (sortedPGs.get(random2).getHitTime() == ((Long)minimumTime.get(0)).longValue()) {
                logger.debug("MINIMUM TIME FOR PRIVACY GATEWAY IS : " + sortedPGs.get(random2).getHitTime() + "GATEWAY NAME IS : " + sortedPGs.get(random2).getGatewayName() + "RANDOM NO : " + random2);
                return sortedPGs.get(random2).getGatewayName();
            }
            random2 = (random2 + 1) % sortedPGs.size();
        }
        return null;
    }

    private static void sortOutMinimumTime(List<Long> minimumTime, List<GatewayTO> sortedPGs) {
        minimumTime.clear();
        for (GatewayTO gatewayTO : sortedPGs) {
            minimumTime.add(gatewayTO.getHitTime());
        }
    }

    private static List<GatewayTO> getPGTypeAndOrder(String backupType, List<GatewayTO> gatewayList) {
        ArrayList<GatewayTO> sortedGatewayList = new ArrayList<GatewayTO>();
        for (GatewayTO gatewayTO : gatewayList) {
            if (!gatewayTO.getType().equalsIgnoreCase(backupType)) continue;
            sortedGatewayList.add(gatewayTO);
        }
        if (sortedGatewayList.isEmpty()) {
            for (GatewayTO gatewayTO : gatewayList) {
                if (!"BOTH".equalsIgnoreCase(gatewayTO.getType())) continue;
                sortedGatewayList.add(gatewayTO);
            }
        }
        if (sortedGatewayList.isEmpty()) {
            sortedGatewayList.addAll(gatewayList);
        }
        return sortedGatewayList;
    }

    public static void loadBackupPolicyElement(String deviceName) {
        if ("true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) {
            try {
                List deviceContainerElements = backUpAdapter.getContainerDetails(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName()).getDeviceContainerElement();
                PolicyManagementServerHelper.createContainerDetalis(backupPolicyDAOImpl, deviceContainerElements);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("error in loading the backup policy elements" + e.getMessage());
            }
        }
        BackupPolicyTO backupPolicyTo = new BackupPolicyTO();
        try {
            GroupPolicyElementList groupPolicyElementList = backUpAdapter.getGroupPolicyElement(SettingHelper.getCurrentCloudIpAddress(), deviceName, SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), SettingHelper.getServerBackupLicensed());
            PolicyManagementServerHelper.createGroupPolicyAndChildDetails(backupPolicyDAOImpl, backupPolicyTo, groupPolicyElementList);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("error in getting the group policy elements" + e.getMessage());
        }
    }

    public static void createGroupPolicyAndChildDetails(BackupPolicyDAOImpl backupPolicyDAOImpl, BackupPolicyTO backupPolicyTo, GroupPolicyElementList groupPolicyElementList) {
        if (!groupPolicyElementList.getGroupPolicyElement().isEmpty()) {
            backupPolicyDAOImpl.deleteGroupPolicyAndChildDetails();
            ArrayList<String> policyStoredToDb = new ArrayList<String>();
            for (GroupPolicyElement groupPolicyElement : groupPolicyElementList.getGroupPolicyElement()) {
                Object throttlings2;
                if (policyStoredToDb.contains(groupPolicyElement.getPolicygroupName())) continue;
                List listFolderPathElement = groupPolicyElement.getFolderPathElement();
                List excludedFolderListElement = groupPolicyElement.getExcludedFolderPathElement();
                try {
                    backupPolicyTo.setPolicyGroupName(groupPolicyElement.getPolicygroupName());
                    backupPolicyTo.setMaxFileSize(groupPolicyElement.getMaxFileSize());
                    backupPolicyTo.setMaxVersions(groupPolicyElement.getMaxVersions());
                    backupPolicyTo.setOsType(groupPolicyElement.getOsType());
                    backupPolicyTo.setLastModifiedTime(groupPolicyElement.getLastModifiedTime());
                    backupPolicyTo.setPftEnabled(groupPolicyElement.getPftEnabled());
                    backupPolicyTo.setPftSize(groupPolicyElement.getPftSize());
                    backupPolicyTo.setCpuUtilization(groupPolicyElement.getCpuUtilization());
                    backupPolicyTo.setPolicyRefreshInterval(PolicyManagementServerHelper.changeTimeToMin(groupPolicyElement.getPolicyRefreshInterval()));
                    backupPolicyTo.setStatisticsRefreshInterval(PolicyManagementServerHelper.changeTimeToMin(groupPolicyElement.getStatisticsRefreshInterval()));
                    backupPolicyTo.setCrawlLimit(groupPolicyElement.getCrawlLimit());
                    backupPolicyTo.setIsStatisticsCollectorEnabled(groupPolicyElement.getIsStatisticsEnabled());
                    backupPolicyTo.setLegalHoldEnabled(groupPolicyElement.getLegalHoldEnabled());
                    backupPolicyTo.setBackupSystemFilesEnabled(groupPolicyElement.getBackupSystemFilesEnabled());
                    backupPolicyTo.setChunkSize(groupPolicyElement.getChunkSize());
                    backupPolicyTo.setVssEnabled(groupPolicyElement.getVssEnabled());
                    backupPolicyTo.setCompressionEnabled(groupPolicyElement.isCompressionEnabled());
                    backupPolicyTo.setMemoryUtilization(groupPolicyElement.getMemoryUtilisation());
                    backupPolicyTo.setNetworkThrottleSpeed(groupPolicyElement.getNetworkThrottleSpeed());
                    SettingHelper.setIsStatisticsEnabled(groupPolicyElement.getIsStatisticsEnabled());
                    SettingHelper.setUserMaxStorageLimit(groupPolicyElement.getUserSizeAllowed());
                    SettingHelper.setMaxVersionsToKeep(groupPolicyElement.getMaxVersions());
                    SettingHelper.setDCMEnabled(Boolean.parseBoolean(groupPolicyElement.getDcmEnabled()));
                    SettingHelper.setBackupCrawlLimit(groupPolicyElement.getCrawlLimit());
                    SettingHelper.setIsVssEnabled(groupPolicyElement.getVssEnabled());
                    logger.debug("Is compression enabled:" + backupPolicyTo.isCompressionEnabled());
                    if (groupPolicyElement.getMemoryUtilisation() != 0 && SettingHelper.getOsName().contains("Win")) {
                        logger.debug("mem util  :: " + groupPolicyElement.getMemoryUtilisation());
                        PropertyHelper.changeConfigProperty((String)"Jvm-Max-Size", (String)("-Xmx" + groupPolicyElement.getMemoryUtilisation() + "m"));
                    }
                    boolean success = backupPolicyDAOImpl.insertBackupPolicyDetailsToTable(backupPolicyTo);
                    logger.debug("Result for inserting backup policy details into table:" + success);
                    if (success) {
                        policyStoredToDb.add(groupPolicyElement.getPolicygroupName());
                    }
                }
                catch (Exception e) {
                    logger.trace("" + e);
                    logger.error("Result for inserting backup policy details into table:false" + e.getMessage());
                }
                if (!listFolderPathElement.isEmpty()) {
                    backUpFolderDAOImpl.createBackUpTable();
                    SettingHelper.setBackupPolicyFoldersList(listFolderPathElement);
                    PolicyManagementServerHelper.addBkPolicyFolderToExistingTable(listFolderPathElement, groupPolicyElement.getPolicygroupName());
                }
                if (!excludedFolderListElement.isEmpty()) {
                    backupPolicyDAOImpl.createPolicyExcludedFolderTable();
                    PolicyManagementServerHelper.addBkPolicyExcludedFoldersToTable(excludedFolderListElement);
                }
                List networkThrottlings = groupPolicyElement.getNetworkThrottleElement();
                for (Object throttlings2 : networkThrottlings) {
                    for (Object throttling : throttlings2.getThrottlingList()) {
                        NWThrottlingTO nwThrottlingTO = new NWThrottlingTO();
                        nwThrottlingTO.setNwName(throttling.getNetworkThrottlingName());
                        nwThrottlingTO.setStartTime(throttling.getStartTime());
                        nwThrottlingTO.setEndTime(throttling.getEndTime());
                        nwThrottlingTO.setMaxSpeed(throttling.getMaxSpeed());
                        nwThrottlingTO.setUploadSpeed(throttling.getUploadSpeed());
                        nwThrottlingTO.setDownloadSpeed(throttling.getDownloadSpeed());
                        backUpFolderDAOImpl.insertNetworkThrottling(nwThrottlingTO);
                    }
                }
                List scheduleElements = groupPolicyElement.getSchedulesElement();
                throttlings2 = scheduleElements.iterator();
                while (throttlings2.hasNext()) {
                    Object throttling;
                    ScheduleElement scheduleElement = (ScheduleElement)throttlings2.next();
                    throttling = scheduleElement.getScheduleList().iterator();
                    while (throttling.hasNext()) {
                        Schedule schedule = (Schedule)throttling.next();
                        ScheduleTO scheduleTO = new ScheduleTO();
                        logger.debug("schedule name : " + schedule.getScheduleName());
                        scheduleTO.setScheduleName(schedule.getScheduleName());
                        scheduleTO.setStartTime(schedule.getTime());
                        scheduleTO.setDayArray(PolicyManagementServerHelper.toString(PolicyManagementServerHelper.getArrayInt(schedule.getDayArrayElementList().getDayArray())));
                        if (SettingHelper.getServerBackupLicensed().contentEquals("true")) {
                            scheduleTO.setBackupType(schedule.getBackupType().toUpperCase());
                            scheduleTO.setContainerName(PolicyManagementServerHelper.getContainerNamesForSchedule(groupPolicyElement.getPolicygroupName(), backupPolicyDAOImpl));
                        } else {
                            scheduleTO.setBackupType("");
                        }
                        scheduleTO.setPolicyName(groupPolicyElement.getPolicygroupName());
                        backUpFolderDAOImpl.insertSchedules(scheduleTO);
                    }
                }
                InclusionFilterElement inclusionElement = groupPolicyElement.getInclusionFilterElement();
                logger.debug("Filter name : " + inclusionElement.getFilterName());
                InclusionTO inclusionTO = new InclusionTO();
                inclusionTO.setFilterName(inclusionElement.getFilterName());
                inclusionTO.setExtensionName(inclusionElement.getExtensions());
                inclusionTO.setPolicyName(groupPolicyElement.getPolicygroupName());
                backUpFolderDAOImpl.insertInclusions(inclusionTO);
                GatewayElement gatewayElement = groupPolicyElement.getGatewayElement();
                List nameElements = gatewayElement.getGatewayList();
                for (GatewayNameElement gatewayElements : nameElements) {
                    logger.debug("GATEWAY RECEIVED " + gatewayElements.getName());
                    GatewayTO gatewayTO = new GatewayTO();
                    gatewayTO.setGatewayName(gatewayElements.getName());
                    gatewayTO.setType(gatewayElements.getType());
                    backUpFolderDAOImpl.insertGatewayNames(gatewayTO);
                }
                BluVaultMappingListElement ebmsMappingListElement = groupPolicyElement.getBluVaultMappingListElements();
                List mappingElements = ebmsMappingListElement.getEBMSList();
                for (BluVaultMappingElement ebmsMappingElement : mappingElements) {
                    BluVaultTO bluvaultTO = new BluVaultTO();
                    bluvaultTO.setBluVaultName(ebmsMappingElement.getBluvaultName());
                    backupPolicyDAOImpl.insertBluVaultNamesToTable(bluvaultTO);
                }
            }
        }
    }

    private static int changeTimeToMin(String time) {
        int timeInMin = 0;
        if (!StringUtils.isEmpty((String)time)) {
            String[] hourMin = time.split(":");
            if (hourMin.length == 1) {
                return Integer.parseInt(hourMin[0]);
            }
            int hour = Integer.parseInt(hourMin[0]);
            int mins = Integer.parseInt(hourMin[1]);
            timeInMin = hour * 60 + mins;
        }
        return timeInMin;
    }

    private static int[] getArrayInt(List<DayArray> list) {
        int[] dayArray = new int[list.size()];
        int i = 0;
        for (DayArray arrayElement : list) {
            dayArray[i] = arrayElement.getDayArray();
            ++i;
        }
        return dayArray;
    }

    public static String toString(int[] input) {
        StringBuilder buffer = new StringBuilder();
        if (input.length != 0) {
            buffer.append(input[0]);
            for (int i = 1; i < input.length; ++i) {
                buffer.append(",");
                buffer.append(input[i]);
            }
        }
        return buffer.toString();
    }

    private static void addBkPolicyExcludedFoldersToTable(List<BkPolicyExcludedFolderListElement> excludedFolderListElement) {
        for (BkPolicyExcludedFolderListElement folderListElement : excludedFolderListElement) {
            List folderPathElements = folderListElement.getFolderPathList();
            logger.debug("Adding Folders from policy:");
            for (ExcludedFolderPathElement folderPathElement : folderPathElements) {
                if (folderPathElement.getFolderPath().toLowerCase().contains(USERHOME_CONTAINS)) {
                    String newPath = folderPathElement.getFolderPath().toLowerCase().replace(USERHOME_CONTAINS, System.getProperty(USERHOME));
                    folderPathElement.setFolderPath(newPath);
                }
                logger.info(" " + folderPathElement.getFolderPath());
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    backupPolicyDAOImpl.insertPolicyExcludedFoldersToTable(folderPathElement.getFolderPath().toLowerCase());
                    continue;
                }
                backupPolicyDAOImpl.insertPolicyExcludedFoldersToTable(folderPathElement.getFolderPath());
            }
        }
    }

    private static void addBkPolicyFolderToExistingTable(List<BkPolicyFolderPathElement> listFolderPathElement, String policyName) {
        boolean isDefaultFoldersLatest = true;
        logger.debug("IS Default Folders Latest:" + isDefaultFoldersLatest);
        List<BackupFolderTO> existingBackupFolderList = backUpFolderDAOImpl.getAllFolderToBackUpFiles();
        ArrayList<String> backupFolderTOsExistingFolderPaths = new ArrayList<String>();
        if (existingBackupFolderList != null && !existingBackupFolderList.isEmpty()) {
            for (BackupFolderTO backupFolderTO : existingBackupFolderList) {
                backupFolderTOsExistingFolderPaths.add(backupFolderTO.getFolderPath().toLowerCase());
            }
        }
        if (isDefaultFoldersLatest) {
            PolicyManagementServerHelper.storeSystemRoots();
            for (BkPolicyFolderPathElement bkPolicyFolderPathElement : listFolderPathElement) {
                List folderPathElements = bkPolicyFolderPathElement.getFolderPathList();
                logger.debug("Adding Folders from policy:");
                PolicyManagementServerHelper.checkAllDrivesSelectedForBackup(folderPathElements);
                for (FolderPathElement folderPathElement : folderPathElements) {
                    BackupFolderTO backupFolderTO = new BackupFolderTO();
                    if (folderPathElement.getFolderPath().toLowerCase().contains(USERHOME_CONTAINS)) {
                        String newPath = folderPathElement.getFolderPath().toLowerCase().replace(USERHOME_CONTAINS, System.getProperty(USERHOME));
                        folderPathElement.setFolderPath(newPath);
                    }
                    if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                        PolicyManagementServerHelper.checkPreconditionsForFolderPath(folderPathElement);
                        String basePathOfTheFolder = folderPathElement.getFolderPath().substring(0, 3);
                        if (!rootFilesList.contains(basePathOfTheFolder.toLowerCase())) {
                            logger.debug("Not Supported Drive....." + basePathOfTheFolder);
                            continue;
                        }
                    }
                    if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
                        String macAppendedPath = "Macintosh" + folderPathElement.getFolderPath();
                        folderPathElement.setFolderPath(macAppendedPath);
                    }
                    if (backupFolderTOsExistingFolderPaths.contains(folderPathElement.getFolderPath().toLowerCase())) {
                        logger.debug("Folder already Added by User");
                        continue;
                    }
                    if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                        backupFolderTO.setFolderPath(folderPathElement.getFolderPath().toLowerCase());
                    } else {
                        backupFolderTO.setFolderPath(folderPathElement.getFolderPath());
                    }
                    backupFolderTO.setCreateBy("IA");
                    backupFolderTO.setPolicyName(policyName);
                    logger.info(" " + backupFolderTO.getFolderPath());
                    backUpFolderDAOImpl.insertAParentFolder(backupFolderTO);
                }
            }
        }
    }

    private static void checkPreconditionsForFolderPath(FolderPathElement folderPathElement) {
        if (folderPathElement.getFolderPath().length() < 3) {
            switch (folderPathElement.getFolderPath().length()) {
                case 1: {
                    folderPathElement.setFolderPath(new StringBuffer(folderPathElement.getFolderPath()).append(":\\").toString());
                    break;
                }
                case 2: {
                    folderPathElement.setFolderPath(new StringBuffer(folderPathElement.getFolderPath()).append("\\").toString());
                    break;
                }
                default: {
                    logger.debug("Path after verifying " + folderPathElement.getFolderPath());
                }
            }
        }
    }

    private static void checkAllDrivesSelectedForBackup(List<FolderPathElement> folderPathElements) {
        boolean allDriversSelected = false;
        for (FolderPathElement folderPathElement : folderPathElements) {
            if (!folderPathElement.getFolderPath().contentEquals("ALL")) continue;
            logger.debug("Inside all drives selected");
            allDriversSelected = true;
            break;
        }
        if (allDriversSelected) {
            folderPathElements.clear();
            for (String rootfile : rootFilesList) {
                FolderPathElement folderpathElement = new FolderPathElement();
                folderpathElement.setFolderPath(rootfile);
                folderpathElement.setOsType(SettingHelper.getOsName());
                folderPathElements.add(folderpathElement);
            }
        }
    }

    public static void updateFailCodeToActivityHistory(int errorCode) {
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            backupActivityTO.setFailCode(errorCode);
            backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    private static String backupBatchInitiated(String batchStatus, String batchId, int totalCount, int errorCode, long totalUploadSize, String totalUploadedCount, String crawlTimestamp) {
        String jobType = "BACKUP";
        String curentbatchId = batchId;
        try {
            logger.debug("The status:" + batchStatus + "the count is:" + totalCount);
            curentbatchId = backUpAdapter.sendEmailNotification(batchStatus, SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), curentbatchId, jobType, SettingHelper.getDeviceName(), totalCount, errorCode, SettingHelper.getDeviceUUId(), totalUploadSize, totalUploadedCount, 0, crawlTimestamp);
        }
        catch (Exception e) {
            curentbatchId = "-1";
            logger.trace("" + e);
            logger.error(" Exception inside  put batch " + e.getMessage());
        }
        return curentbatchId;
    }

    public static void sendCurrentStatisticsToServerBeforeExit(String status) {
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (backupActivityTO != null && backupActivityTO.getBatchStatus().equals(BackupLifeCycle.STARTED.toString())) {
            logger.debug("User exit the app or network connection failed. so failed status to be sent");
            backupActivityTO.setBatchStatus(status);
            String batchId = backupActivityTO.getBatchId();
            int errorCode = backupActivityTO.getFailCode();
            logger.debug("The fail code is:" + errorCode);
            long totalUploadSize = backupActivityTO.getTotalUploadSize();
            String uploadedList = backupActivityTO.getBackupUploadCount();
            batchId = PolicyManagementServerHelper.backupBatchInitiated(backupActivityTO.getBatchStatus(), batchId, 0, errorCode, totalUploadSize, uploadedList, backupActivityTO.getBackupActivityTimeStamp());
            if (batchId != null && batchId != "-1") {
                logger.debug("Batch id for this backup is:" + batchId + "status:" + status);
                backupActivityTO.setBatchId(batchId);
                backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
            }
        }
        if (backupActivityTO != null && backupActivityTO.getBackupActivityStatus().equals(CrawlLifecycle.INPROGRESS.toString())) {
            backupActivityTO.setBackupActivityStatus(CrawlLifecycle.STOPPED.toString());
            backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
        }
    }

    private static void storeSystemRoots() {
        if (rootFilesList != null) {
            rootFilesList.clear();
        } else {
            rootFilesList = new HashSet<String>();
        }
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File[] files = File.listRoots();
        logger.debug("List of root folders:" + files.length);
        for (File file : files) {
            if (PolicyManagementServerHelper.isDriveSkip(fsv, file) || PolicyManagementServerHelper.isDriveNotValid(fsv, file)) {
                logger.debug("error reading root files" + file.getAbsolutePath());
                continue;
            }
            rootFilesList.add(file.getAbsolutePath().toLowerCase());
        }
    }

    private static boolean isDriveSkip(FileSystemView fsv, File file) {
        return !fsv.isDrive(file) || !file.canRead() || !file.canWrite();
    }

    private static boolean isDriveNotValid(FileSystemView fsv, File file) {
        return fsv.getSystemTypeDescription(file).equalsIgnoreCase("Removable Disk") || fsv.getSystemTypeDescription(file).equalsIgnoreCase("Network Drive") || fsv.getSystemTypeDescription(file).equalsIgnoreCase("CD Drive");
    }

    public static void createContainerDetalis(BackupPolicyDAOImpl backupPolicyDAOImpl2, List<DeviceContainerElement> deviceContainerElements) {
        if (!deviceContainerElements.isEmpty()) {
            backupPolicyDAOImpl2.deleteContainerDetails();
            for (DeviceContainerElement deviceContainerElement : deviceContainerElements) {
                if (deviceContainerElement == null) continue;
                ContainerDetailsTo containerDetailsTo = new ContainerDetailsTo();
                containerDetailsTo.setPolicyname(deviceContainerElement.getBackupPolicyName());
                containerDetailsTo.setGroupName(deviceContainerElement.getGroupName());
                containerDetailsTo.setContainerName(deviceContainerElement.getContainerName());
                containerDetailsTo.setContainerLocation(deviceContainerElement.getContainerLocation());
                containerDetailsTo.setContainerPassword(deviceContainerElement.getPassword());
                containerDetailsTo.setContainerPort(deviceContainerElement.getPort());
                containerDetailsTo.setContainerType(deviceContainerElement.getContainerType());
                containerDetailsTo.setContainerUserName(deviceContainerElement.getUsername());
                boolean success = backupPolicyDAOImpl.insertContainerDetailsToTable(containerDetailsTo);
                logger.debug("Storing container details to database " + success);
            }
        } else {
            logger.debug("Device element list empty");
        }
    }

    public static String getContainerNamesForSchedule(String policyName, BackupPolicyDAOImpl backupPolicyDAOImpl) {
        StringBuilder containerName = new StringBuilder("");
        List<ContainerDetailsTo> containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(policyName, false);
        for (ContainerDetailsTo container : containerDetailsTos) {
            if ("".equals(containerName.toString())) {
                containerName = containerName.append(container.getContainerName());
                continue;
            }
            containerName = containerName.append("|").append(container.getContainerName());
        }
        return containerName.toString();
    }

    public static String sendServerBackupStatus(BackupAdapter backupAdapter, String status, String processId, String backupSizeOnDisk, int currentStep, boolean isUpdate, String token, String serverBackupStatusId, String recivedEndTime) {
        String recivedBackupStatusId = "";
        String startTime = Long.toString(0L);
        String endTime = Long.toString(0L);
        ContainerBackupStatusTo containerBackupStatusTo = new ContainerBackupStatusTo();
        List<ContainerDetailsTo> containerDetailsTos = backupPolicyDAOImpl.getCurrentContainerDetails(NotificationHelper.getCurrentContainerName(), true);
        if (!containerDetailsTos.isEmpty()) {
            if ("F".equalsIgnoreCase(NotificationHelper.getServerBackupType())) {
                containerBackupStatusTo.setBackupJobType("FULL");
            } else {
                containerBackupStatusTo.setBackupJobType("INCREMENTAL");
            }
            containerBackupStatusTo.setContainerName(NotificationHelper.getCurrentContainerName());
            containerBackupStatusTo.setContainerType(containerDetailsTos.get(0).getContainerType());
            containerBackupStatusTo.setStatus(status);
            containerBackupStatusTo.setProcessId(processId);
            containerBackupStatusTo.setTotalSteps("4");
            containerBackupStatusTo.setBackupSizeOnDiskInMB(backupSizeOnDisk);
            containerBackupStatusTo.setCurrentStep(currentStep);
            if (!isUpdate) {
                startTime = Long.toString(System.currentTimeMillis());
            } else if (!"0".equalsIgnoreCase(recivedEndTime)) {
                endTime = recivedEndTime;
            }
            containerBackupStatusTo.setStartTime(startTime);
            containerBackupStatusTo.setEndTime(endTime);
            try {
                recivedBackupStatusId = backupAdapter.sendCurrentBakupStatus(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), containerBackupStatusTo, isUpdate, token, serverBackupStatusId);
                if (!isUpdate) {
                    NotificationHelper.setCurrentContainerJobId(recivedBackupStatusId);
                }
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("error while sending the server backup status" + e.getMessage());
            }
        } else {
            logger.debug("Container detalis empty");
        }
        logger.debug("Sucessfuly updated bakup status  " + recivedBackupStatusId);
        return recivedBackupStatusId;
    }

    public static DeviceTo getsServerBackupDeviceDetails() {
        String userName = null;
        DeviceTo deviceTo = null;
        try {
            deviceTo = backUpAdapter.getUserForDevice(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.readTokenFromFile(), SettingHelper.getDeviceUUId());
            userName = deviceTo.getUserName();
            logger.debug("Server userName " + userName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.debug("Could not get server user name " + e.getMessage());
        }
        return deviceTo;
    }
}

