/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.adapter.pcb.MultiPartBackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ChunkFileElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.helper.about.SystemInfo;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewBackUpUpload
extends Thread {
    private Logger logger = LoggerFactory.getLogger(NewBackUpUpload.class);
    private final String keyStorePath;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String token;
    private BackupAdapter backUpAdapter = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private boolean isTerminated = false;
    private int uploadCount = 0;
    private String uploadIPForGateway = null;
    private String prevIPForGateway = null;
    private Long totalUploadSize = 0L;
    private String isFileDedup = "";
    private BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    private int serverErrorRetryCounter = 1;
    private final Set<DedupTO> dedupSet;
    private HashMap<String, String> dedupHashMap = new HashMap();
    private NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
    BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    private boolean restart;
    private String batchIdForBackup = "";
    BackupActivityTO backupActivityTO = null;
    BackupPolicyTO currentPolicy = null;
    private long restartId = 1L;
    private String requestURL = "/upload/files/all";
    private String backupType = null;
    private MultiPartBackupAdapter multiPartBackupAdapter = null;
    private static final String FAILED = "FAILED";
    private static final String COMPLETED = "COMPLETED";
    private static final String FALSE = "false";
    private static final String STARTED = "STARTED";

    public NewBackUpUpload(String iP, Integer port, String cn, String token, String backupDBUrl, String keyStorePath, Set<DedupTO> dedupTOs, boolean restartValue, long restartID, String backupType) {
        this.keyStorePath = keyStorePath;
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(backupDBUrl);
        this.uploadIP = iP;
        this.cloudName = cn;
        this.backUpAdapter = new BackupAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
        this.dedupSet = dedupTOs;
        this.restart = restartValue;
        this.restartId = restartID;
        this.backupType = backupType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.uploadCount = 0;
        this.getCurrentBackupActivityAndBackupPolicy();
        ArrayList<BackupTO> backupTOs = new ArrayList<BackupTO>();
        this.logger.info("newbackupupload  backUpImageDAOImpl:" + this.backUpImageDAOImpl);
        this.logger.info("newbackupupload  serverErrorRetryCounter:" + this.serverErrorRetryCounter);
        String currentIP = null;
        if (("true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy()) || "true".equalsIgnoreCase(SettingHelper.getServerBackupLicensed())) && "true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
            SettingHelper.setMaxVersionsToKeep(this.getMaxVersionsFromPolicy());
            try {
                this.logger.debug("$$$$$$backup type>>>>>>>>" + this.backupType);
                this.uploadIPForGateway = PolicyManagementServerHelper.getPrivacyGatewayIP(this.backupType);
                this.logger.debug("Nearest Gateway:" + this.uploadIPForGateway);
                if (this.uploadIPForGateway == null) {
                    this.logger.error("Error in get privacy gateway");
                    this.updateFailReasonInActivityTable(2304);
                    this.updateSystrayToolTipNotification("Privacy Gateway Not Found", "Server could not connect to privacy gateway");
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Error in get privacy gateway", (Throwable)e);
                this.updateFailReasonInActivityTable(2304);
                this.updateSystrayToolTipNotification("Privacy Gateway Not Found", "Server could not connect to privacy gateway");
                return;
            }
            currentIP = this.uploadIPForGateway;
            if (this.prevIPForGateway == null) {
                this.prevIPForGateway = this.uploadIPForGateway;
            }
            if (this.dedupSet != null && !this.dedupSet.isEmpty()) {
                for (DedupTO dedupTO : this.dedupSet) {
                    this.dedupHashMap.put(dedupTO.getMd5Value(), dedupTO.getBackupId());
                }
                this.logger.debug("Size of dedup hashMap" + this.dedupHashMap.size());
            }
        }
        int crawlFileCount = this.newBackUpCrawlDAOImpl.getCountOfTable(true);
        if (this.restart) {
            ++this.restartId;
            this.logger.debug("Inside restart so id is: " + this.restartId);
        } else {
            this.restartId = 1L;
            this.logger.debug("Fresh backup so id is:" + this.restartId);
        }
        try {
            if (this.multiPartBackupAdapter == null) {
                this.multiPartBackupAdapter = new MultiPartBackupAdapter(this.uploadIPForGateway, null, this.requestURL, this.cloudName, this.keyStorePath);
            } else {
                this.logger.debug("connection not null>>>>>>>>");
            }
        }
        catch (Exception e1) {
            this.logger.trace("" + e1);
            this.logger.error("error while calling multipart backup adapter" + e1.getMessage());
            return;
        }
        while (this.restartId <= (long)crawlFileCount) {
            block41: {
                BackupTO tempUploadFileTO = this.newBackUpCrawlDAOImpl.getBackupFileFromTableWithID(this.restartId);
                if (tempUploadFileTO != null) {
                    try {
                        this.updateRestartId();
                        tempUploadFileTO.setClientData(this.checkForMacBasePath(tempUploadFileTO.getClientData()));
                        if (this.isTerminated) {
                            this.logger.error("Terminated: ", (Object)this.isTerminated);
                            break;
                        }
                        if (!tempUploadFileTO.isFolder()) {
                            this.backupStatisticsDAOImpl.insertFileNameIntoTable(tempUploadFileTO);
                        }
                        boolean isNormalUpload = true;
                        boolean uploadViaGateway = false;
                        int pftSize = 1;
                        if ("true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy())) {
                            int systemUsage = (int)this.checkSystemUsage();
                            if (systemUsage >= this.getCpuUtilFromUser()) {
                                this.logger.debug("Machine utils Exceeded");
                                PolicyManagementServerHelper.updateFailCodeToActivityHistory(912);
                                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(FAILED);
                                this.updateSystrayToolTipNotification("Machine Utils Exceeded", "Your machine utilization exceeded the policy");
                                break;
                            }
                            if ("true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
                                uploadViaGateway = true;
                                isNormalUpload = false;
                            }
                            pftSize = this.getCurrentPolicyPFTSize();
                        }
                        boolean currentFileChunkable = false;
                        if (pftSize != 0) {
                            currentFileChunkable = this.isFileChunkable(tempUploadFileTO, pftSize);
                        }
                        currentFileChunkable = this.checkDedup(tempUploadFileTO, currentFileChunkable);
                        this.logger.debug("File chunkable: " + currentFileChunkable);
                        if (currentFileChunkable) {
                            String chunkPath;
                            if (!this.handleFileExist(tempUploadFileTO.getClientData())) {
                                this.updateUI("", this.uploadCount);
                                this.backupStatisticsDAOImpl.updateFailedStatusFileNameIntoTable(tempUploadFileTO, "File Not Found");
                                backupTOs.add(tempUploadFileTO);
                                tempUploadFileTO.setBkupStatus(FAILED);
                                this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                break block41;
                            }
                            String osType = System.getProperty("os.name");
                            if (osType.toLowerCase().contains("win")) {
                                chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
                                this.createChunkFolderAndHideIt(chunkPath);
                            } else {
                                chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
                                this.createChunkFolder(chunkPath);
                            }
                            String sourcePath = tempUploadFileTO.getClientData();
                            String destinationPath = chunkPath + File.separator;
                            File file = null;
                            try {
                                file = new File(destinationPath);
                            }
                            catch (Exception e) {
                                this.logger.trace("" + e);
                                this.logger.error("File not accessible" + e.getMessage());
                                backupTOs.add(tempUploadFileTO);
                                tempUploadFileTO.setBkupStatus(FAILED);
                                this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                break block41;
                            }
                            boolean isFileUploaded = false;
                            if (file != null) {
                                isFileUploaded = this.splitAndWriteORNormalUpload(backupTOs, tempUploadFileTO, sourcePath, destinationPath, file, isNormalUpload);
                            }
                            if (isFileUploaded || this.isTerminated) break block41;
                            List<String> listOfChunkFiles = NewBackUpUpload.getExistingFileNames(destinationPath);
                            if (listOfChunkFiles.isEmpty()) {
                                this.logger.debug("List of chunks size is zero");
                                backupTOs.add(tempUploadFileTO);
                                FileUtils.cleanDirectory((File)file);
                                this.deleteChunkFolder(file);
                                tempUploadFileTO.setBkupStatus(FAILED);
                                this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                break block41;
                            }
                            ChunkFileElement chunkFileElement = new ChunkFileElement();
                            chunkFileElement.setFileChunks(listOfChunkFiles);
                            String prevBackupId = "";
                            this.getPrevBackupId(tempUploadFileTO);
                            boolean uploadChunkResponse = this.uploadChunkFilesNew(tempUploadFileTO, destinationPath, chunkFileElement, uploadViaGateway);
                            if (!uploadChunkResponse) {
                                backupTOs.add(tempUploadFileTO);
                                FileUtils.cleanDirectory((File)file);
                                this.deleteChunkFolder(file);
                                tempUploadFileTO.setBkupStatus(FAILED);
                                this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                break block41;
                            }
                            if (!tempUploadFileTO.isFolder()) {
                                ++this.uploadCount;
                                this.updateUI(tempUploadFileTO.getClientData(), this.uploadCount);
                                this.updateTotalUploadSize(tempUploadFileTO);
                                this.backupStatisticsDAOImpl.updateStatusFileNameIntoTable(tempUploadFileTO);
                            }
                            this.logger.debug("Chunk File merged successfully  ");
                            FileUtils.cleanDirectory((File)file);
                            this.deleteChunkFolder(file);
                            tempUploadFileTO.setBkupStatus(COMPLETED);
                            this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                            this.uploadIPForGateway = currentIP;
                            if (this.isTerminated) break;
                            if (!uploadViaGateway) {
                                String ipForStoreFileInExternalStorage = this.uploadIP;
                                int response = this.backUpAdapter.storeFileInExternalStorage(tempUploadFileTO, ipForStoreFileInExternalStorage, null, this.cloudName, SettingHelper.readTokenFromFile(), chunkFileElement, SettingHelper.getOsName(), chunkFileElement.getDeviceUUID(), "", SettingHelper.getUserName().toLowerCase(), uploadViaGateway, prevBackupId, this.prevIPForGateway, SettingHelper.getMaxVersionsToKeep());
                                if (response != 200) {
                                    this.logger.error(" Chunk File not merged. ");
                                    backupTOs.add(tempUploadFileTO);
                                    FileUtils.cleanDirectory((File)file);
                                    this.deleteChunkFolder(file);
                                    break block41;
                                }
                                if (!tempUploadFileTO.isFolder()) {
                                    ++this.uploadCount;
                                    this.updateUI(tempUploadFileTO.getClientData(), this.uploadCount);
                                    this.updateTotalUploadSize(tempUploadFileTO);
                                    this.backupStatisticsDAOImpl.updateStatusFileNameIntoTable(tempUploadFileTO);
                                }
                                this.logger.debug("Chunk File merged successfully ");
                                FileUtils.cleanDirectory((File)file);
                                this.deleteChunkFolder(file);
                                tempUploadFileTO.setBkupStatus(COMPLETED);
                                this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
                                this.uploadIPForGateway = currentIP;
                            }
                            isNormalUpload = false;
                            uploadViaGateway = false;
                        }
                        this.logger.debug("Normal Upload  " + isNormalUpload);
                        if (isNormalUpload && !this.uploadFile(tempUploadFileTO)) {
                            backupTOs.add(tempUploadFileTO);
                            break block41;
                        }
                        if (uploadViaGateway && !this.uploadFileViaGateway(tempUploadFileTO)) {
                            backupTOs.add(tempUploadFileTO);
                        }
                    }
                    catch (Exception e) {
                        this.logger.trace("" + e);
                        this.logger.error("Exception Occurred while backing up  file: ", (Object)e.getMessage());
                    }
                }
            }
            ++this.restartId;
        }
        try {
            this.multiPartBackupAdapter.finish();
        }
        catch (CrawlAdapterException e) {
            this.logger.trace("" + (Object)((Object)e));
            this.logger.error("error in multipart backup adapter finish call" + e.getMessage());
        }
        this.newBackUpCrawlDAOImpl.updateFailedEventForBackupList(backupTOs);
        this.updateUI("", this.uploadCount);
        NotificationHelper.setFileBeingBackedup(null);
    }

    private void getPrevBackupId(BackupTO tempUploadFileTO) {
        try {
            this.backUpAdapter.getBackupId(this.uploadIP, SettingHelper.getDeviceUUId(), tempUploadFileTO, SettingHelper.readTokenFromFile(), this.batchIdForBackup);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in get previous backup id" + e.getMessage());
        }
    }

    private boolean checkDedup(BackupTO tempUploadFileTO, boolean currentFileChunkable) {
        boolean isCurrentFileChunkable = currentFileChunkable;
        if ("true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy()) && !tempUploadFileTO.isFolder()) {
            this.isFileDedup = "";
            this.isFileDedup = this.checkDedupOfFile(tempUploadFileTO);
            if (!this.isFileDedup.isEmpty()) {
                this.logger.debug("File Dedup value:" + this.isFileDedup);
                isCurrentFileChunkable = false;
            }
        }
        return isCurrentFileChunkable;
    }

    private int getMaxVersionsFromPolicy() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        if (currentDetails != null && !currentDetails.isEmpty()) {
            BackupPolicyTO policyToUse = currentDetails.get(0);
            this.logger.debug("MaxVersions to Keep." + policyToUse.getMaxVersions());
            if (!StringUtils.isEmpty((String)policyToUse.getLegalHoldEnabled())) {
                SettingHelper.setIsLegalHoldEnabled(policyToUse.getLegalHoldEnabled());
            } else {
                SettingHelper.setIsLegalHoldEnabled(FALSE);
            }
            return policyToUse.getMaxVersions();
        }
        return 0;
    }

    private String checkDedupOfFile(BackupTO tempUploadFileTO) {
        String fileDedupFlag = "";
        String backupId = this.dedupHashMap.get(tempUploadFileTO.getMd5checksum());
        if (backupId != null) {
            fileDedupFlag = backupId;
        }
        return fileDedupFlag;
    }

    private boolean splitAndWriteORNormalUpload(List<BackupTO> backupTOs, BackupTO tempUploadFileTO, String sourcePath, String destinationPath, File file, boolean isNormalUpload) throws IOException {
        boolean isDiskSpaceAvailable = true;
        try {
            this.logger.debug("inside before split and backup>>>>>>>>>");
            this.splitAndWrite(sourcePath, destinationPath);
        }
        catch (Exception ex) {
            this.logger.error("Inside split and write catch skipping chunk file " + ex);
            ex.getMessage();
            isDiskSpaceAvailable = false;
        }
        boolean isFileUploaded = false;
        if (!isDiskSpaceAvailable) {
            try {
                FileUtils.cleanDirectory((File)file);
                FileUtils.forceDelete((File)file);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("error in cleaninig directory" + e.getMessage());
            }
            isFileUploaded = this.uploadIfLessDiskspace(backupTOs, tempUploadFileTO, isFileUploaded, isNormalUpload);
        }
        return isFileUploaded;
    }

    private void sleepForOneMinute() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Thread interrupted in chunk response empty block" + e.getMessage());
        }
    }

    private boolean uploadChunkFilesNew(BackupTO tempUploadFileTO, String destinationPath, ChunkFileElement chunkFileElement, boolean viaGateway) throws NoSuchAlgorithmException, FileNotFoundException, InvalidKeyException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.updateUI(tempUploadFileTO.getClientData(), this.uploadCount);
        if (tempUploadFileTO.getBkupStatus() == null) {
            tempUploadFileTO.setBkupStatus(STARTED);
            tempUploadFileTO.setGatewayIP(this.uploadIPForGateway);
            this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(tempUploadFileTO);
            this.serverErrorRetryCounter = 1;
        }
        String isAchunkFile = "true";
        String nearestGatewayIP = viaGateway ? this.uploadIPForGateway : this.uploadIP;
        for (String chunk : chunkFileElement.getFileChunks()) {
            chunkFileElement.setDeviceUUID(SettingHelper.getDeviceUUId());
            chunkFileElement.setChecksum(MD5Generator.generateMD5OfFile((File)new File(destinationPath + chunk)));
            chunkFileElement.setFileCompletePath(destinationPath + chunk);
            chunkFileElement.setFileName(chunk);
            File file = new File(chunkFileElement.getFileCompletePath());
            this.multiPartBackupAdapter.addFormField();
            this.addHeaderToMultipart(tempUploadFileTO, nearestGatewayIP, new File(tempUploadFileTO.getClientData()));
            this.addHeaderToMultipartforChunks(chunkFileElement);
            this.multiPartBackupAdapter.addHeaderField("isAChunkFile", isAchunkFile);
            this.multiPartBackupAdapter.addFilePart(file);
        }
        this.sendChunkValues(tempUploadFileTO, destinationPath, chunkFileElement, nearestGatewayIP);
        return true;
    }

    private void sendChunkValues(BackupTO tempUploadFileTO, String destinationPath, ChunkFileElement chunkFileElement, String nearestGatewayIP) {
        this.multiPartBackupAdapter.addFormField();
        this.addHeaderToMultipart(tempUploadFileTO, nearestGatewayIP, new File(tempUploadFileTO.getClientData()));
        this.addHeaderToMultipartforChunks(chunkFileElement);
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", FALSE);
        File chunkValuefile = null;
        try {
            chunkValuefile = new File(destinationPath + "chunkvalues");
            if (!chunkValuefile.exists()) {
                chunkValuefile.createNewFile();
            }
            String fileChunks = StringUtils.join((Collection)chunkFileElement.getFileChunks(), (char)',');
            FileWriter fileWriter = new FileWriter(chunkValuefile);
            fileWriter.write(fileChunks);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error in send chunk value method" + e.getMessage());
        }
        this.multiPartBackupAdapter.addFilePart(chunkValuefile);
    }

    private boolean uploadIfLessDiskspace(List<BackupTO> backupTOs, BackupTO tempUploadFileTO, boolean isFileUploaded, boolean isNormalUpload) throws IOException {
        boolean fileUploadedStat = isFileUploaded;
        if (isNormalUpload) {
            if (!this.uploadFile(tempUploadFileTO)) {
                backupTOs.add(tempUploadFileTO);
                return true;
            }
        } else {
            if (!this.uploadFileViaGateway(tempUploadFileTO)) {
                backupTOs.add(tempUploadFileTO);
                return true;
            }
            fileUploadedStat = true;
        }
        return fileUploadedStat;
    }

    private void createChunkFolderAndHideIt(String chunkPath) {
        try {
            Process proc;
            int exitVal;
            Runtime rt = Runtime.getRuntime();
            boolean success = this.createFolder(chunkPath);
            if (success && (exitVal = (proc = rt.exec("attrib +h " + chunkPath)).waitFor()) != 0) {
                Process proc1 = rt.exec("attrib +h " + chunkPath);
                proc1.waitFor();
            }
        }
        catch (Exception t) {
            this.logger.trace("" + t);
            this.logger.error("Make Hidden Folder exception" + t.getMessage());
        }
    }

    private void createChunkFolder(String chunkPath) {
        try {
            this.createFolder(chunkPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in create chunk folder" + e.getMessage());
        }
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Chunk folder deletion Failed" + e.getMessage());
                }
                this.logger.debug("Chunk folder deleted successfully");
            } else {
                try {
                    FileUtils.cleanDirectory((File)file);
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("error while cleaning directory" + e.getMessage());
                }
            }
        }
    }

    private boolean isFileChunkable(BackupTO tempUploadFileTO, int pftSize) {
        boolean isChunkable = false;
        int chunkableSizeFromPolicy = this.getChunkableSize();
        File file = new File(tempUploadFileTO.getClientData());
        if (file.isDirectory()) {
            return isChunkable;
        }
        long fileSizeinBytes = file.length();
        float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
        if (fileSizeinMb >= (float)pftSize && fileSizeinMb > (float)chunkableSizeFromPolicy) {
            isChunkable = true;
        }
        return isChunkable;
    }

    private int getCurrentPolicyPFTSize() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO policyToUse = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            policyToUse = currentDetails.get(0);
        }
        if (policyToUse != null && "true".equals(policyToUse.getPftEnabled())) {
            int pftSize = policyToUse.getPftSize();
            return pftSize;
        }
        return 0;
    }

    private int getCpuUtilFromUser() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO policyToUse = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            policyToUse = currentDetails.get(0);
        }
        if (policyToUse != null) {
            return policyToUse.getCpuUtilization();
        }
        return 80;
    }

    public double checkSystemUsage() {
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getSystemMemory();
            this.logger.debug("System memory percentage is:" + percentage);
            return percentage;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error in checking system usage" + e.getMessage());
            return 0.0;
        }
    }

    private boolean uploadFile(BackupTO fileToUpload) {
        this.updateUI(fileToUpload.getClientData(), this.uploadCount);
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = fileToUpload.getClientData();
        if (!this.handleFileExist(absPath)) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (this.handleHttpRequests(fileToUpload)) {
            BackupTO backupTo = fileToUpload;
            if (!backupTo.isFolder()) {
                ++this.uploadCount;
                this.updateUI(backupTo.getClientData(), this.uploadCount);
                this.updateTotalUploadSize(backupTo);
            }
            backupTo.setBkupStatus(COMPLETED);
            backupTo.setGatewayIP(this.uploadIP);
            this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(backupTo);
            return true;
        }
        return false;
    }

    private void updateUI(String fileName, int uploadCount2) {
        NotificationHelper.setFileBeingBackedup(fileName);
        NotificationHelper.setTotalBackupCount(uploadCount2);
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        if (!file.exists()) {
            this.logger.debug("File doesnt exist: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    private boolean handleFileModified(String absPath, long lastModifiedTimestamp) {
        File file = new File(absPath);
        if (file.isDirectory()) {
            return true;
        }
        if (file.lastModified() > lastModifiedTimestamp) {
            this.logger.debug("File modified: " + file.getAbsoluteFile());
            return false;
        }
        return true;
    }

    private boolean handleHttpRequests(BackupTO fileToUpload) {
        int retrycount = 0;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.uploadIP;
        this.logger.debug("Trying to upload file: " + fileToUpload.getClientData());
        NotificationHelper.setFileBeingBackedup(fileToUpload.getClientData());
        fileToUpload.setBkupStatus(STARTED);
        fileToUpload.setGatewayIP(currentUploadIPToUse);
        this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(fileToUpload);
        String filePath = fileToUpload.getClientData();
        while (true) {
            boolean retry = false;
            try {
                int response = this.backUpAdapter.uploadBackUpFile(fileToUpload, currentUploadIPToUse, this.port, filePath, this.token);
                if (response != 3 && response != 4) {
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                    } else if (response == 1006) {
                        this.updateSystrayToolTipNotification("Cloud disk space full", " Your cloud has reached its maximum storage limit.");
                        NotificationHelper.cloudSpaceExceeded = true;
                        this.isTerminated = true;
                    } else if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                    } else if (response == 1008) {
                        this.isTerminated = true;
                    } else if (response == 1007) {
                        this.updateSystrayToolTipNotification("Upload failed  ", " The file " + fileToUpload.getFileName() + " could not be uploaded due to space restrictions.");
                    } else if (response == 417) {
                        this.updateSystrayToolTipNotification("User Limit Exceeded", "The cloud space limit for backup has reached");
                    }
                    return false;
                }
                NotificationHelper.cloudSpaceExceeded = false;
                if (currentUploadIPToUse != null && !currentUploadIPToUse.equals(this.uploadIP)) {
                    this.uploadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (CrawlAdapterException e) {
                this.logger.error("Exception occurred  CrawlAdapterException: ", (Throwable)e);
                try {
                    retry = true;
                    ++retrycount;
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("InterruptedException" + ex.getMessage());
                }
                if (retrycount <= 14 || (currentUploadIPToUse = this.updateIpToUse(0, 1, currentUploadIPToUse)) != null || retrycount <= 15) continue;
                this.logger.debug("Current Upload IP To Use is null");
                return false;
                if (retry && retrycount < 15) continue;
                return false;
            }
            break;
        }
    }

    public abstract void updateSystrayToolTipNotification(String var1, String var2);

    private String updateIpToUse(int gaeLocal, int gaePublic, String currentUploadIPToUse) {
        String[] ipToUse = new String[3];
        String[] ports = new String[2];
        String currentUploadIPToBeUsed = currentUploadIPToUse;
        boolean isIpFound = NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)this.keyStorePath, (String[])ipToUse, (String[])ports);
        if (!isIpFound) {
            if (!PropertyHelper.MAIN_EBMS_DOMAIN.isEmpty() && "true".equalsIgnoreCase(SettingHelper.getIsEnableBackupPolicy())) {
                BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
                String bluVaultIP = bluVaultIPHelper.getNearestBluVaultByResponseTime();
                if (!StringUtils.isEmpty((String)bluVaultIP)) {
                    SettingHelper.setGaeLocalIpAddress(bluVaultIP);
                    SettingHelper.setPublicIpAddress(bluVaultIP);
                    SettingHelper.setCurrentCloudIpAddress(bluVaultIP);
                }
                currentUploadIPToBeUsed = SettingHelper.getCurrentCloudIpAddress();
            }
            return currentUploadIPToBeUsed;
        }
        if (ipToUse[0] == null && ipToUse[1] == null) {
            return null;
        }
        if (ipToUse[gaeLocal] != null && !ipToUse[gaeLocal].equals(currentUploadIPToBeUsed)) {
            currentUploadIPToBeUsed = ipToUse[gaeLocal];
            this.port = null;
        } else if (ipToUse[gaeLocal] != null) {
            currentUploadIPToBeUsed = ipToUse[gaePublic];
            this.port = null;
        }
        return currentUploadIPToBeUsed;
    }

    public void abortUploadProcesses() {
        if (this.backUpAdapter != null) {
            this.backUpAdapter.cancelHttpPut();
        }
    }

    public void splitAndWrite(String sourceFilePath, String destinationPath) throws IOException, NoSuchAlgorithmException {
        this.logger.debug("Inside chunk file split and write");
        int chunkableSizeFromPolicy = this.getChunkableSize();
        int chunkSize = chunkableSizeFromPolicy * 0x100000;
        File willBeRead = new File(sourceFilePath);
        if (!willBeRead.exists()) {
            return;
        }
        long fileSize = willBeRead.length();
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        int numberOfChunks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            this.logger.debug("Inside split and write function");
            while (totalBytesRead < fileSize) {
                int bytesRead;
                String partName = String.valueOf(numberOfChunks);
                long bytesRemaining = fileSize - totalBytesRead;
                if (bytesRemaining < (long)chunkSize) {
                    chunkSize = Integer.parseInt(String.valueOf(bytesRemaining));
                    this.logger.debug("CHUNK SIZE: " + chunkSize);
                }
                if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[chunkSize], 0, chunkSize)) > 0) {
                    totalBytesRead += (long)bytesRead;
                    ++numberOfChunks;
                }
                this.write(temporary, destinationPath + partName);
                File tempFile = new File(destinationPath + partName);
                String tempFileMd5 = MD5Generator.generateMD5OfFile((File)tempFile);
                String newName = String.format("part%06d.%s", numberOfChunks, tempFileMd5);
                File renameFile = new File(destinationPath + newName);
                tempFile.renameTo(renameFile);
                md5AndFileValueMap.put(tempFileMd5, tempFile.getPath());
            }
            this.logger.debug("End of split and write function");
        }
    }

    private int getChunkableSize() {
        int chunkableSizeFromPolicy = 4;
        if (this.currentPolicy != null) {
            chunkableSizeFromPolicy = this.currentPolicy.getChunkSize();
        }
        return chunkableSizeFromPolicy;
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        ((OutputStream)output).close();
    }

    public static List<String> getExistingFileNames(String path) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = new File(path).listFiles();
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }

    private boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception while creating folder" + e.getMessage());
            }
        }
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    private boolean uploadFileViaGateway(BackupTO fileToUpload) {
        this.updateUI(fileToUpload.getClientData(), this.uploadCount);
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = fileToUpload.getClientData();
        if (!this.handleFileExist(absPath)) {
            this.updateUI("", this.uploadCount);
            this.backupStatisticsDAOImpl.updateFailedStatusFileNameIntoTable(fileToUpload, "File Not Found");
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.updateUI("", this.uploadCount);
            this.backupStatisticsDAOImpl.updateFailedStatusFileNameIntoTable(fileToUpload, "File Modified");
            return false;
        }
        if (this.handleHttpRequestsFromGateway(fileToUpload)) {
            if (!fileToUpload.isFolder()) {
                ++this.uploadCount;
                this.updateUI(fileToUpload.getClientData(), this.uploadCount);
                this.updateTotalUploadSize(fileToUpload);
                this.backupStatisticsDAOImpl.updateStatusFileNameIntoTable(fileToUpload);
            }
            fileToUpload.setBkupStatus(COMPLETED);
            this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(fileToUpload);
            return true;
        }
        fileToUpload.setBkupStatus(FAILED);
        this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(fileToUpload);
        return false;
    }

    private void checkChunkFolderExistsAndDelete(BackupTO fileToUpload) {
        if (SettingHelper.getOsName().contains("win")) {
            String chunkPath = new StringBuffer().append(fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
            File file = new File(chunkPath);
            this.deleteChunkFolder(file);
        } else {
            String chunkPath = new StringBuffer().append(fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
            File file = new File(chunkPath);
            this.deleteChunkFolder(file);
        }
    }

    private boolean handleHttpRequestsFromGateway(BackupTO fileToUpload) {
        int response = 0;
        int retrycount = 0;
        this.serverErrorRetryCounter = 1;
        String currentUploadIPToUse = this.uploadIPForGateway;
        NotificationHelper.setFileBeingBackedup(fileToUpload.getClientData());
        if (fileToUpload.getBkupStatus() == null) {
            fileToUpload.setBkupStatus(STARTED);
            fileToUpload.setGatewayIP(this.uploadIPForGateway);
            this.newBackUpCrawlDAOImpl.updateEventToNewBackupCrawlTable(fileToUpload);
        }
        String filePath = fileToUpload.getClientData();
        while (true) {
            try {
                if (fileToUpload.isFolder()) {
                    return true;
                }
                File file = new File(filePath);
                this.addFilePart(fileToUpload, response, currentUploadIPToUse, file);
                return true;
            }
            catch (CrawlAdapterException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Exception occurred  CrawlAdapterException: " + e.getMessage());
                this.sleepForOneMinute();
                currentUploadIPToUse = this.getNearestGateway(currentUploadIPToUse);
                if (++retrycount <= 30) continue;
                this.logger.debug("Current Upload IP To Use is null");
                this.updateFailReasonInActivityTable(909);
                this.isTerminated = true;
                return false;
                if (retrycount < 30) continue;
                this.isTerminated = true;
                return false;
            }
            break;
        }
    }

    private String getNearestGateway(String currentUploadIPToUse) {
        String ipToUse = null;
        try {
            int responseForPing = this.backUpAdapter.pingGatewayIP(currentUploadIPToUse);
            if (responseForPing != 200) {
                ipToUse = PolicyManagementServerHelper.getPrivacyGatewayIP(this.backupType);
                this.logger.debug("The PG Gateway IP in catch" + ipToUse);
            }
            this.multiPartBackupAdapter = new MultiPartBackupAdapter(ipToUse, this.port, this.requestURL, this.cloudName, this.keyStorePath);
        }
        catch (Exception ex) {
            this.logger.trace("" + ex);
            this.logger.error("Error in get privacy gatewayip" + ex.getMessage());
        }
        return ipToUse;
    }

    private void addFilePart(BackupTO fileToUpload, int response, String currentUploadIPToUse, File file) {
        try {
            this.logger.debug("Response for upload via Gateway:" + response);
            this.multiPartBackupAdapter.addFormField();
            this.addHeaderToMultipart(fileToUpload, currentUploadIPToUse, file);
            this.multiPartBackupAdapter.addFilePart(file);
        }
        catch (CrawlAdapterException e2) {
            this.logger.trace("" + (Object)((Object)e2));
            this.logger.error("CrawlAdapterException" + e2.getMessage());
        }
    }

    private void addHeaderToMultipart(BackupTO fileToUpload, String currentUploadIPToUse, File file) {
        this.logger.debug("adding header>>>>>>>>>>>");
        this.multiPartBackupAdapter.addHeaderField("gatewayName", currentUploadIPToUse);
        this.multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        this.multiPartBackupAdapter.addHeaderField("dedupifiedBackupId", this.isFileDedup);
        this.multiPartBackupAdapter.addHeaderField("maxVersions", String.valueOf(SettingHelper.getMaxVersionsToKeep()));
        this.multiPartBackupAdapter.addHeaderField("is-base-folder", String.valueOf(fileToUpload.isBaseFolder()));
        this.multiPartBackupAdapter.addHeaderField("is-folder", String.valueOf(fileToUpload.isFolder()));
        this.multiPartBackupAdapter.addHeaderField("is-exists", String.valueOf(true));
        this.multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        this.multiPartBackupAdapter.addHeaderField("modified", String.valueOf(fileToUpload.getLastModifiedTimestamp()));
        this.multiPartBackupAdapter.addHeaderField("backupBatchId", this.batchIdForBackup);
        this.multiPartBackupAdapter.addHeaderField("userUnderLegalHold", FALSE);
        this.multiPartBackupAdapter.addHeaderField("userName", SettingHelper.getUserName().toLowerCase());
        this.multiPartBackupAdapter.addHeaderField("deviceUUID", SettingHelper.getDeviceUUId());
        this.multiPartBackupAdapter.addHeaderField("file-path", fileToUpload.getAbstractFilePath());
        this.multiPartBackupAdapter.addHeaderField("file-name", fileToUpload.getFileName());
        this.multiPartBackupAdapter.addHeaderField("cloudName", this.cloudName);
        this.multiPartBackupAdapter.addHeaderField("prevGatewayName", this.prevIPForGateway);
        this.multiPartBackupAdapter.addHeaderField("token", this.token);
        this.multiPartBackupAdapter.addHeaderField("osType", SettingHelper.getOsName());
        this.multiPartBackupAdapter.addHeaderField("file-size", String.valueOf(file.length()));
        this.multiPartBackupAdapter.addHeaderField("restartId", String.valueOf(this.restartId));
    }

    private void addHeaderToMultipartforChunks(ChunkFileElement chunkFileElement) {
        this.logger.debug("adding header>>>>>>>>>>>");
        this.multiPartBackupAdapter.addHeaderField("fileChunkNamesa", "");
        this.multiPartBackupAdapter.addHeaderField("chunkFileMD5", chunkFileElement.getChecksum());
        this.logger.debug("chunk Md5 checkSum>>>>" + chunkFileElement.getChecksum());
        this.multiPartBackupAdapter.addHeaderField("chunkFileName", chunkFileElement.getFileName());
        this.multiPartBackupAdapter.addHeaderField("isNormalFile", FALSE);
    }

    private void updateFailReasonInActivityTable(int statusCode) {
        this.backupActivityTO.setFailCode(statusCode);
        this.backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(this.backupActivityTO);
    }

    private void getCurrentBackupActivityAndBackupPolicy() {
        BackupPolicyDAOImpl backupPolicyDAOImpl;
        List<BackupPolicyTO> currentDetails;
        this.backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (this.backupActivityTO != null) {
            this.batchIdForBackup = this.backupActivityTO.getBatchId();
            this.logger.debug("Backup batch ID:" + this.batchIdForBackup);
        }
        if ((currentDetails = (backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl())).getBackupPolicyDetails()) != null && !currentDetails.isEmpty()) {
            this.currentPolicy = currentDetails.get(0);
            this.logger.debug("Chunk size to keep." + this.currentPolicy.getChunkSize());
            if (this.currentPolicy.getChunkSize() == 0) {
                this.currentPolicy.setChunkSize(4);
            }
        }
    }

    private void updateTotalUploadSize(BackupTO backupTO) {
        if (this.backupActivityTO != null) {
            long fileSize = backupTO.getFileSize();
            this.totalUploadSize = this.totalUploadSize + fileSize;
            this.logger.debug("Total uploading size till now:" + this.totalUploadSize);
            NotificationHelper.setTotalUploadSize(this.totalUploadSize);
            this.backupActivityTO.setTotalUploadSize(this.totalUploadSize.longValue());
            this.backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp());
            this.backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(this.backupActivityTO);
        }
    }

    private void updateRestartId() {
        this.backupActivityTO.setRestartID(this.restartId);
        this.backupActivityHistoryDAOImpl.updateRestartIdINBackupActivityHistoryTable(this.backupActivityTO);
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    String getFileSnapshotPath(String path) {
        String fileSnapshotPath = SettingHelper.getSnapFolderPath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + path.substring(0, 1) + "_drive" + path.substring(2);
        if (!new File(fileSnapshotPath).exists()) {
            this.logger.debug("snap shot for the file does not exist  path:" + fileSnapshotPath);
            fileSnapshotPath = path;
        }
        this.logger.debug("returning file snap shot path:" + fileSnapshotPath);
        return fileSnapshotPath;
    }
}

