/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.BackupCrawlDAO;
import com.parablu.epa.core.to.BackUpCrawlFileTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupCrawlDAOImpl
extends BaseDAO
implements BackupCrawlDAO {
    private Logger logger = LoggerFactory.getLogger(BackupCrawlDAOImpl.class);
    private static final String DELETEFROM = "delete from ";
    private static final String SQLEXCEPTION_WHILE_DELETING = "SQLException while delete";

    public BackupCrawlDAOImpl(String uRL) {
        super(uRL);
    }

    public boolean createBackUpCrawlTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_FOLDER_CRAWL_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while create backupCrawl table", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean insertFileNameIntoTable(File file) {
        String query = "insert into CRAWLTABLE_(FileName,filepath) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into CRAWLTABLE_(FileName,filepath) values(?,?);");
                this.statement.setString(1, file.getName());
                this.statement.setString(2, file.getAbsolutePath());
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while insert parent folder into backup crawl table", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getCrawlBackUpFiles() {
        String query = "select * from CRAWLTABLE_";
        ArrayList<BackUpCrawlFileTO> files = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from CRAWLTABLE_");
                resultSet = this.statement.executeQuery();
                files = new ArrayList<BackUpCrawlFileTO>();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                        backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                        backUpCrawlFileTO.setId(resultSet.getInt("Id"));
                        files.add(backUpCrawlFileTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while seelct from backup crawl tabel:", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set while seelct from backup crawl tabel :" + e);
                    }
                }
            }
            this.closeConnection();
        }
        return files;
    }

    public boolean clearTable(List<BackUpCrawlFileTO> crawlFileTOs) {
        String query = "delete from CRAWLTABLE_ where Id in (" + this.fetchIds(crawlFileTOs) + ")";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    private String fetchIds(List<BackUpCrawlFileTO> crawlFileTO) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (BackUpCrawlFileTO upCrawlFileTO : crawlFileTO) {
            sb.append(prefix);
            prefix = ",";
            sb.append(upCrawlFileTO.getId());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountOfTable() {
        String query = "SELECT COUNT(*) FROM CRAWLTABLE_ where IsFolder = 'false';";
        this.statement = null;
        ResultSet resultSet = null;
        int count = 0;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("SELECT COUNT(*) FROM CRAWLTABLE_ where IsFolder = 'false';");
                resultSet = this.statement.executeQuery();
                while (resultSet.next()) {
                    count = resultSet.getInt(1);
                }
                resultSet.close();
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while counting backup crawl table", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException exception) {
                        this.logger.error("SQLException while closing result set for counting backup crawl table" + exception);
                    }
                }
            }
            this.closeConnection();
        }
        return count;
    }

    public boolean clearEntireTable() {
        String query = "delete from CRAWLTABLE_";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from CRAWLTABLE_");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean insertListOfFileNamesIntoTable(List<File> files) {
        String query = "insert into CRAWLTABLE_(FileName,filepath,IsFolder) values(?,?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into CRAWLTABLE_(FileName,filepath,IsFolder) values(?,?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getName());
                    this.statement.setString(2, files.get(recordCount).getAbsolutePath());
                    this.statement.setString(3, String.valueOf(files.get(recordCount).isDirectory()));
                    this.statement.addBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while insert list of parent folders", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean createBackUpStatisticsCrawlTable() {
        String query = BluSyncSQLConstants.CREATE_BACKUP_STATISTICS_CRAWL_TABLE_QUERY;
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement(query);
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while create backupCrawl table", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean insertListOfFileNamesIntoBackupStatCrawlTable(List<File> files) {
        String query = "insert into BKUP_STAT_CRAWL(filename,filepath) values(?,?);";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("insert into BKUP_STAT_CRAWL(filename,filepath) values(?,?);");
                int listsize = files.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    this.statement.setString(1, files.get(recordCount).getName());
                    this.statement.setString(2, files.get(recordCount).getAbsolutePath());
                    this.statement.addBatch();
                }
                this.statement.executeBatch();
                this.conn.commit();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while insert list of files into backup crawl statistics folders", (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    public boolean clearEntireBackupStatCrawlTable() {
        String query = "delete from BKUP_STAT_CRAWL";
        boolean success = false;
        this.statement = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("delete from BKUP_STAT_CRAWL");
                this.statement.execute();
                success = true;
            }
            catch (SQLException exception) {
                this.logger.error(SQLEXCEPTION_WHILE_DELETING, (Throwable)exception);
            }
            this.closeConnection();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackUpCrawlFileTO> getBackupStatCrawlBackUpFiles() {
        String query = "select * from BKUP_STAT_CRAWL";
        ArrayList<BackUpCrawlFileTO> files = null;
        this.statement = null;
        ResultSet resultSet = null;
        if (this.getConnection()) {
            try {
                this.statement = this.conn.prepareStatement("select * from BKUP_STAT_CRAWL");
                resultSet = this.statement.executeQuery();
                files = new ArrayList<BackUpCrawlFileTO>();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        BackUpCrawlFileTO backUpCrawlFileTO = new BackUpCrawlFileTO();
                        backUpCrawlFileTO.setCompletePath(resultSet.getString("filepath"));
                        backUpCrawlFileTO.setId(resultSet.getInt("Id"));
                        files.add(backUpCrawlFileTO);
                    }
                }
            }
            catch (SQLException exception) {
                this.logger.error("SQLException while selct from backup crawl statistcs", (Throwable)exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing result set for geting Previous Image Table Name" + e);
                    }
                }
            }
            this.closeConnection();
        }
        return files;
    }

    public boolean alterTable() {
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement("ALTER table CRAWLTABLE_ ADD COLUMN IsFolder TEXT;");
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("sqlExeception in CREATE_ACTIVITY_TABLE" + e);
            }
        }
        this.closeConnection();
        return success;
    }
}

