/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.service.alarm.StatisticsCollectorHelper;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.settings.SharedPreferences;
import com.parablu.epa.core.adapter.pcb.UpdateAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.helper.CommandListenerService;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.WindowsPolicyRefreshHelper;
import com.parablu.epa.service.notifications.DirectoryRefreshHelper;
import com.parablu.epa.service.notifications.IconOverlayHelper;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.service.settings.ShellExtensionUpgrader;
import com.parablu.epa.service.settings.VersionHelper;
import com.parablu.epa.service.settings.WindowsSettingsHelper;
import com.parablu.epa.view.ActivityHistoryTask;
import com.parablu.epa.view.RegistrationView;
import com.parablu.epa.view.SystemTrayUI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BluSyncLauncher {
    private static FileChannel mainAppChannel;
    private static FileLock mainAppLock;
    private static File mainAppFile;
    private static RandomAccessFile randomAccessFile;
    private static SystemTrayUI systray;
    private static final int TIMER_DAY_MILLISECONDS = 86400000;
    private static final int TIMER_FOURHOUR_MILLISECONDS = 14400000;
    private static final int TIMER_MINUTE_MILLISECONDS = 60000;
    private static final int TIMER_TWO_MINUTE_MILLISECONDS = 120000;
    private static final String FALSE = "false";
    private static Logger logger;
    private static Timer activityCleanUPTimer;
    private static Timer upgradeCheckTimer;
    public static String isSilent;
    public static String isNoUi;
    public static String certName;

    private BluSyncLauncher() {
    }

    public static void main(String[] args) {
        try {
            boolean isSettingsInitialized = WindowsSettingsHelper.initiateSettings();
            if (!isSettingsInitialized) {
                logger.debug("Error in  initialize settings");
                return;
            }
            String logfilePath = SettingHelper.getParabluBlusyncAppDataFolderUrl();
            PropertyConfigurator.configure((String)(logfilePath + StringLiterals.FILE_SEPARATOR + "ParaBlu-log4j.properties"));
            BluSyncLauncher.validateOnlyOneInstanceIsRunning();
            logger.info("Application started");
            ShellExtensionUpgrader.upgradeShellExtensions();
            logger.debug("arg lngth " + args.length);
            for (int z = 0; z < args.length; ++z) {
                logger.debug(args[z]);
            }
            if (args.length != 0 && "silent".equalsIgnoreCase(args[0])) {
                isSilent = args[0];
                String cloudName = args[1];
                certName = args[2];
                logger.debug("CloudName for silent" + cloudName + "cert Name&&&&&" + certName);
                BluSyncLauncher.startWiproUI(cloudName);
                logger.info("After starting UI silently");
            } else {
                certName = PropertyHelper.CERT_FILE_ALIAS;
                BluSyncLauncher.startUI();
                logger.info("After starting UI");
            }
            logger.debug("Exiting");
        }
        catch (Exception e) {
            logger.error("Exception in Main : ", (Throwable)e);
        }
    }

    private static void launchSyncFolderListener() throws IOException {
        SettingHelper.createParaBluPathFile();
        IconOverlayHelper iconOverlayHelper = new IconOverlayHelper();
        iconOverlayHelper.startDirectoryListener();
        logger.debug("ParaBlu directory listner started");
    }

    private static void validateOnlyOneInstanceIsRunning() throws IOException, CrawlAdapterException {
        mainAppFile = new File(SettingHelper.getMainLockUrl());
        if (mainAppFile.exists()) {
            mainAppFile.delete();
        }
        if ((mainAppLock = (mainAppChannel = (randomAccessFile = new RandomAccessFile(mainAppFile, "rw")).getChannel()).tryLock()) == null) {
            mainAppChannel.close();
            randomAccessFile.close();
            throw new CrawlAdapterException("Application instance already exists");
        }
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static synchronized void unlockFile() {
        logger.debug("Running during app shutdown");
        try {
            if (mainAppLock != null) {
                mainAppLock.release();
                mainAppChannel.close();
                mainAppFile.delete();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void changeAccount() {
        BluSyncLauncher.stopCrawlProcess();
        BluSyncLauncher.stopAllTimersOperating();
        BluSyncLauncher.killSystrayUI();
        BluSyncLauncher.deleteAllTablesAndUpdateSettingFile();
        SettingHelper.deleteNotSyncedFile();
        SettingHelper.deleteParaBluFolderPathTempFile();
        SettingHelper.deleteUserValidityFilePath();
        if (SettingHelper.process != null) {
            SettingHelper.process.destroy();
        }
        logger.info("Change Acount");
        System.exit(20001);
    }

    private static void stopAllTimersOperating() {
        BluSyncLauncher.stopTimers();
    }

    public static void startUI() {
        try {
            boolean isSettingsInitialized = WindowsSettingsHelper.initiateSettings();
            if (!isSettingsInitialized) {
                return;
            }
            activityCleanUPTimer = new Timer();
            upgradeCheckTimer = new Timer();
            logger.info("Loading UI");
            if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                    BluSyncLauncher.setServerBackupUser();
                }
                logger.debug("Registration Id is not null");
                BluSyncLauncher.startCrawlThreadAndUI();
            } else {
                BluSyncLauncher.deleteOldDatabasesIfPresent();
                RegistrationView regview = new RegistrationView();
                regview.loadRegistrationUI();
                logger.debug("Registration complete");
                if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                    BluSyncLauncher.setServerBackupUser();
                }
                if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                    BluSyncLauncher.startCrawlThreadAndUI();
                }
            }
            BluSyncLauncher.stopTimers();
        }
        catch (Exception e) {
            logger.error("Exception in start UI: ", (Throwable)e);
            System.exit(0);
        }
    }

    public static boolean ping(String url, int timeout) {
        String newUrl = url.replaceFirst("https", "http");
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(newUrl).openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            logger.trace("" + exception);
            logger.error("IOException in http request" + exception.getMessage());
            return false;
        }
    }

    private static void startCrawlThreadAndUI() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
        logger.debug("Crawl Started");
        SettingHelper.initiateAndCreateDatabases();
        SettingHelper.alterTables();
        if (!StringUtils.isEmpty((String)PropertyHelper.MAIN_EBMS_DOMAIN)) {
            SettingHelper.checkAndUpdateIpAddress();
        }
        logger.info("ldap Enabled:" + SettingHelper.getLdapEnabled());
        NotificationHelper.setLastSyncTime((long)SettingHelper.loadLastSuccessfulCrawl());
        SettingHelper.setLastSuccessfulBackup((long)SettingHelper.loadLastSuccessfullBackup());
        if (SettingHelper.isLicenseActive()) {
            if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.getBackupLicenced().contentEquals("true")) {
                logger.info("Started crawl for sync and backup");
                BluSyncLauncher.validateUserValidity();
                BluSyncLauncher.launchSyncFolderListener();
                logger.debug("Inside sync and backup for both sync and backup");
                BlusyncThreadHelper.initiateSyncTimer();
                logger.info("Initiated Sync Timer");
                if (SettingHelper.getLdapEnabled().equalsIgnoreCase("true")) {
                    SettingHelper.setBackupCrawlLimit((String)SettingHelper.loadBackupCrawlLimit());
                    SettingHelper.setIsStatisticsEnabled((String)SettingHelper.loadStatisticsEnabled());
                    WindowsPolicyRefreshHelper.initiatePolicyTimer();
                    StatisticsCollectorHelper.initiateStatisticsTimer();
                }
                BlusyncThreadHelper.initiateBackUpTimer();
                logger.info("Initiated BackUp Timer");
            } else if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.getBackupLicenced().contentEquals(FALSE)) {
                logger.info("Started crawl only for sync");
                BluSyncLauncher.validateUserValidity();
                BluSyncLauncher.launchSyncFolderListener();
                BlusyncThreadHelper.initiateSyncTimer();
            } else if (SettingHelper.getSyncLicenced().contentEquals(FALSE) && SettingHelper.getBackupLicenced().contentEquals("true")) {
                logger.debug("Crawl only for backup");
                logger.info("Started crawl (backup)");
                BluSyncLauncher.validateUserValidity();
                BluSyncLauncher.launchSyncFolderListener();
                logger.debug("Only backup selected");
                if (SettingHelper.getLdapEnabled().equalsIgnoreCase("true")) {
                    SettingHelper.setBackupCrawlLimit((String)SettingHelper.loadBackupCrawlLimit());
                    SettingHelper.setIsStatisticsEnabled((String)SettingHelper.loadStatisticsEnabled());
                    WindowsPolicyRefreshHelper.initiatePolicyTimer();
                    StatisticsCollectorHelper.initiateStatisticsTimer();
                }
                BlusyncThreadHelper.initiateBackUpTimer();
            }
        }
        logger.info("Starting Activity Timer");
        activityCleanUPTimer.schedule((TimerTask)new ActivityHistoryTask(), 120000L, 86400000L);
        upgradeCheckTimer.schedule((TimerTask)new UpdateTask(), 60000L, 14400000L);
        if (PropertyHelper.COMMAND_LISTNER_ENABLED.equalsIgnoreCase("true")) {
            logger.debug("before server listner");
            logger.debug("PORT " + PropertyHelper.AGENT_LISTNER_PORT);
            CommandListenerService service = new CommandListenerService();
            service.startAsync();
            logger.debug("after server listner");
        }
        logger.info("Load SystemTrayUI");
        systray = new SystemTrayUI();
        systray.loadSystemTray();
    }

    private static void validateUserValidity() throws IOException {
        boolean valid = true;
        String userSettingsPath = SettingHelper.getSharedPreferencesUrl();
        String tokenFileUrl = SettingHelper.getTokenFileUrl();
        SharedPreferences sp = new SharedPreferences(userSettingsPath);
        Map map = sp.readAllData();
        if (map == null || map.isEmpty() || map.get("cloud_name") == null) {
            valid = false;
        } else {
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                String key = (String)entry.getKey();
                String tempval = (String)entry.getValue();
                if (key.equals("parablu-folder") && (tempval == null || tempval.equals("null"))) {
                    valid = false;
                    continue;
                }
                if (key.equals("working_cloud_ip") && (tempval == null || tempval.equals("null"))) {
                    valid = false;
                    continue;
                }
                if (key.equals("cloud_name") && (tempval == null || tempval.equals("null"))) {
                    valid = false;
                    continue;
                }
                if (!key.equals("user_name") || tempval != null && !tempval.equals("null")) continue;
                valid = false;
            }
        }
        File tokenFile = new File(tokenFileUrl);
        if (!tokenFile.exists()) {
            valid = false;
        }
        if (valid) {
            logger.info("Creating user validity file");
            BluSyncLauncher.createUserValidityFile();
        } else {
            logger.info("Creating user validity file inside else part");
            BluSyncLauncher.createUserNotValidFile();
        }
    }

    private static void createUserNotValidFile() throws IOException {
        String userValidityFilePath = SettingHelper.createUserNotValidFilePath();
        File file = new File(userValidityFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("Not a valid user");
        bw.close();
    }

    private static void createUserValidityFile() throws IOException {
        String userValidityFilePath = SettingHelper.createUserValidityFilePath();
        File file = new File(userValidityFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        DirectoryRefreshHelper directoryRefreshHelper = new DirectoryRefreshHelper();
        directoryRefreshHelper.refreshDirectory();
    }

    private static void deleteOldDatabasesIfPresent() {
        logger.info("Deleting Old databases If Present");
        ArrayList<String> databaseToDeleteList = new ArrayList<String>();
        databaseToDeleteList.add(SettingHelper.getDownloadTableDBUrl());
        databaseToDeleteList.add(SettingHelper.getActivityDBUrl());
        databaseToDeleteList.add(SettingHelper.getUploadTableDBUrl());
        databaseToDeleteList.add(SettingHelper.getImageTableHistoryDBUrl());
        databaseToDeleteList.add(SettingHelper.getBackUpDbUrl());
        for (String fileToDelete : databaseToDeleteList) {
            try {
                File databaseFile = new File(fileToDelete);
                if (!databaseFile.exists()) continue;
                FileUtils.forceDelete((File)databaseFile);
            }
            catch (IOException e) {
                logger.error("Couldnt delete old databases " + e);
            }
        }
    }

    private static synchronized void stopTimers() {
        logger.info("stop Timers");
        if (activityCleanUPTimer != null) {
            activityCleanUPTimer.cancel();
            activityCleanUPTimer = null;
        }
        if (upgradeCheckTimer != null) {
            upgradeCheckTimer.cancel();
            upgradeCheckTimer = null;
        }
    }

    private static void stopCrawlProcess() {
        if (!SettingHelper.getSyncLicenced().contentEquals(FALSE)) {
            BlusyncThreadHelper.cancelSyncTimer();
            BlusyncThreadHelper.cancelCurrentSyncProcess();
        }
        if (!SettingHelper.getBackupLicenced().contentEquals(FALSE)) {
            BlusyncThreadHelper.cancelBackupTimer();
            BlusyncThreadHelper.cancelCurrentBackupProcess();
        }
    }

    private static void deleteAllTablesAndUpdateSettingFile() {
        String paraBluDatabaseFolder = SettingHelper.getBaseDBUrl();
        int sleepTime = 400;
        File databaseFolders = new File(paraBluDatabaseFolder);
        try {
            FileUtils.forceDelete((File)databaseFolders);
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.debug("Retrying Delete Database" + e.getMessage());
            BluSyncLauncher.retryDeleteDatabase(databaseFolders, sleepTime);
        }
        SettingHelper.resetSharedPreferences();
        SettingHelper.deleteTokenFile();
    }

    public static void retryDeleteDatabase(File databaseFolders, int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e1) {
            logger.trace("" + e1);
            logger.debug("IllegalThreadStateException", (Object)e1.getMessage());
        }
        try {
            FileUtils.forceDelete((File)databaseFolders);
        }
        catch (IOException e1) {
            logger.trace("" + e1);
            logger.error("IOException in forceDelete" + e1.getMessage());
        }
    }

    private static void killSystrayUI() {
        systray.disposeSystrayUIShells();
    }

    public static void startWiproUI(String cloudName) {
        try {
            String deviceName = BluSyncLauncher.getDeviceName();
            String userName = System.getProperty("user.name");
            logger.debug("The user name is:" + userName + " DeviceName:" + deviceName);
            boolean isSettingsInitialized = WindowsSettingsHelper.initiateSettings();
            if (!isSettingsInitialized) {
                return;
            }
            activityCleanUPTimer = new Timer();
            upgradeCheckTimer = new Timer();
            logger.info("Loading UI");
            logger.debug("SettingHelper.readTokenFromFile()    :: " + SettingHelper.readTokenFromFile());
            logger.debug("CloudName :: " + SettingHelper.getCloudName());
            logger.debug("SyncFolder :: " + SettingHelper.getParabluSyncFolder());
            if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                logger.debug("Registration Id is not null");
                if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                    BluSyncLauncher.setServerBackupUser();
                }
                BluSyncLauncher.startCrawlThreadAndUI();
            } else {
                logger.debug("Started Registration");
                BluSyncLauncher.deleteOldDatabasesIfPresent();
                RegistrationView regview = new RegistrationView();
                regview.loadSilentRegistration(deviceName, userName, null, cloudName);
                logger.debug("Registration complete");
                if (SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) {
                    BluSyncLauncher.setServerBackupUser();
                }
                if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                    BluSyncLauncher.startCrawlThreadAndUI();
                }
            }
            BluSyncLauncher.stopTimers();
        }
        catch (Exception e) {
            logger.error("Exception in start UI: ", (Throwable)e);
            System.exit(0);
        }
    }

    static String getDeviceName() {
        String deviceName = "";
        try {
            deviceName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.trace("" + e);
            logger.error("UnKnownHostException" + e.getMessage());
        }
        return deviceName;
    }

    public static void revertChanges() {
        BluSyncLauncher.deleteAllTablesAndUpdateSettingFile();
        SettingHelper.deleteNotSyncedFile();
        SettingHelper.deleteParaBluFolderPathTempFile();
        SettingHelper.deleteUserValidityFilePath();
        if (SettingHelper.process != null) {
            SettingHelper.process.destroy();
        }
        logger.info("Changing account");
    }

    private static void setServerBackupUser() {
        DeviceTo deviceTo = PolicyManagementServerHelper.getsServerBackupDeviceDetails();
        if (deviceTo != null && deviceTo.getUserName() != null) {
            SettingHelper.setUserName((String)deviceTo.getUserName());
        }
    }

    static {
        systray = null;
        logger = LoggerFactory.getLogger(BluSyncLauncher.class);
        activityCleanUPTimer = null;
        upgradeCheckTimer = null;
        isSilent = "";
        isNoUi = "";
        certName = "";
    }

    static class UpdateTask
    extends TimerTask {
        private static final int UPGARDE_EXIT_CODE = 20002;
        Logger logger = LoggerFactory.getLogger(UpdateTask.class);

        UpdateTask() {
        }

        @Override
        public void run() {
            if (SettingHelper.getCloudName() == null) {
                this.logger.debug("No cloud name");
                return;
            }
            if (VersionHelper.getProductVersion() == null) {
                this.logger.debug("No Product version");
                return;
            }
            String downloadUrl = SettingHelper.getUpdateDownloadURL() + StringLiterals.FILE_SEPARATOR + "bsupdate.exe";
            this.checkAndDownloadLatestUpdate(downloadUrl);
        }

        private void sleepUntilCrawlFinishedAndDisplayBalloonAndWait() throws InterruptedException {
            while (NotificationHelper.getMainStatus() == 101) {
                Thread.sleep(30000L);
            }
        }

        private void checkAndDownloadLatestUpdate(String downloadUrl) {
            Integer port = null;
            String tempDownloadUrl = SettingHelper.getUpdateDownloadURL() + StringLiterals.FILE_SEPARATOR + VersionHelper.getProductVersion() + StringLiterals.FILE_SEPARATOR + "bsupdate.exe";
            if (SettingHelper.getCloudName() == null) {
                this.logger.debug("Cloud Name is null");
                return;
            }
            UpdateAdapter adapter = new UpdateAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            String cloudVersion = adapter.checkCloudForVersion(SettingHelper.getCurrentCloudIpAddress(), null, VersionHelper.getProductVersion(), "windows");
            this.logger.debug("Version from system  " + VersionHelper.getProductVersion());
            if (cloudVersion == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                port = Integer.valueOf(SettingHelper.getHttpsPort());
                cloudVersion = adapter.checkCloudForVersion(SettingHelper.getCurrentCloudIpAddress(), port, VersionHelper.getProductVersion(), "windows");
                this.logger.debug(" CloudVersion " + cloudVersion);
            }
            if (cloudVersion == null || cloudVersion.equals(VersionHelper.getProductVersion())) {
                this.logger.debug("cloud " + cloudVersion);
                return;
            }
            File file = new File(tempDownloadUrl);
            file.getParentFile().mkdirs();
            if (file.exists() && !file.delete()) {
                this.logger.debug("Couldnt delete old file (tempDownloadUrl)");
                return;
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.logger.error("Couldnt dcreate new file (tempDownloadUrl)", (Throwable)e);
                return;
            }
            if (adapter.downloadLatestVersion(SettingHelper.getCurrentCloudIpAddress(), port, SettingHelper.getCloudName(), cloudVersion, "windows", tempDownloadUrl, SettingHelper.getDeviceUUId())) {
                this.logger.info("Downloading Latest Version");
                File newFile = new File(downloadUrl);
                newFile.getParentFile().mkdirs();
                if (newFile.exists()) {
                    newFile.delete();
                }
                try {
                    FileUtils.moveFile((File)file, (File)newFile);
                }
                catch (IOException e1) {
                    this.logger.error("IOException in moveFile", (Throwable)e1);
                }
                try {
                    this.sleepUntilCrawlFinishedAndDisplayBalloonAndWait();
                    UIHelper.disposeSystray();
                    if (SettingHelper.process != null) {
                        SettingHelper.process.destroy();
                    }
                    System.exit(20002);
                }
                catch (InterruptedException e) {
                    this.logger.trace("" + e);
                    this.logger.error("InterruptedException (while System.exit) ", (Object)e.getMessage());
                }
            } else {
                this.logger.debug("No file to download (else of Download Latest Version)");
            }
        }
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            BluSyncLauncher.unlockFile();
        }
    }
}

