/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.settings;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.helper.ShortCutService;
import java.io.File;

public class ShortcutHelper {
    private static final String DESKTOP = "Desktop";
    private static final String LINKS = "Links";

    private ShortcutHelper() {
    }

    public static void createDesktopShortCut(String path, String cloudName) {
        File file = cloudName != null ? new File(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + DESKTOP + "/" + PropertyHelper.SHORTCUT_FOLDER_NAME + "(" + cloudName + ").lnk") : new File(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + DESKTOP + "/" + PropertyHelper.SHORTCUT_FOLDER_NAME + ".lnk");
        if (file.exists()) {
            file.delete();
        }
        ShortCutService shortCutService = new ShortCutService();
        shortCutService.createFolderShortcut(path, file.getAbsolutePath(), "Shortcut to your " + PropertyHelper.SHORTCUT_FOLDER_NAME + "Folder", SettingHelper.getIconPath());
    }

    public static void createFavouritesShortcut(String path, String cloudName) {
        File file = cloudName != null ? new File(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + LINKS + "/" + PropertyHelper.SHORTCUT_FOLDER_NAME + "(" + cloudName + ").lnk") : new File(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + LINKS + "/" + PropertyHelper.SHORTCUT_FOLDER_NAME + ".lnk");
        if (file.exists()) {
            file.delete();
        }
        ShortCutService shortCutService = new ShortCutService();
        shortCutService.createFolderShortcut(path, file.getAbsolutePath(), "Shortcut to your " + PropertyHelper.SHORTCUT_FOLDER_NAME + "Folder", SettingHelper.getIconPath());
    }

    public static void deleteDesktopShortCut(String cloudName) {
        File file = new File(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "Desktop/" + PropertyHelper.SHORTCUT_FOLDER_NAME + "(" + cloudName + ").lnk");
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteFavouritesShortcut(String cloudName) {
        File file = new File(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "Links/" + PropertyHelper.SHORTCUT_FOLDER_NAME + "(" + cloudName + ").lnk");
        if (file.exists()) {
            file.delete();
        }
    }
}

