/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.service.settings.HashChecker;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.to.BackupPolicyTO;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesBeSkippedAsPerPolicy {
    private static Logger logger = LoggerFactory.getLogger(FilesBeSkippedAsPerPolicy.class);
    private static boolean isFileTobeSkipped;
    public static long allowedSize;
    public static String extensions;
    public static String filterType;
    private static boolean legalHoldEnabled;
    private static boolean backupSystemFilesEnabled;
    private static final String SYSTEM_ROOT = "system.root";
    static BackupPolicyTO currentPolicy;
    private static boolean skipHiddenfile;
    private static List<String> filterExludedFoldresFromPolicy;
    private static List<String> rootexclusionfoldersFromPolicy;

    public static boolean isSkipHiddenfile() {
        return skipHiddenfile;
    }

    public static void setSkipHiddenfile(boolean skipHiddenfile) {
        FilesBeSkippedAsPerPolicy.skipHiddenfile = skipHiddenfile;
    }

    private FilesBeSkippedAsPerPolicy() {
    }

    public static boolean checkVariousPolicies(File file, boolean includeExclusions) {
        isFileTobeSkipped = true;
        FilesBeSkippedAsPerPolicy.skipExcludedFolders(filterExludedFoldresFromPolicy, file.getAbsolutePath(), includeExclusions);
        if (!isFileTobeSkipped) {
            isFileTobeSkipped = true;
            FilesBeSkippedAsPerPolicy.checkExtensions(file);
            if (!isFileTobeSkipped) {
                isFileTobeSkipped = true;
                FilesBeSkippedAsPerPolicy.checkFileSize(file, allowedSize);
            }
        }
        return isFileTobeSkipped;
    }

    public static boolean checkExcludeFolders(File file, boolean includeExclusions) {
        isFileTobeSkipped = true;
        FilesBeSkippedAsPerPolicy.skipExcludedFolders(filterExludedFoldresFromPolicy, file.getAbsolutePath(), includeExclusions);
        return isFileTobeSkipped;
    }

    public static boolean skipExcludedFolders(List<String> excludedFolders, String recivedFolderPath, boolean includeExclusions) {
        isFileTobeSkipped = false;
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            isFileTobeSkipped = FilesBeSkippedAsPerPolicy.isWindowsFileToSkip(excludedFolders, recivedFolderPath, includeExclusions);
        } else if (SettingHelper.getOsName().toLowerCase().contains("mac")) {
            isFileTobeSkipped = FilesBeSkippedAsPerPolicy.isMacFileToSkip(excludedFolders, recivedFolderPath, includeExclusions);
        }
        return isFileTobeSkipped;
    }

    private static boolean isMacFileToSkip(List<String> excludedFolders, String recivedFolderPath, boolean includeExclusions) {
        isFileTobeSkipped = false;
        if (!includeExclusions) {
            return isFileTobeSkipped;
        }
        String folderPath = recivedFolderPath;
        String rootDirectory = FilesBeSkippedAsPerPolicy.rootDirectory().toLowerCase();
        for (String excludedFolderFromPolicy : excludedFolders) {
            if (excludedFolderFromPolicy.startsWith("{") && excludedFolderFromPolicy.endsWith("}")) {
                if ((excludedFolderFromPolicy = excludedFolderFromPolicy.replaceAll("[{}]", "")).contains(SYSTEM_ROOT)) {
                    excludedFolderFromPolicy = excludedFolderFromPolicy.replace(SYSTEM_ROOT, rootDirectory);
                }
                List<String> folderPathArray = Arrays.asList(folderPath.split("/"));
                if (!folderPathArray.stream().anyMatch(excludedFolderFromPolicy::equalsIgnoreCase)) continue;
                isFileTobeSkipped = true;
                return isFileTobeSkipped;
            }
            if (!includeExclusions) continue;
            File fileTobeExcluded = new File(excludedFolderFromPolicy);
            excludedFolderFromPolicy = fileTobeExcluded.getAbsolutePath();
            folderPath = FilesBeSkippedAsPerPolicy.checkForMacBasePath(folderPath);
            boolean sameFolder = folderPath.equalsIgnoreCase(excludedFolderFromPolicy);
            boolean childFolder = folderPath.toLowerCase().startsWith(excludedFolderFromPolicy.toLowerCase() + StringLiterals.FILE_SEPARATOR);
            if (!sameFolder && !childFolder) continue;
            isFileTobeSkipped = true;
            return isFileTobeSkipped;
        }
        return isFileTobeSkipped;
    }

    public static boolean isWindowsFileToSkip(List<String> excludedFolders, String recivedFolderPath, boolean includeExclusions) {
        isFileTobeSkipped = false;
        if (!includeExclusions) {
            return isFileTobeSkipped;
        }
        String folderPath = recivedFolderPath;
        String rootDirectory = FilesBeSkippedAsPerPolicy.rootDirectory().toLowerCase();
        for (String excludedFolderFromPolicy : excludedFolders) {
            if (excludedFolderFromPolicy.startsWith("{") && excludedFolderFromPolicy.endsWith("}")) {
                excludedFolderFromPolicy = excludedFolderFromPolicy.replaceAll("[{}]", "");
                if (SettingHelper.getOsName().toLowerCase().contains("win")) {
                    if (excludedFolderFromPolicy.contains(SYSTEM_ROOT)) {
                        excludedFolderFromPolicy = excludedFolderFromPolicy.replace(SYSTEM_ROOT, System.getenv("SystemDrive"));
                    }
                } else if (excludedFolderFromPolicy.contains(SYSTEM_ROOT)) {
                    excludedFolderFromPolicy = excludedFolderFromPolicy.replace(SYSTEM_ROOT, rootDirectory);
                }
                List<String> folderPathArray = Arrays.asList(folderPath.split("\\\\"));
                if (!folderPathArray.stream().anyMatch(excludedFolderFromPolicy::equalsIgnoreCase)) continue;
                isFileTobeSkipped = true;
                return isFileTobeSkipped;
            }
            File fileTobeExcluded = new File(excludedFolderFromPolicy);
            excludedFolderFromPolicy = fileTobeExcluded.getAbsolutePath();
            while (excludedFolderFromPolicy.endsWith("/") || excludedFolderFromPolicy.endsWith("\\")) {
                excludedFolderFromPolicy = excludedFolderFromPolicy.substring(0, excludedFolderFromPolicy.length() - 1);
            }
            boolean sameFolder = folderPath.equalsIgnoreCase(excludedFolderFromPolicy);
            boolean childFolder = folderPath.toLowerCase().contains(excludedFolderFromPolicy.toLowerCase() + StringLiterals.FILE_SEPARATOR);
            if (!sameFolder && !childFolder) continue;
            isFileTobeSkipped = true;
            return isFileTobeSkipped;
        }
        return isFileTobeSkipped;
    }

    public static boolean checkExtensions(File file) {
        boolean isExtAllowed;
        String[] tmpExtensionCheck = null;
        isFileTobeSkipped = true;
        if (!StringUtils.isEmpty((String)extensions)) {
            String delimiter = ",";
            tmpExtensionCheck = extensions.split(delimiter);
        }
        if (!StringUtils.isEmpty((String)extensions) && (isExtAllowed = filterType.equalsIgnoreCase("inclusion") ? FilesBeSkippedAsPerPolicy.isExtensionAllowedForBackup(tmpExtensionCheck, file) : FilesBeSkippedAsPerPolicy.isExtensionRestrictedForBackup(tmpExtensionCheck, file))) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    private static boolean isExtensionAllowedForBackup(String[] tmpExtensionCheck, File file) {
        String fileext = FilenameUtils.getExtension((String)file.getName());
        boolean fileAllowedForBackup = false;
        for (String ext : tmpExtensionCheck) {
            if ("ALL".equalsIgnoreCase(ext = ext.trim())) {
                fileAllowedForBackup = true;
                break;
            }
            if ("{no_ext}".equalsIgnoreCase(ext) && StringUtils.isEmpty((String)fileext)) {
                fileAllowedForBackup = true;
                break;
            }
            if (!ext.equalsIgnoreCase(fileext)) continue;
            fileAllowedForBackup = true;
            break;
        }
        return fileAllowedForBackup;
    }

    private static void checkFileSize(File file, long allowedSize) {
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = file.length();
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
    }

    public static long getCurrentPolicyMaxSize() {
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null) {
            return currentPolicy.getMaxFileSize();
        }
        return 0L;
    }

    public static void setLegalHoldDetails() {
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null && !StringUtils.isEmpty((String)currentPolicy.getLegalHoldEnabled())) {
            FilesBeSkippedAsPerPolicy.setLegalHoldEnabled(Boolean.parseBoolean(currentPolicy.getLegalHoldEnabled()));
        }
        if (currentPolicy != null && !StringUtils.isEmpty((String)currentPolicy.getBackupSystemFilesEnabled())) {
            FilesBeSkippedAsPerPolicy.setBackupSystemFilesEnabled(Boolean.parseBoolean(currentPolicy.getBackupSystemFilesEnabled()));
        }
    }

    public static boolean checkPstExtension(File file) {
        boolean isFileBeskipped = false;
        String pstExtension = "pst";
        String ostExtension = "ost";
        String fileext = FilenameUtils.getExtension((String)file.getName());
        if (pstExtension.equalsIgnoreCase(fileext) || ostExtension.equalsIgnoreCase(fileext)) {
            isFileBeskipped = true;
        }
        return isFileBeskipped;
    }

    public static long getAllowedSize() {
        return allowedSize;
    }

    public static void setAllowedSize(long allowedSize) {
        FilesBeSkippedAsPerPolicy.allowedSize = allowedSize;
    }

    public static String getExtensions() {
        return extensions;
    }

    public static void setExtensions(String extensions) {
        FilesBeSkippedAsPerPolicy.extensions = extensions;
    }

    private static String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        return completeParentPath;
    }

    public static boolean isLegalHoldEnabled() {
        return legalHoldEnabled;
    }

    public static void setLegalHoldEnabled(boolean legalHoldEnabled) {
        FilesBeSkippedAsPerPolicy.legalHoldEnabled = legalHoldEnabled;
    }

    public static boolean isBackupSystemFilesEnabled() {
        return backupSystemFilesEnabled;
    }

    public static void setBackupSystemFilesEnabled(boolean backupSystemFilesEnabled) {
        FilesBeSkippedAsPerPolicy.backupSystemFilesEnabled = backupSystemFilesEnabled;
    }

    private static boolean isExtensionRestrictedForBackup(String[] tmpExtensionCheck, File file) {
        boolean fileAllowedForBackup = true;
        String fileext = FilenameUtils.getExtension((String)file.getName());
        for (String ext : tmpExtensionCheck) {
            if ((ext = ext.trim()).equalsIgnoreCase(fileext)) {
                fileAllowedForBackup = false;
                break;
            }
            if (!"{no_ext}".equalsIgnoreCase(ext) || !StringUtils.isEmpty((String)fileext)) continue;
            fileAllowedForBackup = false;
            break;
        }
        return fileAllowedForBackup;
    }

    public static String rootDirectory() {
        return File.listRoots()[0].getAbsolutePath();
    }

    public static void setSkipHiddenFile() {
        currentPolicy = PolicyManagementServerHelper.getCurrentPolicy();
        if (currentPolicy != null) {
            FilesBeSkippedAsPerPolicy.setSkipHiddenfile(currentPolicy.isSkipHiddenFile());
        }
    }

    public static boolean skipHiddenFile(File file) {
        File currentProcessingFile = file;
        if (FilesBeSkippedAsPerPolicy.isSkipHiddenfile() && currentProcessingFile.isHidden()) {
            logger.debug("<<<<<<<<<<<<<<<<<Skip hidden file>>>>>>>>>>>>>>>>>  " + currentProcessingFile);
            return true;
        }
        return false;
    }

    public static List<String> getFilterExludedFoldresFromPolicy() {
        return filterExludedFoldresFromPolicy;
    }

    public static void setFilterExludedFoldresFromPolicy() {
        ArrayList<String> globalexclusionfolders = new ArrayList<String>();
        List<String> excludedFoldersFromPolicy = HashChecker.getExcludedFoldersList();
        for (String excludedfolder : excludedFoldersFromPolicy) {
            if (excludedfolder.startsWith("{win") || excludedfolder.startsWith("{mac")) continue;
            globalexclusionfolders.add(excludedfolder);
        }
        filterExludedFoldresFromPolicy = globalexclusionfolders;
    }

    public static List<String> getRootexclusionfoldersFromPolicy() {
        return rootexclusionfoldersFromPolicy;
    }

    public static void setRootexclusionfoldersFromPolicy() {
        ArrayList<String> rootexclusionfolders = new ArrayList<String>();
        List<String> excludedFoldersFromPolicy = HashChecker.getExcludedFoldersList();
        for (String excludedfolder : excludedFoldersFromPolicy) {
            if (!excludedfolder.startsWith("{win") && !excludedfolder.startsWith("{mac")) continue;
            rootexclusionfolders.add(excludedfolder);
        }
        rootexclusionfoldersFromPolicy = rootexclusionfolders;
    }

    static {
        legalHoldEnabled = false;
        backupSystemFilesEnabled = false;
        currentPolicy = null;
        skipHiddenfile = false;
        filterExludedFoldresFromPolicy = null;
        rootexclusionfoldersFromPolicy = null;
    }
}

