/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetConnection
implements Serializable {
    private static final long serialVersionUID = 12776L;
    long localPort = 0L;
    String localAddress = null;
    long remotePort = 0L;
    String remoteAddress = null;
    int type = 0;
    int state = 0;
    long sendQueue = 0L;
    long receiveQueue = 0L;

    public native void gather(Sigar var1) throws SigarException;

    static NetConnection fetch(Sigar sigar) throws SigarException {
        NetConnection netConnection = new NetConnection();
        netConnection.gather(sigar);
        return netConnection;
    }

    public long getLocalPort() {
        return this.localPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public long getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getType() {
        return this.type;
    }

    public int getState() {
        return this.state;
    }

    public long getSendQueue() {
        return this.sendQueue;
    }

    public long getReceiveQueue() {
        return this.receiveQueue;
    }

    void copyTo(NetConnection copy) {
        copy.localPort = this.localPort;
        copy.localAddress = this.localAddress;
        copy.remotePort = this.remotePort;
        copy.remoteAddress = this.remoteAddress;
        copy.type = this.type;
        copy.state = this.state;
        copy.sendQueue = this.sendQueue;
        copy.receiveQueue = this.receiveQueue;
    }

    public native String getTypeString();

    public static native String getStateString(int var0);

    public String getStateString() {
        return NetConnection.getStateString(this.state);
    }

    public Map toMap() {
        String strreceiveQueue;
        String strsendQueue;
        String strstate;
        String strtype;
        String strremoteAddress;
        String strremotePort;
        String strlocalAddress;
        HashMap<String, String> map = new HashMap<String, String>();
        String strlocalPort = String.valueOf(this.localPort);
        if (!"-1".equals(strlocalPort)) {
            map.put("LocalPort", strlocalPort);
        }
        if (!"-1".equals(strlocalAddress = String.valueOf(this.localAddress))) {
            map.put("LocalAddress", strlocalAddress);
        }
        if (!"-1".equals(strremotePort = String.valueOf(this.remotePort))) {
            map.put("RemotePort", strremotePort);
        }
        if (!"-1".equals(strremoteAddress = String.valueOf(this.remoteAddress))) {
            map.put("RemoteAddress", strremoteAddress);
        }
        if (!"-1".equals(strtype = String.valueOf(this.type))) {
            map.put("Type", strtype);
        }
        if (!"-1".equals(strstate = String.valueOf(this.state))) {
            map.put("State", strstate);
        }
        if (!"-1".equals(strsendQueue = String.valueOf(this.sendQueue))) {
            map.put("SendQueue", strsendQueue);
        }
        if (!"-1".equals(strreceiveQueue = String.valueOf(this.receiveQueue))) {
            map.put("ReceiveQueue", strreceiveQueue);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

