/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class EncryptedKey
implements DEREncodable {
    private DEROctetString key;

    public EncryptedKey(byte[] byArray) {
        this.setKey(byArray);
    }

    public EncryptedKey(DEROctetString dEROctetString) {
        this.key = dEROctetString;
    }

    public EncryptedKey(EncryptedKey encryptedKey) {
        this.key = encryptedKey.key;
    }

    public static EncryptedKey getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedKey) {
            return (EncryptedKey)object;
        }
        if (object instanceof DEROctetString) {
            return new EncryptedKey((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedKey");
    }

    public static EncryptedKey newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedKey) {
            return new EncryptedKey((EncryptedKey)object);
        }
        if (object instanceof DEROctetString) {
            return new EncryptedKey((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedKey");
    }

    public byte[] getKey() {
        return this.key.getOctets();
    }

    private void setKey(byte[] byArray) {
        this.key = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.key;
    }
}

