/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class ProcMem
implements Serializable {
    private static final long serialVersionUID = 7985L;
    long size = 0L;
    long resident = 0L;
    long share = 0L;
    long minorFaults = 0L;
    long majorFaults = 0L;
    long pageFaults = 0L;

    public native void gather(Sigar var1, long var2) throws SigarException;

    static ProcMem fetch(Sigar sigar, long pid) throws SigarException {
        ProcMem procMem = new ProcMem();
        procMem.gather(sigar, pid);
        return procMem;
    }

    public long getSize() {
        return this.size;
    }

    public long getResident() {
        return this.resident;
    }

    public long getShare() {
        return this.share;
    }

    public long getMinorFaults() {
        return this.minorFaults;
    }

    public long getMajorFaults() {
        return this.majorFaults;
    }

    public long getPageFaults() {
        return this.pageFaults;
    }

    void copyTo(ProcMem copy) {
        copy.size = this.size;
        copy.resident = this.resident;
        copy.share = this.share;
        copy.minorFaults = this.minorFaults;
        copy.majorFaults = this.majorFaults;
        copy.pageFaults = this.pageFaults;
    }

    public long getRss() {
        return this.getResident();
    }

    public long getVsize() {
        return this.getSize();
    }

    public Map toMap() {
        String strpageFaults;
        String strmajorFaults;
        String strminorFaults;
        String strshare;
        String strresident;
        HashMap<String, String> map = new HashMap<String, String>();
        String strsize = String.valueOf(this.size);
        if (!"-1".equals(strsize)) {
            map.put("Size", strsize);
        }
        if (!"-1".equals(strresident = String.valueOf(this.resident))) {
            map.put("Resident", strresident);
        }
        if (!"-1".equals(strshare = String.valueOf(this.share))) {
            map.put("Share", strshare);
        }
        if (!"-1".equals(strminorFaults = String.valueOf(this.minorFaults))) {
            map.put("MinorFaults", strminorFaults);
        }
        if (!"-1".equals(strmajorFaults = String.valueOf(this.majorFaults))) {
            map.put("MajorFaults", strmajorFaults);
        }
        if (!"-1".equals(strpageFaults = String.valueOf(this.pageFaults))) {
            map.put("PageFaults", strpageFaults);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

