/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class RC2CBCParameter
implements DEREncodable {
    private DERInteger rc2ParameterVersion;
    private DEROctetString iv;

    public RC2CBCParameter(BigInteger bigInteger, byte[] byArray) {
        this.setRc2ParameterVersion(bigInteger);
        this.setIv(byArray);
    }

    public RC2CBCParameter(BERConstructedSequence bERConstructedSequence) {
        this.rc2ParameterVersion = (DERInteger)bERConstructedSequence.getObjectAt(0);
        this.iv = (DEROctetString)bERConstructedSequence.getObjectAt(1);
    }

    public RC2CBCParameter(RC2CBCParameter rC2CBCParameter) {
        this.rc2ParameterVersion = rC2CBCParameter.rc2ParameterVersion;
        this.iv = rC2CBCParameter.iv;
    }

    public static RC2CBCParameter getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RC2CBCParameter) {
            return (RC2CBCParameter)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new RC2CBCParameter((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RC2CBCParameter.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RC2CBCParameter");
    }

    public static RC2CBCParameter newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RC2CBCParameter) {
            return new RC2CBCParameter((RC2CBCParameter)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new RC2CBCParameter((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return RC2CBCParameter.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RC2CBCParameter");
    }

    public BigInteger getRc2ParameterVersion() {
        return this.rc2ParameterVersion.getValue();
    }

    private void setRc2ParameterVersion(BigInteger bigInteger) {
        this.rc2ParameterVersion = new DERInteger(bigInteger);
    }

    public byte[] getIv() {
        return this.iv.getOctets();
    }

    private void setIv(byte[] byArray) {
        this.iv = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.rc2ParameterVersion);
        bERConstructedSequence.addObject(this.iv);
        return bERConstructedSequence;
    }
}

