/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.jmx.AbstractMBean;
import org.hyperic.sigar.jmx.SigarCpu;
import org.hyperic.sigar.jmx.SigarCpuInfo;
import org.hyperic.sigar.jmx.SigarCpuPerc;
import org.hyperic.sigar.jmx.SigarLoadAverage;
import org.hyperic.sigar.jmx.SigarMem;
import org.hyperic.sigar.jmx.SigarSwap;

public class SigarRegistry
extends AbstractMBean {
    private static final String MBEAN_TYPE = "SigarRegistry";
    private static final MBeanInfo MBEAN_INFO;
    private static final MBeanConstructorInfo MBEAN_CONSTR_DEFAULT;
    private final String objectName;
    private final ArrayList managedBeans = new ArrayList();

    public SigarRegistry() {
        super(new Sigar(), (short)3);
        this.objectName = "sigar:type=SigarRegistry";
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Object getAttribute(String attr) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(attr);
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException {
        throw new AttributeNotFoundException(attr.getName());
    }

    public Object invoke(String action, Object[] params, String[] signatures) throws MBeanException, ReflectionException {
        throw new ReflectionException(new NoSuchMethodException(action), action);
    }

    public MBeanInfo getMBeanInfo() {
        return MBEAN_INFO;
    }

    public void postRegister(Boolean success) {
        super.postRegister(success);
        if (!success.booleanValue()) {
            return;
        }
        this.registerCpuBeans();
        this.registerMemoryBeans();
        this.registerSystemBeans();
    }

    private void registerCpuBeans() {
        ObjectInstance nextRegistered = null;
        try {
            int cpuCount = this.sigar.getCpuInfoList().length;
            for (int i = 0; i < cpuCount; ++i) {
                SigarCpu nextCpu = new SigarCpu(this.sigarImpl, i);
                try {
                    if (!this.mbeanServer.isRegistered(new ObjectName(nextCpu.getObjectName()))) {
                        nextRegistered = this.mbeanServer.registerMBean(nextCpu, null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (nextRegistered != null) {
                    this.managedBeans.add(nextRegistered.getObjectName());
                }
                nextRegistered = null;
                SigarCpuPerc nextCpuPerc = new SigarCpuPerc(this.sigarImpl, i);
                try {
                    if (!this.mbeanServer.isRegistered(new ObjectName(nextCpuPerc.getObjectName()))) {
                        nextRegistered = this.mbeanServer.registerMBean(nextCpuPerc, null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (nextRegistered != null) {
                    this.managedBeans.add(nextRegistered.getObjectName());
                }
                nextRegistered = null;
                SigarCpuInfo nextCpuInfo = new SigarCpuInfo(this.sigarImpl, i);
                try {
                    if (!this.mbeanServer.isRegistered(new ObjectName(nextCpuInfo.getObjectName()))) {
                        nextRegistered = this.mbeanServer.registerMBean(nextCpuInfo, null);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (nextRegistered != null) {
                    this.managedBeans.add(nextRegistered.getObjectName());
                }
                nextRegistered = null;
            }
        }
        catch (SigarException e) {
            throw this.unexpectedError("CpuInfoList", e);
        }
    }

    private void registerMemoryBeans() {
        ObjectInstance nextRegistered = null;
        SigarMem mem = new SigarMem(this.sigarImpl);
        try {
            if (!this.mbeanServer.isRegistered(new ObjectName(mem.getObjectName()))) {
                nextRegistered = this.mbeanServer.registerMBean(mem, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (nextRegistered != null) {
            this.managedBeans.add(nextRegistered.getObjectName());
        }
        nextRegistered = null;
        SigarSwap swap = new SigarSwap(this.sigarImpl);
        try {
            if (!this.mbeanServer.isRegistered(new ObjectName(swap.getObjectName()))) {
                nextRegistered = this.mbeanServer.registerMBean(swap, null);
            }
        }
        catch (Exception e) {
            nextRegistered = null;
        }
        if (nextRegistered != null) {
            this.managedBeans.add(nextRegistered.getObjectName());
        }
        nextRegistered = null;
    }

    private void registerSystemBeans() {
        ObjectInstance nextRegistered = null;
        SigarLoadAverage loadAvg = new SigarLoadAverage(this.sigarImpl);
        try {
            if (!this.mbeanServer.isRegistered(new ObjectName(loadAvg.getObjectName()))) {
                nextRegistered = this.mbeanServer.registerMBean(loadAvg, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nextRegistered != null) {
            this.managedBeans.add(nextRegistered.getObjectName());
        }
        nextRegistered = null;
    }

    public void preDeregister() throws Exception {
        for (int i = this.managedBeans.size() - 1; i >= 0; --i) {
            ObjectName next = (ObjectName)this.managedBeans.remove(i);
            if (!this.mbeanServer.isRegistered(next)) continue;
            try {
                this.mbeanServer.unregisterMBean(next);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.preDeregister();
    }

    static {
        MBEAN_CONSTR_DEFAULT = new MBeanConstructorInfo(SigarRegistry.class.getName(), "Creates a new instance of this class. Will create the Sigar instance this class uses when constructing other MBeans", new MBeanParameterInfo[0]);
        MBEAN_INFO = new MBeanInfo(SigarRegistry.class.getName(), "Sigar MBean registry. Provides a central point for creation and destruction of Sigar MBeans. Any Sigar MBean created via this instance will automatically be cleaned up when this instance is deregistered from the MBean server.", null, new MBeanConstructorInfo[]{MBEAN_CONSTR_DEFAULT}, null, null);
    }
}

