/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class MessageDigest
implements DEREncodable {
    private DEROctetString digest;

    public MessageDigest(byte[] byArray) {
        this.setDigest(byArray);
    }

    public MessageDigest(DEROctetString dEROctetString) {
        this.digest = dEROctetString;
    }

    public MessageDigest(MessageDigest messageDigest) {
        this.digest = messageDigest.digest;
    }

    public static MessageDigest getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MessageDigest) {
            return (MessageDigest)object;
        }
        if (object instanceof DEROctetString) {
            return new MessageDigest((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return MessageDigest.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid MessageDigest");
    }

    public static MessageDigest newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MessageDigest) {
            return new MessageDigest((MessageDigest)object);
        }
        if (object instanceof DEROctetString) {
            return new MessageDigest((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return MessageDigest.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid MessageDigest");
    }

    public byte[] getDigest() {
        return this.digest.getOctets();
    }

    private void setDigest(byte[] byArray) {
        this.digest = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.digest;
    }
}

