/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class JCEECPublicKey
implements ECPublicKey {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;

    JCEECPublicKey(String string, ECPublicKeySpec eCPublicKeySpec) {
        this.algorithm = string;
        this.q = eCPublicKeySpec.getQ();
        this.ecSpec = eCPublicKeySpec.getParams();
    }

    JCEECPublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.q = eCPublicKeyParameters.getQ();
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    JCEECPublicKey(String string, ECPublicKey eCPublicKey) {
        this.q = eCPublicKey.getQ();
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParams();
    }

    JCEECPublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.q = eCPoint;
        this.ecSpec = eCParameterSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Object object;
        Object object2;
        DEREncodable dEREncodable;
        X962Parameters x962Parameters = new X962Parameters((DERObject)subjectPublicKeyInfo.getAlgorithmId().getParameters());
        if (x962Parameters.isNamedCurve()) {
            dEREncodable = (DERObjectIdentifier)x962Parameters.getParameters();
            object2 = X962NamedCurves.getByOID((DERObjectIdentifier)dEREncodable);
            this.ecSpec = new ECNamedCurveParameterSpec(X962NamedCurves.getName((DERObjectIdentifier)dEREncodable), ((X9ECParameters)object2).getCurve(), ((X9ECParameters)object2).getG(), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH(), ((X9ECParameters)object2).getSeed());
        } else {
            dEREncodable = new X9ECParameters((DERConstructedSequence)x962Parameters.getParameters());
            this.ecSpec = new ECParameterSpec(((X9ECParameters)dEREncodable).getCurve(), ((X9ECParameters)dEREncodable).getG(), ((X9ECParameters)dEREncodable).getN(), ((X9ECParameters)dEREncodable).getH(), ((X9ECParameters)dEREncodable).getSeed());
        }
        dEREncodable = subjectPublicKeyInfo.getPublicKeyData();
        object2 = ((DERBitString)dEREncodable).getBytes();
        DEROctetString dEROctetString = new DEROctetString((byte[])object2);
        if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
            try {
                object = new ByteArrayInputStream((byte[])object2);
                DERInputStream dERInputStream = new DERInputStream((InputStream)object);
                dEROctetString = (DEROctetString)dERInputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        object = new X9ECPoint(this.ecSpec.getCurve(), dEROctetString);
        this.q = ((X9ECPoint)object).getPoint();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        DEREncodable dEREncodable;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X962Parameters x962Parameters = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            x962Parameters = new X962Parameters(X962NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()));
        } else {
            dEREncodable = new X9ECParameters(this.ecSpec.getCurve(), this.ecSpec.getG(), this.ecSpec.getN(), this.ecSpec.getH(), this.ecSpec.getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)dEREncodable);
        }
        dEREncodable = (DEROctetString)new X9ECPoint(this.getQ()).getDERObject();
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.getDERObject()), ((ASN1OctetString)dEREncodable).getOctets());
        try {
            dEROutputStream.writeObject(subjectPublicKeyInfo);
            dEROutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding EC public key");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key" + string);
        stringBuffer.append("            X: " + this.getQ().getX().toBigInteger().toString(16) + string);
        stringBuffer.append("            Y: " + this.getQ().getY().toBigInteger().toString(16) + string);
        return stringBuffer.toString();
    }
}

