/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.MultiPartBackupAdapter;
import com.parablu.epa.core.helper.FileSystemUtility;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUploadCallable
implements Callable<BackupTO> {
    private Logger logger = LoggerFactory.getLogger(MultipartUploadCallable.class);
    private static Logger failedFileLog = LoggerFactory.getLogger((String)"failedFileLogger");
    private long restartId;
    List<BackupTO> chunkFileBatch;
    GatewayTO uploadGatewayTo;
    String requestURL;
    String backupBatchID;
    AtomicInteger uploadCount;
    AtomicLong totalUploadSize;
    BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
    BackupActivityTO backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
    BackupPolicyTO backupPolicyTO;
    CleanupInterface<BackupTO> cleanupInterface;
    int priority;
    MultiPartBackupAdapter multiPartBackupAdapter = null;
    private RateLimiter rateLimiter;
    private static final String EXCEPTION_OCCURED = "Exception Occured";
    private static final String FALSE = "false";
    private int errorCode;
    private static boolean isFullBackup;
    private List<BackupTO> failedBackupTOs;
    private int uploadedChunkCount;
    private static String isBackupManual;
    private BlockingQueue<Future<BackupTO>> finishedBatchesQueue;

    public MultipartUploadCallable(List<BackupTO> chuckFileBatch, GatewayTO uploadGatewayTo, String backupBatchID, AtomicInteger uploadCount, BackupPolicyTO currentPolicyTO, CleanupInterface<BackupTO> cleanupInterface, String requestURL, RateLimiter rateLimiter, int priority, boolean isFullBackup, AtomicLong totalUploadSize, String isBackupManual, BlockingQueue<Future<BackupTO>> finishedBatchesQueue) {
        this.restartId = NotificationHelper.getBackupRestartId();
        this.chunkFileBatch = chuckFileBatch;
        this.uploadGatewayTo = uploadGatewayTo;
        this.backupBatchID = backupBatchID;
        this.uploadCount = uploadCount;
        this.backupPolicyTO = currentPolicyTO;
        this.cleanupInterface = cleanupInterface;
        this.requestURL = requestURL;
        this.rateLimiter = rateLimiter;
        this.priority = priority;
        MultipartUploadCallable.isFullBackup = isFullBackup;
        this.totalUploadSize = totalUploadSize;
        this.failedBackupTOs = new ArrayList<BackupTO>();
        this.finishedBatchesQueue = finishedBatchesQueue;
        MultipartUploadCallable.isBackupManual = isBackupManual;
    }

    /*
     * Exception decompiling
     */
    @Override
    public BackupTO call() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeFailedBackupTOs() {
        Iterator<BackupTO> iter = this.chunkFileBatch.iterator();
        block0: while (iter.hasNext()) {
            BackupTO to = iter.next();
            for (BackupTO backupTo : this.failedBackupTOs) {
                if (to.getRestartId() != backupTo.getRestartId()) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void uploadChunkNameListFile(BackupTO backupTO, long fileSize, List<String> chunkNamesInList, File file) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        StringBuilder chunkNames = new StringBuilder();
        for (String name : chunkNamesInList) {
            chunkNames.append(name);
        }
        this.cleanupInterface.updateChunkFileDetail(backupTO, this.uploadedChunkCount);
        this.multiPartBackupAdapter.addFormField();
        this.logger.debug("Before adding header in req");
        MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
        this.logger.debug("Before adding chunk header in req");
        String md5 = MD5Generator.generateMD5ForByteArray((byte[])chunkNames.toString().getBytes());
        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, "chunkvalues");
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", FALSE);
        this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(chunkNames.toString().getBytes()), this.rateLimiter);
        this.logger.debug("Upload chunk name list file completed");
    }

    private void addChunkDetailsForMultipart(BackupTO backupTO, int numberOfChunks, byte[] actualData, List<String> chunkNamesInList, File file) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        this.multiPartBackupAdapter.addFormField();
        MultipartUploadCallable.addHeaderToMultipart(this.multiPartBackupAdapter, backupTO, this.uploadGatewayTo, file, this.restartId, this.backupBatchID);
        String md5 = MD5Generator.generateMD5ForByteArray((byte[])actualData);
        String chunkName = String.format("part%09d.%s", numberOfChunks, md5);
        this.logger.debug("Chunk Name is :" + chunkName + " for File Name is :" + backupTO.getFileName());
        this.addHeaderToMultipartforChunks(this.multiPartBackupAdapter, backupTO, md5, chunkName);
        this.multiPartBackupAdapter.addHeaderField("isAChunkFile", "true");
        this.multiPartBackupAdapter.addFilePart((InputStream)new ByteArrayInputStream(actualData), this.rateLimiter);
        chunkNamesInList.add(chunkName + ",");
    }

    private void updateChunkDetailForUI(BackupTO backupTO, long fileSize, long totalBytesRead) {
        this.uploadedChunkCount = (int)((double)totalBytesRead / (double)fileSize * 100.0);
        this.cleanupInterface.updateChunkFileDetail(backupTO, this.uploadedChunkCount);
    }

    private void addHeaderToMultipartforChunks(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, String md5, String fileName) {
        multiPartBackupAdapter.addHeaderField("fileChunkNamesa", "");
        multiPartBackupAdapter.addHeaderField("prevBackupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("chunkFileMD5", md5);
        multiPartBackupAdapter.addHeaderField("chunkFileName", fileName);
        multiPartBackupAdapter.addHeaderField("isNormalFile", FALSE);
        multiPartBackupAdapter.addHeaderField("isCompressed", String.valueOf(this.backupPolicyTO.isCompressionEnabled()));
    }

    private static void addHeaderToMultipart(MultiPartBackupAdapter multiPartBackupAdapter, BackupTO fileToUpload, GatewayTO currentUploadGatewayToUse, File file, long restartId, String batchIdForBackup) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        multiPartBackupAdapter.addHeaderField("gatewayName", currentUploadGatewayToUse.getGatewayName());
        multiPartBackupAdapter.addHeaderField("fileMD5", fileToUpload.getMd5checksum());
        multiPartBackupAdapter.addHeaderField("dedupifiedBackupId", "");
        multiPartBackupAdapter.addHeaderField("maxVersions", String.valueOf(SettingHelper.getMaxVersionsToKeep()));
        multiPartBackupAdapter.addHeaderField("is-base-folder", String.valueOf(fileToUpload.isBaseFolder()));
        multiPartBackupAdapter.addHeaderField("is-folder", String.valueOf(fileToUpload.isFolder()));
        multiPartBackupAdapter.addHeaderField("is-exists", String.valueOf(true));
        multiPartBackupAdapter.addHeaderField("modified", String.valueOf(fileToUpload.getLastModifiedTimestamp()));
        multiPartBackupAdapter.addHeaderField("accessTime", String.valueOf(file != null ? Long.valueOf(FileSystemUtility.getFileAccessTime((File)file)) : "0"));
        multiPartBackupAdapter.addHeaderField("creationTime", String.valueOf(file != null ? Long.valueOf(FileSystemUtility.getFileCreatedTime((File)file)) : "0"));
        multiPartBackupAdapter.addHeaderField("backupBatchId", batchIdForBackup);
        multiPartBackupAdapter.addHeaderField("userUnderLegalHold", FALSE);
        multiPartBackupAdapter.addHeaderField("userName", SettingHelper.getUserName().toLowerCase());
        multiPartBackupAdapter.addHeaderField("deviceUUID", SettingHelper.getDeviceUUId());
        multiPartBackupAdapter.addHeaderField("file-path", fileToUpload.getAbstractFilePath());
        multiPartBackupAdapter.addHeaderField("file-name", fileToUpload.getFileName());
        multiPartBackupAdapter.addHeaderField("cloudName", SettingHelper.getCloudName());
        multiPartBackupAdapter.addHeaderField("prevGatewayName", "");
        multiPartBackupAdapter.addHeaderField("token", SettingHelper.readTokenFromFile());
        multiPartBackupAdapter.addHeaderField("osType", SettingHelper.getOsName());
        multiPartBackupAdapter.addHeaderField("file-size", String.valueOf(file.length()));
        multiPartBackupAdapter.addHeaderField("restartId", String.valueOf(fileToUpload.getRestartId()));
        multiPartBackupAdapter.addHeaderField("backupId", fileToUpload.getBackupId());
        multiPartBackupAdapter.addHeaderField("isFullBackup", Boolean.toString(isFullBackup));
        multiPartBackupAdapter.addHeaderField("gatewayType", currentUploadGatewayToUse.getType());
        multiPartBackupAdapter.addHeaderField("isBackupManual", isBackupManual);
        multiPartBackupAdapter.addHeaderField("isSync", String.valueOf(fileToUpload.isSync()));
        multiPartBackupAdapter.addHeaderField("miniCloudId", fileToUpload.getMiniCloudId());
        if (fileToUpload.isSync()) {
            multiPartBackupAdapter.addHeaderField("crawlTimestamp", String.valueOf(fileToUpload.getCrawlTimestamp()));
        }
    }

    public void cancelUpload() {
        this.cleanupInterface.updateBackupCrawlTable(this.failedBackupTOs);
        this.failedBackupTOs.clear();
        if (this.multiPartBackupAdapter != null) {
            this.logger.debug("Canceling upload>>>>>>>>");
            this.multiPartBackupAdapter.cancelUpload();
        } else {
            this.logger.debug("multiThreadBackupAdapter is null>>>>>>>>>>>>");
        }
    }
}

