/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.stringliterals.SyncLiterals;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.ActivityHistoryView;
import com.parablu.epa.view.FontsManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotificationView
extends BaseView {
    private Logger logger = LoggerFactory.getLogger(NotificationView.class);
    private Composite notificationGroup = null;
    private Composite progressStackedComposite = null;
    private StackLayout stackLayout = null;
    private Group uploadDownloadProgressComposite = null;
    private Composite syncDetailsComposite = null;
    private Timer notificationTimer = null;
    private TimerTask notificationTask = null;
    private Composite currentStatusPanel = null;
    private Label currentStatusMainLabel = null;
    private Label currentStatusValueLabel = null;
    private Group uploadProgressGroup = null;
    private Label uploadProgressCurFileBeingUploadedLabel = null;
    private Label uploadProgressCurFileBeingUploadedText = null;
    private Label uploadProgressCurUploadProgressLabel = null;
    private Label uploadProgressCurUploadProgressText = null;
    private Group downloadProgressGroup = null;
    private Label downloadProgressCurFileBeingDownloadedLabel = null;
    private Label downloadProgressCurFileBeingDownloadedText = null;
    private Label downloadProgressCurDownloadProgressLabel = null;
    private Label downloadProgressCurDownloadProgressText = null;
    private Link activityLink = null;
    private Group lastsyncDetailsGroup = null;
    private Label lastSyncLabel = null;
    private Composite buttonPannel = null;
    private Button manualSycButton = null;
    public Button manualBackupButton = null;
    private Label label = null;
    public Label fileBeingBackedUpLabel = null;
    private FontsManager fontsManager;
    private Color notificationcolor = null;
    private Color errorColor = null;
    private Shell activityShell = null;
    private ActivityHistoryView activityHistoryView = null;
    private Image shellImage;
    private ImageData shellImageData;
    private final SimpleDateFormat activityLogdateFmt = new SimpleDateFormat("HH:mm:ss MMM d");
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    private Label backupStatusLabel = null;

    public NotificationView(Composite composite) {
        this.mainParentComposite = composite;
        this.generateUI();
    }

    private void generateUI() {
        int minStringLengths = 114;
        int minDownloadTextStringLengths = 130;
        int minUploadTextStringLengths = 146;
        GridData settingsGroupGridData = new GridData(1808);
        GridData currentStatusNameLabelGridData = new GridData(768);
        GridData uploadProgressCurFileBeingUploadedLabelGridData = new GridData();
        GridData uploadProgressCurFileBeingUploadedTextGridData = new GridData(512);
        GridData uploadProgressCurUploadProgressLabelGridData = new GridData();
        GridData uploadProgressCurUploadProgressTextGridData = new GridData(512);
        GridData downloadProgressCurFileBeingDownloadedLabelGridData = new GridData();
        GridData downloadProgressCurFileBeingDownloadedTextGridData = new GridData(512);
        GridData downloadProgressCurDownloadProgressLabelGridData = new GridData();
        GridData downloadProgressCurDownloadProgressTextGridData = new GridData(512);
        GridLayout notificationGroupGridLayout = new GridLayout();
        GridLayout buttonPannelGridLayout = new GridLayout();
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.notificationcolor = new Color((Device)display, 69, 170, 64);
        this.errorColor = new Color((Device)display, 241, 35, 35);
        this.baseGroup = new Composite(this.mainParentComposite, 4);
        this.baseGroup.setLayoutData((Object)settingsGroupGridData);
        GridLayout baseGroupGridLayout = new GridLayout();
        baseGroupGridLayout.verticalSpacing = 6;
        baseGroupGridLayout.marginBottom = 0;
        baseGroupGridLayout.marginTop = 0;
        baseGroupGridLayout.marginRight = 0;
        baseGroupGridLayout.marginLeft = 0;
        this.baseGroup.setLayout((Layout)baseGroupGridLayout);
        this.baseGroup.setLayoutData((Object)new GridData(1808));
        this.notificationGroup = new Composite(this.baseGroup, 0);
        this.notificationGroup.setLayoutData((Object)new GridData(1808));
        notificationGroupGridLayout.numColumns = 1;
        notificationGroupGridLayout.marginTop = 10;
        notificationGroupGridLayout.marginBottom = 0;
        notificationGroupGridLayout.marginRight = 0;
        notificationGroupGridLayout.verticalSpacing = 10;
        this.notificationGroup.setLayout((Layout)notificationGroupGridLayout);
        if (SettingHelper.getSyncLicenced().contentEquals("true")) {
            this.renderSyncNotificationGroup(114, 130, 146, currentStatusNameLabelGridData, uploadProgressCurFileBeingUploadedLabelGridData, uploadProgressCurFileBeingUploadedTextGridData, uploadProgressCurUploadProgressLabelGridData, uploadProgressCurUploadProgressTextGridData, downloadProgressCurFileBeingDownloadedLabelGridData, downloadProgressCurFileBeingDownloadedTextGridData, downloadProgressCurDownloadProgressLabelGridData, downloadProgressCurDownloadProgressTextGridData, buttonPannelGridLayout);
        }
        if (SettingHelper.getBackupLicenced().contentEquals("true")) {
            // empty if block
        }
        if (SettingHelper.getSyncLicenced().contentEquals("true")) {
            if (NotificationHelper.getMainStatus() == 101) {
                this.uploadDownloadProgressComposite.setParent(this.progressStackedComposite);
                this.stackLayout.topControl = this.uploadDownloadProgressComposite;
                this.progressStackedComposite.layout();
            } else {
                this.syncDetailsComposite.setParent(this.progressStackedComposite);
                this.stackLayout.topControl = this.syncDetailsComposite;
                this.progressStackedComposite.layout();
            }
        }
    }

    private void renderSyncNotificationGroup(int minStringLengths, int minDownloadTextStringLengths, int minUploadTextStringLengths, GridData currentStatusNameLabelGridData, GridData uploadProgressCurFileBeingUploadedLabelGridData, GridData uploadProgressCurFileBeingUploadedTextGridData, GridData uploadProgressCurUploadProgressLabelGridData, GridData uploadProgressCurUploadProgressTextGridData, GridData downloadProgressCurFileBeingDownloadedLabelGridData, GridData downloadProgressCurFileBeingDownloadedTextGridData, GridData downloadProgressCurDownloadProgressLabelGridData, GridData downloadProgressCurDownloadProgressTextGridData, GridLayout buttonPannelGridLayout) {
        GridData buttonPannelGridData = new GridData(1024);
        GridData manualSycButtonGridData = new GridData();
        this.lastsyncDetailsGroup = new Group(this.notificationGroup, 16);
        GridLayout lastsyncDetailsGroupGridLayout = new GridLayout();
        lastsyncDetailsGroupGridLayout.marginHeight = 5;
        lastsyncDetailsGroupGridLayout.marginWidth = 10;
        lastsyncDetailsGroupGridLayout.verticalSpacing = 10;
        this.lastsyncDetailsGroup.setText("Sync Details");
        this.lastsyncDetailsGroup.setLayout((Layout)lastsyncDetailsGroupGridLayout);
        this.lastsyncDetailsGroup.setLayoutData((Object)new GridData(1808));
        this.currentStatusValueLabel = new Label((Composite)this.lastsyncDetailsGroup, 16384);
        this.currentStatusValueLabel.setLayoutData((Object)currentStatusNameLabelGridData);
        this.currentStatusValueLabel.setFont(this.fontsManager.getLargeNormalFont());
        this.currentStatusValueLabel.setText("");
        this.currentStatusValueLabel.setText(SyncLiterals.INSYNC_LABEL);
        this.progressStackedComposite = new Composite((Composite)this.lastsyncDetailsGroup, 4);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.progressStackedComposite.setLayout((Layout)this.stackLayout);
        this.progressStackedComposite.setLayoutData((Object)new GridData(768));
        this.syncDetailsComposite = new Composite(this.progressStackedComposite, 4);
        GridLayout syncDetailsCompositeGridLayout = new GridLayout();
        syncDetailsCompositeGridLayout.marginHeight = 0;
        syncDetailsCompositeGridLayout.marginBottom = 0;
        syncDetailsCompositeGridLayout.marginLeft = 0;
        syncDetailsCompositeGridLayout.marginRight = 0;
        this.syncDetailsComposite.setLayout((Layout)syncDetailsCompositeGridLayout);
        this.syncDetailsComposite.setLayoutData((Object)new GridData(768));
        this.lastSyncLabel = new Label(this.syncDetailsComposite, 320);
        this.lastSyncLabel.setText("Last successful sync at: " + (NotificationHelper.getLastSyncTime() != 0L ? this.activityLogdateFmt.format(new Date(NotificationHelper.getLastSyncTime())) : " N.A "));
        this.lastSyncLabel.setFont(this.fontsManager.getSmallNormalFont());
        this.lastSyncLabel.setLayoutData((Object)new GridData(768));
        this.uploadDownloadProgressComposite = new Group(this.progressStackedComposite, 4);
        this.uploadDownloadProgressComposite.setText("Sync Status");
        this.uploadDownloadProgressComposite.setFont(this.fontsManager.getSmallNormalFont());
        GridLayout uploadDownloadProgressCompositeGridLayout = new GridLayout();
        uploadDownloadProgressCompositeGridLayout.marginHeight = 5;
        uploadDownloadProgressCompositeGridLayout.marginBottom = 5;
        uploadDownloadProgressCompositeGridLayout.marginLeft = 0;
        uploadDownloadProgressCompositeGridLayout.marginRight = 0;
        uploadDownloadProgressCompositeGridLayout.marginWidth = 5;
        uploadDownloadProgressCompositeGridLayout.numColumns = 2;
        uploadDownloadProgressCompositeGridLayout.verticalSpacing = 10;
        this.uploadDownloadProgressComposite.setLayout((Layout)uploadDownloadProgressCompositeGridLayout);
        this.uploadDownloadProgressComposite.setLayoutData((Object)new GridData(768));
        this.uploadProgressCurFileBeingUploadedLabel = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        uploadProgressCurFileBeingUploadedLabelGridData.verticalSpan = 2;
        uploadProgressCurFileBeingUploadedLabelGridData.minimumWidth = minStringLengths;
        this.uploadProgressCurFileBeingUploadedLabel.setLayoutData((Object)uploadProgressCurFileBeingUploadedLabelGridData);
        this.uploadProgressCurFileBeingUploadedLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.uploadProgressCurFileBeingUploadedLabel.setText("File Uploading - ");
        this.uploadProgressCurFileBeingUploadedText = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        uploadProgressCurFileBeingUploadedTextGridData.verticalSpan = 2;
        uploadProgressCurFileBeingUploadedTextGridData.widthHint = minUploadTextStringLengths;
        this.uploadProgressCurFileBeingUploadedText.setLayoutData((Object)uploadProgressCurFileBeingUploadedTextGridData);
        this.uploadProgressCurFileBeingUploadedText.setFont(this.fontsManager.getMediumNormalFont());
        this.uploadProgressCurFileBeingUploadedText.setText("");
        this.uploadProgressCurUploadProgressLabel = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        uploadProgressCurUploadProgressLabelGridData.verticalSpan = 2;
        uploadProgressCurUploadProgressLabelGridData.minimumWidth = minStringLengths;
        this.uploadProgressCurUploadProgressLabel.setLayoutData((Object)uploadProgressCurUploadProgressLabelGridData);
        this.uploadProgressCurUploadProgressLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.uploadProgressCurUploadProgressLabel.setText("Files Uploaded - ");
        this.uploadProgressCurUploadProgressText = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        uploadProgressCurUploadProgressTextGridData.verticalSpan = 2;
        uploadProgressCurUploadProgressTextGridData.widthHint = minUploadTextStringLengths;
        this.uploadProgressCurUploadProgressText.setLayoutData((Object)uploadProgressCurUploadProgressTextGridData);
        this.uploadProgressCurUploadProgressText.setFont(this.fontsManager.getMediumNormalFont());
        this.uploadProgressCurUploadProgressText.setText("");
        this.downloadProgressCurFileBeingDownloadedLabel = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        downloadProgressCurFileBeingDownloadedLabelGridData.verticalSpan = 2;
        downloadProgressCurFileBeingDownloadedLabelGridData.minimumWidth = minStringLengths;
        this.downloadProgressCurFileBeingDownloadedLabel.setLayoutData((Object)downloadProgressCurFileBeingDownloadedLabelGridData);
        this.downloadProgressCurFileBeingDownloadedLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.downloadProgressCurFileBeingDownloadedLabel.setText("File Downloading - ");
        this.downloadProgressCurFileBeingDownloadedText = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        downloadProgressCurFileBeingDownloadedTextGridData.verticalSpan = 2;
        downloadProgressCurFileBeingDownloadedTextGridData.minimumWidth = minDownloadTextStringLengths;
        this.downloadProgressCurFileBeingDownloadedText.setLayoutData((Object)downloadProgressCurFileBeingDownloadedTextGridData);
        this.downloadProgressCurFileBeingDownloadedText.setFont(this.fontsManager.getMediumNormalFont());
        this.downloadProgressCurFileBeingDownloadedText.setText("");
        this.downloadProgressCurDownloadProgressLabel = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        downloadProgressCurDownloadProgressLabelGridData.verticalSpan = 2;
        downloadProgressCurDownloadProgressLabelGridData.widthHint = minStringLengths;
        this.downloadProgressCurDownloadProgressLabel.setLayoutData((Object)downloadProgressCurDownloadProgressLabelGridData);
        this.downloadProgressCurDownloadProgressLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.downloadProgressCurDownloadProgressLabel.setText("Files Downloaded  - ");
        this.downloadProgressCurDownloadProgressText = new Label((Composite)this.uploadDownloadProgressComposite, 256);
        downloadProgressCurDownloadProgressTextGridData.verticalSpan = 2;
        downloadProgressCurDownloadProgressTextGridData.widthHint = minDownloadTextStringLengths;
        this.downloadProgressCurDownloadProgressText.setLayoutData((Object)downloadProgressCurDownloadProgressTextGridData);
        this.downloadProgressCurDownloadProgressText.setFont(this.fontsManager.getMediumNormalFont());
        this.downloadProgressCurDownloadProgressText.setText("");
        this.buttonPannel = new Composite((Composite)this.lastsyncDetailsGroup, 4);
        buttonPannelGridLayout.marginTop = 0;
        buttonPannelGridLayout.marginLeft = 0;
        buttonPannelGridLayout.marginWidth = 0;
        buttonPannelGridLayout.horizontalSpacing = 80;
        buttonPannelGridLayout.numColumns = 2;
        this.buttonPannel.setLayout((Layout)buttonPannelGridLayout);
        this.activityLink = new Link(this.buttonPannel, 256);
        this.activityLink.setText("<a>Sync Activity Details</a>");
        this.activityLink.setFont(this.fontsManager.getMediumNormalFont());
        this.activityLink.setLayoutData((Object)new GridData());
        this.activityLink.setFocus();
        Listener listener = event -> {
            if (this.activityShell != null && !this.activityShell.isDisposed()) {
                this.activityShell.forceActive();
            } else {
                this.activityShell = new Shell(Display.getCurrent(), 65728);
                this.shellImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
                this.shellImage = new Image((Device)this.activityShell.getDisplay(), this.shellImageData.scaledTo(72, 72));
                this.activityShell.setImage(this.shellImage);
                this.activityShell.setText("Sync - Activity History");
                this.activityShell.setLocation(this.activityLink.getShell().getLocation());
                Listener listnr = arg0 -> {
                    this.activityHistoryView.disposeAllActivityHistoryFields();
                    this.activityShell.dispose();
                };
                this.activityShell.addListener(21, listnr);
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginWidth = 0;
                gridLayout.marginHeight = 0;
                this.activityShell.setLayout((Layout)gridLayout);
                this.activityHistoryView = new ActivityHistoryView((Composite)this.activityShell);
                this.activityShell.pack();
                this.activityShell.open();
                this.activityHistoryView.startActivityTimerTask();
            }
        };
        this.activityLink.addListener(13, listener);
        this.buttonPannel.setLayoutData((Object)buttonPannelGridData);
        this.manualSycButton = new Button(this.buttonPannel, 8);
        this.manualSycButton.setText("Sync Now");
        this.manualSycButton.setFont(this.fontsManager.getMediumNormalFont());
        this.manualSycButton.setLayoutData((Object)manualSycButtonGridData);
        this.manualSycButton.setEnabled(true);
        this.manualSycButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NotificationView.this.logger.info("starting ManualSyncProcess");
                NotificationView.this.startManualSyncProcess();
            }
        });
    }

    protected void startManualSyncProcess() {
        if (!SettingHelper.isEnableBlusync()) {
            NotificationHelper.setCurrentActivityState((int)9);
        }
        ManualSyncHelper.startManualSync();
        this.manualSycButton.setEnabled(false);
    }

    protected void setUploadDownloadGroupsVisible() {
        if (this.downloadProgressGroup != null && !this.downloadProgressGroup.isDisposed()) {
            this.downloadProgressGroup.setVisible(true);
        }
        if (this.uploadProgressGroup != null && !this.uploadProgressGroup.isDisposed()) {
            this.uploadProgressGroup.setVisible(true);
        }
    }

    public void startNotificationTimerTask() {
        if (this.notificationTimer == null) {
            this.notificationTimer = new Timer();
        }
        if (this.notificationTask == null) {
            this.notificationTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        NotificationView.this.updateNotifications();
                        NotificationView.this.updateDisplay();
                    }
                    catch (Exception e) {
                        NotificationView.this.logger.error("Exception occured during the updating the timer,probrably cause the display was null" + e);
                    }
                }
            };
            this.notificationTimer.schedule(this.notificationTask, 10L, 1000L);
        }
    }

    private void updateDisplay() {
        if (this.mainParentComposite.getDisplay() == null) {
            return;
        }
        Runnable runnable = () -> {
            if (this.manualBackupButton == null || this.manualBackupButton.isDisposed()) {
                return;
            }
            try {
                String lastSuccessfullBackupTime;
                if (SettingHelper.getLastSuccessfulBackup() == 0L) {
                    lastSuccessfullBackupTime = " N.A ";
                } else {
                    SimpleDateFormat activityLogdateFormat = new SimpleDateFormat("d MMM HH:mm:ss");
                    lastSuccessfullBackupTime = activityLogdateFormat.format(SettingHelper.getLastSuccessfulBackup());
                }
                this.backupStatusLabel.setText("");
                if (NotificationHelper.getBackupStatus() == 0) {
                    this.manualBackupButton.setEnabled(true);
                    this.backupStatusLabel.setText("Cloud Not Reachable");
                    this.label.setText((String)(NotificationHelper.backUpStarted ? "Backup in progress" : "Last successfull backup at: " + lastSuccessfullBackupTime));
                }
                if (NotificationHelper.backUpStarted) {
                    this.fileBeingBackedUpLabel.setVisible(true);
                    if (this.manualBackupButton.isEnabled()) {
                        this.manualBackupButton.setEnabled(false);
                        this.label.setText((String)(NotificationHelper.backUpStarted ? "Backup in progress" : "Last successfull backup at: " + lastSuccessfullBackupTime));
                    }
                } else {
                    this.fileBeingBackedUpLabel.setVisible(false);
                    if (!this.manualBackupButton.isEnabled()) {
                        this.manualBackupButton.setEnabled(true);
                        this.label.setText((String)(NotificationHelper.backUpStarted ? "Backup in progress" : "Last successfull backup at: " + lastSuccessfullBackupTime));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(null, (Object)e.getStackTrace(), (Object)e);
            }
        };
        this.mainParentComposite.getDisplay().asyncExec(runnable);
    }

    protected synchronized void updateNotifications() {
        Display display = this.mainParentComposite.getDisplay();
        if (display == null) {
            this.logger.debug("Display for this shell is null");
            return;
        }
        display.asyncExec((Runnable)new NotificationUpdaterRunnable());
    }

    private void stopNotificationTimerTask() {
        this.notificationTimer.cancel();
        this.notificationTimer = null;
        this.notificationTask = null;
    }

    public void disposeAllNotification() {
        this.stopNotificationTimerTask();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        if (this.activityShell != null && !this.activityShell.isDisposed()) {
            this.activityShell.close();
        }
        this.fontsManager.disposeFonts();
        if (this.notificationcolor != null && !this.notificationcolor.isDisposed()) {
            this.notificationcolor.dispose();
        }
        if (this.errorColor != null && !this.errorColor.isDisposed()) {
            this.errorColor.dispose();
        }
        this.disposeCurrentStatusFields();
        this.disposeUploadProgressFields();
        this.disposeDownloadProgressFields();
        this.disposeManualSyncFields();
        if (this.buttonPannel != null) {
            this.buttonPannel.dispose();
        }
        if (this.currentStatusPanel != null) {
            this.currentStatusPanel.dispose();
        }
        if (this.uploadProgressGroup != null) {
            this.uploadProgressGroup.dispose();
        }
        if (this.downloadProgressGroup != null) {
            this.downloadProgressGroup.dispose();
        }
        if (this.notificationGroup != null) {
            this.notificationGroup.dispose();
        }
        this.buttonPannel = null;
        this.currentStatusPanel = null;
        this.uploadProgressGroup = null;
        this.downloadProgressGroup = null;
        this.notificationGroup = null;
    }

    private void disposeManualSyncFields() {
        if (this.manualSycButton != null) {
            this.manualSycButton.dispose();
        }
        this.manualSycButton = null;
    }

    private void disposeDownloadProgressFields() {
        if (this.downloadProgressCurFileBeingDownloadedLabel != null) {
            this.downloadProgressCurFileBeingDownloadedLabel.dispose();
        }
        if (this.downloadProgressCurFileBeingDownloadedText != null) {
            this.downloadProgressCurFileBeingDownloadedText.dispose();
        }
        if (this.downloadProgressCurDownloadProgressLabel != null) {
            this.downloadProgressCurDownloadProgressLabel.dispose();
        }
        if (this.downloadProgressCurDownloadProgressText != null) {
            this.downloadProgressCurDownloadProgressText.dispose();
        }
        this.downloadProgressCurFileBeingDownloadedLabel = null;
        this.downloadProgressCurFileBeingDownloadedText = null;
        this.downloadProgressCurDownloadProgressLabel = null;
        this.downloadProgressCurDownloadProgressText = null;
    }

    private void disposeUploadProgressFields() {
        if (this.uploadProgressCurFileBeingUploadedLabel != null) {
            this.uploadProgressCurFileBeingUploadedLabel.dispose();
        }
        if (this.uploadProgressCurFileBeingUploadedText != null) {
            this.uploadProgressCurFileBeingUploadedText.dispose();
        }
        if (this.uploadProgressCurUploadProgressLabel != null) {
            this.uploadProgressCurUploadProgressLabel.dispose();
        }
        if (this.uploadProgressCurUploadProgressText != null) {
            this.uploadProgressCurUploadProgressText.dispose();
        }
        this.uploadProgressCurFileBeingUploadedLabel = null;
        this.uploadProgressCurFileBeingUploadedText = null;
        this.uploadProgressCurUploadProgressLabel = null;
        this.uploadProgressCurUploadProgressText = null;
    }

    private void disposeCurrentStatusFields() {
        if (this.currentStatusMainLabel != null) {
            this.currentStatusMainLabel.dispose();
        }
        if (this.currentStatusValueLabel != null) {
            this.currentStatusValueLabel.dispose();
        }
        this.currentStatusMainLabel = null;
        this.currentStatusValueLabel = null;
    }

    class NotificationUpdaterRunnable
    implements Runnable {
        NotificationUpdaterRunnable() {
        }

        @Override
        public void run() {
            int lengthForFileName = 20;
            this.changeNotificationStatus();
            this.changeUploadStatus(20);
            this.chnageDownloadStatus(20);
            this.changeBackupStatus();
            this.changeIdleStatus();
        }

        private void changeBackupStatus() {
            int lengthForFileName = 20;
            String fileBeingBackedUp = NotificationHelper.getFileBeingBackedup();
            if (fileBeingBackedUp != null && NotificationView.this.fileBeingBackedUpLabel != null) {
                if (fileBeingBackedUp.length() > 20) {
                    fileBeingBackedUp = new StringBuffer().append(fileBeingBackedUp.substring(0, 20)).append("...").toString();
                }
                NotificationView.this.fileBeingBackedUpLabel.setText("File being backed up: " + fileBeingBackedUp);
                NotificationView.this.fileBeingBackedUpLabel.setToolTipText(NotificationHelper.getFileBeingBackedup());
            }
        }

        private void changeIdleStatus() {
            if (NotificationView.this.lastSyncLabel != null && !NotificationView.this.lastSyncLabel.isDisposed()) {
                NotificationView.this.lastSyncLabel.setText("");
                NotificationView.this.lastSyncLabel.setText("Last successful sync at: " + (NotificationHelper.getLastSyncTime() != 0L ? NotificationView.this.activityLogdateFmt.format(new Date(NotificationHelper.getLastSyncTime())) : " N.A "));
            }
            if (NotificationView.this.baseGroup != null && !NotificationView.this.baseGroup.isDisposed()) {
                NotificationView.this.baseGroup.getShell().layout();
            }
        }

        private void chnageDownloadStatus(int lengthForFileName) {
            if (NotificationHelper.getMainStatus() == 100) {
                return;
            }
            if (!(NotificationHelper.getFileBeingDownloaded() == null || NotificationHelper.getFileBeingDownloaded().isEmpty() || NotificationView.this.downloadProgressCurFileBeingDownloadedText == null || NotificationView.this.downloadProgressCurFileBeingDownloadedText.isDisposed() || NotificationView.this.downloadProgressCurDownloadProgressText == null || NotificationView.this.downloadProgressCurDownloadProgressText.isDisposed())) {
                String fileBeingDownloaded = NotificationHelper.getFileBeingDownloaded();
                if (fileBeingDownloaded.length() > lengthForFileName) {
                    fileBeingDownloaded = new StringBuffer().append(fileBeingDownloaded.substring(0, lengthForFileName)).append("...").toString();
                }
                NotificationView.this.downloadProgressCurFileBeingDownloadedText.setText("");
                NotificationView.this.downloadProgressCurFileBeingDownloadedLabel.setVisible(true);
                NotificationView.this.downloadProgressCurFileBeingDownloadedText.setVisible(true);
                NotificationView.this.downloadProgressCurDownloadProgressText.setVisible(true);
                NotificationView.this.downloadProgressCurDownloadProgressLabel.setVisible(true);
                NotificationView.this.downloadProgressCurFileBeingDownloadedText.setText(fileBeingDownloaded);
            } else if (NotificationView.this.downloadProgressCurFileBeingDownloadedText != null && !NotificationView.this.downloadProgressCurFileBeingDownloadedText.isDisposed() && NotificationView.this.downloadProgressCurDownloadProgressText != null) {
                NotificationView.this.downloadProgressCurFileBeingDownloadedLabel.setVisible(false);
                NotificationView.this.downloadProgressCurFileBeingDownloadedText.setVisible(false);
                NotificationView.this.downloadProgressCurDownloadProgressText.setVisible(false);
                NotificationView.this.downloadProgressCurDownloadProgressLabel.setVisible(false);
            }
            if (NotificationView.this.downloadProgressCurDownloadProgressText != null && !NotificationView.this.downloadProgressCurDownloadProgressText.isDisposed()) {
                NotificationView.this.downloadProgressCurDownloadProgressText.setText("");
                NotificationView.this.downloadProgressCurDownloadProgressText.setText(NotificationHelper.getDowloadCount());
            }
        }

        private void changeUploadStatus(int lengthForFileName) {
            if (NotificationHelper.getMainStatus() == 100) {
                return;
            }
            if (!(NotificationHelper.getFileBeingUploaded() == null || NotificationHelper.getFileBeingUploaded().isEmpty() || NotificationView.this.uploadProgressCurFileBeingUploadedText == null || NotificationView.this.uploadProgressCurFileBeingUploadedText.isDisposed() || NotificationView.this.uploadProgressCurUploadProgressText == null || NotificationView.this.uploadProgressCurUploadProgressText.isDisposed())) {
                NotificationView.this.uploadProgressCurFileBeingUploadedText.setText("");
                NotificationView.this.uploadProgressCurFileBeingUploadedLabel.setVisible(true);
                NotificationView.this.uploadProgressCurFileBeingUploadedText.setVisible(true);
                NotificationView.this.uploadProgressCurUploadProgressText.setVisible(true);
                NotificationView.this.uploadProgressCurUploadProgressLabel.setVisible(true);
                String fileBeingUploaded = NotificationHelper.getFileBeingUploaded();
                if (fileBeingUploaded.length() > lengthForFileName) {
                    fileBeingUploaded = new StringBuffer().append(fileBeingUploaded.substring(0, lengthForFileName)).append("...").toString();
                }
                NotificationView.this.uploadProgressCurFileBeingUploadedText.setText(fileBeingUploaded);
            } else if (NotificationView.this.uploadProgressCurFileBeingUploadedText != null && !NotificationView.this.uploadProgressCurFileBeingUploadedText.isDisposed() && NotificationView.this.uploadProgressCurUploadProgressText != null && !NotificationView.this.uploadProgressCurUploadProgressText.isDisposed()) {
                NotificationView.this.uploadProgressCurFileBeingUploadedLabel.setVisible(false);
                NotificationView.this.uploadProgressCurFileBeingUploadedText.setVisible(false);
                NotificationView.this.uploadProgressCurUploadProgressText.setVisible(false);
                NotificationView.this.uploadProgressCurUploadProgressLabel.setVisible(false);
            }
            if (NotificationView.this.uploadProgressCurUploadProgressText != null && !NotificationView.this.uploadProgressCurUploadProgressText.isDisposed()) {
                NotificationView.this.uploadProgressCurUploadProgressText.setText("");
                NotificationView.this.uploadProgressCurUploadProgressText.setText(NotificationHelper.getUploadCount());
            }
        }

        private void changeNotificationStatus() {
            if (NotificationView.this.currentStatusValueLabel != null && !NotificationView.this.currentStatusValueLabel.isDisposed() && !NotificationView.this.currentStatusValueLabel.getText().equals(NotificationHelper.getCurrentStatus())) {
                if (NotificationHelper.getMainStatus() == 100 && !SettingHelper.isEnableBlusync()) {
                    NotificationHelper.setCurrentActivityState((int)9);
                }
                NotificationView.this.currentStatusValueLabel.setText("");
                NotificationView.this.currentStatusValueLabel.setText(NotificationHelper.getCurrentStatus());
                NotificationView.this.currentStatusValueLabel.getParent().layout();
                if (NotificationHelper.getMainStatus() == 101) {
                    if (NotificationView.this.stackLayout.topControl != NotificationView.this.uploadDownloadProgressComposite) {
                        NotificationView.this.uploadDownloadProgressComposite.setParent(NotificationView.this.progressStackedComposite);
                        NotificationView.this.stackLayout.topControl = NotificationView.this.uploadDownloadProgressComposite;
                        NotificationView.this.progressStackedComposite.layout();
                        NotificationView.this.currentStatusValueLabel.getParent().layout();
                    }
                } else if (NotificationView.this.stackLayout.topControl != NotificationView.this.syncDetailsComposite) {
                    NotificationView.this.syncDetailsComposite.setParent(NotificationView.this.progressStackedComposite);
                    NotificationView.this.stackLayout.topControl = NotificationView.this.syncDetailsComposite;
                    NotificationView.this.progressStackedComposite.layout();
                    NotificationView.this.currentStatusValueLabel.getParent().layout();
                }
            }
            if (NotificationHelper.getMainStatus() == 101) {
                if (NotificationView.this.manualSycButton != null && !NotificationView.this.manualSycButton.isDisposed()) {
                    NotificationView.this.manualSycButton.setVisible(true);
                    NotificationView.this.manualSycButton.setEnabled(false);
                }
            } else if (NotificationHelper.getMainStatus() == 100 && NotificationHelper.getCurrentActivityState() == 9) {
                NotificationView.this.setUploadDownloadGroupsVisible();
                if (NotificationView.this.manualSycButton != null && !NotificationView.this.manualSycButton.isDisposed()) {
                    NotificationView.this.manualSycButton.setVisible(true);
                    NotificationView.this.manualSycButton.setEnabled(true);
                }
            } else if (NotificationView.this.manualSycButton != null && !NotificationView.this.manualSycButton.isDisposed()) {
                NotificationView.this.manualSycButton.setVisible(true);
                NotificationView.this.manualSycButton.setEnabled(true);
            }
        }
    }
}

