/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.JCEPBEKey;

public class JCESecretKeyFactory
extends SecretKeyFactorySpi {
    private String algName;
    static /* synthetic */ Class class$javax$crypto$spec$SecretKeySpec;

    protected JCESecretKeyFactory(String string) {
        this.algName = string;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            return (SecretKey)((Object)keySpec);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if ((class$javax$crypto$spec$SecretKeySpec == null ? (class$javax$crypto$spec$SecretKeySpec = JCESecretKeyFactory.class$("javax.crypto.spec.SecretKeySpec")) : class$javax$crypto$spec$SecretKeySpec).isAssignableFrom(clazz)) {
            return new SecretKeySpec(secretKey.getEncoded(), this.algName);
        }
        throw new InvalidKeySpecException("Not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.algName)) {
            throw new InvalidKeyException("Key not of type " + this.algName + ".");
        }
        return new SecretKeySpec(secretKey.getEncoded(), this.algName);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DESede
    extends JCESecretKeyFactory {
        public DESede() {
            super("DESede");
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DESedeKeySpec) {
                DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)keySpec;
                return new SecretKeySpec(dESedeKeySpec.getKey(), "DESede");
            }
            return super.engineGenerateSecret(keySpec);
        }
    }

    public static class DES
    extends JCESecretKeyFactory {
        public DES() {
            super("DES");
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DESKeySpec) {
                DESKeySpec dESKeySpec = (DESKeySpec)keySpec;
                return new SecretKeySpec(dESKeySpec.getKey(), "DES");
            }
            return super.engineGenerateSecret(keySpec);
        }
    }

    public static class PBE_PKCS12
    extends JCESecretKeyFactory {
        public PBE_PKCS12() {
            super("PBE/PKCS12");
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                return new JCEPBEKey(true, "PBE/PKCS12", pBEKeySpec.getPassword());
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }

    public static class PBE_PKCS5
    extends JCESecretKeyFactory {
        public PBE_PKCS5() {
            super("PBE/PKCS5");
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                return new JCEPBEKey(false, "PBE/PKCS5", pBEKeySpec.getPassword());
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }
}

