/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.NewBackUpCrawlDAOImpl;
import com.parablu.epa.common.dao.NewBackupImageDAOImpl;
import com.parablu.epa.common.service.backup.FilesBeSkippedAsPerPolicy;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.runnables.ChunkRunnable;
import com.parablu.epa.common.service.runnables.DelegateRunnable;
import com.parablu.epa.common.service.runnables.RestartRunnable;
import com.parablu.epa.common.service.settings.HashChecker;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.helper.FileSizeBlockingQueue;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.helper.about.SystemInfo;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadBackupUpload
extends Thread {
    private Logger logger = LoggerFactory.getLogger(MultiThreadBackupUpload.class);
    private static Logger failedFileLog = LoggerFactory.getLogger((String)"failedFileLogger");
    private final String keyStorePath;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String token;
    private BackupAdapter backUpAdapter = null;
    private boolean isTerminated = false;
    private AtomicInteger uploadCount = new AtomicInteger(NotificationHelper.getTotalBackupCount());
    private GatewayTO uploadGatewayTo = null;
    private GatewayTO prevGatewayTo = null;
    private final Set<DedupTO> dedupSet;
    private HashMap<String, String> dedupHashMap = new HashMap();
    private NewBackUpCrawlDAOImpl newBackUpCrawlDAOImpl = null;
    private BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = null;
    private boolean restart;
    private static String batchIdForBackup = "";
    BackupActivityTO backupActivityTO = null;
    BackupPolicyTO currentPolicy = null;
    private long restartId = 1L;
    private String requestURL = "/upload/files/all";
    private String backupType = null;
    private int pftSize = 1;
    private boolean pftEnabled = true;
    private BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    private static final String FAILED = "FAILED";
    private static final String PBCHNKZ = "pbchnkz";
    private boolean isFullBackup;
    private AtomicLong totalUploadSize = new AtomicLong(0L);
    private int count = 0;
    final FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue = new FileSizeBlockingQueue(50, 0x40000000L);
    ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$");
    int maxThreadCount = this.getMaxThreadCount();
    boolean ApplyFilterToExceptionsToExclusion = this.ApplyFilterToExceptionsToExclusion();
    ExecutorService multiPartUploadService = Executors.newFixedThreadPool(this.maxThreadCount, this.factoryBuilder.build());
    ExecutorService chunkService = Executors.newFixedThreadPool(10, this.factoryBuilder.build());
    final BlockingQueue<BackupTO> chunkFileQueue = new LinkedBlockingQueue<BackupTO>(500);
    final BlockingQueue<Future<BackupTO>> finishedBatchesQueue = new LinkedBlockingQueue<Future<BackupTO>>(2);
    final AtomicInteger noOfBatches = new AtomicInteger(0);
    final AtomicInteger chunkedFiles = new AtomicInteger(0);
    private AtomicBoolean loopFinished = new AtomicBoolean(false);
    private AtomicBoolean intrupted = new AtomicBoolean(false);
    private AtomicBoolean allThreadsStopped = new AtomicBoolean(false);
    private Timer backupWatchDogTimer = null;
    private TimerTask backupWatchDogTimerTask = null;
    ParabluFileSystemUtils fileSystemUtils = new ParabluFileSystemUtils();
    private Thread delegateThread = null;
    private Thread chunkDelegateThread = null;
    private Thread restartDelegateThread = null;
    private List<BackupTO> backupTOs = new ArrayList<BackupTO>();
    private List<Integer> removeList = new ArrayList<Integer>();
    private String isBackupManual;
    private List<Integer> skipFilesList = new ArrayList<Integer>();
    NewBackupImageDAOImpl newBackupImageDAOImpl = new NewBackupImageDAOImpl(SettingHelper.getBackUpDbUrl());

    public MultiThreadBackupUpload(String iP, Integer port, String cn, String token, String keyStorePath, Set<DedupTO> dedupTOs, boolean restartValue, long restartID, String backupType) {
        this.keyStorePath = keyStorePath;
        this.newBackUpCrawlDAOImpl = new NewBackUpCrawlDAOImpl(SettingHelper.getBackUpCrawlDbUrl());
        this.backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        this.backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
        this.uploadIP = iP;
        this.cloudName = cn;
        this.backUpAdapter = new BackupAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
        this.dedupSet = dedupTOs;
        this.restart = restartValue;
        this.restartId = restartID + 1L;
        this.backupType = backupType;
    }

    private int getMaxThreadCount() {
        int threadCount = 3;
        this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (this.currentPolicy != null) {
            threadCount = this.currentPolicy.getNumberOfThreadsAllowedForBackup();
        }
        return threadCount;
    }

    @Override
    public void run() {
        RateLimiter rateLimiter;
        this.logger.debug("MULTI THREAD BACKUP UPLOAD STARTED AND PRIORITY " + Thread.currentThread().getPriority());
        this.logger.info("token inside multithreadbackup upload" + this.token);
        this.logger.info("port inside multithreadbackup upload" + this.port);
        this.logger.info("uploadIP inside multithreadbackup upload" + this.uploadIP);
        this.logger.info("keystorepath inside multithreadbackup upload" + this.keyStorePath);
        this.logger.info("backupadapter inside multithreadbackup upload" + this.backUpAdapter);
        this.logger.info("backupFolderDaoimpl inside multithreadbackup upload" + this.backUpFolderDAOImpl);
        this.loadCurrentBackupActivityAndBackupPolicyAndExtensionDetails();
        GatewayTO currentGatewayTo = null;
        if (SettingHelper.getBackupLicenced().contentEquals("true") && "true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
            try {
                this.setBackupTypeAndIntiatedType();
                this.uploadGatewayTo = PolicyManagementServerHelper.getPrivacyGatewayIP(this.backupType, "BACKUP");
                if (this.uploadGatewayTo == null) {
                    this.logger.error("Error in get privacy gateway");
                    this.updateFailReasonInActivityTable(2304);
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Error in get privacy gateway", (Throwable)e);
                this.updateFailReasonInActivityTable(2304);
                return;
            }
            currentGatewayTo = this.uploadGatewayTo;
            if (this.prevGatewayTo == null) {
                this.prevGatewayTo = this.uploadGatewayTo;
            }
        }
        int crawlFileCount = this.newBackUpCrawlDAOImpl.getLastRecordIdFromTable();
        this.logger.debug("total count of table....." + crawlFileCount);
        if (this.restart) {
            this.logger.debug("INSIDE RESTART > ID IS : " + this.restartId);
        } else {
            this.restartId = 1L;
            this.logger.debug("FRESH BACKUP > ID IS : " + this.restartId);
        }
        CleanupInterface<BackupTO> cleanupInterface = new CleanupInterface<BackupTO>(){

            @Override
            public void runCleanup(BackupTO backupTO, int status) {
            }

            @Override
            public void updateUIWrapper(BackupTO backupTO, int uploadCount, long totalUploadSize) {
                MultiThreadBackupUpload.this.updateUI(backupTO.getClientData(), uploadCount, totalUploadSize);
            }

            @Override
            public void updateTooltipNotification(int failCode) {
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(failCode);
                PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit(MultiThreadBackupUpload.FAILED, true);
                if (failCode == 912) {
                    MultiThreadBackupUpload.this.updateSystrayToolTipNotification("Machine Utils Exceeded", "Your machine utilization exceeded the limits set in the policy");
                }
            }

            @Override
            public void updateRestartId(long restartId) {
                NotificationHelper.setBackupRestartId(restartId);
                if (MultiThreadBackupUpload.this.backupActivityTO != null) {
                    MultiThreadBackupUpload.this.backupActivityTO.setRestartID(restartId);
                    MultiThreadBackupUpload.this.backupActivityHistoryDAOImpl.updateRestartIdINBackupActivityHistoryTable(MultiThreadBackupUpload.this.backupActivityTO);
                }
            }

            @Override
            public void updateTotalUploadSize() {
                MultiThreadBackupUpload.this.updateTotalUploadSizeInActitivityTable();
            }

            @Override
            public void updateErrorCode(int failCode) {
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(failCode);
            }

            @Override
            public void updateBackupCrawlTable(List<BackupTO> backupTOsList) {
                MultiThreadBackupUpload.this.backupTOs.addAll(backupTOsList);
                MultiThreadBackupUpload.this.logger.debug("backpTO size: " + MultiThreadBackupUpload.this.backupTOs.size() + "integer remove list before:" + MultiThreadBackupUpload.this.removeList.size());
                for (BackupTO backupTO : backupTOsList) {
                    MultiThreadBackupUpload.this.removeList.add((int)backupTO.getRestartId());
                }
                MultiThreadBackupUpload.this.logger.debug("integer remove list after:" + MultiThreadBackupUpload.this.removeList.size());
            }

            @Override
            public void updateChunkFileDetail(BackupTO backupTO, int uploadedChunkCount) {
                if (backupTO.getChunkFileList() != null) {
                    NotificationHelper.setBackupChunkFileDetails("(" + uploadedChunkCount + "%)" + backupTO.getFileName());
                } else {
                    NotificationHelper.setBackupChunkFileDetails(backupTO.getFileName());
                }
            }

            @Override
            public void removeFailedBackupTOs(List<BackupTO> chunkFileBatch, List<BackupTO> failedBackupTOs) {
                Iterator<BackupTO> iter = chunkFileBatch.iterator();
                block0: while (iter.hasNext()) {
                    BackupTO to = iter.next();
                    for (BackupTO backupTo : failedBackupTOs) {
                        if (to.getRestartId() != backupTo.getRestartId()) continue;
                        iter.remove();
                        continue block0;
                    }
                }
            }
        };
        float networkThrottlrLimit = this.currentPolicy.getNetworkThrottleSpeed();
        this.logger.debug("network throtling from policy>> " + networkThrottlrLimit);
        if (networkThrottlrLimit <= 0.0f) {
            rateLimiter = RateLimiter.create((double)12800.0);
            this.logger.error("rate must be positive");
        } else {
            rateLimiter = RateLimiter.create((double)((double)(networkThrottlrLimit * 1024.0f) / 32.0));
            this.logger.debug("number of permits->" + (double)(networkThrottlrLimit * 1024.0f) / 32.0);
        }
        this.delegateThread = new Thread(new DelegateRunnable(this.chunkFileQueue, this.multiPartUploadService, currentGatewayTo, this.currentPolicy, this.uploadCount, batchIdForBackup, this.finishedBatchesQueue, this.noOfBatches, this.loopFinished, cleanupInterface, this.requestURL, rateLimiter, this.chunkService, this.intrupted, this.isFullBackup, this.totalUploadSize, this.isBackupManual));
        this.delegateThread.setPriority(SettingHelper.getCurrentBackupPolicy().getThreadPriorityForcpuThrottle());
        this.delegateThread.start();
        this.chunkDelegateThread = new Thread(new ChunkRunnable(this.chunkedFiles, this.fileSizeBlockingQueue, this.chunkFileQueue, this.loopFinished, this.intrupted));
        this.chunkDelegateThread.setPriority(SettingHelper.getCurrentBackupPolicy().getThreadPriorityForcpuThrottle());
        this.chunkDelegateThread.start();
        this.restartDelegateThread = new Thread(new RestartRunnable(this.noOfBatches, this.finishedBatchesQueue, this.uploadGatewayTo, batchIdForBackup, this.currentPolicy, this.delegateThread, this.chunkDelegateThread, this.intrupted, this.backUpAdapter));
        this.restartDelegateThread.setPriority(SettingHelper.getCurrentBackupPolicy().getThreadPriorityForcpuThrottle());
        this.restartDelegateThread.start();
        this.startBackupWatchDog();
        NotificationHelper.setBackupStatus(4);
        while (this.restartId <= (long)crawlFileCount) {
            block29: {
                this.logger.debug("PB$$1 Inside Main loop and restart id is:" + this.restartId);
                if (Thread.currentThread().isInterrupted() || this.intrupted.get()) {
                    this.logger.debug("Backup upload thread got nudged>>>>>>>");
                    this.delegateThread.interrupt();
                    this.chunkDelegateThread.interrupt();
                    break;
                }
                boolean currentFileChunkable = false;
                BackupTO tempUploadFileTO = this.newBackUpCrawlDAOImpl.getBackupFileFromTableWithID(this.restartId);
                if (tempUploadFileTO != null) {
                    this.logger.debug("PB$$2 uploadFileTO for restart id is:" + tempUploadFileTO.getClientData());
                    try {
                        tempUploadFileTO.setClientData(this.checkForMacBasePath(tempUploadFileTO.getClientData()));
                        tempUploadFileTO.setRestartId(this.restartId);
                        if (tempUploadFileTO.isFolder()) {
                            this.logger.debug("PB$$2 inside uploadfileTO is folder true:" + tempUploadFileTO.getClientData());
                            break block29;
                        }
                        if (!this.handleFileExist(ObjectUtils.getFileSnapshotPath((String)tempUploadFileTO.getClientData()))) {
                            this.logger.debug("PB$$3 File Not Found ..File name>>" + tempUploadFileTO.getClientData());
                            this.updateUI("", this.uploadCount.get(), this.totalUploadSize.get());
                            this.removeList.add((int)this.restartId);
                            this.backupTOs.add(tempUploadFileTO);
                            break block29;
                        }
                        if (this.isTerminated) break;
                        this.logger.debug("before checking extensions>>");
                        if (this.isExceptiontoExclusionFile(tempUploadFileTO.getClientData())) {
                            if (this.ApplyFilterToExceptionsToExclusion && FilesBeSkippedAsPerPolicy.checkExtensions(new File(tempUploadFileTO.getClientData()))) {
                                this.logger.debug("File has to be skipped...." + tempUploadFileTO.getClientData());
                                this.updateUI("", this.uploadCount.get(), this.totalUploadSize.get());
                                this.removeList.add((int)this.restartId);
                                this.backupTOs.add(tempUploadFileTO);
                                this.skipFilesList.add((int)this.restartId);
                                break block29;
                            }
                        } else if (FilesBeSkippedAsPerPolicy.checkExtensions(new File(tempUploadFileTO.getClientData()))) {
                            String pbLogFilePatah = SettingHelper.getParabluBlusyncAppDataFolderUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "blusync.zip";
                            if (!tempUploadFileTO.getClientData().toLowerCase().equalsIgnoreCase(pbLogFilePatah.toLowerCase())) {
                                this.logger.debug("File has to be skipped...." + tempUploadFileTO.getClientData());
                                this.updateUI("", this.uploadCount.get(), this.totalUploadSize.get());
                                this.removeList.add((int)this.restartId);
                                this.backupTOs.add(tempUploadFileTO);
                                this.skipFilesList.add((int)this.restartId);
                                break block29;
                            }
                        }
                        this.logger.debug("PB$$3 Before Getting pft size>>");
                        this.pftSize = this.currentPolicy.getPftSize();
                        this.logger.debug("PB$$4 After Getting pft size>>");
                        this.pftEnabled = Boolean.parseBoolean(this.currentPolicy.getPftEnabled());
                        this.logger.debug("ptf Enabled :" + this.pftEnabled);
                        if (this.pftEnabled && this.pftSize != 0) {
                            this.logger.debug("PB$$5 Before checking is file chunkable>>");
                            currentFileChunkable = this.isFileChunkable(tempUploadFileTO, this.pftSize);
                            this.logger.debug("PB$$6 After checking is file chunkable>>" + currentFileChunkable);
                        }
                        if (currentFileChunkable) {
                            this.logger.debug("PB$$7a Before deelting chunk folder if present>>");
                            this.deleteChunkFolderIfPresent(tempUploadFileTO);
                            this.logger.debug("PB$$7b Before checking  free space>>");
                        }
                        if (currentFileChunkable) {
                            this.logger.debug("PB$$11 inside current file chunkable");
                            String sourcePath = tempUploadFileTO.getClientData();
                            File file = null;
                            try {
                                file = new File(sourcePath);
                            }
                            catch (Exception e) {
                                this.logger.trace("" + e);
                                this.logger.error("File is not accessible" + e.getMessage() + "..File name>>" + tempUploadFileTO.getClientData());
                                failedFileLog.error(file.getAbsoluteFile() + ",File is not accessible");
                                this.backupTOs.add(tempUploadFileTO);
                                this.removeList.add((int)this.restartId);
                                break block29;
                            }
                            if (file != null) {
                                NotificationHelper.setBackupFileChunkingStatus("Processing file-" + tempUploadFileTO.getFileName());
                                NotificationHelper.setBackupFileChunkingStatus("");
                                this.createDummyChunkFileList(tempUploadFileTO, file);
                                this.logger.debug("dummy chunkList created");
                                this.logger.debug("PB$$12 Queue size before put" + this.fileSizeBlockingQueue.size());
                                this.putInFileSizeBlockingQueue(tempUploadFileTO);
                                this.logger.debug("Queue size after put: " + this.fileSizeBlockingQueue.size() + " upload filesize: " + tempUploadFileTO.getFileSize());
                                this.chunkedFiles.incrementAndGet();
                                this.logger.debug("PB$$13 schunks: " + tempUploadFileTO.getChunkFileList().size());
                            }
                            break block29;
                        }
                        this.putInSizeQueue(tempUploadFileTO);
                        this.logger.debug("PB$$14 After putting it in chunk size queue normal file");
                    }
                    catch (Exception e) {
                        this.logger.error("Exception Occurred while backing up  file: ", (Throwable)e);
                    }
                }
            }
            ++this.restartId;
        }
        try {
            this.loopFinished.set(true);
            this.logger.debug("LOOP FINISHED");
            this.delegateThread.join();
            this.chunkDelegateThread.join();
            this.restartDelegateThread.join();
            this.logger.debug("after loop finished... before removing backupTos " + this.backupTOs.size());
            this.newBackUpCrawlDAOImpl.removeListFromTableByIds(this.removeList);
            this.newBackupImageDAOImpl.removeListFromTableById(this.skipFilesList);
            NotificationHelper.setTotalBackupFilesSkippedCount(this.backupTOs.size());
            NotificationHelper.setNoOfFilesToBeBackedUp(NotificationHelper.getNoOfFilesToBeBackedUp() - this.backupTOs.size());
            this.logger.debug("Before setting all threads stop to true");
            this.allThreadsStopped.set(true);
            this.backupWatchDogTimer.cancel();
            return;
        }
        catch (InterruptedException e) {
            this.logger.debug("Before interrupting thread..");
            this.allThreadsStopped.set(true);
            this.interuptAllThreadAndShutdownServices(this.delegateThread, this.chunkDelegateThread, this.restartDelegateThread, this.backupTOs);
            this.backupWatchDogTimer.cancel();
            return;
        }
    }

    private void setBackupTypeAndIntiatedType() {
        String[] strArray = new String[2];
        strArray = this.backupType.split("\\|");
        if (strArray.length > 1) {
            this.backupType = strArray[0];
            this.isBackupManual = strArray[1];
            this.logger.debug("backupType:" + this.backupType + " isbackup manual:" + this.isBackupManual);
        }
    }

    private void createDummyChunkFileList(BackupTO tempUploadFileTO, File file) {
        this.logger.debug("Inside creating dammy chunk File List");
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        ChunkFileTO chunkFileTO = new ChunkFileTO();
        chunkFileTO.setFileName(file.getName());
        chunkFileTO.setFilePath(tempUploadFileTO.getClientData());
        chunkFileTO.setMd5Checksum(null);
        chunkFileTO.setChunkFileNames(null);
        chunkFileTOs.add(chunkFileTO);
        tempUploadFileTO.setChunkFileList(chunkFileTOs);
    }

    private void deleteChunkFolderIfPresent(BackupTO tempUploadFileTO) {
        String hash32Value = this.fileSystemUtils.convertStringTOBase64(tempUploadFileTO.getFileName());
        this.logger.debug("Hash value For the folder inside delete chunk folder if present>>>>>" + hash32Value);
        String chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(PBCHNKZ).append(hash32Value).toString();
        File file = new File(chunkPath);
        this.deleteChunkFolder(file);
    }

    private void interuptAllThreadAndShutdownServices(Thread delegateThread, Thread chunkDelegateThread, Thread restartDelegateThread, List<BackupTO> backupTOs) {
        this.printlogs("Delegate Thread and chunk been NUDGED");
        NotificationHelper.setTotalBackupFilesSkippedCount(backupTOs.size());
        if (delegateThread.isAlive() && !delegateThread.isInterrupted()) {
            delegateThread.interrupt();
        }
        if (chunkDelegateThread.isAlive() && !chunkDelegateThread.isInterrupted()) {
            chunkDelegateThread.interrupt();
        }
        if (restartDelegateThread.isAlive() && !restartDelegateThread.isInterrupted()) {
            restartDelegateThread.interrupt();
        }
        if (chunkDelegateThread.isAlive()) {
            chunkDelegateThread.stop();
        }
        if (restartDelegateThread.isAlive()) {
            restartDelegateThread.stop();
        }
        if (delegateThread.isAlive()) {
            delegateThread.stop();
        }
        if (this.chunkService != null && !this.chunkService.isShutdown()) {
            this.chunkService.shutdownNow();
        }
        if (this.multiPartUploadService != null && !this.multiPartUploadService.isShutdown()) {
            this.multiPartUploadService.shutdownNow();
        }
        boolean isTerminated1 = true;
        try {
            if (this.multiPartUploadService != null) {
                isTerminated1 = this.multiPartUploadService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            this.printlogs("Nudged thread is TERMINATE : " + isTerminated1);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Nudged thread is TERMINATED : " + isTerminated1, (Object)e1.getMessage());
        }
        this.backupWatchDogTimer.cancel();
    }

    private void putInFileSizeBlockingQueue(BackupTO tempUploadFileTO) {
        try {
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.trace("" + e);
            this.logger.error("error while adding file to filesize block queue" + e.getMessage());
        }
    }

    public List<String> getExistingFileNames(String path, BackupTO backupTO) {
        File backupFile;
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        if (!StringUtils.isEmpty((String)path) && (files = (backupFile = new File(path)).listFiles()) != null && files.length != 0) {
            Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
            for (File file : files) {
                if (!file.isFile()) continue;
                ChunkFileTO chunkFileTO = new ChunkFileTO();
                results.add(file.getName());
                this.logger.debug("Before get md5 from fileName:" + file.getName());
                String md5 = ParabluFileSystemUtils.getMd5FromFileName((String)file.getName());
                this.logger.debug("After get md5:" + md5);
                chunkFileTO.setFileName(file.getName());
                chunkFileTO.setFilePath(path.substring(0, path.length() - 1));
                chunkFileTO.setMd5Checksum(md5);
                chunkFileTO.setChunkFileNames(results);
                chunkFileTOs.add(chunkFileTO);
            }
        }
        backupTO.setChunkFileList(chunkFileTOs);
        for (ChunkFileTO chunkFileTO : chunkFileTOs) {
            chunkFileTO.setChunkFileNames(results);
        }
        return results;
    }

    private void updateUI(String fileName, int uploadCount2, long totalUploadSize) {
        NotificationHelper.setFileBeingBackedup(fileName);
        NotificationHelper.setTotalBackupCount(uploadCount2);
        NotificationHelper.setTotalUploadSize(totalUploadSize);
    }

    private boolean isFileChunkable(BackupTO tempUploadFileTO, int pftSize) {
        boolean isChunkable = false;
        int chunkableSizeFromPolicy = this.getChunkableSize();
        File file = new File(ObjectUtils.getFileSnapshotPath((String)tempUploadFileTO.getClientData()));
        if (file.isDirectory()) {
            return isChunkable;
        }
        long fileSizeinBytes = file.length();
        tempUploadFileTO.setFileSize(fileSizeinBytes);
        float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
        if (fileSizeinMb >= (float)pftSize && fileSizeinMb > (float)chunkableSizeFromPolicy) {
            isChunkable = true;
        }
        return isChunkable;
    }

    private int getChunkableSize() {
        int chunkableSizeFromPolicy = 4;
        if (this.currentPolicy != null) {
            chunkableSizeFromPolicy = this.currentPolicy.getChunkSize();
        }
        return chunkableSizeFromPolicy;
    }

    public double checkSystemUsage() {
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getSystemMemory();
            this.logger.debug("System memory percentage is:" + percentage);
            return percentage;
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("error while checking the sytem usage" + e.getMessage());
            return 0.0;
        }
    }

    private String checkForMacBasePath(String completeParentPath) {
        String mac = "Macintosh";
        if (completeParentPath.startsWith("Macintosh" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(9);
        }
        if (completeParentPath.startsWith("ROOT" + StringLiterals.FILE_SEPARATOR)) {
            return completeParentPath.substring(4);
        }
        return completeParentPath;
    }

    private void loadCurrentBackupActivityAndBackupPolicyAndExtensionDetails() {
        PolicyManagementServerHelper.setFilterDetails();
        this.backupActivityTO = this.backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        if (this.backupActivityTO != null) {
            batchIdForBackup = this.backupActivityTO.getBatchId();
            this.isFullBackup = Boolean.parseBoolean(this.backupActivityTO.getFullBackup());
            this.logger.debug("Backup batch ID:" + batchIdForBackup);
        }
        this.currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (this.currentPolicy != null) {
            this.logger.debug("CHUNK SIZE TO KEEP " + this.currentPolicy.getChunkSize());
            this.logger.debug("COMPRESSION ENABLED " + this.currentPolicy.isCompressionEnabled());
            this.logger.debug("NETWORK THROTTLE SPEED :" + this.currentPolicy.getNetworkThrottleSpeed());
            SettingHelper.setMaxVersionsToKeep(this.currentPolicy.getMaxVersions());
            if (this.currentPolicy.getChunkSize() == 0) {
                this.currentPolicy.setChunkSize(4);
            }
        }
    }

    private void updateFailReasonInActivityTable(int statusCode) {
        this.backupActivityTO.setFailCode(statusCode);
        this.backupActivityHistoryDAOImpl.updateFailCodeToBackupActivityHistoryTable(this.backupActivityTO);
    }

    public abstract void updateSystrayToolTipNotification(String var1, String var2);

    private BackupTO putInSizeQueue(BackupTO tempUploadFileTO) {
        String filePath = ObjectUtils.getFileSnapshotPath((String)tempUploadFileTO.getClientData());
        String md5Checksum = MD5Generator.generateMD5OfFile((File)new File(filePath));
        if (md5Checksum == null) {
            this.backupTOs.add(tempUploadFileTO);
            this.removeList.add((int)this.restartId);
            return null;
        }
        tempUploadFileTO.setMd5checksum(md5Checksum);
        ArrayList<ChunkFileTO> chunkFileList = new ArrayList<ChunkFileTO>();
        ChunkFileTO chunkFileTO = new ChunkFileTO();
        chunkFileTO.setFileName(tempUploadFileTO.getFileName());
        chunkFileTO.setFilePath(tempUploadFileTO.getAbstractFilePath());
        chunkFileTO.setMd5Checksum(tempUploadFileTO.getMd5checksum());
        chunkFileList.add(chunkFileTO);
        try {
            this.logger.debug("Before putting in chunkFile Queue normal file queue size" + this.chunkFileQueue.size());
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted.set(true);
        }
        catch (Exception e) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted.set(true);
        }
        return tempUploadFileTO;
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        if (!file.exists()) {
            this.logger.debug("File doesnt exist: " + file.getAbsolutePath());
            this.logger.error(file.getAbsoluteFile().getParent() + "," + file.getAbsoluteFile().getName() + "," + file.lastModified());
            failedFileLog.error(file.getAbsoluteFile() + ",File doesnt exist");
            return false;
        }
        return true;
    }

    private void deleteChunkFolder(File file) {
        this.logger.debug("Inside deleting chunk folder fileName is:" + file.getAbsolutePath() + "\\" + file.getName());
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("Chunk folder deletion Failed" + e.getMessage());
                }
                this.logger.debug("Chunk folder deleted successfully");
            } else {
                try {
                    FileUtils.cleanDirectory((File)file);
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    this.logger.trace("" + e);
                    this.logger.error("error cleaning the directory" + e.getMessage());
                }
            }
        }
    }

    public void startBackupWatchDog() {
        if (this.backupWatchDogTimer == null) {
            this.backupWatchDogTimer = new Timer();
        }
        if (this.backupWatchDogTimerTask == null) {
            this.backupWatchDogTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        int retryStopThreadsCount = 0;
                        if (MultiThreadBackupUpload.this.intrupted.get()) {
                            MultiThreadBackupUpload.this.logger.debug("###############Inside thread nudged watch dogg################");
                            MultiThreadBackupUpload.this.interuptAllThreadAndShutdownServices(MultiThreadBackupUpload.this.delegateThread, MultiThreadBackupUpload.this.chunkDelegateThread, MultiThreadBackupUpload.this.restartDelegateThread, MultiThreadBackupUpload.this.backupTOs);
                            MultiThreadBackupUpload.this.pauseBackup(false);
                            Thread.currentThread().interrupt();
                            while (!MultiThreadBackupUpload.this.allThreadsStopped.get()) {
                                MultiThreadBackupUpload.this.printlogs("All threads not stopped so wait and intruupt");
                                MultiThreadBackupUpload.this.interuptAllThreadAndShutdownServices(MultiThreadBackupUpload.this.delegateThread, MultiThreadBackupUpload.this.chunkDelegateThread, MultiThreadBackupUpload.this.restartDelegateThread, MultiThreadBackupUpload.this.backupTOs);
                                MultiThreadBackupUpload.this.pauseBackup(false);
                                if (++retryStopThreadsCount < 50) continue;
                                MultiThreadBackupUpload.this.allThreadsStopped.set(true);
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (Exception e) {
                        MultiThreadBackupUpload.this.logger.error("Error in Stop backup threads", (Throwable)e);
                        MultiThreadBackupUpload.this.allThreadsStopped.set(true);
                    }
                }
            };
            this.backupWatchDogTimer.schedule(this.backupWatchDogTimerTask, 1L, 1L);
        }
    }

    private void updateTotalUploadSizeInActitivityTable() {
        if (this.backupActivityTO != null) {
            this.backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp());
            this.backupActivityTO.setTotalUploadSize(NotificationHelper.getTotalUploadSize());
            this.backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(this.backupActivityTO);
        }
    }

    public abstract void pauseBackup(boolean var1);

    public void printlogs(String log) {
        if (this.count == 0) {
            this.logger.debug(log);
        }
        if ((long)this.count >= 60000000L) {
            this.count = -1;
        }
        ++this.count;
    }

    public boolean ApplyFilterToExceptionsToExclusion() {
        BackupPolicyTO currentPolicy = PolicyManagementServerHelper.getCurrentBackupPolicy();
        if (currentPolicy != null) {
            return currentPolicy.isApplyFilterToExceptionsToExclusion();
        }
        return true;
    }

    public boolean isExceptiontoExclusionFile(String fileToUpload) {
        List<BackupFolderTO> exceptionsToExclusions = this.getExceptionsToExclusions();
        for (BackupFolderTO exceptionsToExclusion : exceptionsToExclusions) {
            String actualPath = exceptionsToExclusion.getFolderPath();
            if (SettingHelper.getOsName().toLowerCase().contains("mac") && (actualPath = this.checkForMacBasePath(exceptionsToExclusion.getFolderPath())).startsWith("//")) {
                actualPath = actualPath.replace("//", "/");
            }
            if (!fileToUpload.toLowerCase().startsWith(actualPath.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public List<BackupFolderTO> getExceptionsToExclusions() {
        List<BackupFolderTO> exceptionsToExclusionListFromPolicy = HashChecker.getAllExceptionsToExclusion();
        return exceptionsToExclusionListFromPolicy;
    }
}

