/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IConnectionPoint;
import org.eclipse.swt.internal.ole.win32.IConnectionPointContainer;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleEventTable;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

final class OleEventSink {
    private OleControlSite widget;
    private COMObject iDispatch;
    private int refCount;
    private IUnknown objIUnknown;
    private int eventCookie;
    private GUID eventGuid;
    private OleEventTable eventTable;

    OleEventSink(OleControlSite oleControlSite, int n, GUID gUID) {
        this.widget = oleControlSite;
        this.eventGuid = gUID;
        this.objIUnknown = new IUnknown(n);
        this.createCOMInterfaces();
    }

    void connect() {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            int[] nArray2 = new int[1];
            if (iConnectionPointContainer.FindConnectionPoint(this.eventGuid, nArray2) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray2[0]);
                int[] nArray3 = new int[1];
                if (iConnectionPoint.Advise(this.iDispatch.getAddress(), nArray3) == 0) {
                    this.eventCookie = nArray3[0];
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    void addListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new OleEventTable();
        }
        this.eventTable.hook(n, oleListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        this.iDispatch = new COMObject(new int[]{2, 0, 0, 1, 3, 4, 8}){

            @Override
            public int method0(int[] nArray) {
                return OleEventSink.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return OleEventSink.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return OleEventSink.this.Release();
            }

            @Override
            public int method6(int[] nArray) {
                return OleEventSink.this.Invoke(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7]);
            }
        };
    }

    void disconnect() {
        int[] nArray;
        if (this.eventCookie != 0 && this.objIUnknown != null && this.objIUnknown.QueryInterface(COM.IIDIConnectionPointContainer, nArray = new int[1]) == 0) {
            IConnectionPointContainer iConnectionPointContainer = new IConnectionPointContainer(nArray[0]);
            if (iConnectionPointContainer.FindConnectionPoint(this.eventGuid, nArray) == 0) {
                IConnectionPoint iConnectionPoint = new IConnectionPoint(nArray[0]);
                if (iConnectionPoint.Unadvise(this.eventCookie) == 0) {
                    this.eventCookie = 0;
                }
                iConnectionPoint.Release();
            }
            iConnectionPointContainer.Release();
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iDispatch != null) {
            this.iDispatch.dispose();
        }
        this.iDispatch = null;
    }

    private int Invoke(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        Object object;
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return 0;
        }
        Variant[] variantArray = null;
        if (n5 != 0) {
            object = new DISPPARAMS();
            COM.MoveMemory((DISPPARAMS)object, n5, DISPPARAMS.sizeof);
            variantArray = new Variant[((DISPPARAMS)object).cArgs];
            n9 = VARIANT.sizeof;
            int n10 = (((DISPPARAMS)object).cArgs - 1) * n9;
            for (int i = 0; i < ((DISPPARAMS)object).cArgs; ++i) {
                variantArray[i] = new Variant();
                variantArray[i].setData(((DISPPARAMS)object).rgvarg + n10);
                n10 -= n9;
            }
        }
        object = new OleEvent();
        ((OleEvent)object).arguments = variantArray;
        this.notifyListener(n, (OleEvent)object);
        if (variantArray != null) {
            for (n9 = 0; n9 < variantArray.length; ++n9) {
                variantArray[n9].dispose();
            }
        }
        return 0;
    }

    private void notifyListener(int n, OleEvent oleEvent) {
        if (oleEvent == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        oleEvent.type = n;
        oleEvent.widget = this.widget;
        this.eventTable.sendEvent(oleEvent);
    }

    private int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDispatch) || COM.IsEqualGUID(gUID, this.eventGuid)) {
            COM.MoveMemory(n2, new int[]{this.iDispatch.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    void removeListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            OLE.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, oleListener);
    }

    boolean hasListeners() {
        return this.eventTable.hasEntries();
    }
}

