/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.backup;

import com.parablu.epa.common.dao.BackUpImageDAOImpl;
import com.parablu.epa.common.dao.BackupActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.BackupStatisticsDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ChunkFileElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.UploadChunkFileException;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.BackupActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.DedupTO;
import com.parablu.epa.helper.about.SystemInfo;
import com.parablu.epa.helper.utils.MD5Generator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackUpUpload
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(BackUpUpload.class);
    private final List<BackupTO> uploadList;
    private final String keyStorePath;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String token;
    private BackupAdapter backUpAdapter = null;
    private BackUpImageDAOImpl backUpImageDAOImpl = null;
    private boolean isTerminated = false;
    private int uploadCount = 0;
    private String uploadIPForGateway = null;
    private String prevIPForGateway = null;
    private Long totalUploadSize = 0L;
    private String isFileDedup = "";
    private BackupStatisticsDAOImpl backupStatisticsDAOImpl = new BackupStatisticsDAOImpl(SettingHelper.getBackUpDbUrl());
    private int serverErrorRetryCounter = 1;
    private final Set<DedupTO> dedupSet;
    private HashMap<String, String> dedupHashMap = new HashMap();
    private static final String STARTED = "STARTED";
    private static final String COMPLETED = "COMPLETED";

    public BackUpUpload(String ip, Integer port, String cn, String token, List<BackupTO> backupList, String backupDBUrl, String keyStorePath, Set<DedupTO> dedupTOs) {
        this.keyStorePath = keyStorePath;
        this.backUpImageDAOImpl = new BackUpImageDAOImpl(backupDBUrl);
        this.uploadIP = ip;
        this.cloudName = cn;
        this.uploadList = backupList;
        this.backUpAdapter = new BackupAdapter(this.cloudName, keyStorePath);
        this.token = token;
        this.port = port;
        this.dedupSet = dedupTOs;
    }

    @Override
    public void run() {
        this.uploadCount = 0;
        this.uploadList.size();
        ArrayList<BackupTO> backupTOs = new ArrayList<BackupTO>();
        Comparator statusComparator = (se, se1) -> {
            if (se.getBkupStatus() == null) {
                return Integer.MAX_VALUE;
            }
            if (se1.getBkupStatus() == null) {
                return Integer.MIN_VALUE;
            }
            return se1.getBkupStatus().compareTo(se.getBkupStatus());
        };
        List<BackupTO> queryReturnedFile = null;
        if (!this.uploadList.isEmpty()) {
            queryReturnedFile = this.backUpImageDAOImpl.searchFilename();
        }
        if (queryReturnedFile != null && !queryReturnedFile.isEmpty()) {
            for (BackupTO tempUploadFileTO : this.uploadList) {
                if (tempUploadFileTO.getFileName().equals(queryReturnedFile.get(0).getFileName())) {
                    tempUploadFileTO.setBkupStatus(STARTED);
                    this.prevIPForGateway = queryReturnedFile.get(0).getGatewayIP();
                    break;
                }
                queryReturnedFile.get(0).setBkupStatus("FAILED");
                this.backUpImageDAOImpl.updateEventToBackupImageTable(queryReturnedFile.get(0));
            }
            Collections.sort(this.uploadList, statusComparator);
        }
        String currentIP = null;
        if (SettingHelper.getBackupLicenced().contentEquals("true") && !this.uploadList.isEmpty() && "true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
            SettingHelper.setMaxVersionsToKeep(this.getMaxVersionsFromPolicy());
            try {
                this.uploadIPForGateway = PolicyManagementServerHelper.getPrivacyGatewayIP("ALL", "BACKUP").getGatewayName();
                logger.debug("Nearest Gateway:" + this.uploadIPForGateway);
                if (this.uploadIPForGateway == null) {
                    logger.error("Error duriing geting privacy gateway");
                    this.updateSystrayToolTipNotification("Privacy Gateway Not Found", "Unable to connect to the server.");
                    return;
                }
            }
            catch (Exception e) {
                logger.error("Error in geting privacy gateway", (Throwable)e);
                this.updateSystrayToolTipNotification("Privacy Gateway Not Found", "Unable to connect to the server.");
                return;
            }
            currentIP = this.uploadIPForGateway;
            if (this.prevIPForGateway == null) {
                this.prevIPForGateway = this.uploadIPForGateway;
            }
            if (this.dedupSet != null && !this.dedupSet.isEmpty()) {
                for (DedupTO dedupTO : this.dedupSet) {
                    this.dedupHashMap.put(dedupTO.getMd5Value(), dedupTO.getBackupId());
                }
                logger.debug("Size of dedup files hashMap " + this.dedupHashMap.size());
            }
        }
        for (BackupTO tempUploadFileTO : this.uploadList) {
            try {
                if (this.isTerminated) {
                    logger.error("isTerminated: ", (Object)this.isTerminated);
                    break;
                }
                boolean isNormalUpload = true;
                boolean uploadViaGateway = false;
                int pftSize = 1;
                if (SettingHelper.getBackupLicenced().contentEquals("true")) {
                    int systemUsage = (int)this.checkSystemUsage();
                    if (systemUsage >= this.getCpuUtilFromUser()) {
                        logger.debug("Machine utils Exceeded");
                        PolicyManagementServerHelper.updateFailCodeToActivityHistory(912);
                        PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit("FAILED", true);
                        this.updateSystrayToolTipNotification("Machine Utils Exceeded", "Your machine utilization exceeded the limits set in the policy");
                        break;
                    }
                    if ("true".equalsIgnoreCase(SettingHelper.getIsExternalStorageSelected())) {
                        uploadViaGateway = true;
                        isNormalUpload = false;
                    }
                    pftSize = this.getCurrentPolicyPFTSize();
                }
                boolean currentFileChunkable = false;
                if (pftSize != 0) {
                    currentFileChunkable = this.isFileChunkable(tempUploadFileTO, pftSize);
                }
                if (SettingHelper.getBackupLicenced().contentEquals("true") && !tempUploadFileTO.isFolder()) {
                    this.isFileDedup = "";
                    this.isFileDedup = this.checkDedupOfFile(tempUploadFileTO);
                    if (!this.isFileDedup.isEmpty()) {
                        logger.debug("Is file a dedup value:" + this.isFileDedup);
                        currentFileChunkable = false;
                    }
                }
                logger.debug("IS FILE CHUNKABLE: " + currentFileChunkable);
                if (currentFileChunkable) {
                    String chunkPath;
                    if (!this.handleFileExist(tempUploadFileTO.getClientData())) {
                        this.updateUI("", this.uploadCount);
                        this.backupStatisticsDAOImpl.updateFailedStatusFileNameIntoTable(tempUploadFileTO, "File Not Found");
                        backupTOs.add(tempUploadFileTO);
                        continue;
                    }
                    String osType = SettingHelper.getOsName();
                    if (osType.toLowerCase().contains("win")) {
                        chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
                        this.createChunkFolderAndHideIt(chunkPath);
                    } else {
                        chunkPath = new StringBuffer().append(tempUploadFileTO.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
                        this.createChunkFolder(chunkPath);
                    }
                    String sourcePath = tempUploadFileTO.getClientData();
                    String destinationPath = chunkPath + File.separator;
                    File file = new File(destinationPath);
                    boolean isFileUploaded = false;
                    if (file.list().length == 0) {
                        isFileUploaded = this.splitAndWriteORNormalUpload(backupTOs, tempUploadFileTO, sourcePath, destinationPath, file, isNormalUpload);
                    }
                    if (isFileUploaded || this.isTerminated) continue;
                    List<String> listOfChunkFiles = BackUpUpload.getExistingFileNames(destinationPath);
                    if (listOfChunkFiles.isEmpty()) {
                        logger.debug("List of chunks size is zero");
                        backupTOs.add(tempUploadFileTO);
                        FileUtils.cleanDirectory((File)file);
                        this.deleteChunkFolder(file);
                        continue;
                    }
                    BackupAdapter backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                    ChunkFileElement chunkFileElement = new ChunkFileElement();
                    chunkFileElement.setFileChunks(listOfChunkFiles);
                    String chunkFile = listOfChunkFiles.get(0);
                    String prevBackupId = "";
                    boolean uploadChunkResponse = this.uploadChunkFiles(tempUploadFileTO, destinationPath, backupAdapter, chunkFileElement, chunkFile, prevBackupId, uploadViaGateway, SettingHelper.getMaxVersionsToKeep());
                    if (!uploadChunkResponse) {
                        backupTOs.add(tempUploadFileTO);
                        FileUtils.cleanDirectory((File)file);
                        this.deleteChunkFolder(file);
                        continue;
                    }
                    if (!tempUploadFileTO.isFolder()) {
                        ++this.uploadCount;
                        this.updateUI(tempUploadFileTO.getClientData(), this.uploadCount);
                        this.updateTotalUploadSize(tempUploadFileTO);
                        this.backupStatisticsDAOImpl.updateStatusFileNameIntoTable(tempUploadFileTO);
                    }
                    logger.debug("Chunk File merged successfully");
                    FileUtils.cleanDirectory((File)file);
                    this.deleteChunkFolder(file);
                    tempUploadFileTO.setBkupStatus(COMPLETED);
                    this.backUpImageDAOImpl.updateEventToBackupImageTable(tempUploadFileTO);
                    this.uploadIPForGateway = currentIP;
                    if (this.isTerminated) break;
                    if (!uploadViaGateway) {
                        String ipForStoreFileInExternalStorage = this.uploadIP;
                        int response = backupAdapter.storeFileInExternalStorage(tempUploadFileTO, ipForStoreFileInExternalStorage, null, this.cloudName, SettingHelper.readTokenFromFile(), chunkFileElement, SettingHelper.getOsName(), chunkFileElement.getDeviceUUID(), "", SettingHelper.getUserName().toLowerCase(), uploadViaGateway, prevBackupId, this.prevIPForGateway, SettingHelper.getMaxVersionsToKeep());
                        if (response == 200) {
                            if (!tempUploadFileTO.isFolder()) {
                                ++this.uploadCount;
                                this.updateUI(tempUploadFileTO.getClientData(), this.uploadCount);
                                this.updateTotalUploadSize(tempUploadFileTO);
                                this.backupStatisticsDAOImpl.updateStatusFileNameIntoTable(tempUploadFileTO);
                            }
                            FileUtils.cleanDirectory((File)file);
                            this.deleteChunkFolder(file);
                            tempUploadFileTO.setBkupStatus(COMPLETED);
                            this.backUpImageDAOImpl.updateEventToBackupImageTable(tempUploadFileTO);
                            this.uploadIPForGateway = currentIP;
                        } else {
                            logger.error(" Chunk File not merged");
                            backupTOs.add(tempUploadFileTO);
                            FileUtils.cleanDirectory((File)file);
                            this.deleteChunkFolder(file);
                            continue;
                        }
                    }
                    isNormalUpload = false;
                    uploadViaGateway = false;
                }
                logger.debug(" IS isNormalUpload " + isNormalUpload);
                if (isNormalUpload && !this.uploadFile(tempUploadFileTO)) {
                    backupTOs.add(tempUploadFileTO);
                    continue;
                }
                if (!uploadViaGateway || this.uploadFileViaGateway(tempUploadFileTO)) continue;
                backupTOs.add(tempUploadFileTO);
            }
            catch (Exception e) {
                logger.error("Exception Occurred while backing up  file: ", (Throwable)e);
            }
        }
        this.uploadList.removeAll(backupTOs);
        this.backUpImageDAOImpl.removeListFromTable(backupTOs);
        this.updateUI("", this.uploadCount);
        NotificationHelper.setFileBeingBackedup(null);
    }

    private int getMaxVersionsFromPolicy() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        if (currentDetails != null && !currentDetails.isEmpty()) {
            BackupPolicyTO currentPolicy = currentDetails.get(0);
            logger.debug("MaxVersions to Keep " + currentPolicy.getMaxVersions());
            return currentPolicy.getMaxVersions();
        }
        return 0;
    }

    private String checkDedupOfFile(BackupTO tempUploadFileTO) {
        String fileDedupFlag = "";
        String backupId = this.dedupHashMap.get(tempUploadFileTO.getMd5checksum());
        if (backupId != null) {
            fileDedupFlag = backupId;
        }
        return fileDedupFlag;
    }

    private boolean splitAndWriteORNormalUpload(List<BackupTO> backupTOs, BackupTO tempUploadFileTO, String sourcePath, String destinationPath, File file, boolean isNormalUpload) throws IOException {
        boolean isDiskSpaceAvailable = true;
        try {
            this.splitAndWrite(sourcePath, destinationPath);
        }
        catch (Exception ex) {
            logger.error("Split and write catch skipping chunk file " + ex);
            ex.getMessage();
            isDiskSpaceAvailable = false;
        }
        boolean isFileUploaded = false;
        if (!isDiskSpaceAvailable) {
            try {
                FileUtils.cleanDirectory((File)file);
                FileUtils.forceDelete((File)file);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("error while cleaninig and deleting the file" + e.getMessage());
            }
            isFileUploaded = this.uploadIfLessDiskspace(backupTOs, tempUploadFileTO, isFileUploaded, isNormalUpload);
        }
        return isFileUploaded;
    }

    private boolean uploadChunkFiles(BackupTO tempUploadFileTO, String destinationPath, BackupAdapter backupAdapter, ChunkFileElement chunkFileElement, String chunkFile, String prevBackupId, boolean viaGateway, int maxVersionsToKeep) throws NoSuchAlgorithmException, FileNotFoundException, InvalidKeyException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        String nearestGatewayIP;
        String recivedChunkFile = chunkFile;
        this.updateUI(tempUploadFileTO.getClientData(), this.uploadCount);
        if (tempUploadFileTO.getBkupStatus() == null) {
            tempUploadFileTO.setBkupStatus(STARTED);
            tempUploadFileTO.setGatewayIP(this.uploadIPForGateway);
            this.backUpImageDAOImpl.insertFileToBackupImageTable(tempUploadFileTO);
            this.serverErrorRetryCounter = 1;
        }
        boolean retry = false;
        int retrycount = 0;
        if (viaGateway) {
            boolean success;
            nearestGatewayIP = this.uploadIPForGateway;
            if (!this.prevIPForGateway.equalsIgnoreCase(this.uploadIPForGateway) && (success = this.isPrevBlukryptAvailable(this.prevIPForGateway))) {
                nearestGatewayIP = this.prevIPForGateway;
                this.prevIPForGateway = this.uploadIPForGateway;
            }
        } else {
            nearestGatewayIP = this.uploadIP;
        }
        do {
            try {
                chunkFileElement.setDeviceUUID(SettingHelper.getDeviceUUId());
                chunkFileElement.setChecksum(MD5Generator.generateMD5OfFile((File)new File(destinationPath + recivedChunkFile)));
                chunkFileElement.setFileCompletePath(destinationPath + recivedChunkFile);
                chunkFileElement.setFileName(recivedChunkFile);
                CreateXmlObject.createChunkFileElementXml((ChunkFileElement)chunkFileElement);
                String nextChunkValue = backupAdapter.getNextChunkValue(tempUploadFileTO, nearestGatewayIP, null, this.cloudName, SettingHelper.readTokenFromFile(), chunkFileElement, SettingHelper.getOsName(), SettingHelper.getDeviceUUId(), SettingHelper.getUserName(), prevBackupId, viaGateway, this.prevIPForGateway, maxVersionsToKeep, "", "");
                if ("-1".equals(nextChunkValue)) {
                    logger.debug("Chunk File uploaded successfully " + nextChunkValue);
                    return true;
                }
                logger.debug("Next Chunk File value " + nextChunkValue);
                recivedChunkFile = nextChunkValue;
                if (!"".equals(recivedChunkFile)) continue;
                ++this.serverErrorRetryCounter;
                if (this.serverErrorRetryCounter % 2 == 0) {
                    logger.debug("Empty chunk file value");
                    recivedChunkFile = chunkFileElement.getFileName();
                    ++retrycount;
                    retry = true;
                    this.threadSleepOnemin();
                    continue;
                }
                return false;
            }
            catch (CrawlAdapterException e) {
                logger.error("Exception occurred  inside chunk crawl adapter exception: " + e);
                retry = true;
                ++retrycount;
                nearestGatewayIP = this.sleepAndGetNearestGateway(nearestGatewayIP);
            }
            catch (IOException exception) {
                logger.trace("" + exception);
                logger.error("IOEXception while uploading chunk" + exception.getMessage());
                this.isTerminated = false;
                return false;
            }
            catch (UploadChunkFileException exception) {
                if (exception.getErrorStatus() == 507) {
                    this.updateSystrayToolTipNotification("Upload failed  ", " The file " + tempUploadFileTO.getFileName() + "  could not be uploaded due to lack of disk space on the server.");
                    logger.trace("" + exception);
                    logger.error("disk space full error" + exception.getMessage());
                    return false;
                }
                if (exception.getErrorStatus() != 1011) continue;
                this.updateSystrayToolTipNotification("User Limit Exceeded", "The storage space limit has been reached. Please contact your Administrator.");
                PolicyManagementServerHelper.updateFailCodeToActivityHistory(1981);
                this.isTerminated = true;
                logger.trace("" + exception);
                logger.error("user storage exceeded" + exception.getMessage());
                return false;
            }
        } while (retry && retrycount < 30 || !retry || retrycount <= 30);
        logger.debug("END of loop and retrycount exceeded");
        this.isTerminated = true;
        return false;
    }

    private void threadSleepOnemin() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted in chunk response empty block");
        }
    }

    private boolean isPrevBlukryptAvailable(String prevBlukryptIp) {
        int response = this.backUpAdapter.pingGatewayIP(prevBlukryptIp, SettingHelper.getDeviceUUId());
        if (response == 200) {
            return false;
        }
        return false;
    }

    private boolean uploadIfLessDiskspace(List<BackupTO> backupTOs, BackupTO tempUploadFileTO, boolean isFileUploaded, boolean isNormalUpload) throws IOException {
        boolean fileUploaded = isFileUploaded;
        if (isNormalUpload) {
            if (!this.uploadFile(tempUploadFileTO)) {
                backupTOs.add(tempUploadFileTO);
                return true;
            }
        } else {
            if (!this.uploadFileViaGateway(tempUploadFileTO)) {
                backupTOs.add(tempUploadFileTO);
                return true;
            }
            fileUploaded = true;
        }
        return fileUploaded;
    }

    private void createChunkFolderAndHideIt(String chunkPath) {
        try {
            Process proc;
            int exitVal;
            Runtime rt = Runtime.getRuntime();
            boolean success = BackUpUpload.createFolder(chunkPath);
            if (success && (exitVal = (proc = rt.exec("attrib +h " + chunkPath)).waitFor()) != 0) {
                Process proc1 = rt.exec("attrib +h " + chunkPath);
                proc1.waitFor();
            }
        }
        catch (Exception t) {
            logger.trace("" + t);
            logger.error("Create Hidden chunk Folder exception" + t.getMessage());
        }
    }

    private void createChunkFolder(String chunkPath) {
        try {
            BackUpUpload.createFolder(chunkPath);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Error in create chunk folder" + e.getMessage());
        }
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    logger.trace("" + e);
                    logger.error("Chunk folder deletion Failed" + e.getMessage());
                }
            } else {
                try {
                    FileUtils.cleanDirectory((File)file);
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    logger.trace("" + e);
                    logger.error("IOException in delete chunk filder" + e.getMessage());
                }
            }
        }
    }

    private boolean isFileChunkable(BackupTO tempUploadFileTO, int pftSize) {
        boolean isChunkable = false;
        File file = new File(tempUploadFileTO.getClientData());
        if (file.isDirectory()) {
            return isChunkable;
        }
        long fileSizeinBytes = file.length();
        float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
        if (fileSizeinMb >= (float)pftSize) {
            isChunkable = true;
        }
        return isChunkable;
    }

    private int getCurrentPolicyPFTSize() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            currentPolicy = currentDetails.get(0);
        }
        if (currentPolicy != null && "true".equals(currentPolicy.getPftEnabled())) {
            int pftSize = currentPolicy.getPftSize();
            return pftSize;
        }
        return 0;
    }

    private int getCpuUtilFromUser() {
        BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
        List<BackupPolicyTO> currentDetails = backupPolicyDAOImpl.getBackupPolicyDetails();
        BackupPolicyTO currentPolicy = null;
        if (currentDetails != null && !currentDetails.isEmpty()) {
            currentPolicy = currentDetails.get(0);
        }
        if (currentPolicy != null) {
            return currentPolicy.getCpuUtilization();
        }
        return 80;
    }

    public double checkSystemUsage() {
        try {
            SystemInfo info = new SystemInfo();
            double percentage = info.getSystemMemory();
            logger.debug("System memory percentage is:" + percentage);
            return percentage;
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("error while checking system usage" + e.getMessage());
            return 0.0;
        }
    }

    private boolean uploadFile(BackupTO fileToUpload) {
        this.updateUI(fileToUpload.getClientData(), this.uploadCount);
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = fileToUpload.getClientData();
        if (!this.handleFileExist(absPath)) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (this.handleHttpRequests(fileToUpload)) {
            if (!fileToUpload.isFolder()) {
                ++this.uploadCount;
                this.updateUI(fileToUpload.getClientData(), this.uploadCount);
                this.updateTotalUploadSize(fileToUpload);
            }
            fileToUpload.setBkupStatus(COMPLETED);
            fileToUpload.setGatewayIP(this.uploadIP);
            this.backUpImageDAOImpl.updateEventToBackupImageTable(fileToUpload);
            return true;
        }
        return false;
    }

    private void updateUI(String fileName, int uploadCount2) {
        NotificationHelper.setFileBeingBackedup(fileName);
        NotificationHelper.setTotalBackupCount(uploadCount2);
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        if (!file.exists()) {
            logger.debug("File doesnt exist: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    private boolean handleFileModified(String absPath, long lastModifiedTimestamp) {
        File file = new File(absPath);
        if (file.isDirectory()) {
            return true;
        }
        if (file.lastModified() > lastModifiedTimestamp) {
            logger.debug("File modified: " + file.getAbsoluteFile());
            return false;
        }
        return true;
    }

    private boolean handleHttpRequests(BackupTO fileToUpload) {
        int retrycount = 0;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.uploadIP;
        logger.debug("Trying to upload file: " + fileToUpload.getClientData());
        NotificationHelper.setFileBeingBackedup(fileToUpload.getClientData());
        fileToUpload.setBkupStatus(STARTED);
        fileToUpload.setGatewayIP(currentUploadIPToUse);
        this.backUpImageDAOImpl.insertFileToBackupImageTable(fileToUpload);
        String filePath = fileToUpload.getClientData();
        while (true) {
            try {
                int response = this.backUpAdapter.uploadBackUpFile(fileToUpload, currentUploadIPToUse, this.port, filePath, this.token);
                if (response != 3 && response != 4) {
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                    } else if (response == 1006) {
                        this.updateSystrayToolTipNotification("Cloud disk space full", "  Your CrashPlan subscription has reached its maximum storage limit.");
                        NotificationHelper.cloudSpaceExceeded = true;
                        this.isTerminated = true;
                    } else if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                    } else if (response == 1008) {
                        this.isTerminated = true;
                    } else if (response == 1007) {
                        this.updateSystrayToolTipNotification("Upload failed  ", " The file " + fileToUpload.getFileName() + "  could not be uploaded due to lack of disk space on the server.");
                    } else if (response == 417) {
                        this.updateSystrayToolTipNotification("User Limit Exceeded", "The storage space limit for backup has been reached");
                    }
                    return false;
                }
                NotificationHelper.cloudSpaceExceeded = false;
                if (currentUploadIPToUse != null && !currentUploadIPToUse.equals(this.uploadIP)) {
                    this.uploadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (CrawlAdapterException e) {
                logger.error("Exception occurred  CrawlAdapterException retry: ", (Throwable)e);
                this.threadSleepOnemin();
                if (++retrycount <= 14 || (currentUploadIPToUse = this.updateIpToUse(0, 1, currentUploadIPToUse)) != null || retrycount <= 15) continue;
                logger.debug("Current Upload IP To Use is null");
                return false;
                if (retrycount < 15) continue;
                return false;
            }
            break;
        }
    }

    public abstract void updateSystrayToolTipNotification(String var1, String var2);

    private String updateIpToUse(int gaeLocal, int gaePublic, String currentUploadIPToUse) {
        String[] ipToUse = new String[3];
        String[] ports = new String[2];
        String currentUploadIPToUtilise = currentUploadIPToUse;
        boolean isIpFound = NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)this.keyStorePath, (String[])ipToUse, (String[])ports);
        if (!isIpFound) {
            if (!PropertyHelper.MAIN_EBMS_DOMAIN.isEmpty() && SettingHelper.getBackupLicenced().contentEquals("true")) {
                BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
                String bluVaultIP = bluVaultIPHelper.getNearestBluVaultByResponseTime();
                if (!StringUtils.isEmpty((String)bluVaultIP)) {
                    SettingHelper.setGaeLocalIpAddress(bluVaultIP);
                    SettingHelper.setPublicIpAddress(bluVaultIP);
                    SettingHelper.setCurrentCloudIpAddress(bluVaultIP);
                }
                currentUploadIPToUtilise = SettingHelper.getCurrentCloudIpAddress();
            }
            return currentUploadIPToUtilise;
        }
        if (ipToUse[0] == null && ipToUse[1] == null) {
            return null;
        }
        if (ipToUse[gaeLocal] != null && !ipToUse[gaeLocal].equals(currentUploadIPToUtilise)) {
            currentUploadIPToUtilise = ipToUse[gaeLocal];
            this.port = null;
        } else if (ipToUse[gaeLocal] != null) {
            currentUploadIPToUtilise = ipToUse[gaePublic];
            this.port = null;
        }
        return currentUploadIPToUtilise;
    }

    public void abortUploadProcesses() {
        if (this.backUpAdapter != null) {
            this.backUpAdapter.cancelHttpPut();
        }
    }

    public void splitAndWrite(String sourceFilePath, String destinationPath) throws IOException, NoSuchAlgorithmException {
        int chunckSize = 524288;
        File willBeRead = new File(sourceFilePath);
        if (!willBeRead.exists()) {
            return;
        }
        long fileSize = willBeRead.length();
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        int numberOfChuncks = 0;
        byte[] temporary = null;
        long totalBytesRead = 0L;
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
            while (totalBytesRead < fileSize) {
                int bytesRead;
                String partName = String.valueOf(numberOfChuncks);
                long bytesRemaining = fileSize - totalBytesRead;
                if (bytesRemaining < (long)chunckSize) {
                    chunckSize = Integer.parseInt(String.valueOf(bytesRemaining));
                    logger.debug("CHUNK SIZE: " + chunckSize);
                }
                if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[chunckSize], 0, chunckSize)) > 0) {
                    totalBytesRead += (long)bytesRead;
                    ++numberOfChuncks;
                }
                this.write(temporary, destinationPath + partName);
                File tempFile = new File(destinationPath + partName);
                String tempFileMd5 = MD5Generator.generateMD5OfFile((File)tempFile);
                String newName = String.format("part%09d.%s", numberOfChuncks, tempFileMd5);
                File renameFile = new File(destinationPath + newName);
                tempFile.renameTo(renameFile);
                md5AndFileValueMap.put(tempFileMd5, tempFile.getPath());
            }
        }
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        ((OutputStream)output).close();
    }

    public static List<String> getExistingFileNames(String path) {
        ArrayList<String> results = new ArrayList<String>();
        File[] files = new File(path).listFiles();
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : files) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }

    private static boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("error while creating folder" + e.getMessage());
            }
        }
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    private boolean uploadFileViaGateway(BackupTO fileToUpload) {
        this.updateUI(fileToUpload.getClientData(), this.uploadCount);
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = fileToUpload.getClientData();
        if (!this.handleFileExist(absPath)) {
            this.updateUI("", this.uploadCount);
            this.backupStatisticsDAOImpl.updateFailedStatusFileNameIntoTable(fileToUpload, "File Not Found");
            return false;
        }
        if (!this.handleFileModified(absPath, fileToUpload.getLastModifiedTimestamp())) {
            this.updateUI("", this.uploadCount);
            return false;
        }
        if (this.handleHttpRequestsFromGateway(fileToUpload)) {
            if (!fileToUpload.isFolder()) {
                ++this.uploadCount;
                this.updateUI(fileToUpload.getClientData(), this.uploadCount);
                this.updateTotalUploadSize(fileToUpload);
                this.backupStatisticsDAOImpl.updateStatusFileNameIntoTable(fileToUpload);
            }
            fileToUpload.setBkupStatus(COMPLETED);
            this.backUpImageDAOImpl.updateEventToBackupImageTable(fileToUpload);
            return true;
        }
        return false;
    }

    private void checkChunkFolderExistsAndDelete(BackupTO fileToUpload) {
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String chunkPath = new StringBuffer().append(fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
            File file = new File(chunkPath);
            this.deleteChunkFolder(file);
        } else {
            String chunkPath = new StringBuffer().append(fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
            File file = new File(chunkPath);
            this.deleteChunkFolder(file);
        }
    }

    private boolean handleHttpRequestsFromGateway(BackupTO fileToUpload) {
        boolean retry;
        int retrycount = 0;
        this.serverErrorRetryCounter = 1;
        String currentUploadIPToUse = this.uploadIPForGateway;
        NotificationHelper.setFileBeingBackedup(fileToUpload.getClientData());
        File file = new File(fileToUpload.getClientData());
        try {
            if (file.isDirectory()) {
                fileToUpload.setMd5checksum("null");
            } else {
                fileToUpload.setMd5checksum(MD5Generator.generateMD5OfFile((File)file));
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("error when setting md5 while handling http request from gateway" + e.getMessage());
        }
        if (fileToUpload.getBkupStatus() == null) {
            fileToUpload.setBkupStatus(STARTED);
            fileToUpload.setGatewayIP(this.uploadIPForGateway);
            this.backUpImageDAOImpl.insertFileToBackupImageTable(fileToUpload);
        }
        String filePath = fileToUpload.getClientData();
        do {
            block25: {
                retry = false;
                try {
                    if (fileToUpload.isFolder()) {
                        return true;
                    }
                    int response = this.backUpAdapter.uploadFileUsingGateway(fileToUpload, currentUploadIPToUse, this.port, filePath, this.cloudName, this.token, SettingHelper.getUserName().toLowerCase(), SettingHelper.getDeviceUUId(), SettingHelper.getOsName(), this.prevIPForGateway, this.isFileDedup, SettingHelper.getMaxVersionsToKeep(), "", "");
                    logger.debug("Response for uploading file:" + response);
                    if (response != 3 && response != 4 && response != 500) {
                        if (response == 1005) {
                            SettingHelper.setLicenseActive(false);
                            this.isTerminated = true;
                        } else if (response == 1006) {
                            this.updateSystrayToolTipNotification("Cloud disk space full", "  Your CrashPlan subscription has reached its maximum storage limit.");
                            NotificationHelper.cloudSpaceExceeded = true;
                            this.isTerminated = true;
                        } else if (response == 1009) {
                            SettingHelper.setDeviceBlocked(true);
                            this.isTerminated = true;
                        } else if (response == 1008) {
                            this.isTerminated = true;
                        } else if (response == 1007) {
                            this.updateSystrayToolTipNotification("Upload failed  ", " The file " + fileToUpload.getFileName() + "  could not be uploaded due to lack of disk space on the server.");
                        } else if (response == 417) {
                            this.updateSystrayToolTipNotification("User Limit Exceeded", "The storage space limit for backup has been reached");
                        } else if (response == 1011) {
                            this.updateSystrayToolTipNotification("User Limit Exceeded", "The storage space limit has been reached. Please contact your Administrator.");
                            PolicyManagementServerHelper.updateFailCodeToActivityHistory(1981);
                            this.isTerminated = true;
                        }
                        return false;
                    }
                    if (response == 3) {
                        NotificationHelper.cloudSpaceExceeded = false;
                        return true;
                    }
                    if (response != 500) break block25;
                    ++this.serverErrorRetryCounter;
                    if (this.serverErrorRetryCounter % 2 == 0) {
                        logger.debug("Response 500 retry true");
                        retry = true;
                        this.threadSleepOnemin();
                        break block25;
                    }
                    return false;
                }
                catch (CrawlAdapterException e) {
                    logger.trace("" + e);
                    logger.error("Exception occurred  CrawlAdapterException: " + e.getMessage());
                    retry = true;
                    ++retrycount;
                    currentUploadIPToUse = this.sleepAndGetNearestGateway(currentUploadIPToUse);
                }
            }
            if (retrycount <= 30) continue;
            logger.debug("Current Upload IP To Use is null");
            this.isTerminated = true;
            return false;
        } while (retry && retrycount < 30);
        this.isTerminated = true;
        return false;
    }

    private String sleepAndGetNearestGateway(String currentUploadIPToUse) {
        String iPToUse = null;
        try {
            Thread.sleep(60000L);
            int responseForPing = this.backUpAdapter.pingGatewayIP(currentUploadIPToUse, SettingHelper.getDeviceUUId());
            if (responseForPing != 200) {
                iPToUse = PolicyManagementServerHelper.getPrivacyGatewayIP("ALL", "BACKUP").getGatewayName();
                logger.debug("the pGGateway IP in catch$%$%$%$%$%" + iPToUse);
            }
        }
        catch (InterruptedException ex) {
            logger.trace("" + ex);
            logger.error("Exception in upload file via gateway" + ex.getMessage());
        }
        catch (Exception ex) {
            logger.trace("" + ex);
            logger.error("error in get privacy gateway IP" + ex.getMessage());
        }
        return iPToUse;
    }

    String putEntryInPortal(BackupTO fileToUpload) {
        String filePath = fileToUpload.getClientData();
        String backupId = null;
        try {
            backupId = this.backUpAdapter.uploadExternalBackUpFile(fileToUpload, this.uploadIP, this.port, filePath, this.token);
        }
        catch (Exception ex) {
            logger.trace("error while calling upload external backup file" + ex);
            logger.error(ex.getMessage());
        }
        logger.debug("The response for put entry in portal is Backup ID:" + backupId);
        return backupId;
    }

    private void updateTotalUploadSize(BackupTO backupTO) {
        BackupActivityHistoryDAOImpl backupActivityHistoryDAOImpl = new BackupActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        BackupActivityTO backupActivityTO = backupActivityHistoryDAOImpl.getCurrentStatusFromBackupActivityHistoryTable();
        long fileSize = backupTO.getFileSize();
        this.totalUploadSize = this.totalUploadSize + fileSize;
        NotificationHelper.setTotalUploadSize(this.totalUploadSize);
        backupActivityTO.setTotalUploadSize(this.totalUploadSize.longValue());
        backupActivityTO.setBackupUploadCount(NotificationHelper.getTotalBackupCount() + "/" + NotificationHelper.getNoOfFilesToBeBackedUp());
        backupActivityHistoryDAOImpl.updateEventToBackupActivityHistoryTable(backupActivityTO);
    }
}

