/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeValue;

public class Attribute
implements DEREncodable {
    private DERObjectIdentifier attrType;
    private DERConstructedSet attrValues;

    public Attribute(String string, Vector vector) {
        this.setAttrType(string);
        this.setAttrValues(vector);
    }

    public Attribute(BERConstructedSequence bERConstructedSequence) {
        this.attrType = (DERObjectIdentifier)bERConstructedSequence.getObjectAt(0);
        this.attrValues = (DERConstructedSet)bERConstructedSequence.getObjectAt(1);
    }

    public Attribute(Attribute attribute) {
        this.attrType = attribute.attrType;
        this.attrValues = attribute.attrValues;
    }

    public static Attribute getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Attribute) {
            return (Attribute)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new Attribute((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return Attribute.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid Attribute");
    }

    public static Attribute newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Attribute) {
            return new Attribute((Attribute)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new Attribute((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return Attribute.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid Attribute");
    }

    public String getAttrType() {
        return this.attrType.getId();
    }

    private void setAttrType(String string) {
        this.attrType = new DERObjectIdentifier(string);
    }

    public Vector getAttrValues() {
        int n = this.attrValues.getSize();
        Vector<AttributeValue> vector = new Vector<AttributeValue>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(AttributeValue.getInstance(this.attrValues.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setAttrValues(Vector vector) {
        int n = vector.size();
        this.attrValues = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.attrValues.addObject(AttributeValue.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.attrType);
        bERConstructedSequence.addObject(this.attrValues);
        return bERConstructedSequence;
    }
}

