/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.DecoderBase;
import zmq.IMsgSink;
import zmq.Msg;

public class V1Decoder
extends DecoderBase {
    private static final int ONE_BYTE_SIZE_READY = 0;
    private static final int EIGHT_BYTE_SIZE_READY = 1;
    private static final int FLAGS_READY = 2;
    private static final int MESSAGE_READY = 3;
    private final byte[] tmpbuf;
    private Msg inProgress;
    private IMsgSink msgSink;
    private final long maxmsgsize;
    private int msgFlags;

    public V1Decoder(int bufsize, long maxmsgsize, IMsgSink session) {
        super(bufsize);
        this.maxmsgsize = maxmsgsize;
        this.msgSink = session;
        this.tmpbuf = new byte[8];
        this.nextStep(this.tmpbuf, 1, 2);
    }

    @Override
    public void setMsgSink(IMsgSink msgSink) {
        this.msgSink = msgSink;
    }

    @Override
    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.oneByteSizeReady();
            }
            case 1: {
                return this.eightByteSizeReady();
            }
            case 2: {
                return this.flagsReady();
            }
            case 3: {
                return this.messageReady();
            }
        }
        return false;
    }

    private boolean oneByteSizeReady() {
        int size = this.tmpbuf[0];
        if (size < 0) {
            size = 0xFF & size;
        }
        if (this.maxmsgsize >= 0L && (long)size > this.maxmsgsize) {
            this.decodingError();
            return false;
        }
        this.inProgress = new Msg(size);
        this.inProgress.setFlags(this.msgFlags);
        this.nextStep(this.inProgress.data(), this.inProgress.size(), 3);
        return true;
    }

    private boolean eightByteSizeReady() {
        long msgSize = ByteBuffer.wrap(this.tmpbuf).getLong();
        if (this.maxmsgsize >= 0L && msgSize > this.maxmsgsize) {
            this.decodingError();
            return false;
        }
        if (msgSize > Integer.MAX_VALUE) {
            this.decodingError();
            return false;
        }
        this.inProgress = new Msg((int)msgSize);
        this.inProgress.setFlags(this.msgFlags);
        this.nextStep(this.inProgress.data(), this.inProgress.size(), 3);
        return true;
    }

    private boolean flagsReady() {
        this.msgFlags = 0;
        byte first = this.tmpbuf[0];
        if ((first & 1) > 0) {
            this.msgFlags |= 1;
        }
        if ((first & 2) > 0) {
            this.nextStep(this.tmpbuf, 8, 1);
        } else {
            this.nextStep(this.tmpbuf, 1, 0);
        }
        return true;
    }

    private boolean messageReady() {
        if (this.msgSink == null) {
            return false;
        }
        int rc = this.msgSink.pushMsg(this.inProgress);
        if (rc != 0) {
            if (rc != 35) {
                this.decodingError();
            }
            return false;
        }
        this.nextStep(this.tmpbuf, 1, 2);
        return true;
    }
}

