/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.notifications;

import com.parablu.epa.common.service.notification.EventHandler;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.service.support.SupportHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.ManualSyncHelper;
import com.parablu.epa.service.backup.MacCheckBackupPolicy;
import com.parablu.epa.service.sync.MacCheckSyncPolicy;
import com.parablu.epa.view.RestoreManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacEventsManagement {
    private Logger logger = LoggerFactory.getLogger(MacEventsManagement.class);
    private EventHandler eventHandler = new EventHandler();
    public static Set<String> event = new HashSet<String>();
    private String eventlist = "";
    private boolean pullHistoricalLogs;
    private boolean pullDbLogs;
    private boolean pullSetupLogs;

    public void refreshPolicyTask() {
        this.pullHistoricalLogs = false;
        this.pullDbLogs = false;
        this.pullSetupLogs = false;
        List events = this.eventHandler.checkNotificationFromServer();
        events.forEach(action -> {
            try {
                switch (eventsValues.valueOf(action)) {
                    case BACKUPPOLICY_REFRESH: {
                        if (EventHandler.Actions.BACKUPPOLICY_REFRESH.name().equalsIgnoreCase((String)action)) {
                            MacCheckBackupPolicy.checkGroupPolicy();
                            BlusyncThreadHelper.resetBackupTimer();
                        }
                        break;
                    }
                    case START_BACKUP: {
                        if (EventHandler.Actions.START_BACKUP.name().equalsIgnoreCase((String)action)) {
                            this.logger.debug("Calling start backup.");
                            ManualSyncHelper.startManualBackup();
                        }
                        break;
                    }
                    case SYNCPOLICY_REFRESH: {
                        if (EventHandler.Actions.SYNCPOLICY_REFRESH.name().equalsIgnoreCase((String)action) && SettingHelper.getSyncLicenced().equals("true")) {
                            MacCheckSyncPolicy.pullSyncPolicy();
                            BlusyncThreadHelper.resetSyncTimer();
                        }
                        break;
                    }
                    case PAUSE_BACKUP: {
                        if (EventHandler.Actions.PAUSE_BACKUP.name().equalsIgnoreCase((String)action) && NotificationHelper.isBackUpStarted()) {
                            this.logger.debug("Calling pause backup.");
                            BlusyncThreadHelper.cancelCurrentBackupProcess(true, false, true);
                        }
                        break;
                    }
                    case STOP_BACKUP: {
                        if (EventHandler.Actions.STOP_BACKUP.name().equalsIgnoreCase((String)action) && NotificationHelper.isBackUpStarted()) {
                            this.logger.debug("Calling stop backup.");
                            BlusyncThreadHelper.cancelCurrentBackupProcess(true, true, true);
                        }
                        break;
                    }
                    case START_RESTORE: {
                        this.logger.debug("start restore..");
                        if (NotificationHelper.isRestoreStarted()) break;
                        this.logger.debug("..inside start restore.....");
                        RestoreManager restoreManager = new RestoreManager();
                        restoreManager.getRestoreElementfromServer();
                        break;
                    }
                    case PULL_AGENTLOGS: {
                        event.add((String)action);
                        break;
                    }
                    case PULL_HISTORICAL_LOGS: {
                        event.add((String)action);
                        this.pullHistoricalLogs = true;
                        break;
                    }
                    case DATABASES: {
                        event.add((String)action);
                        this.pullDbLogs = true;
                        break;
                    }
                    case SETUP_LOGS: {
                        event.add((String)action);
                        this.pullSetupLogs = true;
                        break;
                    }
                    default: {
                        this.logger.debug("default case");
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("ERROR ", (Throwable)e);
            }
        });
        if (event.size() > 0) {
            this.eventlist = StringUtils.join(event, (String)",");
            event.clear();
            SupportHelper.sendNewSupportLogs((String)SettingHelper.getCloudName(), (String)SettingHelper.getUserName(), (String)SettingHelper.getDeviceName(), (boolean)true, (boolean)this.pullHistoricalLogs, (boolean)this.pullDbLogs, (boolean)this.pullSetupLogs, (String)this.eventlist);
        }
    }

    public static enum eventsValues {
        PULL_AGENTLOGS,
        SYNCPOLICY_REFRESH,
        BACKUPPOLICY_REFRESH,
        STOP_BACKUP,
        START_BACKUP,
        PULL_HISTORICAL_LOGS,
        PAUSE_BACKUP,
        DATABASES,
        SETUP_LOGS,
        START_RESTORE;

    }
}

