/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.dao.DownloadTableDAO;
import com.parablu.epa.core.to.FileTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTableImpl
extends BaseDAO
implements DownloadTableDAO {
    private Logger logger = LoggerFactory.getLogger(DownloadTableImpl.class);
    private static final String SQLEXCEPTION_WHILE_CLOSING_RESULTSET = "SQLException while closing result set";

    public DownloadTableImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListToTable(List<FileTO> fileList) {
        StringBuilder sqlQuery = new StringBuilder().append("INSERT INTO ").append("DownloadTable").append(" Values(?,?,?,?,?,?,?,?,?);");
        this.statement = null;
        boolean success = false;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                int listsize = fileList.size();
                this.conn.setAutoCommit(false);
                for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                    FileTO currentFilesTO = fileList.get(recordCount);
                    int tempValueFolder = currentFilesTO.isFolder() ? 1 : 0;
                    int tempValueExist = currentFilesTO.isExists() ? 1 : 0;
                    this.statement.setString(1, currentFilesTO.getFileName());
                    this.statement.setString(2, currentFilesTO.getAbstractFilePath());
                    this.statement.setString(3, currentFilesTO.getMiniCloudId());
                    this.statement.setString(4, currentFilesTO.getMd5checksum());
                    this.statement.setString(5, currentFilesTO.getMetaData());
                    this.statement.setString(6, String.valueOf(currentFilesTO.getLastModifiedTimestamp()));
                    this.statement.setInt(7, tempValueFolder);
                    this.statement.setString(8, currentFilesTO.getFileRevisionId());
                    this.statement.setInt(9, tempValueExist);
                    this.statement.addBatch();
                    if (recordCount % 1000 != 0) continue;
                    this.logger.info("Record count reached Thousand.");
                    this.statement.executeBatch();
                    this.statement.clearBatch();
                }
                this.statement.executeBatch();
                this.statement.close();
                this.conn.commit();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while inserting List To download Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return success;
    }

    @Deprecated
    public void removeListFromTable(List<FileTO> fileList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTable(FileTO fileList) {
        String filePath = fileList.getAbstractFilePath();
        String filename = fileList.getFileName();
        StringBuilder sqlQuery = new StringBuilder().append("delete from ").append("DownloadTable").append(" where ").append("filepath").append("=?").append(" and ").append("filename").append("= ?").append(";");
        this.statement = null;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                this.statement.setString(1, filePath);
                this.statement.setString(2, filename);
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while removing From Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable() {
        this.statement = null;
        StringBuilder sqlQuery = new StringBuilder().append("delete from ").append("DownloadTable");
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while clear download Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
    }

    public boolean createDownloadTable() {
        this.statement = null;
        boolean gotConnection = this.getConnectionForCreatingDatabase();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(createDownloadTableSqlQuery.toString());
                this.statement.execute();
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while creating Download Table" + e);
            }
            finally {
                this.closeConnection();
            }
        }
        return gotConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> selectListFromTable() {
        StringBuilder sqlQuery = new StringBuilder().append("select * from ").append("DownloadTable");
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = new ArrayList<FileTO>();
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setFileRevisionId(selectImageTableResult.getString("fileRevId"));
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting List From Table " + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTO> selectSortedListFromTable(int range) {
        StringBuilder sqlQuery = new StringBuilder().append("select * from ").append("DownloadTable").append(" Order By ").append("folder").append(" Desc,").append("(Length(").append("filepath").append(") - Length(REPLACE(").append("filepath").append(",\"\\\",\"\"))) Asc LIMIT ").append(range);
        this.statement = null;
        ResultSet selectImageTableResult = null;
        ArrayList<FileTO> fileTOList = new ArrayList<FileTO>();
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                while (selectImageTableResult != null && selectImageTableResult.next()) {
                    FileTO tempFile = new FileTO();
                    tempFile.setFileName(selectImageTableResult.getString("filename"));
                    tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                    tempFile.setMiniCloudId(selectImageTableResult.getString("miniCloudId"));
                    tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                    tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                    String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                    tempFile.setFolder(selectImageTableResult.getInt("folder") == 1);
                    tempFile.setExists(selectImageTableResult.getInt("exist") == 1);
                    tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                    tempFile.setFileRevisionId(selectImageTableResult.getString("fileRevId"));
                    fileTOList.add(tempFile);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while selecting Sorted List From download Table " + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return fileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowCountFromTable() {
        StringBuilder sqlQuery = new StringBuilder().append("select count(*) from ").append("DownloadTable");
        this.statement = null;
        ResultSet selectImageTableResult = null;
        long countOfFileTOList = 0L;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                if (selectImageTableResult != null && selectImageTableResult.next()) {
                    countOfFileTOList = selectImageTableResult.getLong(1);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while getting RowCount From download Table." + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return countOfFileTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileCountFromTable() {
        StringBuilder sqlQuery = new StringBuilder().append("select count(*) from ").append("DownloadTable").append(" where ").append("folder").append("=0").append(";");
        this.statement = null;
        ResultSet selectImageTableResult = null;
        long countOfFileTOList = 0L;
        boolean gotConnection = this.getConnection();
        if (gotConnection) {
            try {
                this.statement = this.conn.prepareStatement(sqlQuery.toString());
                selectImageTableResult = this.statement.executeQuery();
                if (selectImageTableResult != null && selectImageTableResult.next()) {
                    countOfFileTOList = selectImageTableResult.getLong(1);
                }
                this.statement.close();
            }
            catch (SQLException e) {
                this.logger.error("SQLException while getting FileCount From download Table." + e);
            }
            finally {
                if (selectImageTableResult != null) {
                    try {
                        selectImageTableResult.close();
                    }
                    catch (SQLException e) {
                        this.logger.error(SQLEXCEPTION_WHILE_CLOSING_RESULTSET + e);
                    }
                }
                this.closeConnection();
            }
        }
        return countOfFileTOList;
    }
}

