/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.SignatureAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.SignatureValue;
import org.bouncycastle.asn1.cms.SignedAttributes;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.UnsignedAttributes;

public class SignerInfo
implements DEREncodable {
    private CMSVersion version;
    private SignerIdentifier sid;
    private DigestAlgorithmIdentifier digestAlgorithm;
    private SignedAttributes signedAttrs;
    private SignatureAlgorithmIdentifier signatureAlgorithm;
    private SignatureValue signature;
    private UnsignedAttributes unsignedAttrs;

    public SignerInfo(CMSVersion cMSVersion, SignerIdentifier signerIdentifier, DigestAlgorithmIdentifier digestAlgorithmIdentifier, SignedAttributes signedAttributes, SignatureAlgorithmIdentifier signatureAlgorithmIdentifier, SignatureValue signatureValue, UnsignedAttributes unsignedAttributes) {
        this.setVersion(cMSVersion);
        this.setSid(signerIdentifier);
        this.setDigestAlgorithm(digestAlgorithmIdentifier);
        this.setSignedAttrs(signedAttributes);
        this.setSignatureAlgorithm(signatureAlgorithmIdentifier);
        this.setSignature(signatureValue);
        this.setUnsignedAttrs(unsignedAttributes);
    }

    public SignerInfo(BERConstructedSequence bERConstructedSequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(n++));
        this.sid = SignerIdentifier.getInstance(bERConstructedSequence.getObjectAt(n++));
        this.digestAlgorithm = DigestAlgorithmIdentifier.getInstance(bERConstructedSequence.getObjectAt(n++));
        DEREncodable dEREncodable = bERConstructedSequence.getObjectAt(n++);
        if (dEREncodable instanceof BERTaggedObject) {
            this.signedAttrs = SignedAttributes.getInstance(dEREncodable);
            dEREncodable = bERConstructedSequence.getObjectAt(n++);
        }
        this.signatureAlgorithm = SignatureAlgorithmIdentifier.getInstance(dEREncodable);
        this.signature = SignatureValue.getInstance(bERConstructedSequence.getObjectAt(n++));
        if (bERConstructedSequence.getSize() > n) {
            this.unsignedAttrs = UnsignedAttributes.getInstance(bERConstructedSequence.getObjectAt(n));
        }
    }

    public SignerInfo(SignerInfo signerInfo) {
        this.version = signerInfo.version;
        this.sid = signerInfo.sid;
        this.digestAlgorithm = signerInfo.digestAlgorithm;
        this.signedAttrs = signerInfo.signedAttrs;
        this.signatureAlgorithm = signerInfo.signatureAlgorithm;
        this.signature = signerInfo.signature;
        this.unsignedAttrs = signerInfo.unsignedAttrs;
    }

    public static SignerInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignerInfo) {
            return (SignerInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new SignerInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignerInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignerInfo");
    }

    public static SignerInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignerInfo) {
            return new SignerInfo((SignerInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new SignerInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignerInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignerInfo");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public SignerIdentifier getSid() {
        return this.sid;
    }

    private void setSid(SignerIdentifier signerIdentifier) {
        this.sid = signerIdentifier;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    private void setDigestAlgorithm(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.digestAlgorithm = digestAlgorithmIdentifier;
    }

    public SignedAttributes getSignedAttrs() {
        return this.signedAttrs;
    }

    private void setSignedAttrs(SignedAttributes signedAttributes) {
        this.signedAttrs = signedAttributes;
    }

    public SignatureAlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    private void setSignatureAlgorithm(SignatureAlgorithmIdentifier signatureAlgorithmIdentifier) {
        this.signatureAlgorithm = signatureAlgorithmIdentifier;
    }

    public SignatureValue getSignature() {
        return this.signature;
    }

    private void setSignature(SignatureValue signatureValue) {
        this.signature = signatureValue;
    }

    public UnsignedAttributes getUnsignedAttrs() {
        return this.unsignedAttrs;
    }

    private void setUnsignedAttrs(UnsignedAttributes unsignedAttributes) {
        this.unsignedAttrs = unsignedAttributes;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.sid);
        bERConstructedSequence.addObject(this.digestAlgorithm);
        if (this.signedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.signedAttrs.getDERObject()));
        }
        bERConstructedSequence.addObject(this.signature);
        if (this.unsignedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.unsignedAttrs.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

