/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.AuthAttributes;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.EncapsulatedContentInfo;
import org.bouncycastle.asn1.cms.MessageAuthenticationCode;
import org.bouncycastle.asn1.cms.MessageAuthenticationCodeAlgorithm;
import org.bouncycastle.asn1.cms.OriginatorInfo;
import org.bouncycastle.asn1.cms.RecipientInfos;
import org.bouncycastle.asn1.cms.UnauthAttributes;

public class AuthenticatedData
implements DEREncodable {
    private CMSVersion version;
    private OriginatorInfo originatorInfo;
    private RecipientInfos recipientInfos;
    private MessageAuthenticationCodeAlgorithm macAlgorithm;
    private DigestAlgorithmIdentifier digestAlgorithm;
    private EncapsulatedContentInfo encapContentInfo;
    private AuthAttributes authenticatedAttributes;
    private MessageAuthenticationCode mac;
    private UnauthAttributes unauthenticatedAttributes;

    public AuthenticatedData(CMSVersion cMSVersion, OriginatorInfo originatorInfo, RecipientInfos recipientInfos, MessageAuthenticationCodeAlgorithm messageAuthenticationCodeAlgorithm, DigestAlgorithmIdentifier digestAlgorithmIdentifier, EncapsulatedContentInfo encapsulatedContentInfo, AuthAttributes authAttributes, MessageAuthenticationCode messageAuthenticationCode, UnauthAttributes unauthAttributes) {
        this.setVersion(cMSVersion);
        this.setOriginatorInfo(originatorInfo);
        this.setRecipientInfos(recipientInfos);
        this.setMacAlgorithm(messageAuthenticationCodeAlgorithm);
        this.setDigestAlgorithm(digestAlgorithmIdentifier);
        this.setEncapContentInfo(encapsulatedContentInfo);
        this.setAuthenticatedAttributes(authAttributes);
        this.setMac(messageAuthenticationCode);
        this.setUnauthenticatedAttributes(unauthAttributes);
    }

    public AuthenticatedData(BERConstructedSequence bERConstructedSequence) {
        int n = 0;
        DEREncodable dEREncodable = bERConstructedSequence.getObjectAt(n++);
        this.version = CMSVersion.getInstance(dEREncodable);
        dEREncodable = bERConstructedSequence.getObjectAt(n++);
        if (dEREncodable instanceof BERTaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance(dEREncodable);
            dEREncodable = bERConstructedSequence.getObjectAt(n++);
        }
        this.recipientInfos = RecipientInfos.getInstance(dEREncodable);
        this.macAlgorithm = MessageAuthenticationCodeAlgorithm.getInstance(bERConstructedSequence.getObjectAt(n++));
        if ((dEREncodable = bERConstructedSequence.getObjectAt(n++)) instanceof BERTaggedObject) {
            this.digestAlgorithm = DigestAlgorithmIdentifier.getInstance(dEREncodable);
            dEREncodable = bERConstructedSequence.getObjectAt(n++);
        }
        this.encapContentInfo = EncapsulatedContentInfo.getInstance(dEREncodable);
        if ((dEREncodable = bERConstructedSequence.getObjectAt(n++)) instanceof BERTaggedObject) {
            this.authenticatedAttributes = AuthAttributes.getInstance(dEREncodable);
            dEREncodable = bERConstructedSequence.getObjectAt(n++);
        }
        this.mac = MessageAuthenticationCode.getInstance(dEREncodable);
        if (bERConstructedSequence.getSize() > n) {
            this.unauthenticatedAttributes = UnauthAttributes.getInstance(bERConstructedSequence.getObjectAt(n++));
        }
    }

    public AuthenticatedData(AuthenticatedData authenticatedData) {
        this.version = authenticatedData.version;
        this.originatorInfo = authenticatedData.originatorInfo;
        this.recipientInfos = authenticatedData.recipientInfos;
        this.macAlgorithm = authenticatedData.macAlgorithm;
        this.digestAlgorithm = authenticatedData.digestAlgorithm;
        this.encapContentInfo = authenticatedData.encapContentInfo;
        this.authenticatedAttributes = authenticatedData.authenticatedAttributes;
        this.mac = authenticatedData.mac;
        this.unauthenticatedAttributes = authenticatedData.unauthenticatedAttributes;
    }

    public static AuthenticatedData getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AuthenticatedData) {
            return (AuthenticatedData)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new AuthenticatedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return AuthenticatedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid AuthenticatedData");
    }

    public static AuthenticatedData newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AuthenticatedData) {
            return new AuthenticatedData((AuthenticatedData)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new AuthenticatedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return AuthenticatedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid AuthenticatedData");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    private void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    public RecipientInfos getRecipientInfos() {
        return this.recipientInfos;
    }

    private void setRecipientInfos(RecipientInfos recipientInfos) {
        this.recipientInfos = recipientInfos;
    }

    public MessageAuthenticationCodeAlgorithm getMacAlgorithm() {
        return this.macAlgorithm;
    }

    private void setMacAlgorithm(MessageAuthenticationCodeAlgorithm messageAuthenticationCodeAlgorithm) {
        this.macAlgorithm = messageAuthenticationCodeAlgorithm;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    private void setDigestAlgorithm(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.digestAlgorithm = digestAlgorithmIdentifier;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    private void setEncapContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.encapContentInfo = encapsulatedContentInfo;
    }

    public AuthAttributes getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    private void setAuthenticatedAttributes(AuthAttributes authAttributes) {
        this.authenticatedAttributes = authAttributes;
    }

    public MessageAuthenticationCode getMac() {
        return this.mac;
    }

    private void setMac(MessageAuthenticationCode messageAuthenticationCode) {
        this.mac = messageAuthenticationCode;
    }

    public UnauthAttributes getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    private void setUnauthenticatedAttributes(UnauthAttributes unauthAttributes) {
        this.unauthenticatedAttributes = unauthAttributes;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        if (this.originatorInfo != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.originatorInfo.getDERObject()));
        }
        bERConstructedSequence.addObject(this.recipientInfos);
        bERConstructedSequence.addObject(this.macAlgorithm);
        if (this.digestAlgorithm != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(1, this.digestAlgorithm.getDERObject()));
        }
        bERConstructedSequence.addObject(this.encapContentInfo);
        if (this.authenticatedAttributes != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 2, this.authenticatedAttributes.getDERObject()));
        }
        bERConstructedSequence.addObject(this.mac);
        if (this.unauthenticatedAttributes != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 3, this.unauthenticatedAttributes.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

