/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.UnauthAttributes;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class ExtendedCertificateInfo
implements DEREncodable {
    private CMSVersion version;
    private X509CertificateStructure certificate;
    private UnauthAttributes attributes;

    public ExtendedCertificateInfo(DERConstructedSequence dERConstructedSequence) {
        this.version = CMSVersion.getInstance(dERConstructedSequence.getObjectAt(0));
        DEREncodable dEREncodable = dERConstructedSequence.getObjectAt(1);
        if (dEREncodable instanceof X509CertificateStructure) {
            this.certificate = (X509CertificateStructure)dEREncodable;
        } else if (dEREncodable instanceof DERConstructedSequence) {
            this.certificate = new X509CertificateStructure((DERConstructedSequence)dEREncodable);
        } else {
            throw new IllegalArgumentException("Invalid Certificate");
        }
        this.attributes = UnauthAttributes.getInstance(dERConstructedSequence.getObjectAt(2));
    }

    public static ExtendedCertificateInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedCertificateInfo) {
            return (ExtendedCertificateInfo)object;
        }
        if (object instanceof DERConstructedSequence) {
            return new ExtendedCertificateInfo((DERConstructedSequence)object);
        }
        throw new IllegalArgumentException("Invalid ExtendedCertificateInfo");
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.certificate);
        dERConstructedSequence.addObject(this.attributes);
        return dERConstructedSequence;
    }
}

