/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERGeneralizedTime
extends DERObject {
    String time;

    public static DERGeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERGeneralizedTime.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance");
    }

    public DERGeneralizedTime(String string) {
        this.time = string;
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = simpleDateFormat.format(date);
    }

    DERGeneralizedTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        this.time = new String(cArray);
    }

    public String getTime() {
        if (this.time.length() == 15) {
            return this.time.substring(0, 14) + "GMT+00:00";
        }
        if (this.time.length() == 17) {
            return this.time.substring(0, 14) + "GMT" + this.time.substring(15, 17) + ":" + this.time.substring(17, 19);
        }
        return this.time;
    }

    private byte[] getOctets() {
        char[] cArray = this.time.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n != cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(24, this.getOctets());
    }
}

