/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.sync;

import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.epa.common.dao.ActivityHistoryImpl;
import com.parablu.epa.common.dao.ImageTableImpl;
import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.dao.UploadTableImpl;
import com.parablu.epa.common.service.backup.interfaces.CleanupInterface;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.runnables.ChunkRunnable;
import com.parablu.epa.common.service.runnables.DelegateRunnable;
import com.parablu.epa.common.service.runnables.RestartRunnable;
import com.parablu.epa.common.service.settings.BluVaultIPHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.SyncAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.exception.DatabaseException;
import com.parablu.epa.core.helper.FileSizeBlockingQueue;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.network.NetworkHelper;
import com.parablu.epa.core.service.sync.BaseJob;
import com.parablu.epa.core.to.ActivityTO;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.ChunkFileTO;
import com.parablu.epa.core.to.FileTO;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.RenamedTO;
import com.parablu.epa.core.to.SyncPolicyTo;
import com.parablu.epa.helper.exceptions.BaseException;
import com.parablu.epa.helper.utils.MD5Generator;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadSyncUploadJob
extends BaseJob {
    private Logger logger = LoggerFactory.getLogger(MultiThreadSyncUploadJob.class);
    private static final String TMP_UPLOAD_NAME = ".pbsup.tmp";
    private List<FileTO> uploadList;
    private String uploadIP;
    private final String cloudName;
    private Integer port;
    private final String uploadTableURL;
    private final String fullDevicePath;
    private final String basePathForImageTables;
    private final String currentImageTablePath;
    private final String currentImageTableName;
    private final String token;
    private SyncAdapter uploadAdapter = null;
    private AtomicInteger uploadCount = new AtomicInteger(0);
    private int totalsize = 0;
    private int pftSize = 0x500000;
    private GatewayTO uploadGatewayTO;
    private String requestURL = "/sync/upload/files/all";
    private ActivityHistoryImpl activityHistory = null;
    private String batchId = "";
    SyncPolicyTo currentPolicy = null;
    private static final String DOT_PBS = ".pbsdn";
    private int count = 0;
    final FileSizeBlockingQueue<BackupTO> fileSizeBlockingQueue = new FileSizeBlockingQueue(100, 0x40000000L);
    ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$");
    ExecutorService multiPartUploadService = Executors.newFixedThreadPool(1, this.factoryBuilder.build());
    ExecutorService chunkService = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("multipartupload-$$%d$$").build());
    final BlockingQueue<BackupTO> chunkFileQueue = new LinkedBlockingQueue<BackupTO>(10000);
    final BlockingQueue<Future<BackupTO>> finishedBatchesQueue = new LinkedBlockingQueue<Future<BackupTO>>();
    final AtomicInteger noOfBatches = new AtomicInteger(0);
    final AtomicInteger chunkedFiles = new AtomicInteger(0);
    private AtomicBoolean loopFinished = new AtomicBoolean(false);
    private AtomicBoolean intrupted = new AtomicBoolean(false);
    ParabluFileSystemUtils fileSystemUtils = new ParabluFileSystemUtils();
    private AtomicLong totalUplodSize = new AtomicLong(0L);
    private Thread delegateThread = null;
    private Thread chunkDelegateThread = null;
    private Thread restartDelegateThread = null;
    private AtomicBoolean allThreadsStopped = new AtomicBoolean(false);
    private Timer syncWatchDogTimer = null;
    private TimerTask syncWatchDogTimerTask = null;

    public MultiThreadSyncUploadJob(String iP, Integer port, String cn, String setTableURL, String devicePath, String currentImageTablePath, String baseURlForImageTables, String currentImageTableName, String token, String keyStorePath, GatewayTO gatewayTo) {
        this.uploadIP = iP;
        this.cloudName = cn;
        this.uploadTableURL = setTableURL;
        this.fullDevicePath = devicePath;
        this.uploadAdapter = new SyncAdapter(this.cloudName, keyStorePath);
        this.basePathForImageTables = baseURlForImageTables;
        this.currentImageTablePath = currentImageTablePath;
        this.currentImageTableName = currentImageTableName;
        this.token = token;
        this.port = port;
        this.activityHistory = new ActivityHistoryImpl(SettingHelper.getActivityDBUrl());
        this.uploadGatewayTO = gatewayTo;
    }

    public void run() {
        try {
            RateLimiter rateLimiter;
            this.uploadCount.set(0);
            this.uploadList = new ArrayList<FileTO>();
            SettingHelper.setErrorOccuredDuringSync(false);
            this.loadCurrentSyncPolicy();
            boolean readFromTable = this.readFromUploadTable();
            if (!readFromTable) {
                this.logger.debug("No records in Upload Table");
                this.updateUI(0, null);
                Thread.sleep(150L);
                return;
            }
            this.logger.debug("upload  Gateway IP: " + this.uploadGatewayTO.getGatewayName());
            if (this.uploadGatewayTO == null) {
                SettingHelper.setErrorOccuredDuringSync(true);
                this.updateUI(0, null);
                return;
            }
            this.totalsize = this.setTotalUploadCount(this.uploadList);
            this.batchId = this.getBatchId(this.activityHistory);
            BackupPolicyTO backupPolicyTO = new BackupPolicyTO();
            backupPolicyTO.setCompressionEnabled(this.currentPolicy.isCompressionEnabled());
            backupPolicyTO.setPolicyGroupName("SYNC");
            backupPolicyTO.setChunkSize(this.currentPolicy.getChunkSize());
            backupPolicyTO.setPftSize(this.currentPolicy.getPftSize());
            backupPolicyTO.setPftEnabled(this.currentPolicy.getPftEnabled());
            CleanupInterface<FileTO> cleanupInterface = new CleanupInterface<FileTO>(){

                @Override
                public void runCleanup(FileTO fileToUpload, int status) {
                    Logger loger = LoggerFactory.getLogger(CleanupInterface.class);
                    if (status == 200) {
                        loger.debug("uploadTable URL" + MultiThreadSyncUploadJob.this.uploadTableURL);
                        MultiThreadSyncUploadJob.this.removeFromUploadTable(fileToUpload, MultiThreadSyncUploadJob.this.uploadTableURL);
                    } else {
                        loger.debug("status is not ok:" + status);
                        MultiThreadSyncUploadJob.this.removeFromCurrentImageTable(fileToUpload);
                        SettingHelper.setErrorOccuredDuringSync(true);
                    }
                }

                @Override
                public void updateUIWrapper(FileTO backupTO, int uploadCount, long totalUplodSize) {
                    MultiThreadSyncUploadJob.this.updateUI(uploadCount, backupTO.getFileName());
                }

                @Override
                public void updateTooltipNotification(int failCode) {
                }

                @Override
                public void updateRestartId(long restartId) {
                }

                @Override
                public void updateTotalUploadSize() {
                }

                @Override
                public void updateErrorCode(int failCode) {
                }

                @Override
                public void updateBackupCrawlTable(List<FileTO> backupTO) {
                }

                @Override
                public void updateChunkFileDetail(FileTO backupTO, int uploadedChunkCount) {
                }
            };
            float networkThrottlrLimit = this.currentPolicy.getNetworkThrottleSpeed();
            if (networkThrottlrLimit <= 0.0f) {
                rateLimiter = RateLimiter.create((double)12800.0);
                this.logger.error("rate must be positive");
            } else {
                rateLimiter = RateLimiter.create((double)((double)(networkThrottlrLimit * 1024.0f) / 32.0));
                this.logger.debug("number of permits->" + (double)(networkThrottlrLimit * 1024.0f) / 32.0);
            }
            this.delegateThread = new Thread(new DelegateRunnable(this.chunkFileQueue, this.multiPartUploadService, this.uploadGatewayTO, backupPolicyTO, this.uploadCount, this.batchId, this.finishedBatchesQueue, this.noOfBatches, this.loopFinished, cleanupInterface, this.requestURL, rateLimiter, this.chunkService, this.intrupted, false, this.totalUplodSize, ""));
            this.delegateThread.start();
            this.chunkDelegateThread = new Thread(new ChunkRunnable(this.chunkedFiles, this.fileSizeBlockingQueue, this.chunkFileQueue, this.loopFinished, this.intrupted));
            this.chunkDelegateThread.start();
            this.restartDelegateThread = new Thread(new RestartRunnable(this.noOfBatches, this.finishedBatchesQueue, this.uploadGatewayTO, this.batchId, backupPolicyTO, this.delegateThread, this.chunkDelegateThread, this.intrupted));
            this.restartDelegateThread.start();
            this.startBackupWatchDog();
            for (FileTO tempUploadFileTO : this.uploadList) {
                if (tempUploadFileTO.getFileName().startsWith(DOT_PBS)) {
                    this.removeFromUploadTable(tempUploadFileTO, this.uploadTableURL);
                    String absoluteFilePath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getFileName();
                    this.logger.debug("Absolute File path>>>" + absoluteFilePath);
                    this.deleteTempFile(absoluteFilePath, false);
                    continue;
                }
                this.logger.debug("Current thread name for Sync>>>>>>>>" + Thread.currentThread().getName());
                if (Thread.currentThread().isInterrupted() || this.intrupted.get()) {
                    this.logger.debug("Backup upload thread interupted>>>>>>>");
                    this.delegateThread.interrupt();
                    this.chunkDelegateThread.interrupt();
                    break;
                }
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.debug("Time before uploading file :" + timeBeforeUpload);
                if (this.isTerminated) {
                    this.logger.debug("Terminated");
                    break;
                }
                File file = new File(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + tempUploadFileTO.getFileName());
                if (file.exists()) {
                    tempUploadFileTO.setFileSize(file.length());
                }
                this.logger.debug("File to be uploaded :" + tempUploadFileTO.getFileName() + "  fileSize: " + tempUploadFileTO.getFileSize());
                if (!this.isFileChunkable(tempUploadFileTO.getFileSize())) {
                    if (!tempUploadFileTO.isFolder()) {
                        this.putInSizeQueue(tempUploadFileTO);
                    } else {
                        this.uploadFile(tempUploadFileTO);
                    }
                } else {
                    this.uploadFileAsChunks(tempUploadFileTO);
                }
                this.logger.debug("Total time taken to upload : " + (System.currentTimeMillis() - timeBeforeUpload));
            }
            this.updateUI(this.uploadCount.get(), null);
            this.uploadList = null;
        }
        catch (BaseException e) {
            this.logger.error("BaseException" + (Object)((Object)e));
        }
        catch (InterruptedException e) {
            this.logger.error("Interrupted probably cause of disconnection of account");
        }
        catch (Exception e) {
            this.logger.error("Exception Occurred" + e.getMessage());
            this.logger.trace("" + e);
        }
        try {
            this.loopFinished.set(true);
            this.logger.debug("LOOP FINISHED newww");
            this.delegateThread.join();
            this.chunkDelegateThread.join();
            this.restartDelegateThread.join();
            this.logger.debug("Before setting all threads stop to true");
            this.allThreadsStopped.set(true);
            this.syncWatchDogTimer.cancel();
            return;
        }
        catch (InterruptedException e) {
            this.logger.debug("Before interrupting thread..");
            this.allThreadsStopped.set(true);
            this.interuptAllThreadAndShutdownServices(this.delegateThread, this.chunkDelegateThread, this.restartDelegateThread);
            this.syncWatchDogTimer.cancel();
            return;
        }
    }

    private void shutDownAllServices(Thread delegateThread, Thread chunkDelegateThread, Thread restartDelegateThread) {
        try {
            this.chunkService.shutdown();
            this.chunkService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            this.loopFinished.set(true);
            this.logger.debug("Loop finished for sync");
            delegateThread.join();
            chunkDelegateThread.join();
            restartDelegateThread.join();
        }
        catch (InterruptedException e) {
            this.logger.debug(" delegate Thread and chunk INTERUPTED");
            delegateThread.interrupt();
            chunkDelegateThread.interrupt();
            this.multiPartUploadService.shutdownNow();
            this.shutDownMultiPartUploadService();
        }
    }

    private void shutDownMultiPartUploadService() {
        try {
            this.multiPartUploadService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Interrupted thread", (Throwable)e1);
        }
    }

    private void interuptAllThreadAndShutdownServices(Thread delegateThread, Thread chunkDelegateThread, Thread restartDelegateThread) {
        this.printlogs("Delegate Thread and chunk been NUDGED");
        if (delegateThread.isAlive() && !delegateThread.isInterrupted()) {
            delegateThread.interrupt();
        }
        if (chunkDelegateThread.isAlive() && !chunkDelegateThread.isInterrupted()) {
            chunkDelegateThread.interrupt();
        }
        if (restartDelegateThread.isAlive() && !restartDelegateThread.isInterrupted()) {
            restartDelegateThread.interrupt();
        }
        if (chunkDelegateThread.isAlive()) {
            chunkDelegateThread.stop();
        }
        if (restartDelegateThread.isAlive()) {
            restartDelegateThread.stop();
        }
        if (delegateThread.isAlive()) {
            delegateThread.stop();
        }
        if (this.chunkService != null && !this.chunkService.isShutdown()) {
            this.chunkService.shutdownNow();
        }
        if (this.multiPartUploadService != null && !this.multiPartUploadService.isShutdown()) {
            this.multiPartUploadService.shutdownNow();
        }
        boolean isTerminated1 = true;
        try {
            if (this.multiPartUploadService != null) {
                isTerminated1 = this.multiPartUploadService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            if (this.chunkService != null) {
                this.chunkService.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            this.printlogs("Nudged thread is TERMINATE : " + isTerminated1);
        }
        catch (InterruptedException e1) {
            this.logger.error("Nudged thread is TERMINATED : " + isTerminated1, (Object)e1.getMessage());
        }
        this.syncWatchDogTimer.cancel();
    }

    private String getBatchId(ActivityHistoryImpl activityHistory2) {
        String currentBatchId = "";
        ActivityTO activityTO = activityHistory2.getCurrentStatusFromActivityHistoryTable();
        if (activityTO != null) {
            currentBatchId = activityTO.getBatchId();
        }
        return currentBatchId;
    }

    private void putInSizeQueue(FileTO fileTO) {
        String uploadFilePath = this.copyFileToTempFile(fileTO);
        BackupTO tempUploadFileTO = new BackupTO();
        this.copyPropertiesFromFileTOtoBackupTo(fileTO, tempUploadFileTO);
        tempUploadFileTO.setClientData(uploadFilePath);
        try {
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e1) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted.set(true);
        }
        catch (Exception e) {
            this.logger.debug("Thread is interupted here so set boolean ingterupt to true>>>>>>");
            this.intrupted.set(true);
        }
    }

    private void copyPropertiesFromFileTOtoBackupTo(FileTO fileTO, BackupTO tempUploadFileTO) {
        tempUploadFileTO.setFileName(fileTO.getFileName());
        tempUploadFileTO.setFileSize(fileTO.getFileSize());
        tempUploadFileTO.setAbstractFilePath(fileTO.getAbstractFilePath());
        tempUploadFileTO.setExists(fileTO.isExists());
        tempUploadFileTO.setMd5checksum(fileTO.getMd5checksum());
        tempUploadFileTO.setFolder(fileTO.isFolder());
        tempUploadFileTO.setLastModifiedTimestamp(fileTO.getLastModifiedTimestamp());
    }

    private boolean readFromUploadTable() {
        try {
            UploadTableImpl upload = new UploadTableImpl(this.uploadTableURL);
            this.uploadList.addAll(upload.selectSortedListFromTable());
            if (!this.uploadList.isEmpty()) {
                return true;
            }
            this.logger.debug("Upload List is empty");
            return false;
        }
        catch (DatabaseException e) {
            this.logger.error("DatabaseException: " + (Object)((Object)e));
            return false;
        }
    }

    private boolean uploadFile(FileTO fileToUpload) {
        this.checkChunkFolderExistsAndDelete(fileToUpload);
        String absPath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug(absPath);
        if (!this.handleFileExist(absPath)) {
            this.logger.debug("File not found");
            this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
            return false;
        }
        long asda1 = System.currentTimeMillis();
        if (this.handleHttpRequests(fileToUpload)) {
            long asda = System.currentTimeMillis();
            this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
            this.logger.debug("DB time: " + (System.currentTimeMillis() - asda));
        } else {
            this.removeFromCurrentImageTable(fileToUpload);
            SettingHelper.setErrorOccuredDuringSync(true);
            this.logger.debug("Error occured during sync");
        }
        this.logger.debug("Total upload and db time: " + (System.currentTimeMillis() - asda1));
        return true;
    }

    private void removeFromCurrentImageTable(FileTO fileToUpload) {
        ImageTableImpl imageTableHandler = new ImageTableImpl(SettingHelper.getBaseDBUrl() + StringLiterals.CONSTANTS_FILE_SEPARATOR + this.currentImageTableName, SettingHelper.getBaseDBUrl());
        imageTableHandler.removeFilTOFromTable(fileToUpload, this.currentImageTableName);
    }

    public boolean updateUI(int count, String fileName) {
        NotificationHelper.setTotalUploadCount(count);
        NotificationHelper.setUploadCount(String.valueOf(count) + "/" + this.totalsize);
        if (fileName != null) {
            NotificationHelper.setFileBeingUploaded(fileName);
        }
        return false;
    }

    private boolean handleFileExist(String absPath) {
        File file = new File(absPath);
        return file.exists();
    }

    private boolean handleFileModified(String absPath, long lastModifiedTimestamp) {
        File file = new File(absPath);
        if (file.isDirectory()) {
            return true;
        }
        return file.lastModified() <= lastModifiedTimestamp;
    }

    private boolean isMD5Equal(String filePath, String md5checksum) {
        File fileToCheckMD5 = new File(filePath);
        if (fileToCheckMD5.isDirectory()) {
            return true;
        }
        return md5checksum.equals(MD5Generator.generateMD5OfFile((File)fileToCheckMD5));
    }

    private boolean handleHttpRequests(FileTO fileToUpload) {
        int response = 0;
        int retrycount = 0;
        boolean copyUploadFile = false;
        boolean gaeLocal = false;
        boolean gaePublic = true;
        String currentUploadIPToUse = this.uploadIP;
        this.logger.debug("Trying to upload file:" + fileToUpload.getFileName());
        String originalFileName = fileToUpload.getFileName();
        String uploadFilePath = null;
        StringBuilder conflictedFileName = new StringBuilder();
        try {
            if (this.checkIfFileIsEditable(fileToUpload.getFileName(), fileToUpload.isFolder())) {
                copyUploadFile = true;
                String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + TMP_UPLOAD_NAME;
                File file = new File(path);
                uploadFilePath = this.copyFileToTempFolder(fileToUpload, file);
            } else {
                uploadFilePath = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception while copying file to tempFolder" + e);
        }
        if (uploadFilePath == null) {
            return false;
        }
        while (true) {
            boolean retry = false;
            try {
                this.logger.trace("Uploading file from temp folder");
                long timeBeforeUpload = System.currentTimeMillis();
                this.logger.trace("time before upload==" + timeBeforeUpload);
                if (fileToUpload.isFolder()) {
                    response = this.uploadAdapter.uploadFile(fileToUpload, currentUploadIPToUse, this.port, uploadFilePath, conflictedFileName, this.token);
                }
                this.logger.trace("Time after upload==" + (System.currentTimeMillis() - timeBeforeUpload));
                this.logger.trace("Response after trying to upload:" + response);
                this.logger.trace(" Time for function  hannle http Requests ");
                if (response != 3 && response != 4) {
                    if (response == 1005) {
                        SettingHelper.setLicenseActive(false);
                        this.isTerminated = true;
                    } else if (response == 1006) {
                        this.updateSystrayToolTipNotification("Cloud disk space full", " Your cloud has reached its maximum storage limit.");
                        NotificationHelper.cloudSpaceExceeded = true;
                        this.isTerminated = true;
                    } else if (response == 1009) {
                        SettingHelper.setDeviceBlocked(true);
                        this.isTerminated = true;
                    } else if (response == 1010) {
                        this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
                    } else if (response == 1008) {
                        this.isTerminated = true;
                    } else if (response == 1007) {
                        this.updateSystrayToolTipNotification("Upload failed  ", " The file " + fileToUpload.getFileName() + " could not be uploaded due to space restrictions.");
                    }
                    this.deleteTempFile(uploadFilePath, copyUploadFile);
                    return false;
                }
                if (response == 4) {
                    this.handleConflictDuringUpload(fileToUpload.getAbstractFilePath(), conflictedFileName, originalFileName);
                }
                NotificationHelper.cloudSpaceExceeded = false;
                this.deleteTempFile(uploadFilePath, copyUploadFile);
                this.logger.debug("Time Before Upload: " + (System.currentTimeMillis() - timeBeforeUpload));
                if (!currentUploadIPToUse.equals(this.uploadIP)) {
                    this.uploadIP = currentUploadIPToUse;
                }
                return true;
            }
            catch (CrawlAdapterException e) {
                this.logger.trace("" + (Object)((Object)e));
                this.logger.error("Exception occurred  CrawlAdapterException: " + e.getMessage());
                try {
                    retry = true;
                    ++retrycount;
                    Thread.sleep(60000L);
                    int responseForPing = this.uploadAdapter.pingGatewayIP(currentUploadIPToUse);
                    if (responseForPing != 200) {
                        GatewayTO gatewayTO = PolicyManagementServerHelper.getPrivacyGatewayIP("ALL", "SYNC");
                        this.logger.debug("the PG Gateway IP in catch" + gatewayTO.getGatewayName());
                    }
                }
                catch (InterruptedException ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("Exception in upload file via gateway" + ex.getMessage());
                }
                catch (Exception ex) {
                    this.logger.trace("" + ex);
                    this.logger.error("exception" + ex.getMessage());
                }
                currentUploadIPToUse = this.updateIpToUse(0, 1, currentUploadIPToUse);
                if (currentUploadIPToUse != null) continue;
                return false;
                if (retry && retrycount < 2) continue;
                return false;
            }
            break;
        }
    }

    private String copyFileToTempFile(FileTO fileToUpload) {
        String uploadFilePath = null;
        try {
            if (this.checkIfFileIsEditable(fileToUpload.getFileName(), fileToUpload.isFolder())) {
                String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + this.fileSystemUtils.convertStringTOBase64(fileToUpload.getFileName());
                File file = new File(path);
                uploadFilePath = this.copyFileToTempFolder(fileToUpload, file);
            } else {
                uploadFilePath = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception while copying file to tempFolder" + e);
        }
        return uploadFilePath;
    }

    private boolean checkIfFileIsEditable(String fileName, boolean isFolder) {
        if (isFolder) {
            return false;
        }
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        if (tokens.length != 2) {
            return false;
        }
        return false;
    }

    private void deleteTempFile(String tempraryFilePath, boolean copyUploadFile) {
        if (!copyUploadFile) {
            return;
        }
        File newFile = new File(tempraryFilePath);
        if (newFile.exists()) {
            newFile.delete();
        }
    }

    private String updateIpToUse(int gaeLocal, int gaePublic, String currentUploadIPToUse) {
        String[] ipToUse = new String[3];
        String[] ports = new String[2];
        String currentUploadIPToBeUsed = currentUploadIPToUse;
        boolean isIpFound = NetworkHelper.updateGaeIpFromServer((String)this.cloudName, (String)SettingHelper.getKeystorePath(), (String[])ipToUse, (String[])ports);
        if (!isIpFound) {
            if (!PropertyHelper.MAIN_EBMS_DOMAIN.isEmpty()) {
                BluVaultIPHelper bluVaultIPHelper = new BluVaultIPHelper();
                String bluVaultIP = bluVaultIPHelper.getNearestBluVaultByResponseTime();
                if (!StringUtils.isEmpty((String)bluVaultIP)) {
                    SettingHelper.setGaeLocalIpAddress(bluVaultIP);
                    SettingHelper.setPublicIpAddress(bluVaultIP);
                    SettingHelper.setCurrentCloudIpAddress(bluVaultIP);
                    ProxyElement.setIp((String)bluVaultIP);
                }
                currentUploadIPToBeUsed = SettingHelper.getCurrentCloudIpAddress();
            }
            return currentUploadIPToBeUsed;
        }
        if (ipToUse[0] == null && ports[0] == null) {
            return null;
        }
        if (ipToUse[gaeLocal] != null && !ipToUse[gaeLocal].equals(currentUploadIPToBeUsed)) {
            currentUploadIPToBeUsed = ipToUse[gaeLocal];
        } else if (ipToUse[gaeLocal] != null) {
            currentUploadIPToBeUsed = ipToUse[gaePublic];
        }
        return currentUploadIPToBeUsed;
    }

    private void handleConflictDuringUpload(String filePath, StringBuilder conflictedFileName, String oldUploadedFileName) {
        File oldUploadedFile = new File(this.fullDevicePath + StringLiterals.FILE_SEPARATOR + filePath + StringLiterals.FILE_SEPARATOR + oldUploadedFileName);
        File renamedUploadedFile = new File(this.fullDevicePath + StringLiterals.FILE_SEPARATOR + filePath + StringLiterals.FILE_SEPARATOR + conflictedFileName.toString());
        oldUploadedFile.renameTo(renamedUploadedFile);
        ImageTableImpl imtble = new ImageTableImpl(this.currentImageTablePath, this.basePathForImageTables);
        ArrayList<RenamedTO> listOfRenamedFiles = new ArrayList<RenamedTO>();
        RenamedTO rn = new RenamedTO();
        rn.setAbstractFilePath(filePath);
        rn.setOldFileName(oldUploadedFileName);
        rn.setNewfileName(conflictedFileName.toString());
        listOfRenamedFiles.add(rn);
        imtble.updateTable(listOfRenamedFiles, this.currentImageTableName);
    }

    private String copyFileToTempFolder(FileTO fileToUpload, File tempUploadFile) throws IOException {
        String path = this.fullDevicePath + StringLiterals.FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug("The temprary upload folder for this file is: " + tempUploadFile);
        File makeTempFolder = new File(tempUploadFile.getParent());
        if (!makeTempFolder.exists()) {
            boolean success = makeTempFolder.mkdirs();
            this.logger.debug("Trying to make temp folder structure (did it succeed?)-> :" + success);
        }
        if (fileToUpload.isFolder()) {
            this.logger.debug("Whether uploaded file is folder -> " + fileToUpload.isFolder());
            return tempUploadFile.getAbsolutePath();
        }
        File actualFile = new File(path);
        if (tempUploadFile.exists()) {
            tempUploadFile.delete();
        }
        FileUtils.copyFile((File)actualFile, (File)tempUploadFile);
        tempUploadFile.deleteOnExit();
        return tempUploadFile.getAbsolutePath();
    }

    private boolean uploadFileAsChunks(FileTO fileToUpload) {
        String absPath = this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath() + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getFileName();
        this.logger.debug(absPath);
        if (!this.handleFileExist(absPath)) {
            this.logger.debug("File not found");
            this.removeFromUploadTable(fileToUpload, this.uploadTableURL);
            return false;
        }
        this.handleHttpRequestsForUploadChunks(fileToUpload);
        return true;
    }

    private boolean removeFromUploadTable(FileTO fileToRemove, String uploadTableURL) {
        boolean success = false;
        UploadTableImpl upload = new UploadTableImpl(uploadTableURL);
        upload.removeFromTable(fileToRemove);
        return success;
    }

    public void abortUploadProcesses() {
        if (this.uploadAdapter != null) {
            this.uploadAdapter.cancelHttpPut();
        }
    }

    private boolean handleHttpRequestsForUploadChunks(FileTO fileToUpload) {
        String sourcePath = SettingHelper.getParabluSyncFolder() + File.separator + fileToUpload.getAbstractFilePath() + File.separator + fileToUpload.getFileName();
        this.logger.debug("FilePath " + sourcePath);
        File file = null;
        try {
            file = new File(sourcePath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
        }
        BackupTO tempUploadFileTO = new BackupTO();
        if (file != null) {
            this.copyPropertiesFromFileTOtoBackupTo(fileToUpload, tempUploadFileTO);
            this.createDummyChunkFileList(tempUploadFileTO, file);
            this.logger.debug("dummy chunkList created");
        }
        this.logger.debug("Queue size: " + this.fileSizeBlockingQueue.size() + " upload filesize: " + fileToUpload.getFileSize());
        try {
            String uploadFilePath = this.copyFileToTempFile(fileToUpload);
            tempUploadFileTO.setClientData(uploadFilePath);
            this.putInFileSizeBlockingQueuenew(tempUploadFileTO);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted Exception" + e.getMessage());
        }
        this.chunkedFiles.incrementAndGet();
        return true;
    }

    private String createPreRequisiteForChunk(FileTO fileToUpload) {
        String chunkPath;
        String osType = System.getProperty("os.name");
        String hash32Value = this.fileSystemUtils.convertStringTOBase64(fileToUpload.getFileName());
        if (osType.toLowerCase().contains("win")) {
            chunkPath = new StringBuffer().append(this.fullDevicePath + File.separator + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("pbchnkz").append(hash32Value).toString();
            this.createChunkFolderAndHideIt(chunkPath);
        } else {
            chunkPath = new StringBuffer().append(this.fullDevicePath + File.separator + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".pbchnkz").append(hash32Value).toString();
            this.createChunkFolder(chunkPath);
        }
        return chunkPath;
    }

    private void createChunkFolderAndHideIt(String chunkPath) {
        try {
            Process proc;
            int exitVal;
            Runtime rt = Runtime.getRuntime();
            boolean success = this.createFolder(chunkPath);
            if (success && (exitVal = (proc = rt.exec("attrib +h " + chunkPath)).waitFor()) != 0) {
                Process proc1 = rt.exec("attrib +h " + chunkPath);
                proc1.waitFor();
            }
        }
        catch (Exception t) {
            this.logger.trace("" + t);
            this.logger.error("Make Hidden Folder exception" + t.getMessage());
        }
    }

    private void createChunkFolder(String chunkPath) {
        try {
            this.createFolder(chunkPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Error in create chunk folder" + e.getMessage());
        }
    }

    private boolean createFolder(String filename) {
        boolean success = true;
        File file = new File(filename);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Error in create folder" + e.getMessage());
            }
        }
        if (!file.exists()) {
            success = file.mkdirs();
        }
        return success;
    }

    public void splitAndWrite(String sourceFilePath, String destinationPath) throws IOException, NoSuchAlgorithmException {
        this.logger.debug(" chunck src : " + sourceFilePath);
        this.logger.debug("chunck dest : " + destinationPath);
        this.fileSystemUtils.splitAndWrite(sourceFilePath, destinationPath, this.currentPolicy.getChunkSize(), this.currentPolicy.isCompressionEnabled());
    }

    void write(byte[] dataByteArray, String destinationFileName) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));
        ((OutputStream)output).write(dataByteArray);
        ((OutputStream)output).close();
    }

    private void deleteChunkFolder(File file) {
        if (file.isDirectory() && file.list().length == 0) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Chunk folder deletion Failed" + e.getMessage());
            }
            this.logger.debug("chunk folder deleted successfully");
        }
    }

    private void checkChunkFolderExistsAndDelete(FileTO fileToUpload) {
        if (SettingHelper.getOsName().toLowerCase().contains("win")) {
            String chunkPath = new StringBuffer().append(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append("CHUNK").toString();
            File file = new File(chunkPath);
            if (file.exists()) {
                this.deleteChunkFolder(file);
            }
        } else {
            String chunkPath = new StringBuffer().append(this.fullDevicePath + StringLiterals.CONSTANTS_FILE_SEPARATOR + fileToUpload.getAbstractFilePath()).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(".CHUNK").toString();
            File file = new File(chunkPath);
            if (file.exists()) {
                this.deleteChunkFolder(file);
            }
        }
    }

    private void loadCurrentSyncPolicy() {
        SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());
        List<SyncPolicyTo> syncPolicyTos = syncPolicyDAOImpl.getSyncPolicyDetails();
        SyncPolicyTo currentDetails = null;
        if (syncPolicyTos != null && !syncPolicyTos.isEmpty()) {
            currentDetails = syncPolicyTos.get(0);
        }
        if (currentDetails != null) {
            this.currentPolicy = currentDetails;
            this.logger.debug("CHUNK SIZE TO KEEP " + this.currentPolicy.getChunkSize());
            this.logger.debug("COMPRESSION ENABLED " + this.currentPolicy.isCompressionEnabled());
            SettingHelper.setMaxVersionsToKeep(this.currentPolicy.getMaxVersions());
            if (this.currentPolicy.getChunkSize() == 0) {
                this.currentPolicy.setChunkSize(4);
            }
        }
    }

    private boolean isFileChunkable(long fileSizeinBytes) {
        boolean isChunkable = false;
        this.pftSize = this.currentPolicy.getPftSize();
        int chunkableSizeFromPolicy = this.getChunkableSize();
        float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
        if ("true".equals(this.currentPolicy.getPftEnabled()) && fileSizeinMb >= (float)this.pftSize && fileSizeinMb > (float)chunkableSizeFromPolicy) {
            isChunkable = true;
        }
        return isChunkable;
    }

    private int getChunkableSize() {
        int chunkableSizeFromPolicy = 4;
        if (this.currentPolicy != null) {
            chunkableSizeFromPolicy = this.currentPolicy.getChunkSize();
        }
        return chunkableSizeFromPolicy;
    }

    private void createDummyChunkFileList(BackupTO tempUploadFileTO, File file) {
        this.logger.debug("Inside creating dummy chunk File List");
        ArrayList<ChunkFileTO> chunkFileTOs = new ArrayList<ChunkFileTO>();
        ChunkFileTO chunkFileTO = new ChunkFileTO();
        chunkFileTO.setFileName(file.getName());
        chunkFileTO.setFilePath(tempUploadFileTO.getClientData());
        chunkFileTO.setMd5Checksum(null);
        chunkFileTO.setChunkFileNames(null);
        chunkFileTOs.add(chunkFileTO);
        tempUploadFileTO.setChunkFileList(chunkFileTOs);
    }

    private void putInFileSizeBlockingQueuenew(BackupTO tempUploadFileTO) {
        try {
            this.chunkFileQueue.put(tempUploadFileTO);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.trace("" + e);
            this.logger.error("error while adding file to filesize block queue" + e.getMessage());
        }
    }

    private int setTotalUploadCount(List<FileTO> totalUploadCount) {
        this.logger.debug("calculating the total upload count$$$$$$$$$$$$$");
        List<Object> totalUploadCountWithoutFolders = new ArrayList();
        try {
            if (totalUploadCount == null || totalUploadCount.size() == 0) {
                return 0;
            }
            totalUploadCountWithoutFolders = totalUploadCount.stream().filter(p -> !p.isFolder()).collect(Collectors.toList());
            this.logger.debug("Total upload count.............$$" + totalUploadCountWithoutFolders.size());
        }
        catch (Exception e) {
            this.logger.error("Exception in filtering out the folder list...", (Throwable)e);
        }
        return totalUploadCountWithoutFolders.size();
    }

    public void printlogs(String log) {
        if (this.count == 0) {
            this.logger.debug(log);
        }
        if ((long)this.count >= 60000000L) {
            this.count = -1;
        }
        ++this.count;
    }

    public void startBackupWatchDog() {
        if (this.syncWatchDogTimer == null) {
            this.syncWatchDogTimer = new Timer();
        }
        if (this.syncWatchDogTimerTask == null) {
            this.syncWatchDogTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        int retryStopThreadsCount = 0;
                        if (MultiThreadSyncUploadJob.this.intrupted.get()) {
                            MultiThreadSyncUploadJob.this.logger.debug("###############Inside thread nudged watch dogg################");
                            MultiThreadSyncUploadJob.this.interuptAllThreadAndShutdownServices(MultiThreadSyncUploadJob.this.delegateThread, MultiThreadSyncUploadJob.this.chunkDelegateThread, MultiThreadSyncUploadJob.this.restartDelegateThread);
                            Thread.currentThread().interrupt();
                            while (!MultiThreadSyncUploadJob.this.allThreadsStopped.get()) {
                                MultiThreadSyncUploadJob.this.printlogs("All threads not stopped so wait and intruupt");
                                MultiThreadSyncUploadJob.this.interuptAllThreadAndShutdownServices(MultiThreadSyncUploadJob.this.delegateThread, MultiThreadSyncUploadJob.this.chunkDelegateThread, MultiThreadSyncUploadJob.this.restartDelegateThread);
                                if (++retryStopThreadsCount < 50) continue;
                                MultiThreadSyncUploadJob.this.allThreadsStopped.set(true);
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (Exception e) {
                        MultiThreadSyncUploadJob.this.logger.error("Error in Stop backup threads", (Throwable)e);
                        MultiThreadSyncUploadJob.this.allThreadsStopped.set(true);
                    }
                }
            };
            this.syncWatchDogTimer.schedule(this.syncWatchDogTimerTask, 1L, 1L);
        }
    }
}

