/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.runnables;

import com.google.common.util.concurrent.Futures;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.dao.RestoreDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.restore.MultipartRestoreCallable;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.to.RestoreActivityTO;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(RestoreRunnable.class);
    private ExecutorService multiPartRestoreService;
    private String gatewayIp;
    private AtomicInteger restoreCount;
    private AtomicLong restoredSize;
    private AtomicBoolean stopRestore;
    private RestoreElement restoreElement;
    private RestoreActivityTO activityTO;
    private MultipartRestoreCallable multipartRestoreCallable;
    private BlockingQueue<Future<Integer>> finishedBatchesQueue;
    private AtomicInteger noOfBatches;

    public RestoreRunnable(ExecutorService multiPartRestoreService, String gatewayIP, AtomicInteger restoreCount, AtomicLong restoredSize, AtomicBoolean stopRestore, RestoreElement restoreElement, RestoreActivityTO activityTO, BlockingQueue<Future<Integer>> finishedBatchesQueue, AtomicInteger noOfBatches) {
        this.multiPartRestoreService = multiPartRestoreService;
        this.gatewayIp = gatewayIP;
        this.restoreCount = restoreCount;
        this.restoredSize = restoredSize;
        this.stopRestore = stopRestore;
        this.restoreElement = restoreElement;
        this.activityTO = activityTO;
        this.finishedBatchesQueue = finishedBatchesQueue;
        this.noOfBatches = noOfBatches;
    }

    @Override
    public void run() {
        this.logger.debug("thread priority:" + Thread.currentThread().getPriority());
        int restoredFolderCount = 0;
        RestoreDAOImpl restoreDAOImpl = new RestoreDAOImpl(SettingHelper.getRestoreDbUrl());
        List<RestoreElement> fileListFromDb = restoreDAOImpl.getRestoreFilepath();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        block4: while (restoredFolderCount < fileListFromDb.size()) {
            this.logger.debug("restoredFolderCount:" + restoredFolderCount);
            try {
                for (RestoreElement element : fileListFromDb) {
                    if (this.stopRestore.get()) {
                        this.logger.debug("REstore called for stop....");
                        continue block4;
                    }
                    NotificationHelper.setRestoreStarted(true);
                    NotificationHelper.restoreFinished = false;
                    NotificationHelper.successfulRestore = 1;
                    element.setCloudName(this.restoreElement.getCloudName());
                    element.setDeleteRestoreEvent(this.restoreElement.isDeleteRestoreEvent());
                    element.setDeviceUUid(this.restoreElement.getDeviceUUid());
                    element.setFileBackupId(this.restoreElement.getFileBackupId());
                    element.setFileName(this.restoreElement.getFileName());
                    element.setFileUserOwner(this.restoreElement.getFileUserOwner());
                    element.setRestoreAllVersions(this.restoreElement.isRestoreAllVersions());
                    element.setRestoreBatchId(this.restoreElement.getRestoreBatchId());
                    element.setRestoredFolder(this.restoreElement.getRestoredFolder());
                    element.setRestoreInterrupted(this.restoreElement.isRestoreInterrupted());
                    element.setRestoreTillDate(this.restoreElement.getRestoreTillDate());
                    this.updateRestoreEvent(this.activityTO, restoreActivityHistoryDAOImpl);
                    this.logger.debug(this.multiPartRestoreService + " before calling restore:" + element.getSelectedDevicePath() + " restoreCount:" + this.restoreCount.get() + " restoredSize:" + this.restoredSize.get());
                    element.setDevicePath(element.getDevicePath().replace("\\", "/"));
                    this.multipartRestoreCallable = new MultipartRestoreCallable(element, this.stopRestore, this.gatewayIp, this.restoreCount, this.restoredSize, this.restoreElement, this.noOfBatches);
                    Future<Integer> response = this.multiPartRestoreService.submit(this.multipartRestoreCallable);
                    this.logger.debug("REstore element:" + element.getDevicePath());
                    this.finishedBatchesQueue.put(response);
                    this.logger.debug("response:" + response + " restoredFolder count:" + ++restoredFolderCount);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.finishedBatchesQueue.put((Future<Integer>)Futures.immediateFuture((Object)-1));
        }
        catch (InterruptedException e) {
            this.logger.trace("" + e);
            this.logger.error("Interrupted Exception" + e.getMessage());
        }
    }

    private void updateRestoreEvent(RestoreActivityTO restoreActivityTo, RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        restoreActivityTo.setTotalRestoreCount(this.restoreCount.get() + "");
        restoreActivityTo.setTotalRestoredSize(this.restoredSize.get());
        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
        this.logger.debug("Resore count:" + restoreActivityTo.getTotalRestoreCount() + "Resore size:" + restoreActivityTo.getTotalRestoredSize());
    }
}

