/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.api;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.element.LogFileInfoElement;
import com.parablu.epa.core.element.NewSupportElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportAdapter
extends BaseAdapter {
    private Logger logger = LoggerFactory.getLogger(SupportAdapter.class);
    private static final String SUPPORT_URL = "/support";
    private static final String HEADER_REQUEST_ID = "request-id";
    private static final String PARACLOUD_BASE_VERSION_NUMBER = "/versions/";
    private static final String PARACLOUD_BASE_CLOUD_NAME = "/clouds";
    private String versionNumber = "2.2";
    public static final String SUPPORT_LOG_SAVE_URL = "/logs/save";
    public static final String SUPPORT_LOG_FILE_URL = "/logs/file";
    private static final String SUPPORT_LOGS_URL = "/support/logs";
    private String requestID = null;

    public SupportAdapter(String keyStore) {
        super(keyStore);
    }

    public SupportAdapter(InputStream inputStream) {
        super(inputStream);
    }

    public boolean sendSupportMessage(String cloudName, NewSupportElement supportElement, String ip, String token, String deviceUUID, String eventList, String userName) {
        HttpPost httpPost;
        HttpResponse response = null;
        boolean logSent = false;
        try {
            URI uri = this.formHttpsUri(ip, "/support/versions/" + this.versionNumber + "/clouds/" + cloudName + SUPPORT_LOG_SAVE_URL);
            this.logger.debug("uri" + uri);
            httpPost = new HttpPost(uri);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("token", token);
            httpPost.setHeader("event", eventList);
            httpPost.setHeader("userName", userName);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("deviceUUID", deviceUUID);
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)supportElement.getId());
            obj.put((Object)"timeStamp", (Object)supportElement.getTimestamp());
            obj.put((Object)"userName", (Object)supportElement.getUserName());
            obj.put((Object)"deviceName", (Object)supportElement.getDeviceName());
            obj.put((Object)"cloudName", (Object)supportElement.getCloudName());
            JSONArray logFilesDetails = new JSONArray();
            List<LogFileInfoElement> fileInfoElementList = supportElement.getFileElementList().getLogFiles();
            for (LogFileInfoElement logFileInfoElement : fileInfoElementList) {
                JSONObject logFileDetail = new JSONObject();
                logFileDetail.put((Object)"filename", (Object)logFileInfoElement.getFilename());
                logFileDetail.put((Object)"size", (Object)logFileInfoElement.getSize());
                logFileDetail.put((Object)"lastModified", (Object)logFileInfoElement.getLastModified());
                logFilesDetails.add((Object)logFileDetail);
            }
            obj.put((Object)"logFiles", (Object)logFilesDetails);
            String jsonString = obj.toJSONString();
            if (jsonString == null) {
                this.logger.debug("jsonString is null");
                return false;
            }
            this.logger.debug("Support String>>>>" + jsonString);
            httpPost.setEntity((HttpEntity)new StringEntity(jsonString, "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.error("UnsupportedEncodingException in sendSupportMessage: ", (Throwable)e1);
            return false;
        }
        try {
            JSONParser parser;
            JSONObject jsonObject;
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            int responseStatusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("response Code= " + responseStatusCode);
            if (responseStatusCode == 200 && (jsonObject = (JSONObject)(parser = new JSONParser()).parse(EntityUtils.toString((HttpEntity)response.getEntity()))) != null && "SUCCESS".equalsIgnoreCase((String)jsonObject.get((Object)"status")) && jsonObject.get((Object)"data") != null) {
                this.requestID = (String)((JSONObject)jsonObject.get((Object)"data")).get((Object)"requestId");
                logSent = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in response: " + e);
        }
        if (response != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception sending support message :" + e.getMessage());
            }
        }
        return logSent;
    }

    public boolean sendSupportLogs(File logFile, String cloudName) {
        HttpResponse response = null;
        int responseStatusCode = 0;
        boolean logSent = false;
        try {
            URI uri = this.formHttpsUri("supportapi.parablu.com", "/support/logs/" + cloudName);
            HttpPost httpPost = new HttpPost(uri);
            if (this.requestID == null) {
                return false;
            }
            httpPost.setHeader(HEADER_REQUEST_ID, this.requestID);
            httpPost.setEntity((HttpEntity)new FileEntity(logFile, "binary/octet-stream"));
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            responseStatusCode = response.getStatusLine().getStatusCode();
            this.logger.debug(String.valueOf(responseStatusCode));
            if (responseStatusCode == 200) {
                logSent = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception " + e);
        }
        if (response != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception sending support logs :" + e.getMessage());
            }
        }
        return logSent;
    }

    public boolean sendSupportLogFile(File logFile, String cloudName, String userName, String ip, String token, String deviceUUID) {
        HttpResponse response = null;
        int responseStatusCode = 0;
        boolean logSent = false;
        try {
            JSONParser parser;
            JSONObject jsonObject;
            URI uri = this.formHttpsUri(ip, "/support/versions/" + this.versionNumber + "/clouds/" + cloudName + SUPPORT_LOG_FILE_URL);
            this.logger.debug("Calling for support logs. URI:" + uri);
            HttpPost httpPost = new HttpPost(uri + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "&deviceUUID=" + URLEncoder.encode(deviceUUID, "UTF-8"));
            httpPost.setHeader("token", token);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new FileEntity(logFile, "binary/octet-stream"));
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            responseStatusCode = response.getStatusLine().getStatusCode();
            this.logger.debug("responsestatus code" + responseStatusCode);
            if (responseStatusCode == 200 && (jsonObject = (JSONObject)(parser = new JSONParser()).parse(EntityUtils.toString((HttpEntity)response.getEntity()))) != null && "SUCCESS".equalsIgnoreCase((String)jsonObject.get((Object)"status"))) {
                String requestId = (String)((JSONObject)jsonObject.get((Object)"data")).get((Object)"requestId");
                this.logger.debug("request ID:" + requestId);
                logSent = true;
            }
        }
        catch (Exception e) {
            this.logger.error("Exception " + e);
        }
        if (response != null && response.getEntity().isStreaming()) {
            try {
                response.getEntity().getContent().close();
            }
            catch (IOException e) {
                this.logger.trace("" + e);
                this.logger.error("Exception sending new support logs :" + e.getMessage());
            }
        }
        return logSent;
    }

    public String getRequestID() {
        return this.requestID;
    }
}

