/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CertificateChoices;

public class CertificateSet
implements DEREncodable {
    private DERConstructedSet certificateChoices;

    public CertificateSet(Vector vector) {
        this.setCertificateChoices(vector);
    }

    public CertificateSet(DERConstructedSet dERConstructedSet) {
        this.certificateChoices = dERConstructedSet;
    }

    public CertificateSet(CertificateSet certificateSet) {
        this.certificateChoices = certificateSet.certificateChoices;
    }

    public static CertificateSet getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CertificateSet) {
            return (CertificateSet)object;
        }
        if (object instanceof DERConstructedSet) {
            return new CertificateSet((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return CertificateSet.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CertificateSet");
    }

    public static CertificateSet newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CertificateSet) {
            return new CertificateSet((CertificateSet)object);
        }
        if (object instanceof DERConstructedSet) {
            return new CertificateSet((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return CertificateSet.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CertificateSet");
    }

    public Vector getCertificateChoices() {
        int n = this.certificateChoices.getSize();
        Vector<CertificateChoices> vector = new Vector<CertificateChoices>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(CertificateChoices.getInstance(this.certificateChoices.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setCertificateChoices(Vector vector) {
        int n = vector.size();
        this.certificateChoices = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.certificateChoices.addObject(CertificateChoices.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.certificateChoices;
    }
}

