/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.BackupLifeCycle;
import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.RestoreActivityHistoryDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.FileElement;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.RestoreElement;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.ObjectUtils;
import com.parablu.epa.core.helper.RestoreHelper;
import com.parablu.epa.core.service.transformer.CreateXmlObject;
import com.parablu.epa.core.to.BackupOrRestoreStatusTo;
import com.parablu.epa.core.to.DeviceTo;
import com.parablu.epa.core.to.DisplayTo;
import com.parablu.epa.core.to.GatewayTO;
import com.parablu.epa.core.to.RestoreActivityTO;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.RestoreUI;
import com.parablu.epa.view.SearchDialog;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreBackupOld
extends Shell {
    private Logger logger = LoggerFactory.getLogger(RestoreBackupOld.class);
    private BackupAdapter backupAdapter = null;
    private DeviceTo selectedItem;
    private TimerTask restoreTimerTask = null;
    private Timer restoreTimer = null;
    private int lengthForFileName = 25;
    private List<DisplayTo> listDevices = null;
    Button restoreButton;
    private boolean restoreLoadingStatus = true;
    Label restoreStatus;
    Label currentFileBeingRestoredLabel;
    private FontsManager fontsManager;
    private Integer port;
    private Button closeButton;
    private DeviceTo selectedFolder;
    private DeviceTo previousSelectedFolder;
    private String folderPath;
    public String deviceuid;
    int restoreFolderorDevice = 0;
    private List<DisplayTo> listFolders = null;
    String fullPath = null;
    String previousFolderPath = null;
    public int count = 1;
    public int restoredCount = 0;
    public int totalnoOfFilesToBeRestored = 0;
    Label currentRestoreStatusLabel;
    private SearchDialog searchDialog;
    private static final String[] columnNames = new String[]{"Device", "Username"};
    Shell searchShell;
    Group restoreFolderGroup = null;
    Group restoreGroup = null;
    Group queryGroup = null;
    private Image imageBack = null;
    Label showPathLabel;
    Button backLabel = null;
    String uploadIpForGateway = null;
    Group restorePathGroup = null;
    private static String backImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "glyphicons_221_unshare.png";
    String batchId = "";
    private Image imageFolder = null;
    private Image imageFile = null;
    private Image imageWindows = null;
    private Image imageMac = null;
    private static String folderImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "folder_img.png";
    private static String fileImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "file_img.png";
    private static String winImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "win_img.png";
    private static String macImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "mac_img.png";
    private static String calImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "calender.png";
    private static String imageOdbLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "onedrive_icon.png";
    private static String shellImageLocation = MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE;
    private static String androidImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "android_img.jpg";
    private static String unknownImageLocation = MacSettingsHelper.baseResourceFolder + "resource" + File.separator + "img" + File.separator + "question_img.png";
    private static final String RESTORE_DEFAULT_STR = "Restore default Closing shell cause of error";
    private static final String SELECTED_FOLDER_LOG = "selected folder: ";
    private static final String STARTED = "STARTED";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    Button checkBox;
    Button checkBoxbtn;
    private boolean restoreAllVersionSelected = false;
    RestoreElement restoreElement = new RestoreElement();
    private Thread restoreThread = null;
    private boolean restoreInPlace = false;
    private static Button folderSelectButton;
    private static Text subtext;
    private static String oldfolder;
    private static Button helpButton;
    private static Button checkBoxbutton;
    private static Button InplacecheckBox;
    private static Button calender;
    private Image imageCalender = null;
    Button pointInplaceCheckBox;
    private static Button pointInTimeCheckBox;
    private static Button refresh;
    long restoreTilldate;
    private Date date = null;
    private static Shell dialog;
    private Image imageO365 = null;
    private Text labelForDate;
    private Image dialogeImage = null;
    private Image imageAndroid = null;
    private Image imageUnknown = null;
    private Stack<DisplayTo> listFoldersStack = new Stack();
    private Button PointInTimeCheckBoxBtn;
    private boolean PointInTimeRestoreSelected = false;
    private boolean dialogAlive = false;
    public String deviceOsType;
    String oldDeviceuid;
    TableItem[] tableItemsForRestore = null;
    Group multiSelectRestoreGroup = null;
    private Table multiSelectTable;
    private Button btnForAdd;
    private Button btnForRemove;
    private boolean isDeviceSelectedForRestore = false;
    private boolean isFolderFileSelectedForRestore = false;
    List<String> listofAddedFolder;
    DeviceTo deviceto;
    private int selectedIndex;

    public RestoreBackupOld(Shell shell) throws Exception {
        super(shell, 65760);
        this.searchShell = this.getShell();
        this.setLocation(shell.getLocation());
        this.disableEscapeKey();
    }

    public RestoreBackupOld(Shell parent, int style) {
        super(parent, style);
        this.setLocation(parent.getLocation());
        this.disableEscapeKey();
    }

    private void disableEscapeKey() {
        Listener listener = e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        };
        this.getShell().addListener(31, listener);
    }

    public boolean openShell() throws InvalidKeyException, GeneralSecurityException, IOException {
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        NotificationHelper.successfulRestore = 3;
        boolean result = false;
        Shell parent = this.getShell();
        final Shell shell = this.getShell();
        shell.setText(this.getText());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.marginTop = 10;
        shell.setLayout((Layout)gridLayout);
        shell.setLocation(parent.getLocation());
        this.imageBack = new Image((Device)shell.getDisplay(), new ImageData(backImageLocation).scaledTo(16, 12));
        this.imageFolder = new Image((Device)shell.getDisplay(), new ImageData(folderImageLocation).scaledTo(10, 10));
        this.imageFile = new Image((Device)shell.getDisplay(), new ImageData(fileImageLocation).scaledTo(10, 10));
        this.imageWindows = new Image((Device)shell.getDisplay(), new ImageData(winImageLocation).scaledTo(15, 15));
        this.imageMac = new Image((Device)shell.getDisplay(), new ImageData(macImageLocation).scaledTo(15, 15));
        this.imageCalender = new Image((Device)shell.getDisplay(), new ImageData(calImageLocation).scaledTo(15, 15));
        this.imageO365 = new Image((Device)shell.getDisplay(), new ImageData(imageOdbLocation).scaledTo(15, 15));
        this.dialogeImage = new Image((Device)shell.getDisplay(), new ImageData(shellImageLocation).scaledTo(15, 15));
        this.imageAndroid = new Image((Device)shell.getDisplay(), new ImageData(androidImageLocation).scaledTo(15, 15));
        this.imageUnknown = new Image((Device)shell.getDisplay(), new ImageData(unknownImageLocation).scaledTo(15, 15));
        this.fontsManager = new FontsManager(this.getParent().getDisplay());
        Composite composite = new Composite((Composite)shell, 0x1000000);
        GridLayout compositeGridLayout = new GridLayout();
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.numColumns = 2;
        compositeGridLayout.verticalSpacing = 3;
        compositeGridLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)compositeGridLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.restoreGroup = new Group(composite, 0x1000000);
        GridLayout groupGridLayout = new GridLayout();
        groupGridLayout.numColumns = 2;
        groupGridLayout.makeColumnsEqualWidth = false;
        this.restoreGroup.setLayout((Layout)groupGridLayout);
        GridData contactGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        this.restoreGroup.setLayoutData((Object)contactGroupGridData);
        this.restoreGroup.setText("Select the device to restore");
        this.restoreGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table table = new Table((Composite)this.restoreGroup, 68356);
        table.setLayoutData((Object)contactGroupGridData);
        table.setHeaderVisible(true);
        TableColumn deviceColumn = new TableColumn(table, 16);
        deviceColumn.setText("Device");
        deviceColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                table.removeAll();
                int sortDirection = table.getSortDirection();
                RestoreBackupOld.this.logger.debug("SORT Direction : " + sortDirection);
                if (1024 == sortDirection || 0 == sortDirection) {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listDevices, "Device", true);
                    table.setSortDirection(128);
                    RestoreBackupOld.this.logger.debug("UP SORT");
                } else {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listDevices, "Device", false);
                    table.setSortDirection(1024);
                    RestoreBackupOld.this.logger.debug("DOWN SORT");
                }
                RestoreBackupOld.this.addDevicesToTable(RestoreBackupOld.this.listDevices, table);
                table.setSortColumn(column);
            }
        });
        TableColumn deviceUserColumn = new TableColumn(table, 16);
        deviceUserColumn.setText("Username");
        deviceUserColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                table.removeAll();
                if (1024 == table.getSortDirection() || 0 == table.getSortDirection()) {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listDevices, "Username", true);
                    table.setSortDirection(128);
                } else {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listDevices, "Username", false);
                    table.setSortDirection(1024);
                }
                RestoreBackupOld.this.addDevicesToTable(RestoreBackupOld.this.listDevices, table);
                table.setSortColumn(column);
            }
        });
        Label showHelpLabel = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel.setLayoutData((Object)contactGroupGridData);
        showHelpLabel.setText("Click a device to select all data on the device for restoration");
        showHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        Label showHelpLabel1 = new Label((Composite)this.restoreGroup, 0);
        showHelpLabel1.setLayoutData((Object)contactGroupGridData);
        showHelpLabel1.setText("Double click a device to drill down and select a specific folder or a file in it.");
        showHelpLabel1.setFont(this.fontsManager.getSmallNormalFont());
        Button button = new Button((Composite)this.restoreGroup, 8);
        button.setText("Search");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackupOld.this.searchDialog.setMatchCase(false);
                RestoreBackupOld.this.searchDialog.setMatchWord(false);
                RestoreBackupOld.this.searchDialog.setSearchDown(true);
                RestoreBackupOld.this.searchDialog.setSearchString("");
                RestoreBackupOld.this.searchDialog.setSelectedSearchArea(0);
                RestoreBackupOld.this.searchDialog.open();
            }
        });
        this.searchDialog = new SearchDialog(shell);
        this.searchDialog.setSearchAreaNames(columnNames);
        this.searchDialog.setSearchAreaLabel("Column");
        this.searchDialog.addFindListener(new SearchDialog.FindListener(){

            @Override
            public boolean find() {
                return RestoreBackupOld.this.findEntry(table);
            }
        });
        this.restorePathGroup = new Group(composite, 0x1000000);
        this.restorePathGroup.setVisible(false);
        GridLayout groupPathGridLayout = new GridLayout();
        groupPathGridLayout.numColumns = 2;
        groupPathGridLayout.makeColumnsEqualWidth = false;
        groupPathGridLayout.horizontalSpacing = 10;
        this.restorePathGroup.setLayout((Layout)groupPathGridLayout);
        this.restoreFolderGroup = new Group(composite, 0x1000000);
        this.restoreFolderGroup.setVisible(false);
        GridLayout groupFolderGridLayout = new GridLayout();
        groupFolderGridLayout.numColumns = 1;
        groupFolderGridLayout.makeColumnsEqualWidth = false;
        this.restoreFolderGroup.setLayout((Layout)groupFolderGridLayout);
        GridData contactGroupFolderGridData = new GridData(768);
        contactGroupFolderGridData.horizontalSpan = 2;
        GridData gdBtnNewButton3 = new GridData(4, 4, false, false, 1, 1);
        gdBtnNewButton3.heightHint = 27;
        gdBtnNewButton3.widthHint = 40;
        this.backLabel = new Button((Composite)this.restorePathGroup, 16384);
        this.backLabel.setLayoutData((Object)gdBtnNewButton3);
        this.backLabel.setText("");
        this.backLabel.setImage(this.imageBack);
        GridData gdBtnNewButton4 = new GridData(4, 4, true, false, 1, 1);
        gdBtnNewButton4.heightHint = 10;
        gdBtnNewButton4.widthHint = 500;
        this.showPathLabel = new Label((Composite)this.restorePathGroup, 0);
        this.showPathLabel.setLayoutData((Object)gdBtnNewButton4);
        this.showPathLabel.setText("");
        this.restoreFolderGroup.setLayoutData((Object)contactGroupFolderGridData);
        this.restoreFolderGroup.setText("Select a folder or a file to restore");
        this.restoreFolderGroup.setFont(this.fontsManager.getSmallNormalFont());
        final Table foldertable = new Table((Composite)this.restoreFolderGroup, 68356);
        TableColumn fileColumn = new TableColumn(foldertable, 16);
        foldertable.setHeaderVisible(true);
        fileColumn.setText("Folders/Files");
        fileColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listFolders, "Folders/Files", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listFolders, "Folders/Files", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackupOld.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        TableColumn timestampColumn = new TableColumn(foldertable, 16);
        timestampColumn.setText("Modified Time");
        timestampColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listFolders, "Modified Time", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listFolders, "Modified Time", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackupOld.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        TableColumn sizeColumn = new TableColumn(foldertable, 16);
        sizeColumn.setText("Size(KB)");
        sizeColumn.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumn column = (TableColumn)e.widget;
                foldertable.removeAll();
                if (1024 == foldertable.getSortDirection() || 0 == foldertable.getSortDirection()) {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listFolders, "Size(KB)", true);
                    foldertable.setSortDirection(128);
                } else {
                    RestoreBackupOld.this.sortListForRestore(RestoreBackupOld.this.listFolders, "Size(KB)", false);
                    foldertable.setSortDirection(1024);
                }
                RestoreBackupOld.this.setDataToFolderTable(foldertable, 1);
                foldertable.setSortColumn(column);
            }
        });
        Label showFolderHelpLabel = new Label((Composite)this.restoreFolderGroup, 0);
        showFolderHelpLabel.setLayoutData((Object)contactGroupFolderGridData);
        showFolderHelpLabel.setText("Selecting a folder will result in restoring all sub-folders and files under it.");
        showFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        this.backLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (RestoreBackupOld.this.fullPath == null) {
                        return;
                    }
                    if (RestoreBackupOld.this.fullPath.contains("/")) {
                        String tmpPath;
                        RestoreBackupOld.this.fullPath = tmpPath = this.getPreviousPathforBackButton();
                        RestoreBackupOld.this.logger.debug("tempPath in back function is:" + tmpPath);
                        RestoreBackupOld.this.showPathLabel.setText(RestoreBackupOld.this.fullPath);
                        RestoreBackupOld.this.getBasePathFromServer(foldertable, RestoreBackupOld.this.fullPath);
                        RestoreBackupOld.this.backLabel.setEnabled(false);
                    } else {
                        RestoreBackupOld.this.fullPath = null;
                        RestoreBackupOld.this.getBasePathFromServer(foldertable, RestoreBackupOld.this.fullPath);
                        RestoreBackupOld.this.backLabel.setEnabled(false);
                        RestoreBackupOld.this.showPathLabel.setText("");
                    }
                }
                catch (Exception e1) {
                    RestoreBackupOld.this.logger.trace("" + e1);
                    RestoreBackupOld.this.logger.error("Exception occured" + e1.getMessage());
                }
            }

            String getPreviousPathforBackButton() {
                String delimiter = "\\/";
                String[] tmpArray = RestoreBackupOld.this.fullPath.split(delimiter);
                StringBuilder tmpPath = null;
                for (int i = 0; i < tmpArray.length - 1; ++i) {
                    tmpPath = tmpPath == null ? new StringBuilder(tmpArray[i]) : tmpPath.append("/").append(tmpArray[i]);
                }
                if (tmpPath != null) {
                    return tmpPath.toString();
                }
                return null;
            }
        });
        foldertable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackupOld.this.selectedFolder = (DeviceTo)item.getData();
                    if (RestoreBackupOld.this.selectedFolder == null) {
                        RestoreBackupOld.this.fullPath = RestoreBackupOld.this.previousFolderPath;
                        return;
                    }
                    RestoreBackupOld.this.logger.debug(RestoreBackupOld.SELECTED_FOLDER_LOG + RestoreBackupOld.this.selectedFolder.getFilePath());
                    RestoreBackupOld.this.folderPath = RestoreBackupOld.this.selectedFolder.getFilePath();
                    RestoreBackupOld.this.previousSelectedFolder = RestoreBackupOld.this.selectedFolder;
                    if (RestoreBackupOld.this.fullPath == null) {
                        RestoreBackupOld.this.fullPath = RestoreBackupOld.this.folderPath;
                        RestoreBackupOld.this.previousFolderPath = RestoreBackupOld.this.folderPath;
                    } else {
                        RestoreBackupOld.this.previousFolderPath = RestoreBackupOld.this.fullPath;
                        RestoreBackupOld.this.fullPath = RestoreBackupOld.this.fullPath + "/" + RestoreBackupOld.this.folderPath;
                        RestoreBackupOld.this.logger.debug("fullPath is:#####$$$$$$$ " + RestoreBackupOld.this.fullPath);
                        RestoreBackupOld.this.logger.debug("previousPath:#####$$$$$$$ " + RestoreBackupOld.this.previousFolderPath);
                    }
                    try {
                        if (!RestoreBackupOld.this.selectedFolder.getFolder().equals("true")) {
                            RestoreBackupOld.this.logger.debug("Current selected file is a folde:" + RestoreBackupOld.this.selectedFolder.getFolder());
                            RestoreBackupOld.this.showupRevisions(foldertable, RestoreBackupOld.this.selectedFolder.getFilePath(), RestoreBackupOld.this.selectedFolder.getFileName());
                        } else {
                            RestoreBackupOld.this.getBasePathFromServer(foldertable, RestoreBackupOld.this.fullPath);
                        }
                        RestoreBackupOld.this.showPathLabel.setText(RestoreBackupOld.this.fullPath);
                    }
                    catch (Exception e1) {
                        RestoreBackupOld.this.logger.trace("" + e1);
                        RestoreBackupOld.this.logger.error("Exception in getting basepath from server" + e1.getMessage());
                    }
                }
            }
        });
        foldertable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ++RestoreBackupOld.this.count;
                RestoreBackupOld.this.logger.debug("count inside click:" + RestoreBackupOld.this.count);
                RestoreBackupOld.this.restoreFolderorDevice = 0;
                if (foldertable.getSelectionIndex() != -1) {
                    TableItem item = foldertable.getItem(foldertable.getSelectionIndex());
                    RestoreBackupOld.this.selectedFolder = (DeviceTo)item.getData();
                    if (item.getText().startsWith(" Version") && RestoreBackupOld.this.checkBoxbtn != null) {
                        RestoreBackupOld.this.checkBox.setSelection(false);
                        RestoreBackupOld.this.restoreAllVersionSelected = RestoreBackupOld.this.checkBoxbtn.getSelection();
                    }
                    if (RestoreBackupOld.this.selectedFolder == null) {
                        RestoreBackupOld.this.selectedFolder = RestoreBackupOld.this.previousSelectedFolder;
                        RestoreBackupOld.this.folderPath = RestoreBackupOld.this.selectedFolder.getFilePath();
                        RestoreBackupOld.this.logger.debug(" selected folder: " + RestoreBackupOld.this.fullPath + File.separator + RestoreBackupOld.this.selectedFolder.getFilePath());
                        return;
                    }
                    if (RestoreBackupOld.this.fullPath == null) {
                        RestoreBackupOld.this.logger.debug(RestoreBackupOld.SELECTED_FOLDER_LOG + RestoreBackupOld.this.selectedFolder.getFilePath());
                    } else {
                        RestoreBackupOld.this.logger.debug(RestoreBackupOld.SELECTED_FOLDER_LOG + RestoreBackupOld.this.fullPath + File.separator + RestoreBackupOld.this.selectedFolder.getFilePath());
                    }
                }
            }
        });
        this.pullRestoreDeviceListFromServer(table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackupOld.this.restoreFolderorDevice = 1;
                RestoreBackupOld.this.selectedFolder = null;
                RestoreBackupOld.this.fullPath = null;
                RestoreBackupOld.this.previousFolderPath = null;
                if (table.getSelectionIndex() != -1) {
                    RestoreBackupOld.this.restoreFolderGroup.setVisible(true);
                    RestoreBackupOld.this.restorePathGroup.setVisible(true);
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackupOld.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackupOld.this.deviceuid = RestoreBackupOld.this.selectedItem.getDeviceUid();
                    RestoreBackupOld.this.logger.debug("selected device: " + RestoreBackupOld.this.selectedItem.getDeviceName());
                    try {
                        foldertable.clearAll();
                        RestoreBackupOld.this.showPathLabel.setText("");
                        RestoreBackupOld.this.listFolders.clear();
                    }
                    catch (Exception e1) {
                        RestoreBackupOld.this.logger.trace("" + e1);
                        RestoreBackupOld.this.logger.error("Exception occured while clearing the folder List" + e1.getMessage());
                    }
                }
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (table.getSelectionIndex() != -1) {
                    TableItem item = table.getItem(table.getSelectionIndex());
                    RestoreBackupOld.this.selectedItem = (DeviceTo)item.getData();
                    RestoreBackupOld.this.logger.debug("selected device: " + RestoreBackupOld.this.selectedItem.getDeviceName());
                    RestoreBackupOld.this.logger.debug("deviceid is:" + RestoreBackupOld.this.selectedItem.getDeviceId());
                    RestoreBackupOld.this.deviceuid = RestoreBackupOld.this.selectedItem.getDeviceUid();
                    try {
                        RestoreBackupOld.this.fullPath = null;
                        RestoreBackupOld.this.previousFolderPath = null;
                        RestoreBackupOld.this.getBasePathFromServer(foldertable, RestoreBackupOld.this.fullPath);
                        RestoreBackupOld.this.showPathLabel.setText("");
                    }
                    catch (Exception e1) {
                        RestoreBackupOld.this.logger.trace("" + e1);
                        RestoreBackupOld.this.logger.error("Exception occured while getting the basepath from server" + e1.getMessage());
                    }
                }
            }
        });
        GridData tableData = new GridData(768);
        tableData.heightHint = 75;
        tableData.widthHint = 500;
        table.setLayoutData((Object)tableData);
        GridData tableFolderData = new GridData(768);
        tableFolderData.heightHint = 120;
        tableData.widthHint = 500;
        foldertable.setLayoutData((Object)tableFolderData);
        Composite inPlaceCheckBoxComposite = new Composite(composite, 16384);
        GridLayout inPlaceCheckBoxButtonLayout = new GridLayout();
        inPlaceCheckBoxButtonLayout.numColumns = 9;
        inPlaceCheckBoxButtonLayout.makeColumnsEqualWidth = false;
        inPlaceCheckBoxButtonLayout.horizontalSpacing = 0;
        inPlaceCheckBoxComposite.setLayout((Layout)inPlaceCheckBoxButtonLayout);
        InplacecheckBox = new Button(inPlaceCheckBoxComposite, 32);
        InplacecheckBox.setBounds(330, 225, 75, 20);
        InplacecheckBox.setText("In place restore");
        InplacecheckBox.setFont(this.fontsManager.getMediumNormalFont());
        InplacecheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                checkBoxbutton = (Button)event.getSource();
                RestoreBackupOld.this.logger.debug(" Restore inplace check box selected:");
                if (checkBoxbutton.getSelection()) {
                    MessageBox msg = new MessageBox(shell, 200);
                    msg.setMessage("Selecting this option could result in overwriting of files already present in the folder from where the backup originally occurred. Would you like to continue?");
                    msg.setText("Restore Alert");
                    MessageBox message = new MessageBox(shell, 40);
                    int result = msg.open();
                    if (result == 64) {
                        if (RestoreBackupOld.this.selectedItem == null) {
                            message.setText("No device selected");
                            message.setMessage("No items selected for Restore. Please add and try Restore.");
                            message.open();
                            checkBoxbutton.setSelection(false);
                        } else if (RestoreBackupOld.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("win")) {
                            message.setText("InplaceRestore Incompatibility ");
                            message.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                            message.open();
                            checkBoxbutton.setSelection(false);
                        } else if (RestoreBackupOld.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("onedrive")) {
                            message.setText("InplaceRestore Incompatibility ");
                            message.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                            message.open();
                            checkBoxbutton.setSelection(false);
                        } else {
                            checkBoxbutton.setSelection(true);
                            folderSelectButton.setEnabled(false);
                            oldfolder = subtext.getText();
                            subtext.setText("");
                            subtext.setEnabled(false);
                            RestoreBackupOld.this.restoreInPlace = checkBoxbutton.getSelection();
                        }
                    } else if (result == 128) {
                        checkBoxbutton.setSelection(false);
                        RestoreBackupOld.this.restoreInPlace = checkBoxbutton.getSelection();
                    }
                } else {
                    RestoreBackupOld.this.logger.debug(oldfolder);
                    folderSelectButton.setEnabled(true);
                    subtext.setText(oldfolder);
                    subtext.setEnabled(true);
                    RestoreBackupOld.this.restoreInPlace = checkBoxbutton.getSelection();
                }
            }
        });
        helpButton = new Button(inPlaceCheckBoxComposite, 0);
        helpButton.setText("");
        helpButton.setText("dumm");
        helpButton.setVisible(false);
        this.checkBox = new Button(inPlaceCheckBoxComposite, 32);
        this.checkBox.setBounds(330, 225, 75, 20);
        this.checkBox.setText("Restore all versions");
        this.checkBox.setFont(this.fontsManager.getMediumNormalFont());
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackupOld.this.checkBoxbtn = (Button)event.getSource();
                RestoreBackupOld.this.restoreAllVersionSelected = RestoreBackupOld.this.checkBoxbtn.getSelection();
                RestoreBackupOld.this.logger.debug("check box selected:" + RestoreBackupOld.this.restoreAllVersionSelected);
                if (RestoreBackupOld.this.checkBoxbtn.getSelection()) {
                    MessageBox msg = new MessageBox(shell, 34);
                    msg.setText("Restore Alert");
                    msg.setMessage("Selecting all versions may result in a long restore operation and consume a lot of space on your hard drive. \nMake sure there is enough disk space available.");
                    msg.open();
                }
            }
        });
        helpButton = new Button(inPlaceCheckBoxComposite, 0);
        helpButton.setText("");
        helpButton.setText("dumm");
        helpButton.setVisible(false);
        pointInTimeCheckBox = new Button(inPlaceCheckBoxComposite, 32);
        pointInTimeCheckBox.setBounds(330, 225, 75, 20);
        pointInTimeCheckBox.setText("Restore data before");
        pointInTimeCheckBox.setFont(this.fontsManager.getMediumNormalFont());
        pointInTimeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreBackupOld.this.PointInTimeCheckBoxBtn = (Button)event.getSource();
                RestoreBackupOld.this.PointInTimeRestoreSelected = RestoreBackupOld.this.PointInTimeCheckBoxBtn.getSelection();
                RestoreBackupOld.this.logger.debug("" + RestoreBackupOld.this.PointInTimeCheckBoxBtn.getSelection());
                if (RestoreBackupOld.this.PointInTimeCheckBoxBtn.getSelection()) {
                    calender.setEnabled(true);
                    RestoreBackupOld.this.labelForDate.setEnabled(true);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
                    Date date = new Date();
                    String currentDate = dateFormat.format(date);
                    RestoreBackupOld.this.labelForDate.setText(currentDate);
                    RestoreBackupOld.this.logger.debug(date + "Restore Till date " + date.getTime());
                    RestoreBackupOld.this.restoreTilldate = date.getTime();
                    refresh.setEnabled(true);
                } else {
                    calender.setEnabled(false);
                    calender.setText("");
                    RestoreBackupOld.this.labelForDate.setEnabled(false);
                    RestoreBackupOld.this.labelForDate.setText("Select Date..");
                    RestoreBackupOld.this.restoreTilldate = 0L;
                    refresh.setEnabled(false);
                }
            }
        });
        calender = new Button(inPlaceCheckBoxComposite, 0);
        calender.setImage(this.imageCalender);
        calender.setFont(this.fontsManager.getMediumNormalFont());
        calender.setEnabled(false);
        calender.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestoreBackupOld.this.dialogAlive) {
                    calender.setFocus();
                    return;
                }
                dialog = new Shell(shell, 2144);
                dialog.setLayout((Layout)new GridLayout(3, false));
                dialog.setText("Select Date..");
                dialog.setImage(RestoreBackupOld.this.dialogeImage);
                if (!RestoreBackupOld.this.dialogAlive) {
                    RestoreBackupOld.this.dialogAlive = true;
                    final DateTime calendar = new DateTime((Composite)dialog, 1024);
                    final DateTime time = new DateTime((Composite)dialog, 32896);
                    new Label((Composite)dialog, 0);
                    new Label((Composite)dialog, 0);
                    Button ok = new Button((Composite)dialog, 8);
                    ok.setText("OK");
                    ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                    ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                            String dateValue = calendar.getDay() + "/" + (calendar.getMonth() + 1) + "/" + calendar.getYear() + " " + time.getHours() + ":" + time.getMinutes();
                            try {
                                RestoreBackupOld.this.date = formatter.parse(dateValue);
                            }
                            catch (ParseException e1) {
                                RestoreBackupOld.this.logger.error("unable to prase the date format" + e1.getMessage());
                            }
                            SimpleDateFormat simple = new SimpleDateFormat("MMM dd, yyyy HH:mm");
                            if (RestoreBackupOld.this.date != null) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm");
                                        String dateText = dateFormat.format(RestoreBackupOld.this.date);
                                        RestoreBackupOld.this.labelForDate.setText(dateText);
                                        RestoreBackupOld.this.restoreTilldate = RestoreBackupOld.this.date.getTime();
                                        RestoreBackupOld.this.logger.debug(dateFormat.format(RestoreBackupOld.this.date) + "Restore Till Date......." + RestoreBackupOld.this.restoreTilldate);
                                    }
                                });
                            } else {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RestoreBackupOld.this.labelForDate.setText("Select Date..");
                                    }
                                });
                            }
                            dialog.close();
                            RestoreBackupOld.this.dialogAlive = false;
                        }
                    });
                    Listener listener = arg0 -> {
                        RestoreBackupOld.this.logger.debug("closing calender");
                        RestoreBackupOld.this.dialogAlive = false;
                    };
                    dialog.addListener(21, listener);
                    dialog.setDefaultButton(ok);
                    dialog.pack();
                    dialog.open();
                }
            }
        });
        this.labelForDate = new Text(inPlaceCheckBoxComposite, 0x1000800);
        this.labelForDate.setText("Select Date..");
        GridData textData = new GridData(0x1000000, 0x1000000, true, true);
        textData.widthHint = 95;
        this.labelForDate.setLayoutData((Object)textData);
        this.labelForDate.setFont(this.fontsManager.smallNormalFont);
        this.labelForDate.setEditable(false);
        this.labelForDate.setEnabled(false);
        helpButton = new Button(inPlaceCheckBoxComposite, 0);
        helpButton.setText("");
        helpButton.setText("du");
        helpButton.setVisible(false);
        refresh = new Button(inPlaceCheckBoxComposite, 1024);
        refresh.setText("Refresh");
        refresh.setEnabled(false);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    foldertable.removeAll();
                    RestoreBackupOld.this.showPathLabel.setText("");
                    if (RestoreBackupOld.this.listFolders != null) {
                        RestoreBackupOld.this.listFolders.clear();
                    }
                    if (RestoreBackupOld.this.selectedFolder != null) {
                        RestoreBackupOld.this.selectedFolder = null;
                    }
                    if (RestoreBackupOld.this.selectedItem != null) {
                        RestoreBackupOld.this.selectedItem = null;
                    }
                }
                catch (Exception e) {
                    RestoreBackupOld.this.logger.debug("Exception to clear the folder list .." + e.getMessage());
                }
            }
        });
        this.queryGroup = new Group(composite, 0x1000000);
        GridLayout queryGroupGridLayout = new GridLayout();
        queryGroupGridLayout.numColumns = 2;
        queryGroupGridLayout.makeColumnsEqualWidth = false;
        this.queryGroup.setLayout((Layout)queryGroupGridLayout);
        GridData queryGroupGridData = new GridData(768);
        queryGroupGridData.horizontalSpan = 2;
        this.queryGroup.setLayoutData((Object)queryGroupGridData);
        this.queryGroup.setText("Select the destination folder");
        this.queryGroup.setFont(this.fontsManager.getSmallNormalFont());
        subtext = new Text((Composite)this.queryGroup, 2052);
        GridData subGridData = new GridData(768);
        subGridData.widthHint = 170;
        subtext.setLayoutData((Object)subGridData);
        subtext.setFont(this.fontsManager.getMediumNormalFont());
        folderSelectButton = new Button((Composite)this.queryGroup, 8);
        folderSelectButton.setText("Select Folder");
        folderSelectButton.setFont(this.fontsManager.getMediumNormalFont());
        Label showDestinationFolderHelpLabel = new Label((Composite)this.queryGroup, 0);
        showDestinationFolderHelpLabel.setLayoutData((Object)queryGroupGridData);
        showDestinationFolderHelpLabel.setText("Restored data will be downloaded to this folder");
        showDestinationFolderHelpLabel.setFont(this.fontsManager.getSmallNormalFont());
        folderSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(shell);
                dlg.setFilterPath(subtext.getText());
                dlg.setText("Parablu");
                dlg.setMessage("Select the directory you want to restore to");
                String dir = dlg.open();
                if (dir != null) {
                    subtext.setText(dir);
                }
            }
        });
        Composite restoreStartGroup = new Composite(composite, 131072);
        GridLayout restoreStartGroupGridLayout = new GridLayout();
        restoreStartGroupGridLayout.numColumns = 2;
        restoreStartGroupGridLayout.makeColumnsEqualWidth = false;
        restoreStartGroup.setLayout((Layout)restoreStartGroupGridLayout);
        GridData restoreStartGroupGridData = new GridData(768);
        contactGroupGridData.horizontalSpan = 2;
        restoreStartGroup.setLayoutData((Object)restoreStartGroupGridData);
        this.restoreStatus = new Label(restoreStartGroup, 16384);
        GridData restoreGridData = new GridData(768);
        restoreGridData.widthHint = 180;
        this.restoreStatus.setLayoutData((Object)restoreGridData);
        this.restoreStatus.setText("Loading information");
        this.restoreStatus.setFont(this.fontsManager.getMediumNormalFont());
        Label dummy = new Label(restoreStartGroup, 16384);
        GridData dummygrid = new GridData(768);
        dummy.setLayoutData((Object)dummygrid);
        dummy.setVisible(false);
        this.currentFileBeingRestoredLabel = new Label(restoreStartGroup, 16384);
        GridData restoreFileGridData = new GridData(768);
        restoreFileGridData.horizontalSpan = 2;
        this.currentFileBeingRestoredLabel.setLayoutData((Object)restoreFileGridData);
        this.currentFileBeingRestoredLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentRestoreStatusLabel = new Label(restoreStartGroup, 16384);
        this.currentRestoreStatusLabel.setLayoutData((Object)new GridData(768));
        this.restoreButton = new Button(restoreStartGroup, 8);
        GridData buttonGridData = new GridData();
        this.restoreButton.setLayoutData((Object)buttonGridData);
        this.restoreButton.setText("Restore");
        this.restoreButton.setFont(this.fontsManager.getMediumNormalFont());
        this.restoreButton.setEnabled(false);
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
                RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
                NotificationHelper.setShowFileBeingRestored((boolean)false);
                RestoreBackupOld.this.logger.debug("the selected item is:(file-1/folder-0):" + RestoreBackupOld.this.restoreFolderorDevice);
                NotificationHelper.successfulRestore = 1;
                if (NotificationHelper.restoreStarted) {
                    return;
                }
                MessageBox msg = new MessageBox(shell, 34);
                String destinationFolder = subtext.getText();
                File file = new File(destinationFolder);
                if (RestoreBackupOld.this.selectedItem == null) {
                    msg.setText("No device selected");
                    msg.setMessage("No items selected for Restore. Please add and try Restore.");
                    msg.open();
                } else if (RestoreBackupOld.this.restoreInPlace && RestoreBackupOld.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("win")) {
                    msg.setText("InplaceRestore Incompatibility ");
                    msg.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                    msg.open();
                } else if (RestoreBackupOld.this.restoreInPlace && RestoreBackupOld.this.selectedItem.getDeviceOsType().toLowerCase().startsWith("onedrive")) {
                    msg.setText("InplaceRestore Incompatibility ");
                    msg.setMessage("InplaceRestore cannot be selected ,Incompatibilty issue");
                    msg.open();
                } else if (!RestoreBackupOld.this.restoreInPlace && "".equals(destinationFolder)) {
                    msg.setText("No folder selected");
                    msg.setMessage("Please select a folder to restore to");
                    msg.open();
                } else if (!RestoreBackupOld.this.restoreInPlace && !file.isDirectory()) {
                    msg.setText("Error");
                    msg.setMessage("The selected path is not a valid folder");
                    msg.open();
                } else if (RestoreBackupOld.this.PointInTimeRestoreSelected && RestoreBackupOld.this.restoreTilldate == 0L) {
                    msg.setMessage("Restore tilldate  shouldn't be empty, please select date");
                    msg.setText("Restore Alert");
                    msg.open();
                } else {
                    if (!RestoreBackupOld.this.restoreInPlace && file.list().length > 0) {
                        msg.setText("Folder not empty");
                        msg.setMessage("The destination folder is not empty. Please note that any file with the same name will be overwritten.");
                        msg.open();
                    }
                    NotificationHelper.successfulRestore = 1;
                    if (RestoreBackupOld.this.restoreFolderorDevice == 0 || RestoreBackupOld.this.restoreFolderorDevice == 1) {
                        RestoreBackupOld.this.restoreButton.setEnabled(false);
                        RestoreBackupOld.this.closeButton.setEnabled(false);
                        NotificationHelper.setRestoreStarted((boolean)true);
                        NotificationHelper.restoreFinished = false;
                        if (RestoreBackupOld.this.restoreFolderorDevice == 1 || RestoreBackupOld.this.selectedFolder.getFilePath().length() <= 3 && RestoreBackupOld.this.selectedFolder.getFilePath().contains(":")) {
                            RestoreBackupOld.this.showInfoMessage();
                        }
                        Runnable runnable = () -> {
                            try {
                                RestoreBackupOld.this.restoredCount = 0;
                                String status = BackupLifeCycle.STARTED.toString();
                                RestoreBackupOld.this.logger.debug("Status" + status);
                                RestoreBackupOld.this.batchId = RestoreBackupOld.this.restoreBatchInitiated(status, "", "0/0");
                                RestoreBackupOld.this.restoreElement = new RestoreElement();
                                Object selectedPathForRestore = destinationFolder;
                                NotificationHelper.setShowFileBeingRestored((boolean)true);
                                if (RestoreBackupOld.this.PointInTimeRestoreSelected) {
                                    RestoreBackupOld.this.restoreElement.setRestoreTillDate(String.valueOf(RestoreBackupOld.this.restoreTilldate));
                                }
                                if (!RestoreBackupOld.this.batchId.equals("") && !"-1".equals(RestoreBackupOld.this.batchId)) {
                                    RestoreBackupOld.this.validatePreviousBatchStatus(restoreActivityHistoryDAOImpl);
                                    RestoreBackupOld.this.logger.debug("Inserting into restore table");
                                    restoreActivityTo.setRestoreBatchStatus(status);
                                    restoreActivityTo.setRestoreBatchId(RestoreBackupOld.this.batchId);
                                    restoreActivityHistoryDAOImpl.addEventToRestoreActivity(restoreActivityTo);
                                }
                                FileElement fileElement = null;
                                FileListElement listFolderFiles = new FileListElement();
                                if (RestoreBackupOld.this.restoreFolderorDevice == 0) {
                                    if (RestoreBackupOld.this.selectedFolder.getFolder().equalsIgnoreCase("true")) {
                                        selectedPathForRestore = destinationFolder + StringLiterals.FILE_SEPARATOR + RestoreBackupOld.this.selectedFolder.getFilePath().replace(":", "_DRIVE");
                                        fileElement = ObjectUtils.convertToFileElement((DeviceTo)RestoreBackupOld.this.selectedFolder);
                                        fileElement.setFileName("");
                                        RestoreBackupOld.this.restoreElement.setSelectedDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackupOld.this.restoreElement.setDevicePath(fileElement.getFileCompletePath());
                                        RestoreBackupOld.this.restoreElement.setFileUserOwner(RestoreBackupOld.this.selectedFolder.getFileUserOwner());
                                        listFolderFiles.getFileElementList().add(fileElement);
                                    } else if (RestoreBackupOld.this.selectedFolder.getFolder().equalsIgnoreCase("false")) {
                                        RestoreBackupOld.this.restoreElement.setSelectedDevicePath(RestoreBackupOld.this.selectedFolder.getFileName());
                                        RestoreBackupOld.this.restoreElement.setDevicePath(RestoreBackupOld.this.selectedFolder.getFileName());
                                        RestoreBackupOld.this.restoreElement.setFileName(RestoreBackupOld.this.selectedFolder.getFilePath());
                                        RestoreBackupOld.this.restoreElement.setFileUserOwner(RestoreBackupOld.this.selectedFolder.getFileUserOwner());
                                        if (!RestoreBackupOld.this.restoreAllVersionSelected) {
                                            RestoreBackupOld.this.logger.debug("all versions not selected so set backup id>>>>>>" + RestoreBackupOld.this.selectedFolder.getFileUserOwner());
                                            RestoreBackupOld.this.restoreElement.setFileBackupId(RestoreBackupOld.this.selectedFolder.getBackupId());
                                        }
                                    }
                                } else if (RestoreBackupOld.this.restoreFolderorDevice == 1) {
                                    RestoreBackupOld.this.restoreElement.setFileUserOwner(SettingHelper.getUserName());
                                    fileElement = new FileElement();
                                }
                                RestoreBackupOld.this.restoreElement.setCloudName(SettingHelper.getCloudName());
                                RestoreBackupOld.this.restoreElement.setRestoreBatchId(RestoreBackupOld.this.batchId);
                                if (RestoreBackupOld.this.restoreInPlace) {
                                    RestoreBackupOld.this.restoreElement.setDestinationPath(null);
                                } else {
                                    RestoreBackupOld.this.restoreElement.setDestinationPath((String)selectedPathForRestore);
                                }
                                RestoreBackupOld.this.restoreElement.setDeviceUUid(RestoreBackupOld.this.deviceuid);
                                RestoreBackupOld.this.restoreElement.setRestoreAllVersions(RestoreBackupOld.this.restoreAllVersionSelected);
                                RestoreBackupOld.this.getUploadIPForGateway();
                                if (fileElement != null) {
                                    String fileElementXml = CreateXmlObject.createXmlForFileElement((FileElement)fileElement);
                                    FileListElement listFolderFilesFromServer = RestoreBackupOld.this.backupAdapter.getAllFoldersForDevicePathToFileElement(SettingHelper.getCurrentCloudIpAddress(), RestoreBackupOld.this.port, RestoreBackupOld.this.deviceuid, SettingHelper.readTokenFromFile(), fileElementXml, RestoreBackupOld.this.restoreTilldate);
                                    listFolderFiles.getFileElementList().addAll(listFolderFilesFromServer.getFileElementList());
                                    List listFileElement = listFolderFiles.getFileElementList();
                                    RestoreBackupOld.this.logger.debug("filelist elements:" + listFolderFiles);
                                    if (CollectionUtils.isEmpty((Collection)listFileElement)) {
                                        NotificationHelper.successfulRestore = 2;
                                    }
                                    for (FileElement element : listFileElement) {
                                        if (RestoreBackupOld.this.restoreThread.isInterrupted()) {
                                            RestoreBackupOld.this.logger.debug("Restore thread is interrupted...");
                                            return;
                                        }
                                        NotificationHelper.setRestoreStarted((boolean)true);
                                        NotificationHelper.restoreFinished = false;
                                        RestoreBackupOld.this.logger.debug("element devicepath:" + element.getFileCompletePath() + " filename:" + element.getFileName());
                                        Object devicePath = element.getFileCompletePath();
                                        if (!StringUtils.isEmpty((String)element.getFileCompletePath()) && !StringUtils.isEmpty((String)element.getFileName())) {
                                            devicePath = element.getFileCompletePath() + "/" + element.getFileName();
                                        }
                                        if (StringUtils.isEmpty((String)element.getFileCompletePath())) {
                                            devicePath = element.getFileName();
                                        }
                                        RestoreBackupOld.this.restoreElement.setDevicePath(((String)devicePath).replace("\\", "/"));
                                        RestoreBackupOld.this.logger.debug("restore element devicepath>" + RestoreBackupOld.this.restoreElement.getDevicePath());
                                        NotificationHelper.successfulRestore = 1;
                                        RestoreBackupOld.this.downloadFile();
                                        restoreActivityTo.setTotalRestoreCount(RestoreBackupOld.this.restoreElement.getRestoreCount());
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                        RestoreBackupOld.this.logger.debug("Resore count:" + RestoreBackupOld.this.restoreElement.getRestoreCount());
                                    }
                                } else {
                                    RestoreBackupOld.this.downloadFile();
                                }
                                return;
                            }
                            catch (Exception e1) {
                                NotificationHelper.successfulRestore = 0;
                                RestoreBackupOld.this.logger.trace("" + e1);
                                RestoreBackupOld.this.logger.error("unsuccessfulRestore, Exception e1: ", (Object)e1.getMessage());
                            }
                            finally {
                                if (NotificationHelper.successfulRestore == 1 || NotificationHelper.successfulRestore == 2) {
                                    String status = BackupLifeCycle.COMPLETED.toString();
                                    restoreCount = RestoreBackupOld.this.restoreElement.getRestoreCount();
                                    RestoreBackupOld.this.batchId = RestoreBackupOld.this.restoreBatchInitiated(status, RestoreBackupOld.this.batchId, restoreCount);
                                    if (RestoreBackupOld.this.batchId != null && RestoreBackupOld.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityTo.setTotalRestoreCount(restoreCount);
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                } else {
                                    String status = BackupLifeCycle.FAILED.toString();
                                    restoreCount = RestoreBackupOld.this.restoreElement.getRestoreCount();
                                    RestoreBackupOld.this.batchId = RestoreBackupOld.this.restoreBatchInitiated(status, RestoreBackupOld.this.batchId, restoreCount);
                                    if (RestoreBackupOld.this.batchId != null && RestoreBackupOld.this.batchId != "-1") {
                                        restoreActivityTo.setRestoreBatchStatus(status);
                                        restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
                                    }
                                }
                                NotificationHelper.setRestoreStarted((boolean)false);
                                NotificationHelper.restoreFinished = true;
                            }
                        };
                        RestoreBackupOld.this.restoreThread = new Thread(runnable);
                        RestoreBackupOld.this.restoreThread.start();
                    }
                }
            }
        });
        this.closeButton = new Button(restoreStartGroup, 8);
        this.closeButton.setLayoutData((Object)new GridData(768));
        this.closeButton.setText("Close");
        this.closeButton.setFont(this.fontsManager.getMediumNormalFont());
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        Listener listener = arg0 -> {
            this.logger.debug("Closing the restore Window");
            try {
                this.restoreTimer.cancel();
                NotificationHelper.restoreFinished = false;
                if (NotificationHelper.isRestoreStarted() && this.restoreThread != null && this.restoreThread.isAlive()) {
                    this.restoreThread.stop();
                    this.restoreElement.setRestoreInterrupted(true);
                    NotificationHelper.setRestoreStarted((boolean)false);
                    this.logger.debug("Stopping thread for restore....");
                }
                RestoreUI.setUilock(false);
                this.disposeWidgets();
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("restoreTimer not cancelled" + e.getMessage());
            }
        };
        shell.addListener(21, listener);
        shell.pack();
        shell.open();
        shell.forceActive();
        return result;
    }

    public void restoreBatchUpdateBeforeExit() {
        String status = BackupLifeCycle.FAILED.toString();
        String restoreCount = this.restoreElement.getRestoreCount();
        RestoreActivityTO restoreActivityTo = new RestoreActivityTO();
        RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl = new RestoreActivityHistoryDAOImpl(SettingHelper.getActivityDBUrl());
        this.batchId = this.restoreBatchInitiated(status, this.batchId, restoreCount);
        if (this.batchId != null && this.batchId != "-1") {
            restoreActivityTo.setRestoreBatchId(this.batchId);
            restoreActivityTo.setRestoreBatchStatus(status);
            restoreActivityTo.setTotalRestoreCount(restoreCount);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(restoreActivityTo);
        }
    }

    private void downloadFile() {
        boolean retry;
        AtomicInteger skipValue = new AtomicInteger(0);
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        do {
            retry = false;
            try {
                if ((SettingHelper.getBackupLicenced().equalsIgnoreCase("true") || SettingHelper.getServerBackupLicensed().equalsIgnoreCase("true")) && SettingHelper.getIsExternalStorageSelected().equalsIgnoreCase("true") && !StringUtils.isEmpty((String)this.uploadIpForGateway)) {
                    int response1 = this.backupAdapter.downloadFileViaGateway1(this.uploadIpForGateway, this.port, SettingHelper.readTokenFromFile(), SettingHelper.getCloudName(), this.restoreElement, skipValue, SettingHelper.getDeviceUUId(), SettingHelper.getKeystorePath());
                    this.logger.debug("New restore all versions selected:" + this.restoreAllVersionSelected);
                    if (response1 == 204) {
                        NotificationHelper.successfulRestore = 5;
                    }
                    if (response1 != 4) {
                        NotificationHelper.successfulRestore = 0;
                    }
                    if (response1 != 4 || !"0".equalsIgnoreCase(this.restoreElement.getRestoreCount())) continue;
                    NotificationHelper.successfulRestore = 2;
                    continue;
                }
                NotificationHelper.successfulRestore = 0;
                this.logger.debug("Restore Failed");
            }
            catch (CrawlAdapterException e) {
                this.logger.debug("Exception : " + e);
                this.logger.error("Crawl Adapter Exception:" + e.getMessage());
                this.logger.debug("retry after time interval>>>" + sleepTime);
                retry = true;
                ParabluFileSystemUtils.sleepForGivenTime((long)sleepTime);
                sleepTime = 60000L * (long)sleepMultiplier;
            }
            catch (Exception e) {
                NotificationHelper.successfulRestore = 0;
                this.logger.error("unsuccessfulRestore, Exception: ", (Throwable)e);
            }
        } while (retry && retryCount < 6);
    }

    public void getBasePathFromServer(Table foldertable, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runnable = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, this.restoreTilldate);
                if (this.listFolders == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listFolders = this.backupAdapter.getAllBasePathForRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, this.restoreTilldate);
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception", (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT_STR);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT_STR);
                this.logger.debug("closing shell cause of z error");
                Runnable runble = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runble);
                return;
            }
            Runnable runner = () -> {
                if (!this.listFolders.isEmpty()) {
                    this.listFoldersStack.removeAllElements();
                    this.listFoldersStack.addAll(this.listFolders);
                }
                this.addFolderDevicesToTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 1;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runner);
        };
        new Thread(runnable).start();
    }

    private void pullRestoreDeviceListFromServer(Table table) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        NotificationHelper.restoreFinished = false;
        Runnable runnable = () -> {
            this.listDevices = null;
            try {
                this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.readTokenFromFile());
                if (this.listDevices == null && SettingHelper.getCurrentCloudIpAddress().equals(SettingHelper.getPublicIpAddress()) && SettingHelper.getHttpsPort() != null) {
                    this.port = Integer.valueOf(SettingHelper.getHttpsPort());
                    this.listDevices = this.backupAdapter.getAllRegisteredDevicesByUser(SettingHelper.getCurrentCloudIpAddress(), this.port, SettingHelper.readTokenFromFile());
                }
            }
            catch (Exception e) {
                this.logger.debug("Exception", (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT_STR);
            if (this.isDisposed() || this.getDisplay() == null) {
                Runnable runnble = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runnble);
                return;
            }
            if (this.listDevices == null || this.listDevices.isEmpty()) {
                this.logger.debug(RESTORE_DEFAULT_STR);
                this.logger.debug("closing shell cause of z error");
                Runnable runable = () -> {
                    this.showErrorMessageForDeviceListEmpty();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runable);
                return;
            }
            Runnable rnble = () -> {
                this.addDevicesToTable(this.listDevices, table);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 1;
            };
            this.getDisplay().asyncExec(rnble);
        };
        new Thread(runnable).start();
    }

    private void addDevicesToTable(List<DisplayTo> listDevices, Table table) {
        for (DisplayTo deviceTo : listDevices) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, deviceTo.getDeviceName());
            if (!StringUtils.isEmpty((String)deviceTo.getUserName())) {
                item.setText(1, deviceTo.getUserName());
            } else {
                item.setText(1, "");
            }
            item.setData((Object)deviceTo);
            if (!StringUtils.isEmpty((String)deviceTo.getDeviceOsType())) {
                if (deviceTo.getDeviceOsType().toLowerCase().contains("win")) {
                    item.setImage(0, this.imageWindows);
                    continue;
                }
                if (deviceTo.getDeviceOsType().toLowerCase().contains("ios") || deviceTo.getDeviceOsType().toLowerCase().contains("mac")) {
                    item.setImage(0, this.imageMac);
                    continue;
                }
                if (deviceTo.getDeviceOsType().toLowerCase().contains("android")) {
                    item.setImage(0, this.imageAndroid);
                    continue;
                }
                if (!deviceTo.getDeviceOsType().toLowerCase().contains("onedrive")) continue;
                item.setImage(0, this.imageO365);
                continue;
            }
            item.setImage(0, this.imageUnknown);
        }
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).pack();
        }
        table.getColumn(0).setWidth((int)((double)table.getClientArea().width * 0.5));
        table.getColumn(1).setWidth((int)((double)table.getClientArea().width * 0.5));
    }

    private void addFolderDevicesToTable(Table foldertable) {
        this.logger.debug("adding folders to the table");
        int counter = 1;
        foldertable.getColumn(0).setText("Folders/Files");
        if (this.listFolders.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("listSet is Empty:" + this.listFolders.isEmpty());
            this.logger.debug("path >>>>> " + this.previousFolderPath);
            this.showPathLabel.setText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("listFoldersStack:" + this.listFoldersStack.size());
                this.listFoldersStack.forEach(p -> this.listFolders.add((DisplayTo)p));
                this.logger.debug("fullPath is:" + this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception in add folder device to table" + e.getMessage());
            }
        } else {
            this.setDataToFolderTable(foldertable, counter);
        }
    }

    private void showErrorMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Server unreachable");
        msg.setMessage("Cannot connect to the server. Please check the network connection and try again. If the problem persists, please contact your Administrator.");
        msg.open();
    }

    protected void createTempFile(File oldTempFile) throws IOException, InterruptedException {
        if (!oldTempFile.getParentFile().exists()) {
            oldTempFile.getParentFile().mkdirs();
        }
        if (oldTempFile.exists()) {
            oldTempFile.delete();
        }
        oldTempFile.createNewFile();
        oldTempFile.deleteOnExit();
    }

    public void startRestoreBackup() {
        if (this.restoreTimer == null) {
            this.restoreTimer = new Timer();
        }
        if (this.restoreTimerTask == null) {
            this.restoreTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        RestoreBackupOld.this.updateRestoreDisplay();
                    }
                    catch (Exception e) {
                        RestoreBackupOld.this.logger.error("error in updateRestoreDisplay", (Throwable)e);
                    }
                }
            };
            this.restoreTimer.schedule(this.restoreTimerTask, 1000L, 1000L);
        }
    }

    protected void updateRestoreDisplay() {
        if (this.getDisplay() == null) {
            return;
        }
        Runnable runnable = () -> {
            if (this.restoreButton == null || this.restoreButton.isDisposed()) {
                return;
            }
            try {
                if (NotificationHelper.isRestoreStarted()) {
                    String fileBeingRestored;
                    this.restoreButton.setEnabled(false);
                    this.closeButton.setEnabled(false);
                    this.restoreStatus.setText("Restore in progress");
                    this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                    this.restoreFolderGroup.setEnabled(false);
                    this.restorePathGroup.setEnabled(false);
                    this.restoreGroup.setEnabled(false);
                    InplacecheckBox.setEnabled(false);
                    calender.setEnabled(false);
                    refresh.setEnabled(false);
                    pointInTimeCheckBox.setEnabled(false);
                    this.checkBox.setEnabled(false);
                    if (!StringUtils.isEmpty((String)this.restoreElement.getFileBeingRestored())) {
                        NotificationHelper.setFileBeingRestored((String)this.restoreElement.getFileBeingRestored());
                    }
                    if ((fileBeingRestored = NotificationHelper.getFileBeingRestored()) != null && NotificationHelper.isShowFileBeingRestored()) {
                        this.currentFileBeingRestoredLabel.setVisible(true);
                        this.currentFileBeingRestoredLabel.setFont(this.fontsManager.getMediumNormalFont());
                        this.currentFileBeingRestoredLabel.setToolTipText(NotificationHelper.getFileBeingRestored());
                        this.currentRestoreStatusLabel.setVisible(true);
                        if (fileBeingRestored.length() > this.lengthForFileName) {
                            fileBeingRestored = new StringBuffer().append(fileBeingRestored.substring(0, this.lengthForFileName)).append("...").toString();
                        }
                        this.currentFileBeingRestoredLabel.setText("File being restored: " + fileBeingRestored);
                        String filesCount = this.restoreElement.getRestoreCount();
                        this.currentRestoreStatusLabel.setToolTipText("Restore in Progress. " + filesCount + "files ");
                        this.currentRestoreStatusLabel.setText("Restore in Progress. " + filesCount + "files ");
                        if (fileBeingRestored.length() > this.lengthForFileName) {
                            fileBeingRestored = new StringBuffer().append(fileBeingRestored.substring(0, this.lengthForFileName)).append("...").toString();
                        }
                        this.currentFileBeingRestoredLabel.setText("File being restored: " + fileBeingRestored);
                    }
                } else {
                    this.closeButton.setEnabled(true);
                    InplacecheckBox.setEnabled(true);
                    if (this.PointInTimeRestoreSelected) {
                        calender.setEnabled(true);
                        refresh.setEnabled(true);
                    }
                    pointInTimeCheckBox.setEnabled(true);
                    this.checkBox.setEnabled(true);
                    this.currentFileBeingRestoredLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setVisible(false);
                    this.currentRestoreStatusLabel.setText("");
                    if (NotificationHelper.restoreFinished) {
                        this.restoreFolderGroup.setEnabled(true);
                        this.restorePathGroup.setEnabled(true);
                        this.restoreGroup.setEnabled(true);
                        InplacecheckBox.setEnabled(true);
                        if (this.PointInTimeRestoreSelected) {
                            calender.setEnabled(true);
                            refresh.setEnabled(true);
                        }
                        pointInTimeCheckBox.setEnabled(true);
                        this.checkBox.setEnabled(true);
                        if (NotificationHelper.successfulRestore == 1) {
                            this.restoreStatus.setText("Restored successfully");
                        } else if (NotificationHelper.successfulRestore == 2) {
                            this.restoreStatus.setText("No files restored.");
                        } else if (NotificationHelper.successfulRestore == 0) {
                            if ("0".equalsIgnoreCase(this.restoreElement.getRestoreCount())) {
                                this.restoreStatus.setText("Unable to connect to the server.");
                            } else {
                                this.restoreStatus.setText("Restore completed - " + this.restoreElement.getRestoreCount() + " files ");
                            }
                        } else if (NotificationHelper.successfulRestore == 5) {
                            this.restoreStatus.setText("Error during restore. Token expired");
                        } else if (NotificationHelper.successfulRestore == 6) {
                            this.restoreStatus.setText("Restore aborted.  Please check your network connection and try again.");
                        }
                    } else if (NotificationHelper.successfulRestore == 3) {
                        this.restoreGroup.setEnabled(false);
                        this.restoreFolderGroup.setEnabled(false);
                        this.restorePathGroup.setEnabled(false);
                        this.checkBox.setEnabled(false);
                        this.queryGroup.setEnabled(false);
                        InplacecheckBox.setEnabled(false);
                        calender.setEnabled(false);
                        refresh.setEnabled(false);
                        pointInTimeCheckBox.setEnabled(false);
                        this.checkBox.setEnabled(false);
                        if (this.restoreLoadingStatus) {
                            this.restoreStatus.setText("Loading information..");
                        } else {
                            this.restoreStatus.setText("Loading information...");
                        }
                        this.restoreLoadingStatus = !this.restoreLoadingStatus;
                    } else {
                        this.restoreGroup.setEnabled(true);
                        this.restoreFolderGroup.setEnabled(true);
                        this.restorePathGroup.setEnabled(true);
                        this.queryGroup.setEnabled(true);
                        InplacecheckBox.setEnabled(true);
                        if (this.PointInTimeRestoreSelected) {
                            calender.setEnabled(true);
                            refresh.setEnabled(true);
                        }
                        pointInTimeCheckBox.setEnabled(true);
                        this.checkBox.setEnabled(true);
                        this.restoreStatus.setText("Click Restore to start restoration");
                        this.restoreStatus.setFont(this.fontsManager.getSmallNormalFont());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("error in restoreStatus toggle", (Throwable)e);
            }
        };
        this.getDisplay().asyncExec(runnable);
    }

    public void disposeWidgets() {
        this.fontsManager.disposeFonts();
    }

    protected void checkSubclass() {
    }

    public String restoreBatchInitiated(String batchStatus, String batchId, String restoreCount) {
        String restoreBatchId;
        this.backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
        String jobType = "RESTORE";
        try {
            BackupOrRestoreStatusTo backupOrRestoreStatusTo = new BackupOrRestoreStatusTo();
            backupOrRestoreStatusTo.setStatus(batchStatus);
            backupOrRestoreStatusTo.setIp(SettingHelper.getCurrentCloudIpAddress());
            backupOrRestoreStatusTo.setToken(SettingHelper.readTokenFromFile());
            backupOrRestoreStatusTo.setBatchId(batchId);
            backupOrRestoreStatusTo.setJobType(jobType);
            backupOrRestoreStatusTo.setDeviceName(SettingHelper.getDeviceName());
            backupOrRestoreStatusTo.setTotalCount(this.restoredCount);
            backupOrRestoreStatusTo.setErrorCode(909);
            backupOrRestoreStatusTo.setDeviceUUID(SettingHelper.getDeviceUUId());
            backupOrRestoreStatusTo.setTotalUploadSize(0L);
            backupOrRestoreStatusTo.setTotalUploadedCount(restoreCount);
            backupOrRestoreStatusTo.setCrawlCount(0);
            backupOrRestoreStatusTo.setCrawlTimeStamp("0");
            backupOrRestoreStatusTo.setFullBackup(false);
            backupOrRestoreStatusTo.setDiskSpaceDetails(new ParabluFileSystemUtils().getSystemSpace());
            backupOrRestoreStatusTo.setPolicyConfiguredFolders("");
            backupOrRestoreStatusTo.setRestoreDeviceUUID(this.deviceuid);
            this.setRestoreFolder(backupOrRestoreStatusTo);
            restoreBatchId = this.backupAdapter.sendEmailNotification(backupOrRestoreStatusTo);
        }
        catch (Exception e) {
            restoreBatchId = "-1";
            this.logger.trace("" + e);
            this.logger.debug(" Exception inside Sysytem Tray UI " + e.getMessage());
        }
        return restoreBatchId;
    }

    private void setRestoreFolder(BackupOrRestoreStatusTo backupOrRestoreStatusTo) {
        if (this.selectedFolder != null) {
            if (this.selectedFolder.getFileName() == null) {
                backupOrRestoreStatusTo.setRestoreFolder(this.selectedFolder.getFilePath());
            } else {
                backupOrRestoreStatusTo.setRestoreFolder(this.selectedFolder.getFileName() + "/" + this.selectedFolder.getFilePath());
            }
        } else {
            backupOrRestoreStatusTo.setRestoreFolder("All drives");
        }
    }

    private void showErrorMessageForDeviceListEmpty() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        if (RestoreHelper.licenseExpired) {
            msg.setText("License has Expired.  Please contact your Administrator.");
            msg.setMessage("License has Expired.  Please contact your Administrator.");
        } else if (RestoreHelper.deviceBlocked) {
            msg.setText(" User Device Blocked.");
            msg.setMessage(" User Device Blocked.");
        } else if (RestoreHelper.sessionExpired) {
            msg.setText(" User Device Blocked.");
            msg.setMessage(" User Device Blocked.");
        } else if (RestoreHelper.serviceUnavailable) {
            msg.setText("Service Unavailable");
            msg.setMessage("Service unavailable, please try again later");
            RestoreHelper.serviceUnavailable = false;
        } else {
            msg.setText("Device List is Empty");
            msg.setMessage("There is no device backed up for the user " + SettingHelper.getUserName());
        }
        msg.open();
    }

    private void getUploadIPForGateway() {
        if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
            try {
                GatewayTO uploadGatewayTo = PolicyManagementServerHelper.getPrivacyGatewayIP((String)"ANY", (String)"RESTORE");
                if (uploadGatewayTo != null) {
                    this.uploadIpForGateway = uploadGatewayTo.getGatewayName();
                }
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("error in get privacy gateway" + e.getMessage());
            }
            this.logger.debug("Restore Privacy Gateway IP:" + this.uploadIpForGateway);
        }
    }

    public void validatePreviousBatchStatus(RestoreActivityHistoryDAOImpl restoreActivityHistoryDAOImpl) {
        RestoreActivityTO activityTO = restoreActivityHistoryDAOImpl.getCurrentStatusFromRestoreActivityHistoryTable(true);
        if (activityTO != null && STARTED.equals(activityTO.getRestoreBatchStatus())) {
            this.logger.debug("user exit the app or network connection failed. so failed status to be sent");
            activityTO.setRestoreBatchStatus("FAILED");
            String batchIdentity = activityTO.getRestoreBatchId();
            this.logger.debug("batchid is" + batchIdentity);
            restoreActivityHistoryDAOImpl.updateEventToRestoreActivityHistoryTable(activityTO);
            this.restoreBatchInitiated(activityTO.getRestoreBatchStatus(), batchIdentity, activityTO.getTotalRestoreCount());
        }
    }

    public void showupRevisions(Table foldertable, String fileName, String folderPath) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        foldertable.removeAll();
        foldertable.getColumn(0).setText("Versions");
        this.restoreButton.setEnabled(false);
        NotificationHelper.successfulRestore = 3;
        NotificationHelper.restoreFinished = false;
        Runnable runable1 = () -> {
            this.listFolders = null;
            try {
                this.listFolders = this.backupAdapter.getAllRevisionsForAFile(SettingHelper.getCurrentCloudIpAddress(), null, this.selectedItem.getDeviceId(), SettingHelper.readTokenFromFile(), folderPath, fileName, this.restoreTilldate);
            }
            catch (Exception e) {
                this.logger.debug(" EXCEPTION :", (Throwable)e);
            }
            this.logger.debug(RESTORE_DEFAULT_STR);
            if (this.isDisposed() || this.getDisplay() == null) {
                return;
            }
            if (this.listFolders == null) {
                this.logger.debug(RESTORE_DEFAULT_STR);
                Runnable runnable = () -> {
                    this.showErrorMessage();
                    this.getShell().close();
                };
                this.getDisplay().asyncExec(runnable);
                return;
            }
            Runnable runbl = () -> {
                this.showRevisionsInTable(foldertable);
                this.restoreButton.setEnabled(true);
                NotificationHelper.successfulRestore = 8;
                this.backLabel.setEnabled(true);
            };
            this.getDisplay().syncExec(runbl);
        };
        new Thread(runable1).start();
    }

    private void showRevisionsInTable(Table foldertable) {
        this.logger.debug("Adding folders to the table");
        ArrayList<DisplayTo> vesionsList = new ArrayList<DisplayTo>();
        int revisionCount = this.listFolders.size();
        for (DisplayTo displayTo : this.listFolders) {
            if (displayTo.getFilePath() == null || !displayTo.isExists()) {
                --revisionCount;
                continue;
            }
            displayTo.setDisplayName(" Version " + revisionCount);
            vesionsList.add(displayTo);
            --revisionCount;
        }
        if (this.listFolders.isEmpty() && this.previousFolderPath != null) {
            this.logger.debug("ListSet is Empty:" + this.listFolders.isEmpty());
            this.showPathLabel.setText(this.previousFolderPath);
            this.showPathLabel.setToolTipText(this.previousFolderPath);
            this.fullPath = this.previousFolderPath;
            try {
                this.logger.debug("Full Path is:" + this.previousFolderPath);
                this.getBasePathFromServer(foldertable, this.previousFolderPath);
            }
            catch (Exception e) {
                this.logger.trace("" + e);
                this.logger.error("Exception :" + e.getMessage());
            }
        } else {
            this.listFolders.clear();
            this.listFolders.addAll(vesionsList);
            this.setDataToFolderTable(foldertable, revisionCount);
        }
    }

    protected void showInfoMessage() {
        MessageBox msg = new MessageBox(this.getShell(), 34);
        msg.setText("Warning!");
        msg.setMessage("This operation may take some time, depending on the amount of data being restored.\nPlease ensure that the system is connected to a power source and doesn\u2019t sleep or hibernate during this time.  \nTo get critical data back faster, you may consider doing multiple restores of smaller file sets.");
        msg.open();
    }

    private int setDataToFolderTable(Table foldertable, int counter) {
        int columnCount = counter;
        foldertable.getColumn(0).setWidth((int)((double)foldertable.getClientArea().width * 0.5));
        foldertable.getColumn(1).setWidth((int)((double)foldertable.getClientArea().width * 0.3));
        foldertable.getColumn(2).setWidth((int)((double)foldertable.getClientArea().width * 0.2));
        for (DisplayTo displayTo : this.listFolders) {
            TableItem item1 = new TableItem(foldertable, 0);
            Date date = new Date(displayTo.getModifiedTime());
            if (displayTo.getDisplayName() == null) {
                displayTo.setDisplayName(displayTo.getFilePath());
            }
            item1.setText(0, displayTo.getDisplayName());
            if (Boolean.parseBoolean(displayTo.getFolder())) {
                item1.setImage(0, this.imageFolder);
                item1.setText(1, "");
                item1.setText(2, "");
            } else {
                item1.setImage(0, this.imageFile);
                item1.setText(1, this.sdf.format(date));
                item1.setText(2, String.valueOf(displayTo.getSize()));
            }
            item1.setData((Object)displayTo);
            ++columnCount;
        }
        for (int i = 0; i < foldertable.getColumnCount(); ++i) {
            foldertable.getColumn(i).pack();
        }
        foldertable.getColumn(0).setWidth((int)((double)foldertable.getClientArea().width * 0.5));
        foldertable.getColumn(1).setWidth((int)((double)foldertable.getClientArea().width * 0.3));
        foldertable.getColumn(2).setWidth((int)((double)foldertable.getClientArea().width * 0.2));
        return columnCount;
    }

    private void sortListForRestore(List<DisplayTo> list, String sortBy, boolean forwardSort) {
        Collections.sort(list, switch (sortBy) {
            case "Folders/Files" -> (d1, d2) -> {
                if (forwardSort) {
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d1.getDisplayName(), (Object)d2.getDisplayName()).toComparison();
                }
                return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append((Object)d2.getDisplayName(), (Object)d1.getDisplayName()).toComparison();
            };
            case "Size(KB)" -> (d1, d2) -> {
                if (forwardSort) {
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d1.getSize(), d2.getSize()).toComparison();
                }
                return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d2.getSize(), d1.getSize()).toComparison();
            };
            case "Modified Time" -> (d1, d2) -> {
                if (forwardSort) {
                    return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d1.getModifiedTime(), d2.getModifiedTime()).toComparison();
                }
                return new CompareToBuilder().append(!Boolean.parseBoolean(d1.getFolder()), !Boolean.parseBoolean(d2.getFolder())).append(d2.getModifiedTime(), d1.getModifiedTime()).toComparison();
            };
            case "Username" -> (d1, d2) -> {
                if (forwardSort) {
                    return d1.getUserName().compareTo(d2.getUserName());
                }
                return d2.getUserName().compareTo(d1.getUserName());
            };
            default -> (d1, d2) -> {
                if (forwardSort) {
                    return d1.getDeviceName().compareTo(d2.getDeviceName());
                }
                return d2.getDeviceName().compareTo(d1.getDeviceName());
            };
        });
    }

    private boolean findEntry(Table table) {
        Cursor waitCursor = new Cursor((Device)this.searchShell.getDisplay(), 1);
        this.searchShell.setCursor(waitCursor);
        boolean matchCase = this.searchDialog.getMatchCase();
        boolean matchWord = this.searchDialog.getMatchWord();
        String searchString = this.searchDialog.getSearchString();
        int column = this.searchDialog.getSelectedSearchArea();
        searchString = matchCase ? searchString : searchString.toLowerCase();
        boolean found = false;
        if (this.searchDialog.getSearchDown()) {
            for (int i = table.getSelectionIndex() + 1; i < table.getItemCount(); ++i) {
                found = this.findMatch(searchString, table.getItem(i), column, matchWord, matchCase);
                if (!found) continue;
                table.setSelection(i);
                break;
            }
        } else {
            for (int i = table.getSelectionIndex() - 1; i > -1; --i) {
                found = this.findMatch(searchString, table.getItem(i), column, matchWord, matchCase);
                if (!found) continue;
                table.setSelection(i);
                break;
            }
        }
        this.searchShell.setCursor(null);
        if (waitCursor != null) {
            waitCursor.dispose();
        }
        return found;
    }

    private boolean findMatch(String searchString, TableItem item, int column, boolean matchWord, boolean matchCase) {
        String tableText;
        String string = tableText = matchCase ? item.getText(column) : item.getText(column).toLowerCase();
        return matchWord ? tableText != null && tableText.equals(searchString) : tableText != null && tableText.indexOf(searchString) != -1;
    }

    public void closeRestoreBackup() {
        this.logger.debug("Closing restore display..");
        if (this.restoreTimer != null) {
            this.restoreTimer.cancel();
            this.restoreTimer = null;
        }
    }

    static {
        subtext = null;
    }
}

