/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.StringWriter;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GZIPHelper {
    private static Logger logger = LoggerFactory.getLogger(GZIPHelper.class);

    private GZIPHelper() {
    }

    public static byte[] zipRequest(StringWriter requestBody) {
        GZIPOutputStream gzipOS = null;
        FilterOutputStream filterOutput = null;
        ByteArrayOutputStream byteArry = null;
        byte[] requestByteArray = null;
        try {
            byteArry = new ByteArrayOutputStream();
            filterOutput = new FilterOutputStream(byteArry);
            gzipOS = new GZIPOutputStream(filterOutput);
            gzipOS.write(requestBody.getBuffer().toString().getBytes("UTF-8"));
            filterOutput.close();
            gzipOS.close();
            requestByteArray = byteArry.toByteArray();
        }
        catch (Exception e) {
            logger.error(" Exception in zipRequest: ", (Throwable)e);
            requestByteArray = requestBody.toString().getBytes();
        }
        return requestByteArray;
    }
}

